/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.tags.ITaggable;
import pyrosim.domain.tags.Tag;
import pyrosim.geom.TexCoordGenerator;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.util.Util;
import thunderheadeng.cad.bim.BIMType;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.geom.PropsUtil;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class GenericGeomSrc
extends NamedPyroObject
implements IModelObj,
IDirectDependent,
ITaggable {
    static final long serialVersionUID = 1L;
    private Object d_geom;
    @Deprecated
    private Object d_texMapper;
    @SkipDep
    private IPropsSrc d_props;
    private boolean d_visible;
    private String d_description;
    private Set<Tag> d_tags;
    private final BIMType d_bimType;
    public static final Composite.IObjectProp colorProp;

    public GenericGeomSrc(String name, IGeomNode geom, IPropsSrc props) {
        this(name, geom, props, BIMType.UNKNOWN);
    }

    public GenericGeomSrc(String name, IGeomNode geom, IPropsSrc props, BIMType bimType) {
        super(name);
        this.d_geom = geom;
        this.d_props = props;
        this.d_bimType = bimType;
        this.d_visible = true;
        this.d_description = "";
        this.d_tags = Collections.emptySet();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = PyroSimObjectInputStream.getVersion(in);
        if (version < 87) {
            IElemSource uvSrc = (IElemSource)this.d_texMapper;
            this.d_texMapper = null;
            if (this.d_geom instanceof IGeom) {
                this.d_geom = GeomNodeUtil.newNode((IGeom)this.d_geom, Elements.NONE);
            } else assert (this.d_geom instanceof IGeomNode);
            if (uvSrc != Elements.NO_UV) {
                IElemSource uv = uvSrc;
                this.d_geom = ((IGeomNode)this.d_geom).applyUVElements("uvset", (pix, oldUV) -> uv.getPrimSource((int)pix));
            }
            this.d_geom = ((IGeomNode)this.d_geom).prune();
        }
        if (version < 130) {
            try {
                theUtil.assignFinalField(this, GenericGeomSrc.class, "d_bimType", (Object)BIMType.UNKNOWN);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (this.d_description == null) {
            this.d_description = "";
        }
        if (this.d_tags == null) {
            this.d_tags = Collections.emptySet();
        }
    }

    @Override
    public DisplayGeom getPickGeom(IDisplayProps dprops, Runnable validateProgress) {
        IGeomNode pickable = this.getGeom().getPickable(validateProgress, dprops.isWireframe(this));
        return new DisplayGeom(pickable, IPickable.DEF_PROPS);
    }

    @Override
    public IGeomNode getGeom() {
        return (IGeomNode)this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode geom) {
        if (this.d_geom == geom) {
            return;
        }
        this.d_geom = geom;
        this.changedEvt(new Object[0]);
    }

    @Override
    public String getDesc() {
        return this.d_description;
    }

    @Override
    public void setDesc(String desc) {
        this.d_description = desc;
        this.changedEvt(new Object[0]);
    }

    public IPropsSrc getDisplayProps() {
        return this.d_props;
    }

    public void setDisplayProps(IPropsSrc src) {
        this.d_props = src;
        this.changedEvt(new Object[0]);
    }

    @Override
    public BIMType getBIMType() {
        return this.d_bimType;
    }

    @Override
    public GenericGeomSrc clone() {
        return (GenericGeomSrc)super.clone();
    }

    @Override
    public IModelObj getRestoreObject() {
        return this.clone();
    }

    @Override
    public void imprint(IModelObj obj) {
        this.restoreFrom(obj);
    }

    public void restoreFrom(IModelObj obj) {
        if (!(obj instanceof GenericGeomSrc)) {
            assert (false);
        } else {
            GenericGeomSrc ref = (GenericGeomSrc)obj;
            this.pauseUpdates();
            this.d_props = ref.d_props;
            this.setName(ref.getName());
            this.setDesc(ref.getDesc());
            this.setTags(ref.getTags());
            this.setGeom(ref.getGeom());
            this.setEnabled(ref.isEnabled());
            this.setVisible(ref.isVisible());
            this.setForceWrite(ref.isForceWrite());
            this.d_texMapper = ref.d_texMapper;
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return new DisplayGeom(this.getGeom(), this.d_props);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible == visible) {
            return;
        }
        this.d_visible = visible;
        this.changedEvt(PyroMod.EVT_VISIBILITY_CHANGED);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        ITaggable.addTagsToDepSnapshot(this, deps);
        LinkedIdentityHashSet<IMaterial> refedMats = new LinkedIdentityHashSet<IMaterial>();
        PropsUtil.getReferencedMaterials(this.getGeom(), this.d_props, refedMats);
        deps.add(DLink.WEAK, theUtil.filter(refedMats, Material.class));
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        ITaggable.removeInvalidTagReplacements(old, objs);
        if (old instanceof Material) {
            Util.keepIfNullOr(objs, Material.class);
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
        Task tagReplace = ITaggable.taskReplaceTagDep(old, replacement, this);
        if (tagReplace != EmptyTask.INSTANCE) {
            return tagReplace;
        }
        if (old instanceof Material) {
            return new AUndoableTask(){
                private IPropsSrc d_props;
                private IGeomNode d_node;

                @Override
                public void run() {
                    int ucount;
                    IGeomNode geom = GenericGeomSrc.this.getGeom();
                    this.d_props = GenericGeomSrc.this.getDisplayProps();
                    this.d_node = geom;
                    int numPrims = geom.getNumPrims(7);
                    BitSet replacedMats = new BitSet(numPrims);
                    PropsBuilder props = new PropsBuilder();
                    for (int m2 = 0; m2 < numPrims; m2 += ucount) {
                        ucount = this.d_props.getUniformCount(m2, numPrims - m2);
                        IPrimProps pprops = this.d_props.get(m2);
                        if (pprops.getMaterial() == old) {
                            pprops = pprops.setMaterial((Material)replacement);
                            replacedMats.set(m2, m2 + ucount);
                        }
                        props.add(pprops, ucount);
                    }
                    Material newMat = (Material)replacement;
                    IPropsSrc newProps = props.finalizeProps();
                    IGeomNode newNode = this.d_node;
                    if (newMat != null) {
                        for (String uvSet : newMat.getAttributes().getUVSets()) {
                            newNode = this.d_node.applyUVElements(uvSet, (m, oldEl) -> replacedMats.get((int)m) ? TexCoordGenerator.DEFAULT_OBJ : oldEl);
                        }
                    }
                    this.setData(newProps, newNode);
                }

                @Override
                public void undo() {
                    this.setData(this.d_props, this.d_node);
                }

                private void setData(IPropsSrc props, IGeomNode node) {
                    GenericGeomSrc.this.pauseUpdates();
                    GenericGeomSrc.this.setDisplayProps(props);
                    GenericGeomSrc.this.setGeom(node);
                    GenericGeomSrc.this.resumeUpdates();
                }
            };
        }
        return EmptyTask.INSTANCE;
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        if (dep instanceof Material) {
            return GeomUtil.taskChanged(this);
        }
        return EmptyTask.INSTANCE;
    }

    @Override
    public Set<Tag> getTags() {
        return this.d_tags;
    }

    @Override
    public void setTags(Set<Tag> tags) {
        this.d_tags = tags;
        this.changedEvt(new Object[0]);
    }

    static {
        TVEntryPoint.registerReferencedUpdateTypes(Material.class);
        colorProp = new Composite.AObjectProp<GenericGeomSrc, Color[]>(GenericGeomSrc.class){

            @Override
            public void set(GenericGeomSrc obj, Color[] colors) {
                PropsBuilder props = new PropsBuilder();
                int count = obj.getGeom().getNumPrims(7);
                assert (colors.length == 1 || colors.length == count);
                for (int m = 0; m < count; ++m) {
                    Color newColor;
                    IPrimProps primProp = obj.getDisplayProps().get(m);
                    Color color = newColor = colors.length == 1 ? colors[0] : colors[m];
                    if (newColor != null) {
                        primProp = primProp.setColor(newColor);
                    }
                    props.add(primProp);
                }
                obj.setDisplayProps(props.finalizeProps());
            }

            @Override
            public Object get(GenericGeomSrc obj) {
                int count = obj.getGeom().getNumPrims(7);
                Color[] colors = new Color[count];
                for (int m = 0; m < count; ++m) {
                    colors[m] = obj.getDisplayProps().get(m).getColor();
                }
                return colors;
            }

            @Override
            public boolean equal(Color[] arg0, Color[] arg1) {
                return Arrays.equals(arg0, arg1);
            }
        };
    }
}

