/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.io.Serializable;
import java.util.Objects;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.Unit;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;

public class FreePointLoc
implements Serializable {
    static final long serialVersionUID = 1L;
    public final IGeom d_geom;
    public final Vector3d d_orientation;
    public final UnitDouble d_rotation;
    @Deprecated
    public final int d_numPoints = 0;
    private static final Vector3d s_baseRotVec = new Vector3d(0.0, 0.0, -1.0);

    public FreePointLoc() {
        this(new Point(Geometry.UP3D_ZERO.getPoint3dValue(Geometry.LU)));
    }

    public FreePointLoc(IGeom geom) {
        this(geom, new Vector3d(0.0, 0.0, -1.0));
    }

    public FreePointLoc(IGeom geom, Vector3d orientation) {
        this(geom, orientation, new UnitDouble(0.0, NonSI.DEGREE_ANGLE));
    }

    public FreePointLoc(IGeom geom, Vector3d orientation, UnitDouble rotation) {
        this.d_geom = geom;
        this.d_orientation = orientation;
        this.d_rotation = rotation;
    }

    public FreePointLoc setGeom(IGeom p) {
        return new FreePointLoc(p, this.d_orientation, this.d_rotation);
    }

    public FreePointLoc setGeom(IGeom p, Vector3d orientation) {
        return new FreePointLoc(p, orientation, this.d_rotation);
    }

    public Matrix4d toTransform() {
        Matrix4d xform = new Matrix4d();
        xform.setIdentity();
        if (!s_baseRotVec.equals(this.d_orientation)) {
            Vector3d axis = Util3D.cross(s_baseRotVec, this.d_orientation);
            double angle = s_baseRotVec.angle(this.d_orientation);
            xform.mul(Util.rotMat(axis.x, axis.y, axis.z, angle));
        }
        return xform;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FreePointLoc)) {
            return false;
        }
        FreePointLoc loc = (FreePointLoc)obj;
        return Objects.equals(this.d_geom, loc.d_geom) && Objects.equals(this.d_orientation, this.d_orientation) && Objects.equals(this.d_rotation, loc.d_rotation);
    }

    public int hashCode() {
        return 16851725 + this.d_geom.hashCode() + this.d_orientation.hashCode() + this.d_rotation.hashCode();
    }

    public void getBounds(AABox bb, Unit u) {
        this.d_geom.getBoundingBox(bb);
    }

    public UnitAABox getBounds() {
        AABox box = new AABox();
        this.getBounds(box, Geometry.LU);
        return new UnitAABox(box, Geometry.LU);
    }

    public FreePointLoc transform(Matrix4d xform) {
        IGeom newGeom = this.d_geom.transform(new TransformInfo(xform), 1);
        return new FreePointLoc(newGeom, this.d_orientation, this.d_rotation);
    }
}

