/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import pyrosim.PyroMod;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.domain.geom.EvacProps;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.signals.Util;
import pyrosim.domain.tags.ITaggable;
import pyrosim.domain.tags.Tag;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.util.LWArray;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public abstract class AFDSObject
extends NamedPyroObject
implements FDSObject,
IDirectDependent,
ITaggable {
    static final long serialVersionUID = 1L;
    protected static final int FLAG_VIS = Integer.MIN_VALUE;
    @Deprecated
    protected static final int FLAG_SEL = 0x40000000;
    protected static final int DEF_FLAGS = Integer.MIN_VALUE;
    private OneLogicInPin d_inPin = new OneLogicInPin(this);
    @SkipDep
    private Object d_colors = null;
    private EvacProps d_evac = EvacProps.DEFAULT;
    private int d_flags = Integer.MIN_VALUE;
    private String d_description = "";
    private Set<Tag> d_tags;
    private CustomFDSProps d_customFDSProps = CustomFDSProps.EMPTY;

    public AFDSObject(String name) {
        super(name);
        this.d_tags = Collections.emptySet();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public void imprint(IModelObj refObject) {
        if (!(refObject instanceof AFDSObject)) {
            assert (false);
        } else {
            AFDSObject refObj = (AFDSObject)refObject;
            this.pauseUpdates();
            this.setName(refObj.getName());
            this.setDesc(refObj.getDesc());
            this.setGeom(refObj.getGeom());
            this.setCustomFDSProps(refObj.getCustomFDSProps());
            this.setEnabled(refObj.isEnabled());
            this.setTags(refObj.getTags());
            this.overrideFlags(refObj.getSetFlags());
            this.setForceWrite(refObj.isForceWrite());
            this.setColors(refObj.getColors());
            this.setVisible(refObj.isVisible());
            this.setEvac(refObj.getEvac());
            Util.restoreInPin(this, this.d_inPin, refObj.getInputPin());
            this.resumeUpdates();
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.d_flags &= 0xBFFFFFFF;
        if (this.d_customFDSProps == null) {
            this.d_customFDSProps = CustomFDSProps.EMPTY;
        }
        if (this.d_description == null) {
            this.d_description = "";
        }
        if (this.d_tags == null) {
            this.d_tags = Collections.emptySet();
        }
    }

    @Override
    public Object clone() {
        AFDSObject clone = (AFDSObject)super.clone();
        clone.d_inPin = (OneLogicInPin)this.d_inPin.clone(clone);
        return clone;
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String recType) {
        return this.d_customFDSProps;
    }

    @Override
    public void setCustomFDSProps(String recType, CustomFDSProps props) {
        this.d_customFDSProps = props;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Set<Tag> getTags() {
        return this.d_tags;
    }

    @Override
    public void setTags(Set<Tag> tags) {
        this.d_tags = tags;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean registerProximity() {
        return true;
    }

    protected boolean testFlags(int flags) {
        return (this.d_flags & flags) == flags;
    }

    protected void setFlags(int flags, boolean set, Object ... changes) {
        int before = this.d_flags;
        this.d_flags = set ? (this.d_flags |= flags) : (this.d_flags &= ~flags);
        if (this.d_flags != before) {
            this.changedEvt(changes);
        }
    }

    protected int getSetFlags() {
        return this.d_flags;
    }

    protected void overrideFlags(int flags) {
        this.d_flags = flags;
    }

    @Override
    public void setEvac(EvacProps evac) {
        if (evac.equals(this.d_evac)) {
            return;
        }
        this.d_evac = evac;
        this.changedEvt(new Object[0]);
    }

    @Override
    public EvacProps getEvac() {
        return this.d_evac;
    }

    @Override
    public String getDesc() {
        return this.d_description;
    }

    @Override
    public void setDesc(String desc) {
        this.d_description = desc;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void setColors(Color ... c) {
        this.d_colors = LWArray.newArray(c);
        this.changedEvt(new Object[0]);
    }

    @Override
    public Color[] getColors() {
        Color[] colorArray;
        Color[] c = LWArray.toArray(this.d_colors, Color.class);
        if (c.length == 0) {
            Color[] colorArray2 = new Color[1];
            colorArray = colorArray2;
            colorArray2[0] = null;
        } else {
            colorArray = c;
        }
        return colorArray;
    }

    @Override
    public void setVisible(boolean visible) {
        this.setFlags(Integer.MIN_VALUE, visible, PyroMod.EVT_VISIBILITY_CHANGED);
    }

    @Override
    public boolean isVisible() {
        return this.testFlags(Integer.MIN_VALUE);
    }

    @Override
    public OneLogicInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        ITaggable.addTagsToDepSnapshot(this, deps);
        deps.add(DLink.WEAK, (IPyroObject)this.d_evac.mesh);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        ITaggable.removeInvalidTagReplacements(old, objs);
        if (old instanceof Grid) {
            pyrosim.util.Util.keepIfNullOr(objs, Grid.class);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        Task tagReplace = ITaggable.taskReplaceTagDep(old, replacement, this);
        if (tagReplace != EmptyTask.INSTANCE) {
            return tagReplace;
        }
        if (old != this.d_evac.mesh) {
            return EmptyTask.INSTANCE;
        }
        return new AReplaceRefTask<Grid>((Object)old, (Object)replacement){

            @Override
            protected void set(Grid obj) {
                AFDSObject.this.setEvac(EvacProps.get(AFDSObject.this.d_evac.evacuation, obj));
            }
        };
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }
}

