/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.sprayers;

import java.util.Arrays;
import java.util.List;
import org.jscience.physics.units.SI;
import pyrosim.domain.devices.ADevice;
import pyrosim.domain.devices.ISinkDevice;
import pyrosim.domain.devices.ISourceDevice;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.LogicOutPin;
import pyrosim.domain.signals.MultiLogicInPin;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.units.UnitDouble;

public class DryPipe
extends ADevice
implements ISourceDevice,
ISinkDevice {
    static final long serialVersionUID = 1L;
    private MultiLogicInPin d_inPin;
    private LogicOutPin d_outPin;
    private UnitDouble d_depressDelay;

    public DryPipe(String name) {
        this(name, new UnitDouble(30.0, SI.SECOND));
    }

    public DryPipe(String name, UnitDouble depressurizeDelay) {
        super(name);
        this.d_depressDelay = depressurizeDelay;
        this.d_inPin = new MultiLogicInPin(this, Integer.MAX_VALUE);
        this.d_outPin = new LogicOutPin(this);
    }

    @Override
    public Object clone() {
        DryPipe clone = (DryPipe)super.clone();
        clone.d_inPin = (MultiLogicInPin)this.d_inPin.clone(clone);
        clone.d_outPin = this.d_outPin.clone(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DryPipe)) {
            return false;
        }
        DryPipe pipe = (DryPipe)obj;
        return super.equals(obj) && this.d_depressDelay.equals(pipe.d_depressDelay) && this.d_inPin.equals(pipe.d_inPin);
    }

    public UnitDouble getDelay() {
        return this.d_depressDelay;
    }

    public void setDelay(UnitDouble delay) {
        this.d_depressDelay = delay;
        this.changedEvt(new Object[0]);
    }

    @Override
    public MultiLogicInPin getInputPin() {
        return this.d_inPin;
    }

    public LogicOutPin getOutputPin() {
        return this.d_outPin;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Arrays.asList(this.d_outPin);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.EMPTY_NODE;
    }

    @Override
    public void setGeom(IGeomNode geom) {
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return DisplayGeom.EMPTY;
    }
}

