/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.sprayers;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.vecmath.Matrix4d;
import pyrosim.Intl;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.ADevice;
import pyrosim.domain.devices.FreeLocSaveTask;
import pyrosim.domain.devices.FreePointGeom;
import pyrosim.domain.devices.IFreePointDevice;
import pyrosim.domain.devices.sprayers.ISprayer;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.LogicOutPin;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.BlockGeom;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.Task;

public abstract class ASprayer
extends ADevice
implements ISprayer,
IDirectDependent,
IFreePointDevice {
    static final long serialVersionUID = 1L;
    private SprayModel d_sprayDescription;
    private FreePointLoc d_location;
    private LogicOutPin d_sprayAlarmPin;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(Color.BLUE, 10.0);

    public ASprayer(String name, SprayModel desc) {
        this(name, desc, new FreePointLoc());
    }

    public ASprayer(String name, SprayModel desc, FreePointLoc loc) {
        super(name);
        this.d_sprayDescription = desc;
        this.d_location = loc;
        this.d_sprayAlarmPin = new LogicOutPin(this, Intl.intl("NOZZLE"));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_sprayAlarmPin == null) {
            this.d_sprayAlarmPin = new LogicOutPin(this, Intl.intl("NOZZLE"));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ASprayer)) {
            return false;
        }
        ASprayer spry = (ASprayer)obj;
        return super.equals(obj) && this.d_sprayDescription.equals(spry.d_sprayDescription) && this.d_location.equals(spry.d_location);
    }

    @Override
    public ASprayer clone() {
        ASprayer clone = (ASprayer)super.clone();
        clone.d_sprayAlarmPin = this.d_sprayAlarmPin.clone(clone);
        return clone;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Collections.singletonList(this.d_sprayAlarmPin);
    }

    public LogicOutPin getNozzleAlarmPin() {
        return this.d_sprayAlarmPin;
    }

    @Override
    public FreePointLoc getLocation() {
        return this.d_location;
    }

    @Override
    public void setLocation(FreePointLoc loc) {
        this.d_location = loc;
        this.changedEvt(new Object[0]);
    }

    public IDOF getDOF() {
        return IDOF.FREE;
    }

    protected void transform(Matrix4d xform) {
        this.setLocation(this.d_location.transform(xform));
    }

    protected void imprintGeom(Object from) {
        this.setLocation(((ASprayer)from).d_location);
    }

    protected Task taskSaveGeometry() {
        return new FreeLocSaveTask(this);
    }

    public SprayModel getSprayModel() {
        return this.d_sprayDescription;
    }

    public void setSprayModel(SprayModel desc) {
        this.d_sprayDescription = desc;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        if (this.d_sprayDescription != null) {
            deps.add(DLink.STRONG, (IPyroObject)this.d_sprayDescription);
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        super.removeInvalidReplacements(old, objs);
        if (old instanceof SprayModel) {
            Util.keepIfNullOr(objs, SprayModel.class);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old == this.d_sprayDescription) {
            assert (replacement != null);
            return new AReplaceRefTask<SprayModel>((Object)old, (Object)replacement){

                @Override
                public void set(SprayModel obj) {
                    ASprayer.this.setSprayModel(obj);
                }
            };
        }
        return super.taskReplaceDep(old, replacement);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return super.taskUpdateDep(dep, changes);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom(this.getGeom(), s_primProps);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getSprayerGeom());
    }

    public IGeom getSprayerGeom() {
        return new FreePointGeom(this.d_location);
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof FreePointGeom) {
            FreePointGeom p = (FreePointGeom)geom;
            this.setLocation(p.loc);
        } else if (geom instanceof Point || geom instanceof LineSeg || geom instanceof BlockGeom) {
            this.setLocation(this.d_location.setGeom(geom));
        }
    }

    @Override
    public void getCustomFDSTypes(Collection<String> recTypes) {
        recTypes.add("DEVC");
    }
}

