/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.awt.Color;
import java.util.Objects;
import java.util.function.Predicate;
import pyrosim.domain.devices.AttachedPointGeom;
import pyrosim.domain.devices.IAttachedPointDevice;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;

public class SolidPointMeasurer
extends AMeasuringDevc
implements IAttachedPointDevice {
    static final long serialVersionUID = 1L;
    private AttachedPointLoc d_loc;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(new Color(0.7f, 0.7f, 0.0f), 10.0);

    public SolidPointMeasurer(String name, IQuantity measurment, AttachedPointLoc loc) {
        super(name, measurment);
        this.d_loc = loc;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SolidPointMeasurer && super.equals(obj) && Objects.equals(this.d_loc, ((SolidPointMeasurer)obj).d_loc);
    }

    @Override
    public FreePointLoc getLocation() {
        return this.d_loc.toFreePoint();
    }

    @Override
    public AttachedPointLoc getAttachedLocation() {
        return this.d_loc;
    }

    @Override
    public void setLocation(AttachedPointLoc loc) {
        this.d_loc = loc;
        this.changedEvt(new Object[0]);
    }

    public static QuantityType getQuantityType() {
        return QuantityType.SOLID;
    }

    public static long getOutputType() {
        return 1L;
    }

    public static Predicate<Quantity> getQuantityFilter() {
        return new QuantityUtil.TypeFilter(SolidPointMeasurer.getOutputType(), SolidPointMeasurer.getQuantityType());
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom(this.getGeom(), s_primProps);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getPointGeom());
    }

    public IGeom getPointGeom() {
        return new AttachedPointGeom(this.d_loc);
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof AttachedPointGeom) {
            AttachedPointGeom p = (AttachedPointGeom)geom;
            this.setLocation(p.loc);
        } else if (geom instanceof Point) {
            this.setLocation(this.d_loc.setLoc(((Point)geom).loc));
        }
    }
}

