/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.io.Serializable;
import java.util.Set;
import pyrosim.PyroMod;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.measurers.IMeasureOutInfo;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.ILatchable;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.LogicOutPin;
import thunderheadeng.util.theUtil;

public class MeasureOutInfo
implements Serializable,
Cloneable,
IMeasureOutInfo {
    static final long serialVersionUID = 1L;
    @SkipDep
    private ILatchable d_src;
    private boolean d_enabled;
    private IDoubleOutPin d_pin;
    private LogicOutPin d_alarmPin;
    private AlarmInfo d_alarmInfo;

    public MeasureOutInfo(ILatchable src, boolean enabled, IDoubleOutPin msrPin, String logicPinName) {
        this(src, enabled, msrPin, new LogicOutPin(src, logicPinName), null);
    }

    public MeasureOutInfo(ILatchable src, boolean enabled, IDoubleOutPin msrPin, LogicOutPin alarmPin, AlarmInfo alarmInfo) {
        this.d_src = src;
        this.d_enabled = enabled;
        this.d_pin = msrPin;
        this.d_alarmPin = alarmPin;
        this.d_alarmInfo = alarmInfo;
    }

    @Override
    public void setAlarmInfo(AlarmInfo ai) {
        if (AlarmInfo.checkAlarmChange((ISignalSource)this.d_src, this.d_alarmInfo, ai, this.d_alarmPin)) {
            this.d_alarmInfo = ai;
            this.d_src.changedEvt(new Object[0]);
        }
    }

    @Override
    public AlarmInfo getAlarmInfo() {
        return this.d_alarmInfo;
    }

    @Override
    public IDoubleOutPin getPin() {
        return this.d_pin;
    }

    @Override
    public LogicOutPin getAlarmPin() {
        return this.d_alarmPin;
    }

    public void legacySetPin(IDoubleOutPin pin) {
        this.d_pin = pin;
        this.d_pin.setSource(this.d_src);
    }

    public void legacySetSource(ILatchable src) {
        this.d_src = src;
        this.d_pin.setSource(src);
        this.d_alarmPin.setSource(src);
    }

    public Object clone(ISignalSource srcClone) {
        try {
            MeasureOutInfo pi = (MeasureOutInfo)super.clone();
            pi.d_pin = (IDoubleOutPin)this.d_pin.clone(srcClone);
            pi.d_alarmPin = this.d_alarmPin.clone(srcClone);
            assert (srcClone instanceof ILatchable);
            pi.d_src = (ILatchable)srcClone;
            return pi;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof MeasureOutInfo && ((MeasureOutInfo)obj).d_enabled == this.d_enabled && theUtil.equal(((MeasureOutInfo)obj).d_alarmInfo, this.d_alarmInfo);
    }

    @Override
    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.d_enabled) {
            return;
        }
        this.d_enabled = enabled;
        PyroMod domain = (PyroMod)this.d_src.getDomain();
        if (domain != null) {
            domain.pauseUpdates();
        }
        if (!this.d_enabled && domain != null) {
            IMeasureOutInfo.disconnectDisabledPins(domain, this.d_src, Set.of(this.d_pin, this.d_alarmPin));
        }
        this.d_src.changedEvt(new Object[0]);
        if (domain != null) {
            domain.resumeUpdates();
        }
    }
}

