/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.awt.Color;
import java.util.Collection;
import java.util.function.Predicate;
import pyrosim.domain.devices.FreePointGeom;
import pyrosim.domain.devices.IFreePointDevice;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;

public class GasPointMeasurer
extends AMeasuringDevc
implements IFreePointDevice {
    static final long serialVersionUID = 1L;
    private FreePointLoc d_location;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(new Color(0.7f, 0.7f, 0.0f), 10.0);

    public GasPointMeasurer(String name, IQuantity measurement, FreePointLoc loc) {
        super(name, measurement);
        this.d_location = loc;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof GasPointMeasurer && super.equals(obj) && this.d_location.equals(((GasPointMeasurer)obj).d_location);
    }

    @Override
    public FreePointLoc getLocation() {
        return this.d_location;
    }

    @Override
    public void setLocation(FreePointLoc loc) {
        this.d_location = loc;
        this.changedEvt(new Object[0]);
    }

    public static QuantityType getQuantityType() {
        return QuantityType.GAS;
    }

    public static long getOutputType() {
        return 1L;
    }

    public static Predicate<Quantity> getQuantityFilter() {
        return new QuantityUtil.TypeFilter(GasPointMeasurer.getOutputType(), GasPointMeasurer.getQuantityType());
    }

    public static void getCustomFDSTypes(IQuantity quantity, Collection<String> recTypes) {
        recTypes.add("DEVC");
        if (quantity == null) {
            return;
        }
        switch (quantity.get()) {
            case THERMOCOUPLE: 
            case ADIABATIC_SURFACE_TEMPERATURE_GAS: 
            case FED: 
            case GAUGE_HEAT_FLUX_GAS: {
                recTypes.add("PROP");
                break;
            }
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom(this.getGeom(), s_primProps);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getPointGeom());
    }

    public IGeom getPointGeom() {
        return new FreePointGeom(this.d_location);
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof FreePointGeom) {
            FreePointGeom p = (FreePointGeom)geom;
            this.setLocation(p.loc);
        } else if (geom instanceof Point) {
            this.setLocation(this.d_location.setGeom(geom));
        }
    }
}

