/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.Quantity;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class AdiabaticSurfTempGasMeasurer
extends GasPointMeasurer {
    static final long serialVersionUID = 1L;
    private double d_emissivity;
    private UnitDouble d_heatTransferCoeff;

    public AdiabaticSurfTempGasMeasurer(String name, FreePointLoc loc) {
        this(name, 0.85, null, loc);
    }

    public AdiabaticSurfTempGasMeasurer(String name, double emissivity, UnitDouble heatTransferCoeff, FreePointLoc loc) {
        super(name, Quantity.ADIABATIC_SURFACE_TEMPERATURE_GAS.create(), loc);
        this.d_emissivity = emissivity;
        this.d_heatTransferCoeff = heatTransferCoeff;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AdiabaticSurfTempGasMeasurer)) {
            return false;
        }
        AdiabaticSurfTempGasMeasurer astgm = (AdiabaticSurfTempGasMeasurer)obj;
        return super.equals(obj) && theUtil.equal(this.d_emissivity, astgm.d_emissivity) && theUtil.equal(this.d_heatTransferCoeff, astgm.d_heatTransferCoeff);
    }

    public void setEmissivity(double emissivity) {
        this.d_emissivity = emissivity;
        this.changedEvt(new Object[0]);
    }

    public double getEmissivity() {
        return this.d_emissivity;
    }

    public void setHeatTransferCoeff(UnitDouble h) {
        this.d_heatTransferCoeff = h;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getHeatTransferCoeff() {
        return this.d_heatTransferCoeff;
    }
}

