/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.hvac;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.domain.devices.ASourceDevice;
import pyrosim.domain.devices.measurers.IMeasurer;
import pyrosim.domain.devices.measurers.MeasureOutInfo;
import pyrosim.domain.devices.statistics.StatisticsDevc;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityReplacer;
import pyrosim.domain.quantity.QuantityStat;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.signals.IDoubleInPin;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public abstract class HvacDevice
extends ASourceDevice
implements IDirectDependent,
IMeasurer {
    static final long serialVersionUID = 1L;
    private IQuantity d_msr;
    private QuantityStat d_temporalStat = null;
    private OneLogicInPin d_freezePin;
    private MeasureOutInfo d_outPin;

    public HvacDevice(String name, IQuantity msr) {
        super(name);
        this.d_msr = msr;
        this.d_outPin = HvacDevice.createOutInfo(this);
        this.d_freezePin = new OneLogicInPin(this);
    }

    public IQuantity getQuantity() {
        return this.d_msr;
    }

    public void setQuantity(IQuantity msr) {
        assert (msr != null);
        if (!Objects.equals(this.d_msr, msr)) {
            this.d_msr = msr;
            this.pauseUpdates();
            this.updateInputUnits();
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    public QuantityStat getTemporalStat() {
        return this.d_temporalStat;
    }

    public void setTemporalStat(QuantityStat stat) {
        assert (stat == null || stat.type == QuantityStat.Type.TEMPORAL);
        if (this.d_temporalStat == stat) {
            return;
        }
        this.pauseUpdates();
        this.d_temporalStat = stat;
        this.updateInputUnits();
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    public int getUnitType() {
        if (this.d_msr == null) {
            return 28;
        }
        return StatisticsDevc.getUnitType(this.d_msr.get(), null, this.d_temporalStat);
    }

    protected void updateInputUnits() {
        if (this.getDomain() == null) {
            return;
        }
        int newUnitType = this.getUnitType();
        Unit newUnit = PyroSim.getAppOpt().map(app -> app.getUnitSystem().getUnit(newUnitType)).orElse(SIUS.unit(newUnitType));
        DepSnapshot ds = ((PyroMod)this.getDomain()).getDependencies(this);
        Set<Dependency> deps = ds.getDependents(this);
        for (Dependency dep : deps) {
            if (!(dep.source instanceof IDoubleInPin)) continue;
            IDoubleInPin pin = (IDoubleInPin)dep.source;
            pin.updateInputUnit(newUnit);
        }
    }

    @Override
    public void setGeom(IGeomNode geom) {
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getDevcGeom());
    }

    protected abstract IGeom getDevcGeom();

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return DisplayGeom.EMPTY;
    }

    public static Point3d getPointForNode(HvacNode n) {
        if (n != null && n.getProp("XYZ") != null) {
            return ((UnitPoint3D)n.getProp("XYZ")).getPoint3dValue(SI.METER);
        }
        return null;
    }

    public static boolean isValidQuantity(IQuantity quantity) {
        return quantity.get().quantityType.hvac;
    }

    @Override
    public int getNumMeasurements() {
        return 1;
    }

    @Override
    public IQuantity getQuantity(int index) {
        return this.getQuantity();
    }

    @Override
    public MeasureOutInfo getMsrInfo(int index) {
        return this.getMsrInfo();
    }

    public MeasureOutInfo getMsrInfo() {
        return this.d_outPin;
    }

    @Override
    public boolean latches(ILogicOutPin pin) {
        return this.getMsrInfo().latches();
    }

    @Override
    public OneLogicInPin getFreezePin() {
        return this.d_freezePin;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        QuantityUtil.takeDepSnapshot(deps, DLink.STRONG, this.d_msr);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        super.removeInvalidReplacements(old, objs);
        if (old instanceof IQuantity) {
            QuantReplacer replacer = new QuantReplacer();
            replacer.removeInvalidReplacements(old, objs, this.d_msr);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        Task tagReplace = super.taskReplaceDep(old, replacement);
        if (tagReplace != EmptyTask.INSTANCE) {
            return tagReplace;
        }
        QuantReplacer replacer = new QuantReplacer();
        return replacer.taskReplaceDep(old, replacement, this.d_msr);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return super.taskUpdateDep(dep, changes);
    }

    private static MeasureOutInfo createOutInfo(HvacDevice devc) {
        OutPin pin = new OutPin(devc);
        return new MeasureOutInfo(devc, true, pin, Intl.intl("ALARM"));
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)HvacDevice.this.getDomain());
        }

        @Override
        protected Task taskReplaceQuant(IQuantity oldMsr, IQuantity newMsr) {
            assert (newMsr != null);
            return new AReplaceRefTask<IQuantity>((Object)oldMsr, (Object)newMsr){

                @Override
                protected void set(IQuantity obj) {
                    HvacDevice.this.d_msr = obj;
                    HvacDevice.this.changedEvt(new Object[0]);
                }
            };
        }
    }

    private static class OutPin
    extends APyroObject
    implements IDoubleOutPin {
        private static final long serialVersionUID = 1L;
        @SkipDep
        private HvacDevice d_source;

        public OutPin(HvacDevice src) {
            this.d_source = src;
        }

        @Override
        public ISignalSource getAttachedSource() {
            return this.d_source;
        }

        @Override
        public void setSource(ISignalSource source) {
            assert (source instanceof HvacDevice);
            this.d_source = (HvacDevice)source;
        }

        @Override
        public String getName() {
            return Intl.intl("OUT");
        }

        @Override
        public void setName(String id) {
        }

        @Override
        public int getUnitType() {
            return this.d_source.d_msr.get().unitType;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof OutPin && this.getAttachedSource().equals(((OutPin)obj).getAttachedSource());
        }

        @Override
        public Object clone(ISignalSource newSource) {
            OutPin pin = (OutPin)super.clone();
            assert (newSource instanceof HvacDevice);
            pin.d_source = (HvacDevice)newSource;
            return pin;
        }

        public int hashCode() {
            return 76557876 + this.getAttachedSource().hashCode();
        }

        @Override
        public boolean isEquiv(Object obj) {
            return this.equals(obj);
        }
    }
}

