/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class ParticleInjection
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    private Particle d_particle;
    public final int d_numPartsPerCell;
    private Object d_massFlux;
    public final UnitDouble d_dtInsert;

    public ParticleInjection() {
        this(null, 1, new TimeBasedValue<UnitDouble>(new UnitDouble(0.0, SIUS.unit(45)), TimeFunction.newDefault()), new UnitDouble(0.01, SI.SECOND));
    }

    public ParticleInjection(Particle particle, int numPartsPerCell, TimeBasedValue<UnitDouble> massFlux, UnitDouble dtInsert) {
        this.d_particle = particle;
        this.d_numPartsPerCell = numPartsPerCell;
        this.d_massFlux = massFlux;
        this.d_dtInsert = dtInsert;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParticleInjection)) {
            return false;
        }
        ParticleInjection pi = (ParticleInjection)obj;
        return this.d_numPartsPerCell == pi.d_numPartsPerCell && theUtil.equal(this.d_particle, pi.d_particle) && theUtil.equal(this.d_massFlux, pi.d_massFlux);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (PyroSimObjectInputStream.getVersion(in) < 38 && this.d_massFlux != null) {
            assert (this.d_massFlux instanceof UnitDouble);
            UnitDouble mf = (UnitDouble)this.d_massFlux;
            this.d_massFlux = new TimeBasedValue<UnitDouble>(mf, TimeFunction.newDefault());
        }
    }

    private Object readResolve() throws ObjectStreamException {
        UnitDouble dtInsert = this.d_dtInsert == null ? SIUS.newud(0.01, 2) : this.d_dtInsert;
        return new ParticleInjection(this.d_particle, this.d_numPartsPerCell, this.getMassFlux(), dtInsert);
    }

    public Particle getParticle() {
        return this.d_particle;
    }

    public TimeBasedValue<UnitDouble> getMassFlux() {
        return (TimeBasedValue)this.d_massFlux;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, (IPyroObject)this.d_particle);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        Util.keepIfNullOr(objs, Particle.class);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old != this.d_particle) {
            return null;
        }
        return new AReplaceRefTask<Particle>((Object)old, (Object)replacement){

            @Override
            protected void set(Particle obj) {
                ParticleInjection.this.d_particle = obj;
            }
        };
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }
}

