/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import pyrosim.Intl;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;

public class SimError
extends Warning {
    public static final int WARNINGINFO_OBJS = 2;
    public final Level level;
    public final String cause;
    public final String fix;
    public final Set<? extends IPyroObject> causeObjs;

    public SimError(Level level, String cause, String fix, IPyroObject ... causeObjs) {
        this(level, cause, fix, Set.of(causeObjs));
    }

    public SimError(Level level, String cause, String fix, Collection<? extends IPyroObject> causeObjs) {
        super(cause, fix);
        Set<IPyroObject> set;
        this.level = level;
        this.cause = cause;
        this.fix = fix;
        if (causeObjs instanceof Set) {
            Set set2 = (Set)causeObjs;
            set = set2;
        } else {
            set = new LinkedIdentityHashSet<IPyroObject>(causeObjs);
        }
        this.causeObjs = set;
    }

    public String format() {
        return String.format(Intl.intl("%1$s: %2$s"), this.level.label, this.cause);
    }

    @Override
    public Comparable<?> getWarningInfo(int type) {
        if (type == 2) {
            List names = this.causeObjs.stream().map(o -> o instanceof INamed ? ((INamed)o).getName() : "").collect(Collectors.toList());
            return guiUtil.escapeHTML(String.join((CharSequence)"; ", names));
        }
        return super.getWarningInfo(type);
    }

    public static WarningReport<SimError> makeWarningReport() {
        return new WarningReport<SimError>(SimError.class, new int[]{0, 1, 2}, new String[]{Intl.intl("Message"), Intl.intl("Action Taken"), Intl.intl("Components")}, 0);
    }

    public static enum Level implements Comparable<Level>
    {
        MODERATE(Intl.intl("Warning"), 5),
        CRITICAL(Intl.intl("Error"), 10);

        public final String label;
        public final int severity;

        private Level(String label, int severity) {
            this.label = label;
            this.severity = severity;
        }
    }
}

