/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.Unit;
import pyrosim.PyroSim;
import pyrosim.domain.GridProcessUtil;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.ModelBackup;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.TypedProps;

public class PyroPrefs {
    public static final TypedProp<Integer> VERSION = TypedProps.newProp((Object)"PyroSim.version", Version.VER_0000.ordinal(), new Object[0]);
    public static final TypedProp<Boolean> PREF_CHECKLATEST = TypedProps.newProp((Object)"CheckLatest", true, new Object[0]);
    public static final TypedProp<String> PREF_LASTLIBRARY = TypedProps.newProp((Object)"LastLib", PyroPrefs.defDatabase(), new Object[0]);
    public static final TypedProp<Boolean> PREF_FDSPARALLEL_USEMPI = TypedProps.newProp((Object)"FDSParallelUseMpi", true, new Object[0]);
    public static final TypedProp<String> PREF_FDSCOMPABILITY = TypedProps.newProp((Object)"FDS.Compability", pyrosim.Version.FDS_DESIGN.toString(), new Object[0]);
    public static final TypedProp<String> PREF_MPOVLOCATION = TypedProps.newProp((Object)"MPOVLocation", "C:\\Documents and Settings\\birkey\\My Documents\\megapov-1.2.1-windows\\bin\\megapov.exe", new Object[0]);
    public static final TypedProp<String> PREF_DXFLOCATION = TypedProps.newProp((Object)"DXFLocation", Application.getApp().getInstallDir() + File.separator + "dxf2fds" + File.separator + "DXF2FDS.exe", new Object[0]);
    public static final TypedProp<Boolean> PREF_RUNSV = TypedProps.newProp((Object)"RunSV", true, new Object[0]);
    public static final TypedProp<Boolean> PREF_CUT_HOLES = TypedProps.newProp((Object)"Display.cutHoles", true, new Object[0]);
    public static final TypedProp<String> PREF_OPTIMIZE_FDS_PROCS = TypedProps.newProp((Object)"FDS.gridProcesses", GridProcessUtil.PREF.BASIC.getPropName(), new Object[0]);
    public static final TypedProp<String> PREF_MPI_PROC_COUNT = TypedProps.newProp((Object)"FDS.mpiProcCount", GridProcessUtil.PROC_COUNT.PER_CORE.getPropName(), new Object[0]);
    public static final TypedProp<Boolean> PREF_USEAUTOSAVE = TypedProps.newProp((Object)"UseAutosave", true, new Object[0]);
    public static final TypedProp<Boolean> PREF_CREATE_BACKUP_ON_OPEN = TypedProps.newProp((Object)"CreateBackupOnOpen", true, new Object[0]);
    public static final UDProp PREF_AUTOSAVE_INTERVAL = new UDProp("AutosaveInterval", ModelBackup.DEF_AUTOSAVE_PERIOD, NonSI.MINUTE);
    public static final TypedProp<Boolean> AUTOSAVE_ON_RUN_FDS = TypedProps.newProp((Object)"AutosaveOnRunFDS", false, new Object[0]);
    public static final TypedProp<Boolean> LIST_EDITORS_PROMPT_TO_SAVE = TypedProps.newProp((Object)"listEditorsPromptToSave", true, new Object[0]);
    public static final TypedProp<Boolean> SKIP_UPDATE = TypedProps.newProp((Object)"Update.skip", false, new Object[0]);
    public static final TypedProp<String> SKIP_UPDATE_VERSION = TypedProps.newProp((Object)"Update.skipVersion", "", new Object[0]);
    public static final TypedProp<Boolean> PROP_ENABLE_FDS_GEOM = TypedProps.newProp((Object)"FDSGeomEnabled", false, new Object[0]);
    public static final TypedProp<Boolean> VALIDATE_GEOM = TypedProps.newProp((Object)"PyroPrefs.ValidateGeom", true, new Object[0]);
    public static final TypedProp<Boolean> PREF_RECORD_PREVIEW = TypedProps.newProp((Object)"EnableRecordPreview", true, new Object[0]);
    public static final TypedProp<Integer> PREF_CLUSTER_NUMHOSTS = TypedProps.newProp((Object)"NumHosts", 0, new Object[0]);
    public static final TypedProp<Integer> UNDO_STACK_SIZE = TypedProps.newProp((Object)"UndoStackSize", 50, new Object[0]);
    public static final TypedProp<Boolean> PREF_DRAWCOLORBUFFER = new SafeModeProp<Boolean>("EnableColorBufferDrawing", Boolean.class, Boolean.valueOf(false), false);
    public static final TypedProp<Boolean> PREF_DRAWDEPTHBUFFER = new SafeModeProp<Boolean>("EnableDepthBufferDrawing", Boolean.class, Boolean.valueOf(false), false);
    public static final TypedProp<Boolean> ShowGridProp = TypedProps.newProp((Object)"3D.showGrid", true, new Object[0]);
    public static final TypedProp<Boolean> ShowBoundaryProp = TypedProps.newProp((Object)"3D.showBoundary", true, new Object[0]);
    public static final TypedProp<Boolean> ShowBoundaryLinesProp = TypedProps.newProp((Object)"3D.showBoundaryLines", false, new Object[0]);
    public static final TypedProp<Boolean> UseSVNavProp = TypedProps.newProp((Object)"3D.useSVNav", false, new Object[0]);
    public static final TypedProp<Double> DefaultSnapSpacing = TypedProps.newProp((Object)"FPE.snap.defaultSpacing", 1.0, new Object[0]);
    public static final TypedProp<Boolean> ShowSystemMouseProp = TypedProps.newProp((Object)"FPE.mouse.showSystem", true, new Object[0]);
    public static final TypedProp<Boolean> ShowGuidesProp = TypedProps.newProp((Object)"FPE.mouse.showGuides", true, new Object[0]);
    public static final TypedProp<Boolean> ShowOriginProp = TypedProps.newProp((Object)"FPE.showOrigin", true, new Object[0]);
    public static final TypedProp<Boolean> ShowAppearancesProp2D = TypedProps.newProp((Object)"FPE.showTextures", true, new Object[0]);
    public static final TypedProp<Boolean> ShowAppearancesProp3D = TypedProps.newProp((Object)"3D.showTextures", true, new Object[0]);
    public static final TypedProp<Boolean> ShowOutlinesProp2D = TypedProps.newProp((Object)"FPE.showOutlines", true, new Object[0]);
    public static final TypedProp<Boolean> ShowOutlinesProp3D = TypedProps.newProp((Object)"3D.showOutlines", true, new Object[0]);
    public static final TypedProp<Boolean> DrawWireframeProp2D = TypedProps.newProp((Object)"FPE.drawWireframe", false, new Object[0]);
    public static final TypedProp<Boolean> DrawWireframeProp3D = TypedProps.newProp((Object)"3D.drawWireframe", false, new Object[0]);
    public static final TypedProp<Boolean> UseSmoothLightingProp2D = TypedProps.newProp((Object)"FPE.useSmoothLighting", false, new Object[0]);
    public static final TypedProp<Boolean> UseSmoothLightingProp3D = TypedProps.newProp((Object)"3D.useSmoothLighting", true, new Object[0]);
    public static final TypedProp<Float> RECORD_VIEW_FONTSIZE = TypedProps.newProp((Object)"RecordViewFontsize", 12.0f, new Object[0]);
    public static final TypedProp<Boolean> SYNTAX_HIGHLIGHT_ENABLE = TypedProps.newProp((Object)"SyntaxHighlightEnable", Boolean.TRUE, new Object[0]);
    public static final TypedProp<Integer> SYNTAX_HIGHLIGHT_OBSTHOLELIMIT = TypedProps.newProp((Object)"SyntaxHighlightObstHoleLimit", 4000, new Object[0]);
    public static final TypedProp<Boolean> RESULTS_DISPLAYGE1 = TypedProps.newProp((Object)"InitSmokeViewGE1", false, new Object[0]);
    public static final TypedProp<Boolean> RESULTS_MESHBOUNDS = TypedProps.newProp((Object)"WriteGE1Meshes", true, new Object[0]);
    public static final TypedProp<Boolean> RESULTS_WRITEGE1 = TypedProps.newProp((Object)"WriteGE1", false, new Object[0]);
    public static final TypedProp<Boolean> RESULTS_WRITEPYROGEOM = TypedProps.newProp((Object)"WritePyroGeom", true, new Object[0]);
    public static final TypedProp<Boolean> RESULTS_WRITESMVINI = TypedProps.newProp((Object)"WriteINI", true, new Object[0]);
    public static final TypedProp<Boolean> RESULTS_WRITEVIEWS = TypedProps.newProp((Object)"WriteViews", true, new Object[0]);
    public static final TypedProp<Boolean> RESULTS_WRITEFLOORS = TypedProps.newProp((Object)"WriteFloors", true, new Object[0]);
    public static final TypedProp<Double> DISPLAY_EDGE_ERROR = TypedProps.newProp((Object)"Display.edgeError", 0.01, new Object[0]);
    public static final TypedProp<Double> DISPLAY_FACE_ERROR = TypedProps.newProp((Object)"Display.faceError", 0.1, new Object[0]);
    public static final TypedProp<Integer> LastSlcfDlgSizeX = TypedProps.newProp((Object)"Dialog.size.x.slcf", -1, new Object[0]);
    public static final TypedProp<Integer> LastSlcfDlgSizeY = TypedProps.newProp((Object)"Dialog.size.y.slcf", -1, new Object[0]);
    public static final TypedProp<Integer> LastPl3dDlgSizeX = TypedProps.newProp((Object)"Dialog.size.x.pl3d", -1, new Object[0]);
    public static final TypedProp<Integer> LastPl3dDlgSizeY = TypedProps.newProp((Object)"Dialog.size.y.pl3d", -1, new Object[0]);
    public static final TypedProp<Integer> LastBndfDlgSizeX = TypedProps.newProp((Object)"Dialog.size.x.bndf", -1, new Object[0]);
    public static final TypedProp<Integer> LastBndfDlgSizeY = TypedProps.newProp((Object)"Dialog.size.y.bndf", -1, new Object[0]);
    public static final TypedProp<Integer> LastIsofDlgSizeX = TypedProps.newProp((Object)"Dialog.size.x.isof", -1, new Object[0]);
    public static final TypedProp<Integer> LastIsofDlgSizeY = TypedProps.newProp((Object)"Dialog.size.y.isof", -1, new Object[0]);
    public static final TypedProp<Integer> LastRampDlgSizeX = TypedProps.newProp((Object)"Dialog.size.x.ramp", -1, new Object[0]);
    public static final TypedProp<Integer> LastRampDlgSizeY = TypedProps.newProp((Object)"Dialog.size.y.ramp", -1, new Object[0]);
    public static final TypedProp<Integer> LastManageFloorsDlgSizeX = TypedProps.newProp((Object)"Dialog.size.x.manageFloors", -1, new Object[0]);
    public static final TypedProp<Integer> LastManageFloorsDlgSizeY = TypedProps.newProp((Object)"Dialog.size.x.manageFloors", -1, new Object[0]);
    public static final TypedProp<Integer> LastHotkeyDlgSizeX = TypedProps.newProp((Object)"", -1, new Object[0]);
    public static final TypedProp<Integer> LastHotkeyDlgSizeY = TypedProps.newProp((Object)"", -1, new Object[0]);
    public static final int FDSFORMAT_SCIENTIFIC = 0;
    public static final int FDSFORMAT_ALIGNED = 1;
    public static final int FDSFORMAT_GENERAL = 2;
    public static final TypedProp<Integer> FDSFormatProp = TypedProps.newProp((Object)"FDS.format", 2, new Object[0]);
    public static final TypedProp<Integer> FDSFormatGenPrecision = TypedProps.newProp((Object)"FDS.format.general.precision", 6, new Object[0]);
    public static final TypedProp<Integer> FDSFormatAlignedDec = TypedProps.newProp((Object)"FDS.format.aligned.numDecimals", 2, new Object[0]);
    public static final TypedProp<Integer> FDSFormatAlignedWidth = TypedProps.newProp((Object)"FDS.format.aligned.width", 10, new Object[0]);
    public static final TypedProp<String> UnitSystemProp = TypedProps.newProp((Object)"PyroSim.UnitSystem", SIUS.getInstance().getSystemName(), new Object[0]);
    public static final TypedProp<String> LicenseDirProp = TypedProps.newProp((Object)"PyroSim.licenseDir", PyroPrefs.defLicenseDir(), new Object[0]);
    public static final TypedProp<String> LicenseServerProp = TypedProps.newProp((Object)"PyroSim.licenseServer", "", new Object[0]);
    public static final TypedProp<String> LastFDSDatabaseDirProp = TypedProps.newProp((Object)"File.lastDir.FDSDatabase", Application.getApp().getInstallDir() + File.separator + "fds", new Object[0]);
    public static final TypedProp<Integer> LastScreenShotWidth = TypedProps.newProp((Object)"File.screenShot.width", 1024, new Object[0]);
    public static final TypedProp<Integer> LastScreenShotHeight = TypedProps.newProp((Object)"File.screenShot.height", 768, new Object[0]);
    public static final TypedProp<Boolean> LastScreenShotPyroButton = TypedProps.newProp((Object)"File.screenShot.pyroButton", true, new Object[0]);
    public static final TypedProp<Boolean> POVScreenShotAntiAlias = TypedProps.newProp((Object)"File.screenShot.AntiAlias", true, new Object[0]);
    public static final TypedProp<Boolean> POVScreenShotShadows = TypedProps.newProp((Object)"File.screenShot.Shadows", true, new Object[0]);
    public static final TypedProp<Boolean> POVScreenShotPOVFile = TypedProps.newProp((Object)"File.screenShot.POVFile", false, new Object[0]);
    public static final TypedProp<String> FDSFEA_ApiKey = TypedProps.newProp((Object)"FDS.FEA.apiKey", "", new Object[0]);
    public static final String FDS_SINGLE = "location";
    public static final String FDS_OPENMP = "openMPLocation";
    public static final String FDS_RUNFDS = "runFDSLocation";
    public static final String FDS_MPIEXEC = "mpiExecLocation";
    public static final String FDS_SMOKEVIEW = "sv.location";
    public static final String FDS_SMPDPORT = "SMPDPort";
    public static final String FDS_CLUSTERPORT = "clusterPort";
    public static final TypedProp<Boolean> RESULTS_OPEN_THROUGH_SOCKET = TypedProps.newProp((Object)"Results.openThroughSocket", true, new Object[0]);
    public static final TypedProp<String> OPEN_DIR_PREF = TypedProps.newProp((Object)"LastDir.Open", String.class, new Object[0]);
    private static final Map<String, String> s_fdsLocPrefs = new HashMap<String, String>();

    private static String installRootPath(String subFolder, String name) {
        File parent = new File(Application.getApp().getInstallDir(), subFolder);
        return new File(parent, name).getAbsolutePath();
    }

    private static String defDatabase() {
        String defDatabaseFilename = "property_library.fds";
        String installDir = Application.getApp().getInstallDir();
        StringBuffer sb = new StringBuffer(installDir);
        sb.append(File.separator);
        sb.append(defDatabaseFilename);
        return sb.toString().replaceAll("/", Matcher.quoteReplacement(File.separator));
    }

    private static String defLicenseDir() {
        String dirSep = File.separator;
        String programData = System.getenv("ALLUSERSPROFILE");
        return programData + dirSep + "Application Data" + dirSep + "PyroSim" + dirSep + "license";
    }

    public static TeciProps instance() {
        return PyroSim.getApp().getPrefs();
    }

    public static double getDouble(TypedProp<Double> prop) {
        return PyroPrefs.instance().getDouble(prop);
    }

    public static UnitDouble getUnitDouble(UDProp prop) {
        return new UnitDouble(PyroPrefs.instance().getDouble(prop), prop.d_storeUnit);
    }

    public static float getFloat(TypedProp<Float> prop) {
        return PyroPrefs.instance().getFloat(prop);
    }

    public static String getString(TypedProp<String> prop) {
        return PyroPrefs.instance().getString(prop);
    }

    public static int getInt(TypedProp<Integer> prop) {
        return PyroPrefs.instance().getInt(prop);
    }

    public static boolean getBoolean(TypedProp<Boolean> prop) {
        return PyroPrefs.instance().getBoolean(prop);
    }

    public static <T> T get(TypedProp<T> prop) {
        return PyroPrefs.instance().get(prop);
    }

    public static <T> void set(TypedProp<T> prop, T val, boolean saveOnComplete) {
        PyroSim psm = PyroSim.getApp();
        psm.getPrefs().set(prop, val);
        if (saveOnComplete) {
            psm.superSavePreferences();
        }
    }

    public static void set(UDProp prop, UnitDouble val, boolean saveOnComplete) {
        PyroPrefs.set(prop, val.getValue(prop.d_storeUnit), saveOnComplete);
    }

    public static <T> void set(TypedProp<T> prop, T val) {
        PyroPrefs.set(prop, val, false);
    }

    public static List<SafeModeProp> getSafeModeProps() {
        ArrayList<SafeModeProp> props = new ArrayList<SafeModeProp>();
        try {
            for (Field field : PyroPrefs.class.getFields()) {
                Object val = field.get(null);
                if (!(val instanceof SafeModeProp)) continue;
                props.add((SafeModeProp)val);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return props;
    }

    public static String getLastVersion() {
        String key = PyroSim.is64Bit() ? "LastVersion.64" : "LastVersion.32";
        return PyroPrefs.instance().getString(key, "2025.1.0826");
    }

    public static void updateLastVersion() {
        String key = PyroSim.is64Bit() ? "LastVersion.64" : "LastVersion.32";
        PyroPrefs.instance().set(key, "2025.1.0826");
    }

    private static String getToolPref(TypedProp<String> key32, TypedProp<String> key64) {
        TypedProp<String> key = PyroPrefs.getToolPrefKey(key32, key64);
        return PyroPrefs.getString(key);
    }

    private static <T> TypedProp<T> getToolPrefKey(TypedProp<T> key32, TypedProp<T> key64) {
        return PyroSim.is64Bit() ? key64 : key32;
    }

    public static String getFDSLocation() {
        return PyroPrefs.getFDSLoc(FDS_SINGLE, true);
    }

    public static String getRunFDSLocation() {
        return PyroPrefs.getFDSLoc(FDS_RUNFDS, true);
    }

    public static String getMPIExecLocation() {
        return PyroPrefs.getFDSLoc(FDS_MPIEXEC, true);
    }

    public static String getSmokeviewLocation() {
        return PyroPrefs.getFDSLoc(FDS_SMOKEVIEW, true);
    }

    public static String getResultsLocation() {
        String installDir = Application.getApp().getInstallDir();
        String resultsLoc = ".";
        if (installDir != null) {
            resultsLoc = installDir;
        }
        ArrayList<String> resultsNames = new ArrayList<String>();
        boolean debug = Application.isDebug();
        if (debug) {
            resultsNames.add("bin/x64/Debug/PyroSimResults/PyroSimResults64_d.exe");
        }
        resultsNames.add("bin/x64/Release/PyroSimResults/PyroSimResults64.exe");
        resultsNames.add("PyroSimResults.exe");
        for (String behemothName : resultsNames) {
            File f = new File(resultsLoc, behemothName);
            if (!f.exists()) continue;
            System.out.println("Results Loc: " + f.getAbsolutePath());
            return f.getAbsolutePath();
        }
        assert (false);
        return null;
    }

    public static String getFDSLoc(String locKey, boolean getDefaultIfUnset) {
        return PyroPrefs.getFDSLoc("2025.1.0826", locKey, getDefaultIfUnset);
    }

    public static String getFDSLoc(String pyroRevision, String locKey, boolean getDefaultIfUnset) {
        String key = PyroPrefs.fdsKey(pyroRevision, locKey, PyroSim.is64Bit());
        String value = PyroPrefs.instance().getString(key, null);
        if (value == null && getDefaultIfUnset) {
            value = s_fdsLocPrefs.get(key);
            assert (value != null);
        }
        return value;
    }

    public static void setFDSLoc(String locKey, String value) {
        PyroPrefs.setFDSLoc("2025.1.0826", locKey, value);
    }

    public static void setFDSLoc(String pyroRevision, String locKey, String value) {
        String key = PyroPrefs.fdsKey(pyroRevision, locKey, PyroSim.is64Bit());
        if (value == null || value.equals(s_fdsLocPrefs.get(key))) {
            PyroPrefs.instance().remove(key);
        } else {
            PyroPrefs.instance().set(key, value);
        }
    }

    private static String fdsKey(String key, boolean is64Bit) {
        return PyroPrefs.fdsKey("2025.1.0826", key, is64Bit);
    }

    private static String fdsKey(String pyroRevision, String fdsKey, boolean is64Bit) {
        String bit = is64Bit ? "64" : "32";
        String key = "PyroSim_" + pyroRevision + ".FDS." + bit + "." + fdsKey;
        return key;
    }

    public static Version getVersion() {
        int ver = PyroPrefs.instance().getInt(VERSION);
        return ver < Version.values().length && ver >= 0 ? Version.values()[ver] : Version.VER_0000;
    }

    public static void save() {
        PyroPrefs.instance().set(VERSION, Integer.valueOf(Version.curr().ordinal()));
    }

    static {
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_SINGLE, false), PyroPrefs.installRootPath("fds", "fds.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_SINGLE, true), PyroPrefs.installRootPath("fds", "fds.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_RUNFDS, false), PyroPrefs.installRootPath("fds", "runfds.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_RUNFDS, true), PyroPrefs.installRootPath("fds", "runfds.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_MPIEXEC, false), PyroPrefs.installRootPath("fds/mpi", "mpiexec.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_MPIEXEC, true), PyroPrefs.installRootPath("fds/mpi", "mpiexec.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_SMOKEVIEW, false), PyroPrefs.installRootPath("fds", "smokeview.exe"));
        s_fdsLocPrefs.put(PyroPrefs.fdsKey(FDS_SMOKEVIEW, true), PyroPrefs.installRootPath("fds", "smokeview.exe"));
    }

    public static class UDProp
    extends TypedProp<Double> {
        public final Unit d_storeUnit;

        public UDProp(String key, UnitDouble defVal, Unit storeUnit) {
            super(key, Double.class, defVal.getValue(storeUnit), Set.of());
            this.d_storeUnit = storeUnit;
        }
    }

    public static class SafeModeProp<T>
    extends TypedProp<T> {
        public final T safeVal;

        public SafeModeProp(String key, Class<T> type, T defVal, T safeVal) {
            super(key, type, defVal, Set.of());
            this.safeVal = safeVal;
        }
    }

    public static enum Version {
        VER_0000,
        VER_0001,
        VER_0002,
        VER_0003;


        static Version curr() {
            return Version.values()[Version.values().length - 1];
        }
    }
}

