/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.Version;
import pyrosim.gui.MpiUtil;
import pyrosim.gui.ProcessUtil;

public class FDSVersion
implements Comparable<FDSVersion> {
    private static final Logger LOGGER = Logger.getLogger(FDSVersion.class.getName());
    private static final Pattern PATTERN_V6_8 = Pattern.compile("Revision\\s+:\\s+FDS-([0-9]+).([0-9]+).([0-9]+)");
    private static final Pattern PATTERN_V6_7 = Pattern.compile("Revision\\s+:\\s+FDS([0-9]).([0-9]).([0-9])");
    private static final Pattern PATTERN_V612 = Pattern.compile(" Version          : FDS ([0-9]).([0-9]).([0-9])");
    public static final FDSVersion V5_0_0 = new FDSVersion(5, 0, 0, 0);
    public static final FDSVersion V5_5_0 = new FDSVersion(5, 5, 0, 0);
    public static final FDSVersion V5_5_2 = new FDSVersion(5, 5, 2, 0);
    public static final FDSVersion V5_5_3 = new FDSVersion(5, 5, 3, 0);
    public static final FDSVersion V6_0_0_3 = new FDSVersion(6, 0, 0, 3);
    public static final FDSVersion V6_0_0 = new FDSVersion(6, 0, 0, 0);
    public static final FDSVersion V6_0_1 = new FDSVersion(6, 0, 1, 0);
    public static final FDSVersion V6_1_0 = new FDSVersion(6, 1, 0, 0);
    public static final FDSVersion V6_1_1 = new FDSVersion(6, 1, 1, 0);
    public static final FDSVersion V6_1_2 = new FDSVersion(6, 1, 2, 0);
    public static final FDSVersion V6_2_0 = new FDSVersion(6, 2, 0, 0);
    public static final FDSVersion V6_3_0 = new FDSVersion(6, 3, 0, 0);
    public static final FDSVersion V6_3_1 = new FDSVersion(6, 3, 1, 0);
    public static final FDSVersion V6_3_2 = new FDSVersion(6, 3, 2, 0);
    public static final FDSVersion V6_4_0 = new FDSVersion(6, 4, 0, 0);
    public static final FDSVersion V6_5_1 = new FDSVersion(6, 5, 1, 0);
    public static final FDSVersion V6_5_3 = new FDSVersion(6, 5, 3, 0);
    public static final FDSVersion V6_6_0 = new FDSVersion(6, 6, 0, 0);
    public static final FDSVersion V6_7_0 = new FDSVersion(6, 7, 0, 0);
    public static final FDSVersion V6_7_1 = new FDSVersion(6, 7, 1, 0);
    public static final FDSVersion V6_7_3 = new FDSVersion(6, 7, 3, 0);
    public static final FDSVersion V6_7_4 = new FDSVersion(6, 7, 4, 0);
    public static final FDSVersion V6_7_5 = new FDSVersion(6, 7, 5, 0);
    public static final FDSVersion V6_7_6 = new FDSVersion(6, 7, 6, 0);
    public static final FDSVersion V6_7_7 = new FDSVersion(6, 7, 7, 0);
    public static final FDSVersion V6_7_8 = new FDSVersion(6, 7, 8, 0);
    public static final FDSVersion V6_7_9 = new FDSVersion(6, 7, 9, 0);
    public static final FDSVersion V6_8_0 = new FDSVersion(6, 8, 0, 0);
    public static final FDSVersion V6_9_0 = new FDSVersion(6, 9, 0, 0);
    public static final FDSVersion V6_9_1 = new FDSVersion(6, 9, 1, 0);
    public static final FDSVersion V6_10_0 = new FDSVersion(6, 10, 0, 0);
    public static final FDSVersion V6_10_1 = new FDSVersion(6, 10, 1, 0);
    public final int major;
    public final int minor;
    public final int maintenance;
    public final int rc;

    public static Collection<FDSVersion> getSupported() {
        return Arrays.asList(Version.FDS_DESIGN);
    }

    public FDSVersion(int major, int minor, int maintenance, int rc) {
        this.major = major;
        this.minor = minor;
        this.maintenance = maintenance;
        this.rc = rc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FDSVersion)) {
            return false;
        }
        FDSVersion fv = (FDSVersion)obj;
        return fv.major == this.major && fv.minor == this.minor && fv.maintenance == this.maintenance && fv.rc == this.rc;
    }

    @Override
    public int compareTo(FDSVersion o) {
        if (this.major == o.major) {
            if (this.minor == o.minor) {
                if (this.maintenance == o.maintenance) {
                    return this.rc - o.rc;
                }
                return this.maintenance - o.maintenance;
            }
            return this.minor - o.minor;
        }
        return this.major - o.major;
    }

    public static FDSVersion parse(String str) throws ParseException {
        Matcher m68 = PATTERN_V6_8.matcher(str);
        if (m68.find()) {
            String major = m68.group(1);
            String minor = m68.group(2);
            String maint = m68.group(3);
            int imajor = Integer.parseInt(major);
            int iminor = Integer.parseInt(minor);
            int imaint = Integer.parseInt(maint);
            return new FDSVersion(imajor, iminor, imaint, 0);
        }
        Matcher m67 = PATTERN_V6_7.matcher(str);
        if (m67.find()) {
            String major = m67.group(1);
            String minor = m67.group(2);
            String maint = m67.group(3);
            int imajor = Integer.parseInt(major);
            int iminor = Integer.parseInt(minor);
            int imaint = Integer.parseInt(maint);
            return new FDSVersion(imajor, iminor, imaint, 0);
        }
        Matcher m612 = PATTERN_V612.matcher(str);
        if (m612.find()) {
            String major = m612.group(1);
            String minor = m612.group(2);
            String maint = m612.group(3);
            int imajor = Integer.parseInt(major);
            int iminor = Integer.parseInt(minor);
            int imaint = Integer.parseInt(maint);
            return new FDSVersion(imajor, iminor, imaint, 0);
        }
        if (str.startsWith("Version:")) {
            int sepchar = str.indexOf(59);
            String verstr = str.substring(9, sepchar).trim().toLowerCase();
            boolean versionIsReleaseCandidate = (verstr = verstr.replace("fds", "")).contains("release candidate");
            if (versionIsReleaseCandidate) {
                verstr = verstr.replace("release candidate", "");
            }
            StringTokenizer strtok = new StringTokenizer(verstr, " ,.;");
            ArrayDeque<String> vernums = new ArrayDeque<String>();
            while (strtok.hasMoreTokens()) {
                vernums.add(strtok.nextToken());
            }
            int major = 0;
            int minor = 0;
            int maint = 0;
            int rc = 0;
            major = Integer.parseInt((String)vernums.removeFirst());
            if (versionIsReleaseCandidate) {
                rc = Integer.parseInt((String)vernums.removeLast());
            }
            if (!vernums.isEmpty()) {
                minor = Integer.parseInt((String)vernums.removeFirst());
            }
            if (!vernums.isEmpty()) {
                maint = Integer.parseInt((String)vernums.removeFirst());
            }
            return new FDSVersion(major, minor, maint, rc);
        }
        throw new ParseException(Intl.intl("Could not parse FDS version."), 0);
    }

    public String toString() {
        if (this.rc == 0) {
            return String.format("Version %d.%d.%d", this.major, this.minor, this.maintenance);
        }
        if (this.minor == 0 && this.maintenance == 0) {
            return String.format("Version %d RC%d", this.major, this.rc);
        }
        if (this.maintenance == 0) {
            return String.format("Version %d.%d RC%d", this.major, this.minor, this.rc);
        }
        return String.format("Version %d.%d.%d RC%d", this.major, this.minor, this.maintenance, this.rc);
    }

    public static FDSVersion detectCompability(File exeLoc) throws Exception {
        if (!exeLoc.exists()) {
            throw new IOException(String.format(Intl.intl("File not found: %s"), exeLoc.getAbsolutePath()));
        }
        ProcessBuilder pb = new ProcessBuilder(exeLoc.getPath());
        MpiUtil.scrubEnvMpi(pb.environment());
        File mpiFolder = new File(PyroPrefs.getMPIExecLocation()).getParentFile();
        pb.environment().put("PATH", MpiUtil.buildEnvPath("", mpiFolder.getPath(), System.getenv("WINDIR"), System.getenv("WINDIR") + "\\system32"));
        try {
            ProcessUtil.ProcessResult pr = ProcessUtil.run(pb.start(), 3);
            try {
                return FDSVersion.parse(pr.stderr);
            }
            catch (ParseException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
                try {
                    return FDSVersion.parse(pr.stdout);
                }
                catch (ParseException e2) {
                    LOGGER.log(Level.WARNING, e2.getMessage(), e2);
                    return null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

