/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.treeview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.gui.IDnDTreeModel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.SortCache;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class PyroTreeModel
implements IDnDTreeModel {
    private final PyroMod d_mediator;
    private final List<TreeModelListener> d_listeners;
    private boolean d_dragging;
    private Map<Object, SortCache> d_caches;

    public PyroTreeModel(PyroMod pMod) {
        this.d_mediator = pMod;
        this.d_listeners = new ArrayList<TreeModelListener>();
        this.d_dragging = false;
        this.d_caches = new IdentityHashMap<Object, SortCache>();
    }

    @Override
    public void addTreeModelListener(TreeModelListener tml) {
        this.d_listeners.add(tml);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener tml) {
        this.d_listeners.remove(tml);
    }

    public <T> TVEntryPoint<T> ep(T obj) {
        return TVEntryPoints.ep(obj);
    }

    @Override
    public Object getRoot() {
        return this.d_mediator;
    }

    private void invalidateCaches() {
        this.d_caches.clear();
    }

    private void invalidateChildCaches(Collection<?> parents) {
        this.d_caches.keySet().removeAll(parents);
    }

    private SortCache getSortCache(Object mgr) {
        TVEntryPoint<Object> ep;
        SortCache cache = this.d_caches.get(mgr);
        if (cache == null && (ep = this.ep(mgr)) != null) {
            cache = new SortCache(ep.getTreeviewChildren(this.d_mediator, mgr));
            this.d_caches.put(mgr, cache);
        }
        return cache;
    }

    @Override
    public boolean isLeaf(Object obj) {
        TVEntryPoint<Object> ep = this.ep(obj);
        if (ep == null) {
            return true;
        }
        return ep.isLeaf(this.d_mediator, obj);
    }

    @Override
    public int getChildCount(Object parent) {
        SortCache ixCache = this.getSortCache(parent);
        if (ixCache == null) {
            return 0;
        }
        return ixCache.size();
    }

    @Override
    public Object getChild(Object parent, int index) {
        SortCache ixCache = this.getSortCache(parent);
        assert (ixCache != null);
        return ixCache.get(index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        SortCache ixCache = this.getSortCache(parent);
        assert (ixCache != null);
        return ixCache.indexOf(child);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newVal) {
        Object obj = path.getLastPathComponent();
        String newName = ((String)newVal).trim();
        if (newName.isEmpty()) {
            return;
        }
        TVEntryPoint<Object> ep = this.ep(obj);
        if (ep != null && ep.canRename(this.d_mediator, obj)) {
            ep.setName(this.d_mediator, obj, newName);
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent evt) {
        for (TreeModelListener listener : this.d_listeners) {
            listener.treeStructureChanged(evt);
        }
    }

    protected void fireTreeNodesChanged(TreeModelEvent evt) {
        for (TreeModelListener listener : this.d_listeners) {
            listener.treeNodesChanged(evt);
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent evt) {
        for (TreeModelListener listener : this.d_listeners) {
            listener.treeNodesInserted(evt);
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent evt) {
        for (TreeModelListener listener : this.d_listeners) {
            listener.treeNodesRemoved(evt);
        }
    }

    public TreePath pathForObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj == this.getRoot()) {
            return new TreePath(obj);
        }
        TVEntryPoint<Object> ep = TVEntryPoints.ep(obj);
        if (!ep.showInTree(this.d_mediator, obj)) {
            return null;
        }
        Object pathObj = obj;
        ArrayList<Object> revPath = new ArrayList<Object>();
        while (pathObj != null) {
            revPath.add(pathObj);
            pathObj = this.parentForObject(pathObj);
        }
        if (revPath.isEmpty() || revPath.get(revPath.size() - 1) != this.getRoot()) {
            System.err.println("returning null tree path for: " + obj.getClass().getName());
            return null;
        }
        Object[] path = new Object[revPath.size()];
        for (int m = revPath.size() - 1; m >= 0; --m) {
            path[revPath.size() - m - 1] = revPath.get(m);
        }
        return new TreePath(path);
    }

    public Object parentForObject(Object obj) {
        TVEntryPoint<Object> ep = this.ep(obj);
        return ep.getTreeviewParent(this.d_mediator, obj);
    }

    public void update(Events events) {
        if (events.getEvents(PyroMod.class, new Class[0]).containsChange(PyroMod.EVT_MODEL_CHANGED)) {
            this.invalidateCaches();
        } else {
            this.invalidateChildCaches(events.getEvents(IPyroObject.class, new Class[0]).getChangedObjs(PyroMod.EVT_CHILDREN_ADDED, PyroMod.EVT_CHILDREN_REMOVED, PyroMod.EVT_CHILDREN_CHANGED));
        }
        Set<Object> structuresChanged = new LinkedIdentityHashSet();
        LinkedIdentityHashSet nodesChanged = new LinkedIdentityHashSet();
        Set<Object> addedObjs = new LinkedIdentityHashSet();
        boolean surfDefChanged = false;
        IEventRecord<IPyroObject> pyroEvts = events.getEvents(IPyroObject.class, new Class[0]);
        structuresChanged.addAll(pyroEvts.getChangedObjs(PyroMod.EVT_CHILDREN_CHANGED, PyroMod.EVT_CHILDREN_REMOVED));
        addedObjs.addAll(pyroEvts.getAddedObjs());
        addedObjs.addAll(pyroEvts.getChangedObjs(PyroMod.EVT_PARENT_CHANGED));
        nodesChanged.addAll(pyroEvts.getChangedNotOfType(PyroMod.EVT_SEL, PyroMod.EVT_PARENT_CHANGED));
        surfDefChanged |= !events.getAffectedChannels(SimParams.Misc.class, new Class[0]).isEmpty();
        addedObjs = this.pruneToHighestParents(addedObjs);
        for (TreeModelEvent evt : this.toEvents(addedObjs, SortMethod.ASCENDING)) {
            this.fireTreeNodesInserted(evt);
        }
        structuresChanged = this.pruneToHighestParents(structuresChanged);
        for (Object obj : structuresChanged) {
            TreePath path = this.pathForObject(obj);
            if (path == null) continue;
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, path));
        }
        List<TreeModelEvent> changeEvents = this.toEvents(nodesChanged, SortMethod.NONE);
        for (TreeModelEvent changeEvent : changeEvents) {
            this.fireTreeNodesChanged(changeEvent);
        }
        if (surfDefChanged) {
            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, this.pathForObject(this.d_mediator.getSurfaceMgr())));
        }
    }

    private Set<Object> pruneToHighestParents(Set<?> objs) {
        LinkedIdentityHashSet<Object> result = new LinkedIdentityHashSet<Object>(objs.size());
        for (Object obj : objs) {
            if (this.containsParent(objs, obj)) continue;
            result.add(obj);
        }
        return result;
    }

    private boolean containsParent(Set<?> objs, Object obj) {
        TVEntryPoint<Object> ep;
        while (obj != null && (ep = this.ep(obj)) != null) {
            Object parent = ep.getTreeviewParent(this.d_mediator, obj);
            if (parent != null && objs.contains(parent)) {
                return true;
            }
            obj = parent;
        }
        return false;
    }

    private <E> List<TreeModelEvent> toEvents(Collection<E> objs, final SortMethod sorting) {
        Predicate<Object> showInTreeFilter = new Predicate<Object>(){

            @Override
            public boolean test(Object o) {
                return TVEntryPoints.ep(o).showInTree(PyroTreeModel.this.d_mediator, o);
            }
        };
        Map<Object, List<E>> parentChildMap = this.getParentChildMap(objs);
        ArrayList<TreeModelEvent> events = new ArrayList<TreeModelEvent>(parentChildMap.size());
        for (Map.Entry<Object, List<E>> entry : parentChildMap.entrySet()) {
            final Object parent = entry.getKey();
            List<E> childSet = entry.getValue();
            TreePath parentPath = this.pathForObject(parent);
            if (parentPath == null) continue;
            Object[] children = theUtil.filter(childSet, showInTreeFilter).toArray();
            if (sorting != SortMethod.NONE) {
                Comparator<Object> childIxComp = new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return sorting == SortMethod.ASCENDING ? PyroTreeModel.this.getIndexOfChild(parent, o1) - PyroTreeModel.this.getIndexOfChild(parent, o2) : PyroTreeModel.this.getIndexOfChild(parent, o2) - PyroTreeModel.this.getIndexOfChild(parent, o1);
                    }
                };
                Arrays.sort(children, childIxComp);
            }
            int[] childIxes = new int[children.length];
            for (int m = 0; m < children.length; ++m) {
                childIxes[m] = this.getIndexOfChild(parent, children[m]);
            }
            events.add(new TreeModelEvent((Object)this, parentPath, childIxes, children));
        }
        return events;
    }

    private <E> Map<Object, List<E>> getParentChildMap(Collection<E> objs) {
        LinkedIdentityHashMap<Object, List<E>> map = new LinkedIdentityHashMap<Object, List<E>>();
        for (E obj : objs) {
            Object parent = this.parentForObject(obj);
            if (parent == null) continue;
            ArrayList<E> children = (ArrayList<E>)map.get(parent);
            if (children == null) {
                children = new ArrayList<E>();
                map.put(parent, children);
            }
            children.add(obj);
        }
        return map;
    }

    @Override
    public IDnDTreeModel.IDragPacket preparePacket(List<? extends TreePath> dragPaths) {
        return new DragPacket(dragPaths);
    }

    @Override
    public boolean canDrop(IDnDTreeModel.IDragPacket packet, Object target) {
        if (target == null) {
            return false;
        }
        DragPacket pyroPacket = (DragPacket)packet;
        TVEntryPoint<Object> ep = this.ep(target);
        return ep.canDrop(this.d_mediator, target, pyroPacket.objs, pyroPacket.commonParent);
    }

    @Override
    public void drop(IDnDTreeModel.IDragPacket packet, Object target, int insertPos) {
        DragPacket pyroPacket = (DragPacket)packet;
        TVEntryPoint<Object> ep = this.ep(target);
        Task task = ep.drop(this.d_mediator, target, insertPos, pyroPacket.objs);
        this.d_mediator.getTaskManager().exec(task, Intl.intl("Reorder Objects"));
    }

    @Override
    public void drop(IDnDTreeModel.IDragPacket packet, Object target) {
        this.drop(packet, target, 0);
    }

    @Override
    public void setDragging(boolean dragging) {
        this.d_dragging = dragging;
    }

    @Override
    public boolean isDragging() {
        return this.d_dragging;
    }

    @Override
    public boolean isLeafDroppable(Object leaf) {
        return TVEntryPoints.ep(leaf).isDroppable(this.d_mediator, leaf);
    }

    private static enum SortMethod {
        NONE,
        ASCENDING,
        DESCENDING;

    }

    public static class DragPacket
    extends IDnDTreeModel.DefaultDragPacket {
        public final Set<Object> objs;
        public final IPyroObject commonParent;

        public DragPacket(List<? extends TreePath> paths) {
            super(paths);
            this.objs = new LinkedIdentityHashSet<Object>(paths.size());
            for (TreePath treePath : paths) {
                this.objs.add(treePath.getLastPathComponent());
            }
            this.commonParent = Hierarchy.getCommonParent(theUtil.filter(this.objs, IPyroObject.class));
        }
    }
}

