/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.mv.gui.ValueEditorUtil;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawProps;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.util.theUtil;

public class DrawAABoxGeomTool
extends ADrawTool {
    private AABoxGeom d_block = null;

    public DrawAABoxGeomTool(IToolController controller, DrawProps toolProps) {
        super(controller, toolProps, DrawProps.GeomSpace.S3D);
    }

    @Override
    public Class<? extends IGeom> getGeomType() {
        return AABoxGeom.class;
    }

    @Override
    protected boolean getSnapToWorkingPlane() {
        return false;
    }

    @Override
    protected void initValueEditor(ValueEditor editor) {
        ValueEditorUtil.configureLocation(editor, Intl.intl("First Point (x,y,z)"));
        ValueEditorUtil.configureOffset(editor, null, Intl.intl("Dimensions (L,W,H)"), Intl.intl("Second Point (x,y,z)"));
    }

    @Override
    public void pointAdded(MouseHistory history, MouseHistory.Point p) {
        if (history.size() < 2) {
            this.d_block = null;
            this.fireRemove(0);
            return;
        }
        List<Point3d> points = history.getAllPoints();
        Point3d p1 = points.get(0);
        Point3d p2 = points.get(1);
        AABox box = new AABox();
        box.add(p1, p2);
        Vector3d extrudeDir = this.getBoxExtrusion(p1, p2);
        if (extrudeDir != null) {
            box.add(Util3D.add(p1, (Tuple3d)extrudeDir));
        }
        this.d_block = new AABoxGeom(box.getMin(), box.getMax());
        this.fireUpdate(0, GeomNodeUtil.newNode(this.d_block), null);
        if (p.committed) {
            this.finish();
        }
        this.repaintSurface();
    }

    protected Vector3d getBoxExtrusion(Point3d p1, Point3d p2) {
        double height = this.getProps().get(DrawProps.HEIGHT).getValue(Geometry.LU);
        if (this.getView().getCamera() instanceof OrthoCamera) {
            Vector3d extrudeDir = new Vector3d(this.getView().getCamera().getViewVector());
            extrudeDir.normalize();
            extrudeDir.negate();
            extrudeDir.scale(height);
            return extrudeDir;
        }
        Vector3d pDir = Util3D.vector(p1, p2);
        double dot = pDir.dot(GeomConstants.VEC3D_ZPOS);
        if (theUtil.eq0(dot, 1.0E-9)) {
            return new Vector3d(0.0, 0.0, height);
        }
        return null;
    }

    @Override
    public void finish() {
        this.fireFinish(this.d_block != null);
        super.finish();
    }

    @Override
    public void reset() {
        this.fireRemove(0);
        this.d_block = null;
        super.reset();
    }
}

