/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.snappers;

import java.util.ArrayList;
import java.util.Arrays;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.domain.Floor;
import pyrosim.domain.Grid;
import pyrosim.geom.Geometry;
import pyrosim.mv.displays.GridDisplay;
import pyrosim.mv.displays.GridDisplayManager;
import pyrosim.mv.snappers.IGridSnapper;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IPrimElements;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.picking.CancelObjectPicking;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class ModelGridSnapper
implements IGridSnapper {
    private final GridDisplayManager d_dispMgr;
    private final Grid d_grid;
    private double[] d_xSnaps;
    private double[] d_ySnaps;
    private double[] d_zSnaps;
    private Floor d_activeFloor;

    public ModelGridSnapper(GridDisplayManager dispMgr, Grid modelGrid) {
        this.d_dispMgr = dispMgr;
        this.d_grid = modelGrid;
        this.d_activeFloor = null;
        this.resetData();
    }

    public void setActiveFloor(Floor floor) {
        this.d_activeFloor = floor;
    }

    public void resetData() {
        Unit u = Geometry.LU;
        Point3d min = this.d_grid.getMinPoint().getValue(u);
        Point3d max = this.d_grid.getMaxPoint().getValue(u);
        UnitDouble[] xDivs = this.d_grid.getXLinePositions();
        this.d_xSnaps = new double[xDivs.length];
        for (int i = 0; i < xDivs.length; ++i) {
            this.d_xSnaps[i] = xDivs[i].getValue(u);
        }
        if (xDivs.length > 0) {
            this.d_xSnaps[0] = min.x;
            this.d_xSnaps[this.d_xSnaps.length - 1] = max.x;
        }
        UnitDouble[] yDivs = this.d_grid.getYLinePositions();
        this.d_ySnaps = new double[yDivs.length];
        for (int i = 0; i < yDivs.length; ++i) {
            this.d_ySnaps[i] = yDivs[i].getValue(u);
        }
        if (yDivs.length > 0) {
            this.d_ySnaps[0] = min.y;
            this.d_ySnaps[this.d_ySnaps.length - 1] = max.y;
        }
        UnitDouble[] zDivs = this.d_grid.getZLinePositions();
        this.d_zSnaps = new double[zDivs.length];
        for (int i = 0; i < zDivs.length; ++i) {
            this.d_zSnaps[i] = zDivs[i].getValue(u);
        }
        if (zDivs.length > 0) {
            this.d_zSnaps[0] = min.z;
            this.d_zSnaps[this.d_zSnaps.length - 1] = max.z;
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return DisplayGeom.EMPTY;
    }

    public boolean[] getVisibility() {
        GridDisplay gd = (GridDisplay)this.d_dispMgr.getDisplay(this.d_grid);
        if (gd == null) {
            return new boolean[]{false, false, false};
        }
        return gd.getVisibility();
    }

    @Override
    public boolean isVisible() {
        boolean[] vis = this.getVisibility();
        return vis[0] || vis[1] || vis[2];
    }

    @Override
    public void setVisible(boolean visible) {
    }

    public Grid getGrid() {
        return this.d_grid;
    }

    @Override
    public AABox getBounds() {
        return this.d_grid.getBounds();
    }

    protected void pickBox(Object source, IIsectFilter filter, ConvexHull box, thunderheadeng.geometry.objs.IBoxCollector result) throws CancelObjectPicking {
        GridDisplay disp;
        boolean points = filter.acceptGeomType(this, GeomType.VERTEX);
        boolean edges = filter.acceptGeomType(this, GeomType.EDGE);
        boolean faces = filter.acceptGeomType(this, GeomType.FACE) || filter.acceptGeomType(this, GeomType.FACE_EDGE) || filter.acceptGeomType(this, GeomType.FACE_VERTEX);
        boolean[] vis = this.getVisibility();
        if (vis[1] && faces && (disp = (GridDisplay)this.d_dispMgr.getDisplay(this.d_grid)) != null) {
            DefaultFilter faceFilter = new DefaultFilter(GeomType.FACE);
            Mesh mesh = disp.getSurfaceMesh();
            mesh.pickBox(source, Elements.ALL_CREASE, faceFilter, box, result);
        }
        if (vis[2] && edges && (disp = (GridDisplay)this.d_dispMgr.getDisplay(this.d_grid)) != null) {
            Mesh mesh = disp.getOutlineMesh();
            mesh.pickBox(source, Elements.ALL_CREASE, filter, box, result);
        }
        if (!vis[0] || points || edges) {
            // empty if block
        }
    }

    @Override
    public void pickBox(IBoxCollector result, IIsectFilter filter, ConvexHull box) {
        if (!filter.acceptPickObject(this)) {
            return;
        }
        try {
            this.pickBox(this, filter, box, IPickable.convertCollector(result, DEF_PROPS));
        }
        catch (CancelObjectPicking cancelObjectPicking) {
            // empty catch block
        }
    }

    @Override
    public void pickPoints(IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
        if (!filter.acceptPickObject(this)) {
            return;
        }
        this.pickPoints(this, IPickable.convertCollector(isects, DEF_PROPS), filter, rayBegin, rayDirN, maxDist, tester);
    }

    protected void pickPoints(Object source, thunderheadeng.geometry.objs.IIsectCollector isects, IIsectFilter filter, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
        double[] yvals;
        double[] xvals;
        PlaneIsect planeIsect;
        GridDisplay disp;
        boolean points = filter.acceptGeomType(this, GeomType.VERTEX);
        boolean edges = filter.acceptGeomType(this, GeomType.EDGE);
        boolean faces = filter.acceptGeomType(this, GeomType.FACE) || filter.acceptGeomType(this, GeomType.FACE_EDGE) || filter.acceptGeomType(this, GeomType.FACE_VERTEX);
        boolean centroid = filter.acceptGeomType(this, GeomType.FACE_CENTROID);
        boolean[] vis = this.getVisibility();
        if (vis[1] && faces && (disp = (GridDisplay)this.d_dispMgr.getDisplay(this.d_grid)) != null) {
            DefaultFilter faceFilter = new DefaultFilter(GeomType.FACE);
            Vector3d viewVec = this.d_dispMgr.getMV().getMainView().getCamera().getViewVector(rayBegin);
            Mesh mesh = disp.getSurfaceMesh();
            int m = 0;
            while (m < mesh.indices.length) {
                Point3d p1 = mesh.vertices[mesh.indices[m++]];
                Point3d p2 = mesh.vertices[mesh.indices[m++]];
                int n = m++;
                Point3d p3 = mesh.vertices[mesh.indices[n]];
                Triangle tri = new Triangle(p1, p2, p3);
                if (!(viewVec.dot(tri.getNormal(true)) >= 0.0)) continue;
                tri.pickPoints(isects, faceFilter, this, Elements.ALL_CREASE, rayBegin, rayDirN, maxDist, tester);
            }
        }
        if (vis[2] && edges && (disp = (GridDisplay)this.d_dispMgr.getDisplay(this.d_grid)) != null) {
            Mesh mesh = disp.getOutlineMesh();
            mesh.pickPoints(isects, filter, this, Elements.ALL_CREASE, rayBegin, rayDirN, maxDist, tester);
        }
        if (vis[0] && (points || edges)) {
            planeIsect = this.getPlaneIsect(true, rayBegin, rayDirN);
            if (planeIsect == null) {
                return;
            }
            xvals = ModelGridSnapper.getIsectDivs(planeIsect.lxdiv, planeIsect.lx);
            yvals = ModelGridSnapper.getIsectDivs(planeIsect.lydiv, planeIsect.ly);
            if (points) {
                for (Object x : (Mesh)xvals) {
                    for (double y : yvals) {
                        Point3d p = planeIsect.localToWorld((double)x, y);
                        isects.addNonFace(this, p, GeomType.VERTEX, -1, IPrimElements.NONE);
                    }
                }
            }
            if (edges) {
                if (xvals.length == 1 && yvals.length == 1) {
                    Point3d isect = planeIsect.localToWorld(xvals[0], yvals[0]);
                    isects.addNonFace(this, isect, GeomType.EDGE, -1, IPrimElements.NONE);
                } else {
                    ArrayList<double[]> lineSegs = new ArrayList<double[]>(4);
                    if (xvals.length == 2) {
                        for (double y : yvals) {
                            lineSegs.add(new double[]{xvals[0], y, xvals[1], y});
                        }
                    }
                    if (yvals.length == 2) {
                        for (double x : xvals) {
                            lineSegs.add(new double[]{x, yvals[0], x, yvals[1]});
                        }
                    }
                    for (double[] ls : lineSegs) {
                        Point2d nearestp = Inter2D.nearestToLineSeg(new Point2d(planeIsect.lx, planeIsect.ly), new Point2d(ls[0], ls[1]), new Point2d(ls[2], ls[3]));
                        isects.addNonFace(this, planeIsect.localToWorld(nearestp.x, nearestp.y), GeomType.EDGE, -1, IPrimElements.NONE);
                    }
                }
            }
        }
        if (vis[0] && centroid) {
            planeIsect = this.getPlaneIsect(true, rayBegin, rayDirN);
            if (planeIsect == null) {
                return;
            }
            xvals = ModelGridSnapper.getIsectDivs(planeIsect.lxdiv, planeIsect.lx);
            yvals = ModelGridSnapper.getIsectDivs(planeIsect.lydiv, planeIsect.ly);
            if (xvals.length < 2 || yvals.length < 2) {
                return;
            }
            Quad poly = new Quad(planeIsect.localToWorld(xvals[0], yvals[0]), planeIsect.localToWorld(xvals[1], yvals[0]), planeIsect.localToWorld(xvals[1], yvals[1]), planeIsect.localToWorld(xvals[0], yvals[1]));
            Point3d center = new Point3d();
            center.x = (poly.p1.x + poly.p2.x + poly.p3.x + poly.p4.x) / 4.0;
            center.y = (poly.p1.y + poly.p2.y + poly.p3.y + poly.p4.y) / 4.0;
            center.z = (poly.p1.z + poly.p2.z + poly.p3.z + poly.p4.z) / 4.0;
            isects.addNonFace(this, center, GeomType.FACE_CENTROID, -1, IPrimElements.NONE);
        }
    }

    @Override
    public void pickCells(IIsectCollector isects, Point3d rayBegin, Vector3d rayDir, ITest<AABox> tester) {
        if (!this.getVisibility()[0]) {
            return;
        }
        PlaneIsect planeIsect = this.getPlaneIsect(false, rayBegin, rayDir);
        if (planeIsect == null) {
            return;
        }
        double[] xvals = ModelGridSnapper.getIsectDivs(planeIsect.lxdiv, planeIsect.lx);
        double[] yvals = ModelGridSnapper.getIsectDivs(planeIsect.lydiv, planeIsect.ly);
        if (xvals.length < 2 || yvals.length < 2) {
            return;
        }
        Quad poly = new Quad(planeIsect.localToWorld(xvals[0], yvals[0]), planeIsect.localToWorld(xvals[1], yvals[0]), planeIsect.localToWorld(xvals[1], yvals[1]), planeIsect.localToWorld(xvals[0], yvals[1]));
        if (poly.getNormal(true).dot(planeIsect.planeEq.getNormal()) < 0.0) {
            poly = new Quad(poly.p4, poly.p3, poly.p3, poly.p1);
        }
        Quad fpoly = poly;
        isects.addFace(this, planeIsect.localToWorld(planeIsect.lx, planeIsect.ly), -1, () -> fpoly, () -> fpoly.getNormal(true), IPrimElements.NONE, IPrimProps.DEF);
    }

    private static double[] getIsectDivs(double[] divs, double val) {
        int min = Arrays.binarySearch(divs, val);
        if (min < 0) {
            min = -min - 2;
        }
        int max = min + 1;
        if (min >= 0 && max < divs.length) {
            return new double[]{divs[min], divs[max]};
        }
        if (max == 0) {
            return new double[]{divs[0]};
        }
        if (min == divs.length - 1) {
            return new double[]{divs[min]};
        }
        return new double[0];
    }

    private PlaneIsect getPlaneIsect(boolean cullFaces, Point3d rayBegin, Vector3d rayDirN) {
        AABox bounds = this.getActiveBounds();
        Plane3d[] planes = new Plane3d[]{new Plane3d(0.0, 0.0, 1.0, -bounds.getMinZ()), new Plane3d(0.0, 1.0, 0.0, -bounds.getMinY()), new Plane3d(1.0, 0.0, 0.0, -bounds.getMinX()), new Plane3d(0.0, 0.0, -1.0, bounds.getMaxZ()), new Plane3d(0.0, -1.0, 0.0, bounds.getMaxY()), new Plane3d(-1.0, 0.0, 0.0, bounds.getMaxX())};
        PlaneIsect closest = null;
        double closestT = Double.MAX_VALUE;
        Vector3d viewVec = cullFaces ? this.d_dispMgr.getMV().getMainView().getCamera().getViewVector(rayBegin) : null;
        block5: for (int m = 0; m < 6; ++m) {
            double t;
            Plane3d plane = planes[m];
            if (cullFaces && viewVec.dot(plane.getNormal()) > 0.0 || Double.isNaN(t = Inter3D.linePlaneIntersectionT(rayBegin, rayDirN, plane, 1.0E-6)) || theUtil.lt0(t, 1.0E-6) || t > closestT) continue;
            closestT = t;
            Point3d isect = Util3D.linePoint(rayBegin, rayDirN, t);
            int swizzle = m % 3;
            switch (swizzle) {
                case 0: {
                    closest = new PlaneIsect(plane, swizzle, this.d_xSnaps, this.d_ySnaps, isect.x, isect.y, isect.z);
                    continue block5;
                }
                case 1: {
                    closest = new PlaneIsect(plane, swizzle, this.d_xSnaps, this.d_zSnaps, isect.x, isect.z, isect.y);
                    continue block5;
                }
                case 2: {
                    closest = new PlaneIsect(plane, swizzle, this.d_ySnaps, this.d_zSnaps, isect.y, isect.z, isect.x);
                }
            }
        }
        return closest;
    }

    private AABox getActiveBounds() {
        Point3d min = this.d_grid.getMinPoint().getPoint3dValue(Geometry.LU);
        Point3d max = this.d_grid.getMaxPoint().getPoint3dValue(Geometry.LU);
        if (this.d_activeFloor != null) {
            double bottom = this.d_activeFloor.getSlabBottom().getValue(Geometry.LU);
            double top = this.d_activeFloor.getCeilingLoc().getValue(Geometry.LU);
            if (theUtil.gt(bottom, min.z, 1.0E-9)) {
                min.z = bottom;
            }
            if (theUtil.lt(top, max.z, 1.0E-9)) {
                max.z = top;
            }
            if (max.z < min.z) {
                min.z = max.z;
            }
        }
        return new AABox(min, max);
    }

    private static class PlaneIsect {
        public final Plane3d planeEq;
        public final int plane;
        public final double[] lxdiv;
        public final double[] lydiv;
        public final double lx;
        public final double ly;
        public final double lz;

        public PlaneIsect(Plane3d planeEq, int plane, double[] lxdiv, double[] lydiv, double lx, double ly, double lz) {
            this.planeEq = planeEq;
            this.plane = plane;
            this.lxdiv = lxdiv;
            this.lydiv = lydiv;
            this.lx = lx;
            this.ly = ly;
            this.lz = lz;
        }

        public Point3d localToWorld(double lx, double ly) {
            switch (this.plane) {
                case 0: {
                    return new Point3d(lx, ly, this.lz);
                }
                case 1: {
                    return new Point3d(lx, this.lz, ly);
                }
                case 2: {
                    return new Point3d(this.lz, lx, ly);
                }
            }
            return null;
        }
    }
}

