/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import javax.vecmath.Matrix4d;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.Native;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.Camera;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.IRenderable;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.Object3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.Keyable;
import thunderheadeng.gui.Application;

public class TextRenderer
extends Object3D
implements IRenderable {
    private static final long serialVersionUID = -2508195566672183971L;
    public static final int MODE_2D = 0;
    public static final int MODE_3D = 1;
    public static final int RENDERTYPE_PIXMAP = 0;
    public static final int RENDERTYPE_TEXTURE = 1;
    public static final int RENDERTYPE_BITMAP = 2;
    private static final int method_setRenderSurface = 0;
    private static final String DEFAULT_FACE_NAME = "lib/Code2003Miao.ttf";
    private String d_face = TextRenderer.getDefaultFont();
    private Color d_fontColor = Color.BLACK;
    private float d_fontSize = 12.0f;
    private Camera d_camera = null;
    private int[] d_padding = new int[]{0, 0, 0, 0};
    private Matrix4d d_xform = null;
    private boolean d_showLeader = false;
    private int d_mode = 0;
    private int d_renderType = 1;

    public static String getDefaultFont() {
        String installDir = Application.getApp().getInstallDir();
        File file = new File(installDir, DEFAULT_FACE_NAME);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        URL fonturl = TextRenderer.class.getResource(DEFAULT_FACE_NAME);
        if (fonturl == null) {
            return DEFAULT_FACE_NAME;
        }
        String rawPath = fonturl.getFile();
        File defaultFont = null;
        try {
            defaultFont = new File(URLDecoder.decode(rawPath, "UTF-8"));
            return defaultFont.getPath();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return DEFAULT_FACE_NAME;
        }
    }

    public TextRenderer() {
        this.nativeConstructed(TextRenderer.class);
    }

    public void setGraphicsContext(IRenderSurface surface) {
        Native.manager.execMethod(TextRenderer.class, this, 0, surface);
    }

    public void setMode(int mode) {
        if (mode == this.d_mode) {
            return;
        }
        this.d_mode = mode;
        this.markNativeDirty();
    }

    public int getMode(int mode) {
        return this.d_mode;
    }

    public void setRenderType(int type) {
        if (type == this.d_renderType) {
            return;
        }
        this.d_renderType = type;
        this.markNativeDirty();
    }

    public int getRenderType() {
        return this.d_renderType;
    }

    public void setTransform(Matrix4d xform) {
        this.d_xform = xform;
        this.markNativeDirty();
    }

    public void setLeaderEnabled(boolean enabled) {
        if (this.d_showLeader == enabled) {
            return;
        }
        this.d_showLeader = enabled;
        this.markNativeDirty();
    }

    public boolean isLeaderEnabled() {
        return this.d_showLeader;
    }

    @Override
    public void writeNativeData(INativeStream writer) {
        writer.writeString(this.d_face);
        writer.writeFloats(this.d_fontColor.getComponents(null));
        writer.writeFloat(this.d_fontSize);
        writer.writeInt(this.d_renderType);
        writer.writeInt(this.d_mode);
        writer.writeInts(this.d_padding);
        writer.write((Keyable)this.d_camera);
        writer.writeBoolean(this.d_xform != null);
        if (this.d_xform != null) {
            writer.writeDoubles(this.d_xform.m00, this.d_xform.m01, this.d_xform.m02, this.d_xform.m03, this.d_xform.m10, this.d_xform.m11, this.d_xform.m12, this.d_xform.m13, this.d_xform.m20, this.d_xform.m21, this.d_xform.m22, this.d_xform.m23, this.d_xform.m30, this.d_xform.m31, this.d_xform.m32, this.d_xform.m33);
        }
        writer.writeBoolean(this.d_showLeader);
    }

    @Override
    public Class resolveNativeClass() {
        return TextRenderer.class;
    }

    public void setFace(String face) {
        this.d_face = face;
        this.markNativeDirty();
    }

    public void setFontColor(Color c) {
        this.d_fontColor = c;
        this.markNativeDirty();
    }

    public void setFontSize(float size) {
        this.d_fontSize = size;
        this.markNativeDirty();
    }

    public void setCamera(Camera c) {
        this.d_camera = c;
        this.markNativeDirty();
    }

    public void setPadding(int[] padding) {
        assert (padding.length == 4);
        this.d_padding = padding;
        this.markNativeDirty();
    }
}

