/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.ANativelyMirrored;
import pyrosim.legacy_2012_1.thunderheadeng.io.nativexfer.INativeStream;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.ILayer;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.nb3dUtil;

public class GradientBG
extends ANativelyMirrored
implements ILayer {
    private static final long serialVersionUID = 2372908796345547036L;
    public static final int GBORIENT_HORIZONTAL = 0;
    public static final int GBORIENT_VERTICAL = 1;
    public static final int GBLOC_SIDE = 0;
    public static final int GBLOC_MIDDLE = 1;
    private Color d_c1;
    private Color d_c2;
    private int d_orientation;
    private int d_stripeLoc;
    private float d_variation;

    public GradientBG(float variation) {
        this(1, 1, variation);
    }

    public GradientBG(int orientation, int stripeLoc, float variation) {
        this(Color.WHITE, Color.WHITE, orientation, stripeLoc);
        this.d_variation = variation;
    }

    public GradientBG(Color c1, Color c2, int orientation, int stripeLoc) {
        this.d_c1 = c1;
        this.d_c2 = c2;
        this.d_variation = 0.0f;
        this.d_orientation = orientation;
        this.d_stripeLoc = stripeLoc;
        this.nativeConstructed(this.resolveNativeClass());
    }

    @Override
    public Class resolveNativeClass() {
        return GradientBG.class;
    }

    private static float getBGComp(float color, float variation) {
        return Math.abs(color - variation);
    }

    public static Color getColor2(Color color1, float variation) {
        float[] c = new float[4];
        color1.getComponents(c);
        return new Color(GradientBG.getBGComp(c[0], variation), GradientBG.getBGComp(c[1], variation), GradientBG.getBGComp(c[2], variation), c[3]);
    }

    public void setColor(Color c) {
        this.d_c1 = c;
        this.d_c2 = GradientBG.getColor2(c, this.d_variation);
        this.markNativeDirty();
    }

    public void setColors(Color c1, Color c2) {
        this.d_c1 = c1;
        this.d_c2 = c2;
        this.markNativeDirty();
    }

    @Override
    public void writeNativeData(INativeStream writer) {
        float[] color = new float[4];
        nb3dUtil.writeFloats(writer, this.d_c1, color);
        nb3dUtil.writeFloats(writer, this.d_c2, color);
        writer.writeInts(this.d_orientation, this.d_stripeLoc);
    }
}

