/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.EmptyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Triangle;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredCollection;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class GeomUtil {
    public static final Vector3d[] AXIS_VECS = new Vector3d[]{new Vector3d(-1.0, 0.0, 0.0), new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, -1.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, 0.0, -1.0), new Vector3d(0.0, 0.0, 1.0)};

    public static List<IPrimitive> explodeToTypes(IGeom geom, int primTypes) {
        return GeomUtil.explodeToTypes(Arrays.asList(geom), primTypes);
    }

    public static List<IPrimitive> explodeToTypes(Collection<? extends IGeom> geomList, int primTypes) {
        Class<? extends IPrimitive>[] types = GeomUtil.getPrimClasses(primTypes);
        int primCount = 0;
        for (IGeom iGeom : geomList) {
            primCount += iGeom.getNumPrims(primTypes);
        }
        ArrayList<IPrimitive> prims = new ArrayList<IPrimitive>(primCount);
        GeomUtil.explodeToTypes(geomList, types, prims);
        assert (prims.size() == primCount);
        return prims;
    }

    public static <T extends IPrimitive> List<T> explode(IGeom geom, Class<? extends T> ... primTypes) {
        return GeomUtil.explode(Arrays.asList(geom), primTypes);
    }

    public static <T extends IPrimitive> List<T> explode(Collection<? extends IGeom> geomList, Class<? extends T> ... primTypes) {
        ArrayList prims = new ArrayList();
        GeomUtil.explodeToTypes(geomList, primTypes, prims);
        return prims;
    }

    private static <T extends IPrimitive> void explodeToTypes(Collection<? extends IGeom> geomList, Class<? extends T>[] types, List<T> prims) {
        for (IGeom iGeom : geomList) {
            if (GeomUtil.isType(iGeom, types)) {
                prims.add((IPrimitive)iGeom);
                continue;
            }
            if (!iGeom.canExplode()) continue;
            Collection<IGeom> subGeom = iGeom.explode(new ArrayList<IGeom>());
            GeomUtil.explodeToTypes(subGeom, types, prims);
        }
    }

    public static boolean isEmpty(IGeom geom) {
        return geom == EmptyGeom.INSTANCE || geom.getNumPrims(7) == 0;
    }

    private static Class<? extends IPrimitive>[] getPrimClasses(int primTypes) {
        int numTypes = Integer.bitCount(primTypes &= 7);
        Class[] types = new Class[numTypes];
        int ix = 0;
        if ((primTypes & 1) != 0) {
            types[ix++] = IFace.class;
        }
        if ((primTypes & 2) != 0) {
            types[ix++] = ICurve.class;
        }
        if ((primTypes & 4) != 0) {
            types[ix++] = Point.class;
        }
        return types;
    }

    public static boolean isType(Object o, Class ... types) {
        for (int m = 0; m < types.length; ++m) {
            if (!types[m].isInstance(o)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static IPolygon newPoly(Point3d[] points) {
        return PolyUtil.newPoly(points);
    }

    @Deprecated
    public static IPolygon newPoly(Point3d[] points, int[] loopOffsets) {
        return PolyUtil.newPoly(points, loopOffsets);
    }

    @Deprecated
    public static IPolygon newPoly(Point3d[][] points) {
        return PolyUtil.newPoly(points);
    }

    @Deprecated
    public static boolean polysEqual(IPolygon poly1, IPolygon poly2) {
        return PolyUtil.polysEqual(poly1, poly2);
    }

    public static boolean test(int flags, int flag) {
        return (flags & flag) == flag;
    }

    public static boolean isAxisAlignedTransform(Matrix4d xform) {
        if (xform.m00 == 0.0 || xform.m11 == 0.0 || xform.m22 == 0.0) {
            return true;
        }
        AxisAngle4d angle = GeomUtil.getRotation(xform);
        if (angle == null) {
            return false;
        }
        if (angle.angle == 0.0) {
            return true;
        }
        Vector3d axis = new Vector3d(angle.x, angle.y, angle.z);
        axis.normalize();
        if (axis.epsilonEquals(GeomConstants.VEC3D_XPOS, 1.0E-6) || axis.epsilonEquals(GeomConstants.VEC3D_XNEG, 1.0E-6) || axis.epsilonEquals(GeomConstants.VEC3D_YPOS, 1.0E-6) || axis.epsilonEquals(GeomConstants.VEC3D_YNEG, 1.0E-6) || axis.epsilonEquals(GeomConstants.VEC3D_ZPOS, 1.0E-6) || axis.epsilonEquals(GeomConstants.VEC3D_ZNEG, 1.0E-6)) {
            double num90s = Math.abs(angle.angle / 1.5707963267948966);
            return theUtil.eq0(num90s - Math.floor(num90s), 1.0E-6);
        }
        return false;
    }

    public static List<Pair<ICurve, Integer>> getFaceOutlines(IGeom geom) {
        ArrayList<ICurve> curves = new ArrayList<ICurve>();
        ArrayList<Pair<ICurve, Integer>> lines = new ArrayList<Pair<ICurve, Integer>>(geom.getNumPrims(1));
        List<IPrimitive> polys = GeomUtil.explodeToTypes(geom, 1);
        for (int m = 0; m < polys.size(); ++m) {
            IFace face = (IFace)polys.get(m);
            if (face == null) continue;
            curves.clear();
            face.getBoundary(curves);
            for (ICurve curve : curves) {
                lines.add(new Pair<ICurve, Integer>(curve, m));
            }
        }
        return lines;
    }

    @Deprecated
    public static void getBoundary(List<ICurve> boundary, IPolygon poly) {
        PolyUtil.getBoundary(boundary, poly);
    }

    @Deprecated
    public static Point3d[] getAllVerts(IPolygon poly) {
        return PolyUtil.getAllVerts(poly, false);
    }

    @Deprecated
    public static Point3d[][] getLoops(IPolygon poly) {
        return PolyUtil.getLoops(poly, false);
    }

    @Deprecated
    public static int[] getLoopOffsets(IPolygon poly) {
        return PolyUtil.getLoopOffsets(poly, false);
    }

    public static void flatten(IGeom geom, List<IGeom> geoms) {
        if (geom instanceof GeomGroup) {
            for (IGeom child : ((GeomGroup)geom).children) {
                GeomUtil.flatten(child, geoms);
            }
        } else {
            geoms.add(geom);
        }
    }

    public static List<IGeom> flatten(IGeom geom) {
        ArrayList<IGeom> geoms = new ArrayList<IGeom>();
        GeomUtil.flatten(geom, geoms);
        return geoms;
    }

    public static boolean isZRotation(Matrix4d xform) {
        AxisAngle4d rot = GeomUtil.getRotation(xform);
        if (rot == null) {
            return false;
        }
        return theUtil.eq0(rot.angle, 1.0E-9) || theUtil.eq0(rot.x, 1.0E-9) && theUtil.eq0(rot.y, 1.0E-9) && !theUtil.eq0(rot.z, 1.0E-9);
    }

    public static AxisAngle4d getRotation(Matrix4d xform) {
        AxisAngle4d aa = new AxisAngle4d();
        aa.set(xform);
        if (aa.x == 0.0 && aa.y == 1.0 && aa.z == 0.0 && aa.angle == 0.0) {
            double sig0 = Math.signum(xform.m00);
            double sig1 = Math.signum(xform.m11);
            double sig2 = Math.signum(xform.m22);
            if (sig0 != 0.0 && sig1 != 0.0 && sig2 != 0.0 && theUtil.eq0(xform.m01, 1.0E-12) && theUtil.eq0(xform.m10, 1.0E-12) && theUtil.eq0(xform.m20, 1.0E-12) && theUtil.eq0(xform.m02, 1.0E-12) && theUtil.eq0(xform.m21, 1.0E-12) && theUtil.eq0(xform.m12, 1.0E-12)) {
                if (sig0 != sig1 && sig1 == sig2) {
                    aa.set(1.0, 0.0, 0.0, Math.PI);
                } else if (sig0 != sig1 && sig0 == sig2) {
                    aa.set(0.0, 1.0, 0.0, Math.PI);
                } else if (sig0 == sig1 && sig1 != sig2) {
                    aa.set(0.0, 0.0, 1.0, Math.PI);
                } else {
                    aa.set(0.0, 0.0, 1.0, 0.0);
                }
            } else {
                return null;
            }
        }
        return aa;
    }

    public static Point3d[] xformVerts(Point3d[] vertices, Matrix4d xform) {
        Point3d[] newVerts = new Point3d[vertices.length];
        for (int m = 0; m < vertices.length; ++m) {
            newVerts[m] = Util3D.xform(xform, vertices[m]);
        }
        return newVerts;
    }

    public static Vector3d getClosestAxis(Vector3d vec) {
        double largestDot = 0.0;
        int bestVec = -1;
        Vector3d[] axes = new Vector3d[]{GeomConstants.VEC3D_XPOS, GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZPOS};
        for (int m = 0; m < axes.length; ++m) {
            double dot = vec.dot(axes[m]);
            if (!(Math.abs(dot) > Math.abs(largestDot))) continue;
            largestDot = dot;
            bestVec = m;
        }
        if (bestVec == -1) {
            return GeomConstants.VEC3D_XNEG;
        }
        if (largestDot < 0.0) {
            switch (bestVec) {
                case 0: {
                    return GeomConstants.VEC3D_XNEG;
                }
                case 1: {
                    return GeomConstants.VEC3D_YNEG;
                }
                case 2: {
                    return GeomConstants.VEC3D_ZNEG;
                }
            }
        }
        return axes[bestVec];
    }

    public static List<LineSeg> getLineSegs(double errorTol, ICurve ... curves) {
        return GeomUtil.getLineSegs(errorTol, Arrays.asList(curves));
    }

    public static List<LineSeg> getLineSegs(double errorTol, Collection<? extends ICurve> curves) {
        ArrayList<LineSeg> lineSegs = new ArrayList<LineSeg>();
        for (ICurve iCurve : curves) {
            Mesh mesh = iCurve.getSegments(errorTol);
            int m = 0;
            while (m < mesh.indices.length) {
                Point3d p1 = mesh.vertices[mesh.indices[m++]];
                Point3d p2 = mesh.vertices[mesh.indices[m++]];
                lineSegs.add(new LineSeg(p1, p2));
            }
        }
        return lineSegs;
    }

    public static List<LineSeg> convertToLineSegs(double errorTol, IGeom geom) {
        return GeomUtil.convertToLineSegs(errorTol, Arrays.asList(geom));
    }

    public static List<LineSeg> convertToLineSegs(double errorTol, Collection<? extends IGeom> geoms) {
        List<IPrimitive> curves = GeomUtil.explodeToTypes(geoms, 2);
        return GeomUtil.getLineSegs(errorTol, new FilteredCollection<ICurve>(curves, ICurve.class));
    }

    public static List<Triangle> convertToTriangles(double errorTol, IGeom geom) {
        return GeomUtil.convertToTriangles(errorTol, Arrays.asList(geom));
    }

    public static List<Triangle> convertToTriangles(double errorTol, Collection<? extends IGeom> geoms) {
        List<IPrimitive> faces = GeomUtil.explodeToTypes(geoms, 1);
        return GeomUtil.getTriangles(errorTol, new FilteredCollection<IFace>(faces, IFace.class));
    }

    public static List<Triangle> getTriangles(double errorTol, IFace ... faces) {
        return GeomUtil.getTriangles(errorTol, Arrays.asList(faces));
    }

    public static List<Triangle> getTriangles(double errorTol, Collection<? extends IFace> faces) {
        ArrayList<Triangle> tris = new ArrayList<Triangle>();
        for (IFace iFace : faces) {
            Mesh mesh = iFace.triangulate(errorTol);
            int m = 0;
            while (m < mesh.indices.length) {
                Point3d p1 = mesh.vertices[mesh.indices[m++]];
                Point3d p2 = mesh.vertices[mesh.indices[m++]];
                Point3d p3 = mesh.vertices[mesh.indices[m++]];
                tris.add(new Triangle(p1, p2, p3));
            }
        }
        return tris;
    }

    public static IGeom group(IGeom ... geoms) {
        if (geoms.length == 0) {
            return EmptyGeom.INSTANCE;
        }
        if (geoms.length == 1) {
            return geoms[0];
        }
        return new GeomGroup(Arrays.asList(geoms));
    }

    public static IGeom group(Collection<? extends IGeom> geoms) {
        if (geoms.isEmpty()) {
            return EmptyGeom.INSTANCE;
        }
        if (geoms.size() == 1) {
            return geoms.iterator().next();
        }
        return new GeomGroup(geoms);
    }

    public static IGeom filter(IGeom geom, int primTypes) {
        List<IPrimitive> geoms = GeomUtil.explodeToTypes(geom, primTypes);
        return GeomUtil.group(geoms);
    }

    public static IDOF groupDOFs(Collection<? extends IDOF> dofs) {
        Set<Object> dofSet;
        Set<Object> set = dofSet = dofs instanceof Set ? (Set<Object>)dofs : new HashSet<IDOF>(dofs);
        if (dofSet.isEmpty()) {
            return IDOF.FREE;
        }
        if (dofSet.size() == 1) {
            return (IDOF)dofSet.iterator().next();
        }
        return new IDOF.CompositeDOF((Set<? extends IDOF>)dofSet);
    }
}

