/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.IParametric2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.IParametric3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;

public class TrimmedCurve3D
implements IParametric3D,
Serializable {
    static final long serialVersionUID = 1L;
    private final IParametric3D d_baseCurve;
    private final double d_t1;
    private final double d_t2;

    public TrimmedCurve3D(IParametric3D base, double t1, double t2) {
        this.d_baseCurve = base;
        this.d_t1 = t1;
        this.d_t2 = t2;
    }

    @Override
    public boolean isLinear() {
        return this.d_baseCurve.isLinear();
    }

    public IParametric3D getBaseCurve() {
        return this.d_baseCurve;
    }

    private double baseT(double localT) {
        return localT * (this.d_t2 - this.d_t1) + this.d_t1;
    }

    private double localT(double baseT) {
        return (baseT - this.d_t1) / (this.d_t2 - this.d_t1);
    }

    @Override
    public Point3d get(double t) {
        return this.d_baseCurve.get(this.baseT(t));
    }

    @Override
    public double getClosestT(Point3d point) {
        double baseT = this.d_baseCurve.getClosestT(point);
        double localT = this.localT(baseT);
        return Util.clampT(localT, 0.0, 1.0);
    }

    @Override
    public double[] getIsects(Plane3d plane, double tol) {
        double[] baseIsects = this.d_baseCurve.getIsects(plane, tol);
        double[] localIsects = new double[baseIsects.length];
        int ix = 0;
        for (double baseIsect : baseIsects) {
            double localIsect = this.localT(baseIsect);
            if (Double.isNaN(localIsect = Util.clampTIfValid(localIsect, 0.0, 1.0, tol))) continue;
            localIsects[ix++] = localIsect;
        }
        if (localIsects.length != ix) {
            double[] isects = new double[ix];
            for (int m = 0; m < isects.length; ++m) {
                isects[m] = localIsects[m];
            }
            localIsects = isects;
        }
        return localIsects;
    }

    @Override
    public double length() {
        double baseLength = this.d_baseCurve.length();
        return baseLength * Math.abs(this.d_t2 - this.d_t1);
    }

    @Override
    public Vector3d getTangent(double t) {
        Vector3d tangent = this.d_baseCurve.getTangent(this.baseT(t));
        if (this.d_t2 < this.d_t1) {
            tangent.negate();
        }
        return tangent;
    }

    @Override
    public IParametric2D projectToPlane(Plane3d plane, Matrix4d wlXform) {
        return this.d_baseCurve.projectToPlane(plane, wlXform).subsegment(this.d_t1, this.d_t2);
    }

    @Override
    public IParametric3D transform(Matrix4d xform) {
        return new TrimmedCurve3D(this.d_baseCurve.transform(xform), this.d_t1, this.d_t2);
    }

    @Override
    public IParametric2D transform2D(Matrix4d xform) {
        return this.d_baseCurve.transform2D(xform).subsegment(this.d_t1, this.d_t2);
    }

    @Override
    public IParametric3D reverse() {
        return new TrimmedCurve3D(this.d_baseCurve, this.d_t2, this.d_t1);
    }

    public String toString() {
        return "TrimmedCurve: " + String.valueOf(this.get(0.0)) + " -> " + String.valueOf(this.get(1.0));
    }
}

