/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.delaunay;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.vecmath.Point2d;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.GeomTests;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.TriangulatorInfo;

public class DnyUtil {
    public static FindResult findTriangle(TriangulatorInfo ti, Point2d p) {
        return DnyUtil.findTriangle(Arrays.asList(ti.points), ti.triangles, ti.adjTris, p);
    }

    public static FindResult findTriangle(TriangulatorInfo ti, Point2d p, int startHint) {
        return DnyUtil.findTriangle(Arrays.asList(ti.points), ti.triangles, ti.adjTris, p, startHint);
    }

    public static FindResult findTriangle(List<? extends Point2d> verts, int[] tris, int[] adj, Point2d p) {
        return DnyUtil.findTriangle(verts, tris, adj, p, -1);
    }

    public static FindResult findTriangle(List<? extends Point2d> points, int[] triangles, int[] adj, Point2d p, int startHint) {
        Handle tri;
        if (triangles.length == 0) {
            return null;
        }
        int numTris = triangles.length / 3;
        if (startHint < 0) {
            int samples = 0;
            while (samples * samples * samples < numTris) {
                ++samples;
            }
            double minDistSq = Double.MAX_VALUE;
            int best = 0;
            Random rand = new Random(0L);
            for (int i = 0; i < samples; ++i) {
                int idx = (int)(rand.nextDouble() * (double)numTris) * 3;
                Point2d test = points.get(triangles[idx + 0]);
                double distSq = test.distanceSquared(p);
                if (!(distSq < minDistSq)) continue;
                minDistSq = distSq;
                best = idx;
            }
            startHint = best;
            if (points.get(triangles[startHint + 0]).equals(p) || points.get(triangles[startHint + 1]).equals(p)) {
                return new FindResult(startHint / 3, FindClass.ONVERT);
            }
        } else {
            startHint *= 3;
        }
        if (GeomTests.orient2d(points.get((tri = new Handle(triangles, adj, startHint, 0)).getA()), points.get(tri.getB()), p) < 0.0) {
            int nbr = tri.getNeighborA();
            tri.moveToNeighbor(nbr);
        }
        while (tri.tri >= 0) {
            Point2d a = points.get(tri.getA());
            Point2d b = points.get(tri.getB());
            Point2d c = points.get(tri.getC());
            if (c.equals(p)) {
                return new FindResult(tri.tri / 3, FindClass.ONVERT);
            }
            double orientB = GeomTests.orient2d(c, b, p);
            double orientC = GeomTests.orient2d(a, c, p);
            boolean moveToC = false;
            if (orientB > 0.0) {
                if (orientC > 0.0) {
                    double dot = (c.x - p.x) * (b.x - a.x) + (c.y - p.y) * (b.y - a.y);
                    if (dot > 0.0) {
                        moveToC = true;
                    }
                } else {
                    moveToC = false;
                }
            } else if (orientC > 0.0) {
                moveToC = true;
            } else {
                FindClass fc = orientB == 0.0 || orientC == 0.0 ? FindClass.ONEDGE : FindClass.INSIDE;
                return new FindResult(tri.tri / 3, fc);
            }
            if (moveToC) {
                tri.moveToNeighbor(tri.getNeighborC());
                continue;
            }
            tri.moveToNeighbor(tri.getNeighborB());
        }
        return null;
    }

    public static boolean contains(Point2d[] points, int[] tris, int tri, Point2d p) {
        Point2d a = points[tris[(tri *= 3) + 0]];
        Point2d b = points[tris[tri + 1]];
        Point2d c = points[tris[tri + 2]];
        return DnyUtil.contains(a, b, c, p);
    }

    public static boolean contains(Point2d ta, Point2d tb, Point2d tc, Point2d p) {
        return GeomTests.orient2d(ta, tb, p) >= 0.0 && GeomTests.orient2d(tb, tc, p) >= 0.0 && GeomTests.orient2d(tc, ta, p) >= 0.0;
    }

    private static TriangulatorInfo testTriangulate(double ... coords) {
        Mesh mesh = new Mesh();
        int m = 0;
        while (m < coords.length) {
            double x = coords[m++];
            double y = coords[m++];
            mesh.addPoint(x, y);
        }
        if (!mesh.triangulateConvexHull(0)) {
            return null;
        }
        return mesh.getOutput(1);
    }

    public static class FindResult {
        public final int tri;
        public final FindClass where;

        public FindResult(int tri, FindClass where) {
            this.tri = tri;
            this.where = where;
        }
    }

    public static enum FindClass {
        INSIDE,
        ONVERT,
        ONEDGE;

    }

    public static class Handle {
        private static final int[] plus1mod3 = new int[]{1, 2, 0};
        private static final int[] plus2mod3 = new int[]{2, 0, 1};
        public final int[] tris;
        public final int[] adj;
        public int tri;
        public int orient;

        public Handle(int[] tris, int[] adj, int t, int o) {
            this.tris = tris;
            this.adj = adj;
            this.tri = t;
            this.orient = o;
        }

        public int getA() {
            return this.tris[this.tri + this.orient];
        }

        public int getB() {
            return this.tris[this.tri + plus1mod3[this.orient]];
        }

        public int getC() {
            return this.tris[this.tri + plus2mod3[this.orient]];
        }

        public int getNeighborA() {
            return this.adj[this.tri + this.orient] * 3;
        }

        public int getNeighborB() {
            return this.adj[this.tri + plus1mod3[this.orient]] * 3;
        }

        public int getNeighborC() {
            return this.adj[this.tri + plus2mod3[this.orient]] * 3;
        }

        public void moveToNeighbor(int neighbor) {
            int neighborOrient = 0;
            if (neighbor >= 0) {
                for (int o = 1; o < 3; ++o) {
                    if (this.adj[neighbor + o] * 3 != this.tri) continue;
                    neighborOrient = o;
                    break;
                }
            }
            this.tri = neighbor;
            this.orient = neighborOrient;
        }
    }
}

