/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.domain.output.AMsrStat;
import pyrosim.legacy_2012_1.domain.output.GasMsrStat;
import pyrosim.legacy_2012_1.domain.output.SolidMsrStat;
import pyrosim.legacy_2012_1.domain.output.StatGeom;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityType;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.common.StatisticMap;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class StatisticsParser
extends AFDS5Parser {
    private Map<StatHash, Set<Integer>> d_solidStatMap = new HashMap<StatHash, Set<Integer>>();
    private Map<StatHash, Set<Integer>> d_gasStatMap = new HashMap<StatHash, Set<Integer>>();

    public StatisticsParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("DEVC");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String fdsStat = (String)rec.get("STATISTICS", false);
        if (fdsStat == null) {
            return true;
        }
        Integer pyroStat = StatisticMap.getPyroVal(fdsStat);
        if (pyroStat == null) {
            this.addWarning(rec, String.format(Intl.intl("Unrecognized statistic: %s"), fdsStat), Intl.intl("Ignoring statistic."));
            return true;
        }
        IQuantity msr = this.parseQuantity(rec, "QUANTITY", "PART_ID", "SPEC_ID", "MATL_ID", "DUCT_ID", "NODE_ID", pyroStat, Intl.intl("Ignoring statistic."), true, false);
        if (msr == null) {
            return true;
        }
        if (msr.get().quantityType != QuantityType.GAS && msr.get().quantityType != QuantityType.SOLID || (msr.get().outputTypes & 1) != 1) {
            this.addWarning(rec, String.format(Intl.intl("Statitistics can only be measured for solid and gas phase quantities."), new Object[0]), Intl.intl("Ignoring statistic."));
            return true;
        }
        if ((msr.get().outputTypes & pyroStat) != pyroStat) {
            this.addWarning(rec, String.format(Intl.intl("Invalid statistic for quantity %s."), rec.getString("QUANTITY")), Intl.intl("Ignoring statistic."));
            return true;
        }
        IGeom geom = this.parseGeom(rec, msr, fdsStat, pyroStat);
        if (geom == null) {
            return true;
        }
        if (msr.get().quantityType == QuantityType.SOLID) {
            this.parseSolidStat(rec, msr, pyroStat, geom);
        } else {
            this.parseGasStat(rec, msr, pyroStat, geom);
        }
        return true;
    }

    private IGeom parseGeom(FDSParseRecord rec, IQuantity msr, String fdsStat, int pyroStat) throws FDSRecordFormatException {
        IGeom geom;
        UnitPoint3D loc = null;
        UnitPoint3D[] bounds = null;
        UnitPoint3D boundsMid = null;
        if (rec.contains("XB")) {
            bounds = StatisticsParser.parseXB(rec, Intl.intl("Gas-phase statistics"), "XB", true);
            Point3d mid = Util3D.getMidPoint(bounds[0].getPoint3dValue(Geometry.LU), bounds[1].getPoint3dValue(Geometry.LU));
            boundsMid = new UnitPoint3D(mid, Geometry.LU);
        }
        if (rec.contains("XYZ")) {
            loc = StatisticsParser.parseLoc(rec, "DEVC", "XYZ", true);
        }
        if (bounds == null && loc == null) {
            this.addWarning(rec, Intl.intl("Statistics must define either an XB or XYZ."), Intl.intl("Ignoring statistic."));
            return null;
        }
        if (pyroStat == 0x400000) {
            AARectangle rect = this.toRect(bounds);
            if (rect == null) {
                this.addWarning(rec, String.format(Intl.intl("%s statistics must specify an area."), fdsStat), Intl.intl("Ignoring statistic."));
                return null;
            }
            geom = rect;
        } else if (pyroStat == 0x1000000) {
            if (loc != null) {
                geom = new Point(loc.getPoint3dValue(Geometry.LU));
            } else {
                assert (boundsMid != null);
                geom = new Point(boundsMid.getPoint3dValue(Geometry.LU));
            }
        } else if (bounds != null) {
            geom = new AABoxGeom(this.toBox(bounds).getValue(Geometry.LU));
        } else {
            Grid grid = this.getGridForPoint(loc);
            if (grid == null) {
                this.addWarning(rec, String.format(Intl.intl("Could not find grid for point %s."), loc.toString()), Intl.intl("Ignoring statistic."));
                return null;
            }
            geom = new StatGeom.GridGeom(grid);
        }
        return geom;
    }

    private void parseGasStat(FDSParseRecord rec, IQuantity msr, int pyroStat, IGeom geom) throws FDSRecordFormatException {
        StatHash hash = new StatHash(rec, geom, msr);
        Set<Integer> stats = this.d_gasStatMap.get(hash);
        if (stats == null) {
            stats = new HashSet<Integer>();
            this.d_gasStatMap.put(hash, stats);
        }
        stats.add(pyroStat);
    }

    private AARectangle toRect(UnitPoint3D[] bounds) {
        return bounds != null ? AARectangle.construct(bounds[0].getPoint3dValue(Geometry.LU), bounds[1].getPoint3dValue(Geometry.LU)) : null;
    }

    private UnitAABox toBox(UnitPoint3D[] bounds) {
        return bounds != null ? new UnitAABox(bounds[0], bounds[1]) : null;
    }

    private void parseSolidStat(FDSParseRecord rec, IQuantity msr, int pyroStat, IGeom geom) throws FDSRecordFormatException {
        StatHash hash = new StatHash(rec, geom, msr);
        Set<Integer> stats = this.d_solidStatMap.get(hash);
        if (stats == null) {
            stats = new HashSet<Integer>();
            this.d_solidStatMap.put(hash, stats);
        }
        stats.add(pyroStat);
    }

    private Grid getGridForPoint(UnitPoint3D loc) {
        Point3d loc3d = loc.getValue(SI.METER);
        for (PyroMod mod : this.getParsingInfo().getSourceContainers()) {
            for (Grid grid : mod.getGridManager().flatten()) {
                Point3d min = grid.getMinPoint().getValue(SI.METER);
                Point3d max = grid.getMaxPoint().getValue(SI.METER);
                if (!(loc3d.x >= min.x) || !(loc3d.x <= max.x) || !(loc3d.y >= min.y) || !(loc3d.y <= max.y) || !(loc3d.z >= min.z) || !(loc3d.z <= max.z)) continue;
                return grid;
            }
        }
        return null;
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        AMsrStat stat;
        String name;
        StatHash hash;
        for (Map.Entry<StatHash, Set<Integer>> entry : this.d_solidStatMap.entrySet()) {
            hash = entry.getKey();
            name = this.getName(hash.rec);
            stat = new SolidMsrStat(name, hash.msr, hash.geom, Collections.EMPTY_LIST, (Collection<Integer>)entry.getValue());
            this.getContainer().getMsrStatMgr().add(stat);
            this.flagObjectAdded(stat);
        }
        for (Map.Entry<StatHash, Set<Integer>> entry : this.d_gasStatMap.entrySet()) {
            hash = entry.getKey();
            name = this.getName(hash.rec);
            stat = new GasMsrStat(name, hash.msr, hash.geom, (Collection<Integer>)entry.getValue());
            this.getContainer().getMsrStatMgr().add(stat);
            this.flagObjectAdded(stat);
        }
    }

    private String getName(FDSParseRecord rec) {
        String name;
        String base = rec.getString("ID", false);
        String fdsStat = rec.getString("STATISTICS");
        assert (fdsStat != null);
        if (base == null) {
            String name2 = Util.getUniqueName(this.getContainer().getMsrStatMgr(), "STAT");
            this.addWarning(rec, Intl.intl("Statistic has no name."), String.format(Intl.intl("Assigning name to \"%s.\""), name2));
            return name2;
        }
        if (base.length() > fdsStat.length() + 1 && base.endsWith("_" + fdsStat)) {
            base = base.substring(0, base.lastIndexOf("_" + fdsStat));
        }
        if (!(name = Util.getUniqueName(this.getContainer().getMsrStatMgr(), base)).equals(base)) {
            this.addWarning(rec, Intl.intl("Statistic did not have a unique name."), String.format(Intl.intl("Changing name from \"%1$s\" to \"%2$s.\""), base, name));
        }
        return name;
    }

    private static class StatHash {
        public final FDSParseRecord rec;
        public final IGeom geom;
        public final IQuantity msr;

        public StatHash(FDSParseRecord rec, IGeom geom, IQuantity msr) {
            this.rec = rec;
            this.geom = geom;
            this.msr = msr;
        }

        public int hashCode() {
            return this.geom.hashCode() + this.msr.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            StatHash hash = (StatHash)obj;
            return this.geom.equals(hash.geom) && this.msr.equals(hash.msr);
        }
    }
}

