/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.SimParams;
import pyrosim.legacy_2012_1.domain.Variant;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.domain.ramp.RampInputs;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class SimParamsParser
extends AFDS5Parser {
    private int d_obstDefaults = 16;

    public SimParamsParser(FDS5ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    public int getObstDefaults() {
        return this.d_obstDefaults;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("HEAD");
        types.add("MISC");
        types.add("TIME");
        types.add("DUMP");
        types.add("RADI");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
        if (type.equals("MISC")) {
            unsupportedFields.add("ASSUMED_GAS_TEMPERATURE");
            unsupportedFields.add("CONDUCTIVITY");
            unsupportedFields.add("H_FIXED");
            unsupportedFields.add("MW");
            unsupportedFields.add("NOISE");
            unsupportedFields.add("SOLID_PHASE_ONLY");
        } else if (type.equals("DUMP")) {
            unsupportedFields.add("FLUSH_FILE_BUFFERS");
        }
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        if (rec.getType().equals("HEAD")) {
            return this.processHead(rec);
        }
        if (rec.getType().equals("MISC")) {
            return this.processMisc(rec);
        }
        if (rec.getType().equals("TIME")) {
            return this.processTime(rec);
        }
        if (rec.getType().equals("DUMP")) {
            return this.processDump(rec);
        }
        if (rec.getType().equals("RADI")) {
            return this.processRadi(rec);
        }
        return true;
    }

    private boolean processHead(FDSParseRecord rec) throws FDSRecordFormatException {
        SimParams params = this.getContainer().getSimParams();
        String title = rec.getString("TITLE");
        if (title != null) {
            params.setJobTitle(title);
        }
        this.flagObjectAdded(params);
        return true;
    }

    private boolean processTime(FDSParseRecord rec) throws FDSRecordFormatException {
        this.getContainer().getSimParams().setCustomFDSProps("TIME", this.getCustomVals(rec));
        SimParams.Time time = this.getContainer().getSimParams().getTime();
        time.setTimeStepLocks(rec.getBoolean("LOCK_TIME_STEP", true), rec.getBoolean("RESTRICT_TIME_STEP", true));
        time.setInitTimeStep(rec.getUnitDouble("DT", true));
        time.setStartTime(rec.getUnitDouble("T_BEGIN", true));
        UnitDouble stopTime = rec.contains("TWFIN") ? rec.getUnitDouble("TWFIN", true) : rec.getUnitDouble("T_END", true);
        time.setStopTime(stopTime);
        time.setWallIncrement(rec.getInteger("WALL_INCREMENT", true));
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }

    private boolean processMisc(FDSParseRecord rec) throws FDSRecordFormatException {
        FDSArray<UnitDouble> texList;
        String evacSurfKey;
        this.getContainer().getSimParams().setCustomFDSProps("MISC", this.getCustomVals(rec));
        SimParams.Calculations calc = this.getContainer().getSimParams().getCalculations();
        calc.setCorrectBaroclinicTorque(rec.getBoolean("BAROCLINIC", true));
        calc.setUseMLTurbulentModel(rec.getBoolean("H_EDDY", true));
        calc.setCflRange(rec.getDouble("CFL_MIN", true), rec.getDouble("CFL_MAX", true));
        calc.setCsmag(rec.getDouble("CSMAG", true));
        calc.setCalcDNS(rec.getBoolean("DNS", true));
        calc.setCalcIsothermal(rec.getBoolean("ISOTHERMAL", true));
        calc.setPrandtlNum(rec.getDouble("PR", true));
        calc.setSchmidtNum(rec.getDouble("SC", true));
        calc.setCForced(rec.getDouble("C_FORCED", true));
        calc.setCHorizontal(rec.getDouble("C_HORIZONTAL", true));
        calc.setCVertical(rec.getDouble("C_VERTICAL", true));
        calc.setGPFlameExtinction(rec.getBoolean("SUPPRESSION", true));
        calc.setVnRange(rec.getDouble("VN_MIN", true), rec.getDouble("VN_MAX", true));
        SimParams.Environment env = this.getContainer().getSimParams().getEnvironment();
        this.readGravity(env, rec);
        env.setGroundLevel(rec.getUnitDouble("GROUND_LEVEL", true));
        env.setRelHumidity(rec.getDouble("HUMIDITY", true));
        env.setAtmLapseRate(rec.getUnitDouble("LAPSE_RATE", true));
        env.setAmbPressure(rec.getUnitDouble("P_INF", true));
        env.setAmbTemp(rec.getUnitDouble("TMPA", true));
        UnitDouble uo = rec.getUnitDouble("U0", true);
        UnitDouble vo = rec.getUnitDouble("V0", true);
        UnitDouble wo = rec.getUnitDouble("W0", true);
        if (uo == null || vo == null || wo == null) {
            throw new FDSRecordFormatException(rec, Intl.intl("Prevailing velocity must have three values."));
        }
        env.setAmbVel(new UnitPoint3D(uo, vo, wo));
        SimParams.Particles par = this.getContainer().getSimParams().getParticles();
        par.setPourousFloor(rec.getBoolean("POROUS_FLOOR", true));
        par.setAllowUndersideDroplets(rec.getBoolean("ALLOW_UNDERSIDE_DROPLETS", true));
        SimParams.RadiationTransport radi = this.getContainer().getSimParams().getRadiTransport();
        radi.setRadiationOn(rec.getBoolean("RADIATION", true));
        SimParams.Misc misc = this.getContainer().getSimParams().getMisc();
        String defaultSurfKey = rec.getString("SURF_DEFAULT", true);
        if (defaultSurfKey != null) {
            Surface defSurf = this.getParsingInfo().findObject(Surface.class, defaultSurfKey);
            if (defSurf == null) {
                throw new FDSRecordFormatException(rec, "The specified default surface, \"" + defaultSurfKey + ",\" does not exist.");
            }
            misc.setSurfDefault(defSurf);
        }
        if ((evacSurfKey = rec.getString("EVAC_SURF_DEFAULT", true)) != null) {
            Surface evacSurf = this.getParsingInfo().findObject(Surface.class, evacSurfKey);
            if (evacSurf == null) {
                throw new FDSRecordFormatException(rec, "The specified default surface, \"" + evacSurfKey + ",\" does not exist.");
            }
            misc.setEvacProp("EVAC_SURF_DEFAULT", evacSurf);
        }
        if ((texList = rec.getArray("TEXTURE_ORIGIN", true)) != null) {
            misc.setTextureOrigin(new UnitPoint3D(texList.toFlatArray(new UnitDouble[3])));
        }
        misc.taskSetPredictCOProd(rec.getBoolean("CO_PRODUCTION", true)).run();
        String bgSpec = rec.getString("BACKGROUND_SPECIES", true);
        if (!ExSpecList.PREDEFINED.containsKey(bgSpec)) {
            this.addWarning(rec, String.format(Intl.intl("Unknown background species, %s."), bgSpec), Intl.intl("Using default background species."));
        } else {
            misc.taskSetBackgroundSpecies(bgSpec).run();
        }
        boolean bndfDef = rec.getBoolean("BNDF_DEFAULT", true);
        boolean thickenDef = rec.getBoolean("THICKEN_OBSTRUCTIONS", true);
        this.d_obstDefaults = bndfDef ? (this.d_obstDefaults |= 0x10) : (this.d_obstDefaults &= 0xFFFFFFEF);
        this.d_obstDefaults = thickenDef ? (this.d_obstDefaults |= 1) : (this.d_obstDefaults &= 0xFFFFFFFE);
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }

    private void readGravity(SimParams.Environment env, FDSParseRecord rec) {
        Variant gzVar;
        FDSArray<UnitDouble> gvec = rec.getArray("GVEC", true);
        UnitPoint3D g = new UnitPoint3D(gvec.toFlatArray(new UnitDouble[3]));
        Variant gxVar = rec.contains("RAMP_GX") ? this.readGravityRamp("RAMP_GX", rec) : new Variant.UnitDoubleVar(g.xu());
        Variant gyVar = rec.contains("RAMP_GY") ? this.readGravityRamp("RAMP_GY", rec) : new Variant.UnitDoubleVar(g.yu());
        Variant variant = gzVar = rec.contains("RAMP_GZ") ? this.readGravityRamp("RAMP_GZ", rec) : new Variant.UnitDoubleVar(g.zu());
        if (gxVar == null || gyVar == null || gzVar == null) {
            this.addWarning(rec, Intl.intl("Unable to read gravity RAMP."), Intl.intl("Gravity will be set to default."));
        }
        env.setGravityAccel(gxVar, gyVar, gzVar);
    }

    private Variant readGravityRamp(String miscRampKey, FDSParseRecord miscRec) {
        String rampId = miscRec.getString(miscRampKey);
        FDS5ParsingInfo.RampInfo rampInfo = this.getParsingInfo().getRampInfo(rampId);
        Ramp r = null;
        if (rampInfo != null) {
            if (rampInfo.rec.contains("T")) {
                r = this.getParsingInfo().getRamp(rampId, RampInputs.TIME, 6, false);
            } else if (rampInfo.rec.contains("X")) {
                r = this.getParsingInfo().getRamp(rampId, RampInputs.XPOS, 6, false);
            }
        }
        if (rampInfo == null || r == null) {
            String warn = String.format(Intl.intl("Unable to read RAMP record \"%s\"."), rampId);
            this.addWarning(miscRec, warn, Intl.intl("Ramp Ignored"));
            return null;
        }
        return new Variant.RampVar(r, RampInputs.TIME, RampInputs.XPOS);
    }

    private boolean processRadi(FDSParseRecord rec) throws FDSRecordFormatException {
        this.getContainer().getSimParams().setCustomFDSProps("RADI", this.getCustomVals(rec));
        SimParams.RadiationTransport radi = this.getContainer().getSimParams().getRadiTransport();
        radi.setAngleIncrement(rec.getInteger("ANGLE_INCREMENT", true));
        radi.setIncludeExtraFuelBands(rec.getBoolean("CH4_BANDS", true));
        radi.setConstAbsorptionCoef(rec.getUnitDouble("KAPPA0", true));
        radi.setNumPolarAngles(rec.getInteger("NMIEANG", true));
        radi.setNumSolidAngles(rec.getInteger("NUMBER_RADIATION_ANGLES", true));
        radi.setRadCalcPathLen(rec.getUnitDouble("PATH_LENGTH", true));
        radi.setRadiativeLossFraction(rec.getDouble("RADIATIVE_FRACTION", true));
        radi.setAssumedRadSourceTemp(rec.getUnitDouble("RADTMP", true));
        radi.setTimeStepInc(rec.getInteger("TIME_STEP_INCREMENT", true));
        radi.setNonGrayGasAssumption(rec.getBoolean("WIDE_BAND_MODEL", true));
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }

    private boolean processDump(FDSParseRecord rec) throws FDSRecordFormatException {
        this.getContainer().getSimParams().setCustomFDSProps("DUMP", this.getCustomVals(rec));
        SimParams.FileOutput fout = this.getContainer().getSimParams().getFileOutput();
        fout.setLimitCSVColumns(rec.getBoolean("COLUMN_DUMP_LIMIT", true));
        fout.setDtBoundaryFile(rec.getUnitDouble("DT_BNDF", true));
        fout.setDtDeviceFiles(rec.getUnitDouble("DT_DEVC", true));
        fout.setDtHeatReleaseRateFiles(rec.getUnitDouble("DT_HRR", true));
        fout.setDtIsofFiles(rec.getUnitDouble("DT_ISOF", true));
        fout.setDtMassFiles(rec.getUnitDouble("DT_MASS", true));
        fout.setDtParticleFiles(rec.getUnitDouble("DT_PART", true));
        fout.setDtPlot3dFile(rec.getUnitDouble("DT_PL3D", true));
        fout.setDtProfileDumpInterval(rec.getUnitDouble("DT_PROF", true));
        fout.setDtRestartFile(rec.getUnitDouble("DT_RESTART", true));
        fout.setDtSliceFiles(rec.getUnitDouble("DT_SLCF", true));
        fout.setNumOutputFrames(rec.getInteger("NFRAMES", true));
        fout.setVisualize3dSmoke(rec.getBoolean("SMOKE3D", true));
        fout.setWriteSpeciesMassFile(rec.getBoolean("MASS_FILE", true));
        fout.setWritePlot3dXYZFile(rec.getBoolean("WRITE_XYZ", true));
        IQuantity smokeQuant = this.parseQuantity(rec, "SMOKE3D_QUANTITY", null, "SMOKE3D_SPEC_ID", null, null, null, 0, Intl.intl("Ignoring custom smoke."), false, false);
        if (smokeQuant != null) {
            if (!SimParams.FileOutput.isValidSmokeQuantity(smokeQuant.get())) {
                this.addWarning(rec, String.format(Intl.intl("%s is not a valid Smoke3D quantity."), rec.getString("SMOKE3D_QUANTITY")), Intl.intl("Ignoring custom smoke."));
            } else {
                fout.setSmokeQuantity(smokeQuant);
            }
        }
        SimParams.Particles par = this.getContainer().getSimParams().getParticles();
        par.setMaxParticlesPerMesh(rec.getInteger("MAXIMUM_DROPLETS", true));
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }
}

