/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.controls.ControlBridge;
import pyrosim.legacy_2012_1.domain.controls.IControl;
import pyrosim.legacy_2012_1.domain.devices.IDevice;
import pyrosim.legacy_2012_1.domain.devices.detectors.Timer;
import pyrosim.legacy_2012_1.domain.signals.ILogicInPin;
import pyrosim.legacy_2012_1.domain.signals.ILogicOutPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSParsingInfo;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.IFDSRecordParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ControlParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnParser;

public class PinConnFinisher
implements IFDSRecordParser {
    private final FDSParsingInfo d_pi;
    private final PinConnParser d_pinConns;
    private final ControlParser d_ctrlParser;

    public PinConnFinisher(FDSParsingInfo pi, PinConnParser pinConns, ControlParser ctrl) {
        this.d_pi = pi;
        this.d_pinConns = pinConns;
        this.d_ctrlParser = ctrl;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("CTRL");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }

    @Override
    public void process(Collection<FDSParseRecord> recs, Collection<FDSParseRecord> unprocessed) throws FDSRecordFormatException {
        this.d_ctrlParser.finish();
        IdentityHashMap<ILogicOutPin, ControlBridge> cbs = new IdentityHashMap<ILogicOutPin, ControlBridge>();
        for (PinConnParser.InputRetrieval inputRetrieval : this.d_pinConns.getRetrievals()) {
            Set<? extends IOutPin> opins = inputRetrieval.inPin.getConnections();
            if (!(inputRetrieval.inPin.getAttachedSink() instanceof IControl) && inputRetrieval.inPin instanceof ILogicInPin) {
                ArrayList<? extends IOutPin> outPins = new ArrayList<IOutPin>(opins);
                Iterator iterator = outPins.iterator();
                while (iterator.hasNext()) {
                    IOutPin outPin = (IOutPin)iterator.next();
                    ControlBridge cb = (ControlBridge)cbs.get(outPin);
                    if (cb == null) {
                        cb = this.addBridge((ILogicOutPin)outPin, this.d_pinConns.getPinFDSNameMap().get(outPin));
                        assert (outPin instanceof ILogicOutPin);
                        cbs.put((ILogicOutPin)outPin, cb);
                    }
                    inputRetrieval.inPin.disconnect(outPin);
                    inputRetrieval.inPin.connect(cb.getOutputPins().get(0));
                }
                continue;
            }
            for (IOutPin iOutPin : opins) {
                if (!(iOutPin instanceof ILogicOutPin) || cbs.containsKey(iOutPin)) continue;
                cbs.put((ILogicOutPin)iOutPin, null);
            }
        }
        for (Map.Entry entry : this.d_pinConns.getPinFDSNameMap().entrySet()) {
            IOutPin outPin = (IOutPin)entry.getKey();
            String ctrlName = (String)entry.getValue();
            if (!(outPin instanceof ILogicOutPin) || cbs.containsKey(outPin) || outPin.getAttachedSource() instanceof IDevice && !(outPin.getAttachedSource() instanceof Timer)) continue;
            ControlBridge controlBridge = this.addBridge((ILogicOutPin)outPin, ctrlName);
            cbs.put((ILogicOutPin)outPin, controlBridge);
        }
    }

    private ControlBridge addBridge(ILogicOutPin outPin, String ctrlName) {
        ControlBridge cb = new ControlBridge(this.getBridgeName(outPin, ctrlName));
        assert (cb.getInputPin().isCompatible(outPin));
        cb.getInputPin().connect(outPin);
        this.d_pi.getContainer().getControls().add(cb);
        this.d_pi.getParseResult().extractedObjs.add(cb);
        return cb;
    }

    private String getBridgeName(ILogicOutPin outPin, String ctrlName) {
        int lcount = 0;
        for (IOutPin iOutPin : outPin.getAttachedSource().getOutputPins()) {
            if (!(iOutPin instanceof ILogicOutPin)) continue;
            ++lcount;
        }
        if (lcount == 1) {
            return ctrlName;
        }
        return ctrlName + "->" + outPin.getName();
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
    }
}

