/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.geom.Vent;
import pyrosim.legacy_2012_1.domain.hvac.HvacAircoil;
import pyrosim.legacy_2012_1.domain.hvac.HvacComponent;
import pyrosim.legacy_2012_1.domain.hvac.HvacDuct;
import pyrosim.legacy_2012_1.domain.hvac.HvacFan;
import pyrosim.legacy_2012_1.domain.hvac.HvacFilter;
import pyrosim.legacy_2012_1.domain.hvac.HvacList;
import pyrosim.legacy_2012_1.domain.hvac.HvacNode;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.domain.ramp.RampInputs;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.VentParser;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class HvacParser
extends AFDS5Parser {
    private Map<FDSParseRecord, HvacAircoil> d_aircoilMap = new HashMap<FDSParseRecord, HvacAircoil>();
    private Map<FDSParseRecord, HvacDuct> d_ductMap = new HashMap<FDSParseRecord, HvacDuct>();
    private Map<FDSParseRecord, HvacFan> d_fanMap = new HashMap<FDSParseRecord, HvacFan>();
    private Map<FDSParseRecord, HvacNode> d_nodeMap = new HashMap<FDSParseRecord, HvacNode>();
    private Map<FDSParseRecord, HvacNode> d_nodesWithVents = new HashMap<FDSParseRecord, HvacNode>();
    private Map<HvacComponent, String> d_renames = new HashMap<HvacComponent, String>();
    private PinConnParser d_pinConns;
    private VentParser d_ventParser;

    public HvacParser(FDS5ParsingInfo parsingInfo, PinConnParser pinConns, VentParser ventParser) {
        super(parsingInfo);
        this.d_pinConns = pinConns;
        this.d_ventParser = ventParser;
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        HvacComponent comp;
        if (System.getProperty("HVAC") == null) {
            this.addWarning(rec, Intl.intl("HVAC not supported"), Intl.intl("Added to Additional Records"));
            return false;
        }
        if (!rec.contains("TYPE_ID")) {
            this.addWarning(rec, Intl.intl("Unable to process HVAC record: Type ID missing"), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (!rec.contains("ID")) {
            this.addWarning(rec, Intl.intl("Unable to process HVAC record: ID missing"), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        HvacList mgr = this.getContainer().getHvacList();
        String type = rec.getString("TYPE_ID");
        String id = rec.getString("ID");
        if (type.equals("AIRCOIL")) {
            comp = new HvacAircoil(id);
            this.d_aircoilMap.put(rec, (HvacAircoil)comp);
            if (!this.parseAircoil(rec, comp)) {
                return false;
            }
        } else if (type.equals("DUCT")) {
            comp = new HvacDuct(id);
            this.d_ductMap.put(rec, (HvacDuct)comp);
            if (!this.parseDuct(rec, comp)) {
                return false;
            }
        } else if (type.equals("FAN")) {
            comp = new HvacFan(id);
            this.d_fanMap.put(rec, (HvacFan)comp);
            if (!this.parseFan(rec, comp)) {
                return false;
            }
        } else if (type.equals("FILTER")) {
            comp = new HvacFilter(id);
            if (!this.parseFilter(rec, comp)) {
                return false;
            }
        } else if (type.equals("NODE")) {
            comp = new HvacNode(id);
            this.d_nodeMap.put(rec, (HvacNode)comp);
            if (!this.parseNode(rec, comp)) {
                return false;
            }
        } else {
            this.addWarning(rec, Intl.intl("Unable to process HVAC record: Invalid type"), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (mgr.get(id) != null) {
            String newIdBase;
            String newId = newIdBase = String.format("%s-%s", type.toLowerCase(), id);
            int i = 0;
            while (mgr.get(newId) != null) {
                newId = String.format("%s-%s", newIdBase, i);
            }
            this.addWarning(rec, Intl.intl("Duplicate ID in HVAC Record"), String.format(Intl.intl("HVAC record ID changed to %s."), newId));
            this.d_renames.put(comp, newId);
        }
        mgr.add(comp);
        this.flagObjectAdded(comp);
        return true;
    }

    private boolean parseAircoil(FDSParseRecord rec, HvacComponent comp) {
        int count = 0;
        if (rec.contains("COOLANT_CP")) {
            comp.setProp("COOLANT_CP", rec.getUnitDouble("COOLANT_CP"));
            ++count;
        }
        if (rec.contains("COOLANT_MDOT")) {
            comp.setProp("COOLANT_MDOT", rec.getUnitDouble("COOLANT_MDOT"));
            ++count;
        }
        if (rec.contains("COOLANT_TEMPERATURE")) {
            comp.setProp("COOLANT_TEMPERATURE", rec.getUnitDouble("COOLANT_TEMPERATURE"));
            ++count;
        }
        if (rec.contains("EFFICIENCY")) {
            comp.setProp("EFFICIENCY", rec.getUnitDouble("EFFICIENCY"));
            ++count;
        }
        if (count > 0 && count < 4) {
            this.addWarning(rec, Intl.intl("Unable to process HVAC record: COOLANT_CP, COOLANT_MDOT, COOLANT_TEMPERATURE, and EFFICIENTY must be defined."), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (count > 0 && rec.contains("FIXED_Q")) {
            this.addWarning(rec, Intl.intl("Unable to process HVAC record: Only one of FIXED_Q and COOLANT properies may be defined."), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (rec.contains("FIXED_Q")) {
            comp.setProp("FIXED_Q", rec.getUnitDouble("FIXED_Q"));
            comp.setProp("opt_aircoil_model", HvacAircoil.AIRCOIL_MODEL_FIXEDQ);
        }
        HvacParser.markSingleInputForRetrieval(rec, (HvacAircoil)comp, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        return true;
    }

    private boolean parseDuct(FDSParseRecord rec, HvacComponent comp) {
        if (rec.contains("AIRCOIL_ID")) {
            comp.setProp("AIRCOIL_ID", rec.getString("AIRCOIL_ID"));
        }
        if (rec.contains("AREA")) {
            comp.setProp("AREA", rec.getUnitDouble("AREA"));
            comp.setProp("opt_area_diameter", "AREA");
        } else if (rec.contains("DIAMETER")) {
            comp.setProp("DIAMETER", rec.getUnitDouble("DIAMETER"));
            comp.setProp("opt_area_diameter", "DIAMETER");
        } else {
            this.addWarning(rec, Intl.intl("Unable to process HVAC record: Either area or diameter must be defined."), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (rec.contains("DAMPER") && rec.contains("FAN_ID")) {
            this.addWarning(rec, Intl.intl("Unable to process HVAC record: Only one of DAMPER and FAN_ID can be defined."), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (rec.contains("DAMPER")) {
            comp.setProp("DAMPER", rec.getBoolean("DAMPER"));
            comp.setProp("opt_none_damper_fan", "airflow_damper");
        } else if (rec.contains("FAN_ID")) {
            comp.setProp("FAN_ID", rec.getString("FAN_ID"));
            comp.setProp("opt_none_damper_fan", "airflow_fan");
            if (rec.contains("VOLUME_FLOW")) {
                this.addWarning(rec, Intl.intl("Unable to process HVAC record: VOLUME_FLOW cannot be used with FAN_ID."), Intl.intl("Ignoring VOLUME_FLOW"));
            }
        } else if (rec.contains("VOLUME_FLOW")) {
            comp.setProp("VOLUME_FLOW", rec.getUnitDouble("VOLUME_FLOW"));
            comp.setProp("RAMP_ID", rec.getString("RAMP_ID"));
            comp.setProp("TAU_VF", rec.getUnitDouble("TAU_VF"));
            ((HvacDuct)comp).d_func = this.parseTimeFunction(rec, "TAU_VF", "RAMP_ID");
        }
        if (!rec.contains("VOLUME_FLOW") && rec.contains("TAU_VF")) {
            this.addWarning(rec, Intl.intl("Invalid HVAC record: TAU_VF can only be used with VOLUME_FLOW."), Intl.intl("Ignoring TAU_VF"));
        }
        if (rec.contains("LENGTH")) {
            comp.setProp("use_length", true);
            comp.setProp("LENGTH", rec.getUnitDouble("LENGTH"));
        }
        if (rec.contains("LOSS")) {
            FDSArray loss = (FDSArray)rec.get("LOSS");
            UnitDouble lossForward = (UnitDouble)loss.get(0, 0);
            UnitDouble lossBackward = (UnitDouble)loss.get(1, 0);
            if (lossForward != null && lossBackward != null) {
                comp.setProp("LOSS", Arrays.asList(lossForward, lossBackward));
            } else if (lossForward != null && lossBackward == null) {
                this.addWarning(rec, Intl.intl("Invalid HVAC entry: DUCT LOSS is a pair of real numbers."), Intl.intl("Using first entry for both values."));
                comp.setProp("LOSS", Arrays.asList(lossForward, new UnitDouble(lossForward.getValueNoUnit(), lossForward.getUnit())));
            } else {
                this.addWarning(rec, Intl.intl("Invalid HVAC entry: DUCT LOSS is a pair of real numbers."), Intl.intl("Using default values."));
            }
        }
        if (rec.contains("NODE_ID")) {
            List nodeId = rec.getList("NODE_ID", false);
            ((HvacDuct)comp).d_n1 = (String)nodeId.get(0);
            ((HvacDuct)comp).d_n2 = (String)nodeId.get(1);
        }
        if (rec.contains("REVERSE")) {
            comp.setProp("REVERSE", rec.getBoolean("REVERSE"));
        }
        if (rec.contains("ROUGHNESS")) {
            comp.setProp("ROUGHNESS", rec.getUnitDouble("ROUGHNESS"));
        }
        HvacParser.markSingleInputForRetrieval(rec, (HvacDuct)comp, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        return true;
    }

    private boolean parseFan(FDSParseRecord rec, HvacComponent comp) {
        if (rec.contains("TAU_FAN")) {
            comp.setProp("TAU_FAN", rec.getUnitDouble("TAU_FAN"));
            ((HvacFan)comp).d_tauFunc = AFDS5Parser.parseTCurve(rec, "TAU_FAN");
        }
        if (rec.contains("LOSS")) {
            FDSArray lossArr = (FDSArray)rec.get("LOSS");
            UnitDouble loss = (UnitDouble)lossArr.get(0, 0);
            if (loss != null) {
                comp.setProp("LOSS", Arrays.asList(loss));
            } else {
                this.addWarning(rec, Intl.intl("Invalid HVAC entry: FAN LOSS"), Intl.intl("Using default."));
            }
        }
        int count = 0;
        if (rec.contains("VOLUME_FLOW")) {
            comp.setProp("VOLUME_FLOW", rec.getUnitDouble("VOLUME_FLOW"));
            comp.setProp("opt_fan_model", HvacFan.FAN_MODEL_VOLFLOW);
            ++count;
        }
        if (rec.contains("MAX_FLOW") && rec.contains("MAX_PRESSURE")) {
            comp.setProp("MAX_FLOW", rec.getUnitDouble("MAX_FLOW"));
            comp.setProp("MAX_PRESSURE", rec.getUnitDouble("MAX_PRESSURE"));
            comp.setProp("opt_fan_model", HvacFan.FAN_MODEL_QUADRATIC);
            ++count;
        }
        if (rec.contains("RAMP_ID")) {
            Ramp r;
            ((HvacFan)comp).d_fanRamp = r = this.getParsingInfo().getRamp(rec.getString("RAMP_ID"), RampInputs.PRESSURE, 24, true);
            comp.setProp("RAMP_ID", rec.getString("RAMP_ID"));
            comp.setProp("opt_fan_model", HvacFan.FAN_MODEL_PRESDROP);
            ++count;
        }
        if (count > 1) {
            this.addWarning(rec, Intl.intl("Unable to process HVAC FAN record: Only one of VOLUME_FLOW, MAX_FLOW + MAX_PRESSURE, and RAMP_ID can be defined"), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        return true;
    }

    private boolean parseFilter(FDSParseRecord rec, HvacComponent comp) {
        if (rec.contains("CLEAN_LOSS")) {
            comp.setProp("CLEAN_LOSS", rec.getUnitDouble("CLEAN_LOSS"));
        }
        if (rec.contains("EFFICIENCY")) {
            comp.setProp("EFFICIENCY", rec.getArray("EFFICIENCY", false));
        }
        if (rec.contains("LOADING")) {
            comp.setProp("LOADING", rec.getList("LOADING", false));
        }
        if (rec.contains("LOADING_MULTIPLIER")) {
            comp.setProp("LOADING_MULTIPLIER", rec.getList("LOADING_MULTIPLIER", false));
        }
        if (rec.contains("SPEC_ID")) {
            comp.setProp("SPEC_ID", Arrays.asList(rec.getString("SPEC_ID")));
        }
        if (rec.contains("LOSS") && rec.contains("RAMP_ID")) {
            this.addWarning(rec, Intl.intl("Unable to process HVAC record: Only one of LOSS and RAMP_ID may be specified"), Intl.intl("HVAC Record Ignored"));
            return false;
        }
        if (rec.contains("LOSS")) {
            FDSArray lossArr = (FDSArray)rec.get("LOSS");
            UnitDouble loss = (UnitDouble)lossArr.get(0, 0);
            if (loss != null) {
                comp.setProp("LOSS", Arrays.asList(loss));
            } else {
                this.addWarning(rec, Intl.intl("Invalid HVAC entry: FILTER LOSS"), Intl.intl("Using default."));
            }
            comp.setProp("opt_loss_ramp", "LOSS");
        } else if (rec.contains("RAMP_ID")) {
            comp.setProp("RAMP_ID", rec.getString("RAMP_ID"));
            comp.setProp("opt_loss_ramp", "RAMP_ID");
        }
        return true;
    }

    private boolean parseNode(FDSParseRecord rec, HvacComponent comp) {
        if (rec.contains("AMBIENT")) {
            comp.setProp("AMBIENT", rec.getBoolean("AMBIENT"));
        }
        int numDucts = 0;
        List ducts = new ArrayList();
        if (rec.contains("DUCT_ID")) {
            ducts = (List)rec.get("DUCT_ID");
            numDucts = ducts.size();
            if (numDucts < 10) {
                comp.setProp("DUCT_ID", ducts);
            } else {
                this.addWarning(rec, Intl.intl("List exceeds limit: DUCT_ID"), Intl.intl("Ignoring tailing entries"));
                ducts = ducts.subList(0, 9);
                comp.setProp("DUCT_ID", ducts);
            }
        }
        if (rec.contains("LOSS")) {
            FDSArray lossArr = (FDSArray)rec.get("LOSS");
            if (lossArr != null) {
                UnitDouble[] losses = new UnitDouble[lossArr.getTotalLength()];
                losses = lossArr.toFlatArray(losses);
                comp.setProp("LOSS", Arrays.asList(losses));
            } else {
                this.addWarning(rec, Intl.intl("Invalid HVAC entry: NODE LOSS"), Intl.intl("Using default."));
            }
        }
        if (rec.contains("VENT_ID") && rec.contains("XYZ")) {
            this.addWarning(rec, Intl.intl("Invalid HVAC record: Only one of VENT_ID and XYZ may be specified"), Intl.intl("XYZ will be ignored."));
        }
        if (rec.contains("VENT_ID")) {
            this.d_nodesWithVents.put(rec, (HvacNode)comp);
            comp.setProp("opt_vent_xyz", "VENT_ID");
        } else if (rec.contains("XYZ")) {
            FDSArray xyzRaw = rec.getArray("XYZ", false);
            UnitPoint3D xyz = new UnitPoint3D(((UnitDouble)xyzRaw.get(0)).getValueNoUnit(), ((UnitDouble)xyzRaw.get(1)).getValueNoUnit(), ((UnitDouble)xyzRaw.get(2)).getValueNoUnit(), ((UnitDouble)xyzRaw.get(0)).getUnit());
            comp.setProp("XYZ", xyz);
            comp.setProp("opt_vent_xyz", "XYZ");
        } else {
            this.addWarning(rec, Intl.intl("Invalid HVAC record: NODE XYZ not specified"), Intl.intl("Using default location (0,0,0)"));
        }
        return true;
    }

    private static final <T> T findById(Map<FDSParseRecord, T> map, String id) {
        for (FDSParseRecord rec : map.keySet()) {
            if (!rec.contains("ID") || !rec.getString("ID").equals(id)) continue;
            return map.get(rec);
        }
        return null;
    }

    @Override
    public void done() {
        for (FDSParseRecord rec : this.d_ductMap.keySet()) {
            String acId;
            String fanId;
            HvacDuct duct = this.d_ductMap.get(rec);
            String[] nodeId = new String[]{duct.d_n1, duct.d_n2};
            if (nodeId != null) {
                HvacNode node1 = HvacParser.findById(this.d_nodeMap, nodeId[0]);
                HvacNode node2 = HvacParser.findById(this.d_nodeMap, nodeId[1]);
                if (node1 == null) {
                    this.addWarning(rec, String.format(Intl.intl("Unable to find NODE for DUCT (NODE_ID=%s)."), node1), Intl.intl("Creating invalid HVAC DUCT"));
                }
                if (node2 == null) {
                    this.addWarning(rec, String.format(Intl.intl("Unable to find NODE for DUCT (NODE_ID=%s)."), node2), Intl.intl("Creating invalid HVAC DUCT."));
                }
                duct.setProp("NODE_ID", Arrays.asList(node1, node2));
            }
            if ((fanId = (String)duct.getProp("FAN_ID")) != null) {
                HvacFan fan = HvacParser.findById(this.d_fanMap, fanId);
                if (fan == null) {
                    this.addWarning(rec, String.format(Intl.intl("Unable to find FAN for DUCT (FAN_ID=%s)."), fanId), Intl.intl("Creating invalid HVAC DUCT."));
                }
                duct.setProp("FAN_ID", fan);
            }
            if ((acId = (String)duct.getProp("AIRCOIL_ID")) == null) continue;
            HvacAircoil ac = HvacParser.findById(this.d_aircoilMap, acId);
            if (ac == null) {
                this.addWarning(rec, String.format(Intl.intl("Unable to find AIRCOIL for DUCT (AIRCOIL_ID=%s)."), acId), Intl.intl("Creating invalid HVAC DUCT."));
            }
            duct.setProp("AIRCOIL_ID", ac);
        }
        for (FDSParseRecord rec : this.d_nodeMap.keySet()) {
            HvacNode node = this.d_nodeMap.get(rec);
            List ductId = (List)node.getProp("DUCT_ID");
            if (ductId == null) continue;
            ArrayList<HvacDuct> ductList = new ArrayList<HvacDuct>(10);
            for (int i = 0; i < ductId.size(); ++i) {
                HvacDuct duct = HvacParser.findById(this.d_ductMap, (String)ductId.get(i));
                if (duct == null) {
                    this.addWarning(rec, String.format(Intl.intl("Unable to find DUCT for NODE (DUCT_ID=%s)."), ductId.get(i)), Intl.intl("Missing DUCT record will be ignored."));
                }
                ductList.add(duct);
            }
            node.setProp("DUCT_ID", ductList);
        }
    }

    @Override
    public void postProcess() {
        Map<FDSParseRecord, Vent> ventMap = this.d_ventParser.getVentMap();
        for (FDSParseRecord rec : this.d_nodesWithVents.keySet()) {
            String ventId;
            if (!rec.contains("VENT_ID") || (ventId = rec.getString("VENT_ID")) == null) continue;
            Vent vent = HvacParser.findById(ventMap, ventId);
            HvacNode node = this.d_nodesWithVents.get(rec);
            if (vent != null) {
                node.setProp("VENT_ID", vent);
                continue;
            }
            node.setProp("VENT_ID", null);
            this.addWarning(rec, String.format(Intl.intl("VENT id=%s not found."), ventId), Intl.intl("VENT_ID will not be set."));
        }
        for (HvacComponent comp : this.d_renames.keySet()) {
            comp.setName(this.d_renames.get(comp));
        }
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("HVAC");
    }

    @Override
    public void getUnsupportedFields(String type, Set<String> unsupportedFields) {
    }
}

