/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashMap;

class ReplacePreserveTask
extends AUndoableTask {
    private final ReplaceRecord[] d_replacements;

    public ReplacePreserveTask(List<? extends IPyroObject> originals, List<? extends IPyroObject> replacements) {
        this.d_replacements = new ReplaceRecord[originals.size()];
        for (int m = 0; m < originals.size(); ++m) {
            this.d_replacements[m] = new ReplaceRecord(originals.get(m), replacements.get(m));
        }
    }

    @Override
    public void run() {
        if (this.d_replacements.length > 0 && this.d_replacements[0].index == -1) {
            IdentityHashMap<IPyroObject, ReplaceRecord> objRecMap = new IdentityHashMap<IPyroObject, ReplaceRecord>();
            IdentityHashSet groups = new IdentityHashSet();
            for (ReplaceRecord rec : this.d_replacements) {
                objRecMap.put(rec.original, rec);
                groups.add((Composite)rec.original.getParent());
            }
            for (Composite group : groups) {
                int ix = 0;
                for (IPyroObject member : group.getMembers()) {
                    ReplaceRecord rec = (ReplaceRecord)objRecMap.get(member);
                    if (rec != null) {
                        rec.index = ix;
                    }
                    ++ix;
                }
            }
        }
        this.runReplacements();
    }

    @Override
    public void undo() {
        this.runReplacements();
    }

    private void runReplacements() {
        LinkedIdentityHashMap<Composite, ArrayList<ReplaceRecord>> parentRecMap = new LinkedIdentityHashMap<Composite, ArrayList<ReplaceRecord>>();
        for (ReplaceRecord rec : this.d_replacements) {
            Composite parent = (Composite)rec.original.getParent();
            ArrayList<ReplaceRecord> recs = (ArrayList<ReplaceRecord>)parentRecMap.get(parent);
            if (recs == null) {
                recs = new ArrayList<ReplaceRecord>();
                parentRecMap.put(parent, recs);
            }
            recs.add(rec);
        }
        for (Map.Entry entry : parentRecMap.entrySet()) {
            Composite parent = (Composite)entry.getKey();
            ArrayList<IPyroObject> members = new ArrayList<IPyroObject>(parent.getMembers());
            for (ReplaceRecord rec : (List)entry.getValue()) {
                parent.remove(rec.original);
                parent.add(rec.replacement);
                members.set(rec.index, rec.replacement);
                rec.swap();
            }
            parent.reorder(members);
        }
    }

    private static class ReplaceRecord {
        public IPyroObject original;
        public IPyroObject replacement;
        public int index;

        public ReplaceRecord(IPyroObject original, IPyroObject replacement) {
            this.original = original;
            this.replacement = replacement;
            this.index = -1;
        }

        public void swap() {
            IPyroObject temp = this.original;
            this.original = this.replacement;
            this.replacement = temp;
        }
    }
}

