/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.output.Slice;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.APlaneHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PlanarSurface;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class PlanarSlice
extends Slice {
    static final long serialVersionUID = 1L;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    private int d_plane;
    private UnitDouble d_location;

    public PlanarSlice(int plane, UnitDouble location, IQuantity measurement, boolean includeFlowVector) {
        super(measurement, includeFlowVector);
        this.d_plane = plane;
        this.d_location = location;
    }

    public PlanarSlice(SliceGeom geom, IQuantity quantity, boolean includeFlowVector) {
        this(geom.plane, new UnitDouble(geom.loc, Geometry.LU), quantity, includeFlowVector);
    }

    public PlanarSlice(PlanarSurface geom, IQuantity quantity, boolean includeFlowVector) {
        super(quantity, includeFlowVector);
        Pair<Integer, UnitDouble> plane = PlanarSlice.convert(geom.plane);
        this.d_plane = (Integer)plane.v1;
        this.d_location = (UnitDouble)plane.v2;
    }

    public int getPlane() {
        return this.d_plane;
    }

    public UnitDouble getLocation() {
        return this.d_location;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PlanarSlice) {
            PlanarSlice rec = (PlanarSlice)obj;
            return super.equals(rec) && this.d_plane == rec.d_plane && this.d_location.equals(rec.d_location);
        }
        return false;
    }

    @Override
    public AABox getBounds() {
        return new AABox(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    private static Pair<Integer, UnitDouble> convert(Plane3d plane) {
        Vector3d adir;
        Vector3d normal = plane.getNormal();
        int axis = Util3D.getClosestAxis(normal);
        int saxis = switch (axis) {
            case 0 -> {
                adir = GeomConstants.VEC3D_XPOS;
                yield 0;
            }
            case 1 -> {
                adir = GeomConstants.VEC3D_YPOS;
                yield 1;
            }
            default -> {
                adir = GeomConstants.VEC3D_ZPOS;
                yield 2;
            }
        };
        double val = adir.dot(normal) < 0.0 ? plane.w : -plane.w;
        return new Pair<Integer, UnitDouble>(saxis, new UnitDouble(val, Geometry.LU));
    }

    private static Plane3d convert(int plane, double loc) {
        switch (plane) {
            case 0: {
                return new Plane3d(1.0, 0.0, 0.0, -loc);
            }
            case 1: {
                return new Plane3d(0.0, 1.0, 0.0, -loc);
            }
        }
        return new Plane3d(0.0, 0.0, 1.0, -loc);
    }

    @Override
    public void setGeom(IGeom geom, boolean optimizeGeom) {
        if ((geom = Geometry.finalize(geom, optimizeGeom)) instanceof SliceGeom) {
            SliceGeom sg = (SliceGeom)geom;
            this.d_plane = sg.plane;
            this.d_location = new UnitDouble(sg.loc, Geometry.LU);
            this.changedEvt(new Object[0]);
        } else if (geom instanceof PlanarSurface) {
            PlanarSurface ps = (PlanarSurface)geom;
            Pair<Integer, UnitDouble> plane = PlanarSlice.convert(ps.plane);
            this.d_plane = (Integer)plane.v1;
            this.d_location = (UnitDouble)plane.v2;
            this.changedEvt(new Object[0]);
        }
    }

    public static class SliceGeom
    extends GeomGroup {
        private static final long serialVersionUID = -5217337990260872179L;
        public final Collection<? extends Grid> grids;
        public final int plane;
        public final double loc;

        public SliceGeom(int plane, double loc, Collection<? extends Grid> grids) {
            this(SliceGeom.getQuads(plane, loc, grids), plane, loc, grids);
        }

        private SliceGeom(List<? extends IGeom> quads, int plane, double loc, Collection<? extends Grid> grids) {
            super(quads);
            this.plane = plane;
            this.loc = loc;
            this.grids = grids;
        }

        @Override
        public Object fromLegacy(LegacyDictionary_2012_1 dict) {
            return super.fromLegacy(dict);
        }

        private static List<AARectangle> getQuads(int plane, double loc, Collection<? extends Grid> grids) {
            ArrayList<AARectangle> quads = new ArrayList<AARectangle>();
            for (Grid grid : grids) {
                AABox bounds = grid.getGeom().getBoundingBox(new AABox());
                switch (plane) {
                    case 0: {
                        if (!(bounds.getMinX() <= loc) || !(loc <= bounds.getMaxX())) break;
                        quads.add(new AARectangle(0, loc, bounds.getMinY(), bounds.getMinZ(), bounds.getMaxY(), bounds.getMaxZ()));
                        break;
                    }
                    case 1: {
                        if (!(bounds.getMinY() <= loc) || !(loc <= bounds.getMaxY())) break;
                        quads.add(new AARectangle(1, loc, bounds.getMinX(), bounds.getMinZ(), bounds.getMaxX(), bounds.getMaxZ()));
                        break;
                    }
                    case 2: {
                        if (!(bounds.getMinZ() <= loc) || !(loc <= bounds.getMaxZ())) break;
                        quads.add(new AARectangle(2, loc, bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY()));
                    }
                }
            }
            return quads;
        }

        @Override
        public GeomGroup optimize(IPointOptimizer pool) {
            GeomGroup optimized = super.optimize(pool);
            return optimized == this ? this : new SliceGeom(optimized.children, this.plane, this.loc, this.grids);
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }

        @Override
        public IGeom transform(Matrix4d xform, IGeom.XformOp op) {
            Plane3d plane = switch (this.plane) {
                case 0 -> new Plane3d(1.0, 0.0, 0.0, -this.loc);
                case 1 -> new Plane3d(0.0, 1.0, 0.0, -this.loc);
                case 2 -> new Plane3d(0.0, 0.0, 1.0, -this.loc);
                default -> {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    yield null;
                }
            };
            plane = plane.transformBy(xform);
            Point3d pOnPlane = new Point3d(-plane.x * plane.w, -plane.y * plane.w, -plane.z * plane.w);
            Vector3d newNorm = plane.getNormal();
            int newAxis = Util.getClosestAxis(newNorm);
            switch (newAxis) {
                case 0: {
                    return new SliceGeom(0, pOnPlane.x, this.grids);
                }
                case 1: {
                    return new SliceGeom(1, pOnPlane.y, this.grids);
                }
                case 2: {
                    return new SliceGeom(2, pOnPlane.z, this.grids);
                }
            }
            return this;
        }

        @Override
        public Collection<? extends IHandle> generateManipHandles() {
            return Arrays.asList(new Handle(this));
        }

        private static class Handle
        extends APlaneHandle<SliceGeom> {
            public Handle(SliceGeom geom) {
                super(geom);
            }

            @Override
            public boolean equals(Object obj) {
                return super.equals(obj) && obj instanceof Handle;
            }

            @Override
            public IGeom getGeom() {
                return (IGeom)this.getManipGeom();
            }

            @Override
            protected Vector3d getPlaneNormal(SliceGeom geom) {
                switch (geom.plane) {
                    case 0: {
                        return GeomConstants.VEC3D_XPOS;
                    }
                    case 1: {
                        return GeomConstants.VEC3D_YPOS;
                    }
                    case 2: {
                        return GeomConstants.VEC3D_ZPOS;
                    }
                }
                return null;
            }

            @Override
            protected SliceGeom modify(SliceGeom origGeom, double offset) {
                return new SliceGeom(origGeom.plane, origGeom.loc + offset, origGeom.grids);
            }
        }
    }
}

