/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.geom;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.TimeBasedValue;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Fuel;
import pyrosim.legacy_2012_1.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.geom.AFDSObject;
import pyrosim.legacy_2012_1.domain.geom.FireSpread;
import pyrosim.legacy_2012_1.domain.geom.ISurfObj;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.domain.rasterization.IFDSObjProps;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.geom.TexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.Rectifier;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.ITexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.LineConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.AcceptAllFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.HashPool;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class Vent
extends AFDSObject
implements ISurfObj {
    static final long serialVersionUID = 1L;
    public static final int OPTION_OUTLINE = 1;
    public static final int ALL_OPTIONS = 1;
    public static final int DEF_OPTIONS = 0;
    private AARectangle d_quad;
    private Vector3d d_normal;
    private Surface d_surf;
    private TexOrigin d_texOrigin;
    private FireSpread d_fireSpread;
    private OpenProps d_openProps;
    public static final Composite.IObjectProp fireSpreadProp = new Composite.AObjectProp<Vent, FireSpread>(Vent.class){

        @Override
        public void set(Vent obj, FireSpread prop) {
            obj.setFireSpread(prop);
        }

        @Override
        public Object get(Vent obj) {
            return obj.getFireSpread();
        }
    };
    public static final Composite.IObjectProp texOriginProp = new Composite.AObjectProp<Vent, TexOrigin>(Vent.class){

        @Override
        public void set(Vent obj, TexOrigin prop) {
            obj.setTextureOrigin(prop);
        }

        @Override
        public Object get(Vent obj) {
            return obj.getTextureOrigin();
        }
    };
    public static final Composite.IObjectProp surfProp = new Composite.AObjectProp<Vent, Surface>(Vent.class){

        @Override
        public void set(Vent obj, Surface prop) {
            obj.setSurface(prop);
        }

        @Override
        public Object get(Vent obj) {
            return obj.getSurface();
        }
    };

    public Vent(String name, Surface mat) {
        this(name, mat, new AARectangle(2, 0.0, 0.0, 0.0, 1.0, 1.0));
    }

    public Vent(String name, Surface mat, AARectangle geom) {
        super(name);
        this.d_quad = geom;
        this.d_surf = mat;
        this.d_normal = geom instanceof VentGeom ? ((VentGeom)geom).normal : null;
        this.d_fireSpread = null;
        this.d_texOrigin = TexOrigin.defaultWorld();
        this.setOptions(0, true);
    }

    public static IObjectFilter<Surface> getSurfaceFilter() {
        return new AcceptAllFilter<Surface>();
    }

    private static int filterOptions(int options) {
        return options & 1;
    }

    public void setOptions(int options, boolean set) {
        this.setFlags(Vent.filterOptions(options), set, new Object[0]);
    }

    public boolean getOptions(int options) {
        return this.testFlags(Vent.filterOptions(options));
    }

    public int getSetOptions() {
        return Vent.filterOptions(super.getSetFlags());
    }

    public void setNormal(Vector3d normal) {
        this.d_normal = normal;
        this.changedEvt(new Object[0]);
    }

    public Vector3d getNormal() {
        return this.d_normal;
    }

    @Override
    public TexOrigin getTextureOrigin() {
        return this.d_texOrigin;
    }

    @Override
    public void setTextureOrigin(TexOrigin origin) {
        this.d_texOrigin = origin;
        this.changedEvt(new Object[0]);
    }

    public void setOpenProps(OpenProps props) {
        this.d_openProps = props;
        this.changedEvt(new Object[0]);
    }

    public OpenProps getOpenProps() {
        return this.d_openProps;
    }

    @Override
    public int getNumFaces() {
        return 1;
    }

    @Override
    public Surface[] getSurfaces() {
        return new Surface[]{this.getSurface()};
    }

    @Override
    public void setSurfaces(Surface[] surfs) {
        assert (surfs.length == 1);
        this.setSurface(surfs[0]);
    }

    @Override
    public IObjectFilter<Surface> getSurfFilter() {
        return Vent.getSurfaceFilter();
    }

    public Surface getSurface() {
        return this.d_surf;
    }

    public void setSurface(Surface surf) {
        if (this.d_surf == surf) {
            return;
        }
        this.d_surf = surf;
        this.changedEvt(new Object[0]);
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return null;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        IPrimProps[] props;
        IGeom dgeom;
        VentGeom vgeom = this.getGeom();
        TexCoordGenerator texGen = new TexCoordGenerator(vgeom, this.d_texOrigin);
        Color color = this.getColors()[0];
        IPrimProps.Face faceProps = new IPrimProps.Face(color, this.getSurface(), false);
        if (vgeom.normal != null) {
            AABox bb = vgeom.getBoundingBox(new AABox());
            Point3d mid = Util3D.getMidPoint(bb.getMin(), bb.getMax());
            Point3d normalEndpoint = new Point3d(vgeom.normal);
            normalEndpoint.scale(Vent.getNormalDistFromCenter(bb));
            normalEndpoint.add(mid);
            LineSeg seg = new LineSeg(mid, normalEndpoint);
            dgeom = new GeomGroup(Arrays.asList(vgeom, seg));
            props = new IPrimProps[]{faceProps, new IPrimProps.Edge(Color.BLACK, 1.0)};
        } else {
            dgeom = vgeom;
            props = new IPrimProps[]{faceProps};
        }
        DisplayGeom dispGeom = new DisplayGeom(dgeom, (ITexCoordGenerator)texGen, props);
        if (this.getOptions(1)) {
            dispGeom = GeomUtil.convertToOutline(dispGeom);
        }
        return dispGeom;
    }

    public static double getNormalDistFromCenter(AABox bounds) {
        double xdiff = bounds.getWidth();
        double ydiff = bounds.getDepth();
        double zdiff = bounds.getHeight();
        double largest = Double.MIN_VALUE;
        if (xdiff > largest) {
            largest = xdiff;
        }
        if (ydiff > largest) {
            largest = ydiff;
        }
        if (zdiff > largest && zdiff > 0.0) {
            largest = zdiff;
        }
        return largest * 0.25;
    }

    @Override
    public VentGeom getGeom() {
        return new VentGeom(this);
    }

    @Override
    public void setGeom(IGeom geom, boolean optimizeGeom) {
        if ((geom = Geometry.finalize(geom, optimizeGeom)) instanceof VentGeom) {
            VentGeom vg = (VentGeom)geom;
            this.d_quad = new AARectangle(vg.d_plane, vg.d_planeVal, vg.d_minx, vg.d_miny, vg.d_maxx, vg.d_maxy);
            this.d_normal = vg.normal;
            this.d_fireSpread = vg.fireSpread;
            this.changedEvt(new Object[0]);
        } else if (geom instanceof AARectangle) {
            this.pauseUpdates();
            this.d_quad = (AARectangle)geom;
            this.clampFireSpread();
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    private void clampFireSpread() {
        if (this.d_fireSpread == null) {
            return;
        }
        Unit u = this.d_fireSpread.d_source.getUnit();
        Point3d o = this.d_fireSpread.d_source.getPoint3dValue(u);
        AABox bb = new AABox();
        this.getGeom().getBoundingBox(bb);
        Point3d min = bb.getMin();
        Point3d max = bb.getMax();
        if (o.x < min.x) {
            o.x = min.x;
        } else if (o.x > max.x) {
            o.x = max.x;
        }
        if (o.y < min.y) {
            o.y = min.y;
        } else if (o.y > max.y) {
            o.y = max.y;
        }
        if (o.z < min.z) {
            o.z = min.z;
        } else if (o.z > max.z) {
            o.z = max.z;
        }
        this.setFireSpread(new FireSpread(new UnitPoint3D(o, u), this.d_fireSpread.d_spreadRate));
    }

    public void setFireSpread(FireSpread spread) {
        this.d_fireSpread = spread;
        this.changedEvt(new Object[0]);
    }

    public FireSpread getFireSpread() {
        return this.d_fireSpread;
    }

    public static boolean isValidFireSpreadSurf(Surface surf) {
        if (surf.getSurfDesc() instanceof BurnerSurfDesc) {
            return true;
        }
        if (surf.getSurfDesc() instanceof LayeredSurfDesc) {
            LayeredSurfDesc desc = (LayeredSurfDesc)surf.getSurfDesc();
            return desc.d_iReac instanceof Fuel.ManualReac;
        }
        return false;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        deps.add(DLink.REQUIRED, (IPyroObject)this.d_surf);
        if (this.d_openProps != null) {
            deps.add(DLink.WEAK, this.d_openProps.species.keySet());
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old == this.d_surf) {
            Util.removeAllNotOfType(objs, Surface.class);
        } else if (old instanceof ExSpec) {
            Util.removeAllNotOfType(objs, ExSpec.class);
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
        if (old instanceof Surface) {
            return new AReplaceRefTask<Surface>((Object)old, (Object)replacement){

                @Override
                protected void set(Surface obj) {
                    Vent.this.setSurface(obj);
                }
            };
        }
        if (old instanceof ExSpec) {
            assert (this.d_openProps != null);
            return new AUndoableTask(){
                private OpenProps d_props;

                @Override
                public void run() {
                    this.d_props = Vent.this.d_openProps;
                    IdentityHashMap<ExSpec, UnitDouble> newSpecs = new IdentityHashMap<ExSpec, UnitDouble>(Vent.this.d_openProps.species);
                    if (replacement != null) {
                        UnitDouble oldMassFrac = Vent.this.d_openProps.species.get(old);
                        UnitDouble newMassFrac = Vent.this.d_openProps.species.get(replacement);
                        if (newMassFrac != null) {
                            oldMassFrac = newMassFrac.add(oldMassFrac);
                        }
                        newSpecs.put((ExSpec)replacement, oldMassFrac);
                    }
                    newSpecs.remove(old);
                    Vent.this.setOpenProps(new OpenProps(Vent.this.d_openProps.temp, Vent.this.d_openProps.pressure, newSpecs));
                }

                @Override
                public void undo() {
                    OpenProps props = this.d_props;
                    this.d_props = null;
                    Vent.this.setOpenProps(props);
                }
            };
        }
        return super.taskReplaceDep(old, replacement);
    }

    public static class VentGeom
    extends AARectangle {
        private static final long serialVersionUID = 2758477878491348619L;
        public final Vector3d normal;
        public final FireSpread fireSpread;

        public VentGeom(Vent vent) {
            this(vent.d_quad, vent.d_normal, vent.d_fireSpread);
        }

        public VentGeom(AARectangle rect, Vector3d normal, FireSpread spread) {
            super(rect.d_plane, rect.d_planeVal, rect.d_minx, rect.d_miny, rect.d_maxx, rect.d_maxy);
            this.normal = normal;
            this.fireSpread = spread;
        }

        public AARectangle optimize(HashPool<Point3d> pool) {
            return this;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }

        @Override
        public VentGeom transform(Matrix4d xform, IGeom.XformOp op) {
            AABox bounds = new AABox();
            super.getBoundingBox(bounds);
            Point3d newMin = Util3D.xform(xform, bounds.getMin());
            Point3d newMax = Util3D.xform(xform, bounds.getMax());
            Rectifier.rectify(newMin, newMax);
            AARectangle rect = AARectangle.construct(newMin, newMax);
            if (rect == null) {
                return this;
            }
            Vector3d newNormal = this.normal;
            if (this.normal != null) {
                newNormal = Util3D.xform(xform, this.normal);
                newNormal.normalize();
            }
            FireSpread newFireSpread = this.fireSpread;
            if (this.fireSpread != null) {
                UnitPoint3D newFSOrigin = Geometry.xform(xform, this.fireSpread.d_source);
                newFireSpread = new FireSpread(newFSOrigin, this.fireSpread.d_spreadRate);
            }
            return new VentGeom(rect, newNormal, newFireSpread);
        }

        @Override
        public Collection<? extends IHandle> generateManipHandles() {
            Collection<? extends IHandle> shandles = super.generateManipHandles();
            ArrayList<? extends IHandle> handles = new ArrayList<IHandle>(shandles);
            handles.add(new NormalHandle(this));
            return handles;
        }

        private static class NormalHandle
        implements IHandle {
            private VentGeom geom;

            public NormalHandle(VentGeom geom) {
                this.geom = geom;
            }

            public boolean equals(Object obj) {
                return obj instanceof NormalHandle;
            }

            @Override
            public IIsectFilter getPickFilter() {
                return null;
            }

            protected Point3d getMidPoint() {
                AABox bb = this.geom.getBoundingBox(new AABox());
                Point3d min = bb.getMin();
                Point3d max = bb.getMax();
                return Util3D.getMidPoint(min, max);
            }

            @Override
            public IGeom getGeom() {
                return new Point(this.getLocation());
            }

            protected Point3d getLocation() {
                Point3d mid = this.getMidPoint();
                Vector3d normalU = this.geom.normal;
                if (normalU != null) {
                    Vector3d normal = new Vector3d(normalU);
                    normal.scale(this.getNormalDistFromCenter());
                    mid.add(normal);
                }
                return mid;
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return new LineConstraint(handleLoc, this.geom.getNormal());
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            }

            @Override
            public VentGeom modify(Point3d newLoc) throws Exception {
                Vector3d normal = this.geom.getNormal();
                Point3d mid = this.getMidPoint();
                double dist = Util3D.tOnLine(mid, normal, newLoc);
                Vector3d newNormal = Math.abs(dist) < this.getNormalDistFromCenter() * 0.5 ? null : Util3D.scale(normal, Math.signum(dist));
                this.geom = new VentGeom(this.geom, newNormal, this.geom.fireSpread);
                return this.geom;
            }

            @Override
            public Object end() {
                return this.geom;
            }

            public double getNormalDistFromCenter() {
                return Vent.getNormalDistFromCenter(this.geom.getBoundingBox(new AABox()));
            }
        }
    }

    public static class OpenProps
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final OpenProps DEFAULT = new OpenProps(null, new TimeBasedValue<UnitDouble>(new UnitDouble(0.0, SIUS.unit(39)), TimeFunction.newDefault()), Collections.EMPTY_MAP);
        public final UnitDouble temp;
        public final Map<ExSpec, UnitDouble> species;
        public final TimeBasedValue<UnitDouble> pressure;

        public OpenProps(UnitDouble temp, TimeBasedValue<UnitDouble> pressure, Map<ExSpec, UnitDouble> species) {
            this.temp = temp;
            this.species = species;
            this.pressure = pressure;
        }
    }

    public static class OptionProp
    extends Composite.AObjectProp<Vent, Boolean> {
        private final int d_option;

        public OptionProp(int option) {
            super(Vent.class);
            this.d_option = option;
        }

        @Override
        public void set(Vent obj, Boolean prop) {
            obj.setOptions(this.d_option, prop);
        }

        @Override
        public Object get(Vent obj) {
            return obj.getOptions(this.d_option);
        }
    }
}

