/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.geom;

import java.awt.Color;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.geom.AFDSObject;
import pyrosim.legacy_2012_1.domain.geom.FDSUtil;
import pyrosim.legacy_2012_1.domain.geom.IHole;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.domain.rasterization.FaceProps;
import pyrosim.legacy_2012_1.domain.rasterization.HoleFragGenerator;
import pyrosim.legacy_2012_1.domain.rasterization.IFDSObjProps;
import pyrosim.legacy_2012_1.domain.rasterization.IFragGenerator;
import pyrosim.legacy_2012_1.domain.rasterization.RasterizationOptions;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.geom.IPyroDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.FlattenedProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.UniformProps;

public class Hole
extends AFDSObject
implements IHole {
    static final long serialVersionUID = 1L;
    public static final double ALPHA = 0.4;
    public static final Color DEF_COLOR = new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 102);
    private IGeom d_geom;

    public Hole(String name, IGeom geom) {
        super(name);
        this.d_geom = Geometry.finalize(geom, true);
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return new FragGen();
    }

    @Override
    public IGeom getGeom() {
        return this.d_geom;
    }

    @Override
    public void setGeom(IGeom geom, boolean optimizeGeom) {
        if ((geom = Geometry.finalize(geom, optimizeGeom)) == this.d_geom) {
            return;
        }
        this.d_geom = geom;
        this.changedEvt(new Object[0]);
    }

    private static IPrimProps toProps(Color c, boolean cull) {
        c = c == null ? DEF_COLOR : new Color(c.getRed(), c.getGreen(), c.getBlue(), 102);
        return new IPrimProps.Face(c, null, cull);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        IPropsSrc props;
        IPyroDisplayProps pyroProps = drawProps instanceof IPyroDisplayProps ? (IPyroDisplayProps)drawProps : null;
        DisplayGeom disp = FDSUtil.getRastDisplay(pyroProps, this, TexOrigin.DEF_WORLD);
        if (disp != null) {
            return disp;
        }
        Color[] c = this.getColors();
        boolean cullGeom = GeomUtil.isCullGeom(this.d_geom);
        if (c.length == 1) {
            props = new UniformProps(Hole.toProps(c[0], cullGeom));
        } else {
            IPrimProps[] fprops = new IPrimProps[c.length];
            for (int m = 0; m < c.length; ++m) {
                fprops[m] = Hole.toProps(c[m], cullGeom);
            }
            props = new FlattenedProps(fprops);
        }
        return new DisplayGeom(this.d_geom, props);
    }

    private class FragGen
    implements IFDSObjProps {
        private FaceProps d_faceProps;

        private FragGen() {
            this.d_faceProps = new FaceProps(Hole.this.getColors()[0]);
        }

        @Override
        public FaceProps getFace(int ix) {
            return this.d_faceProps;
        }

        @Override
        public IFragGenerator getFragGenerator(RasterizationOptions rastOptions) {
            return new HoleFragGenerator(Hole.this, rastOptions);
        }

        @Override
        public boolean thickenEnabled() {
            return true;
        }
    }
}

