/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.measurers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.domain.dependencies.Dependency;
import pyrosim.legacy_2012_1.domain.dependencies.SkipDep;
import pyrosim.legacy_2012_1.domain.devices.AlarmInfo;
import pyrosim.legacy_2012_1.domain.devices.TripFlags;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.domain.ramp.SignalInput;
import pyrosim.legacy_2012_1.domain.signals.IDoubleOutPin;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.ILatchable;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSource;
import pyrosim.legacy_2012_1.domain.signals.LogicOutPin;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class MeasureOutInfo
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    @SkipDep
    private ILatchable d_src;
    private boolean d_enabled;
    private IDoubleOutPin d_pin;
    private LogicOutPin d_alarmPin;
    private AlarmInfo d_alarmInfo;

    public MeasureOutInfo(ILatchable src, boolean enabled, IDoubleOutPin msrPin, String logicPinName) {
        this.d_src = src;
        this.d_enabled = enabled;
        this.d_pin = msrPin;
        this.d_alarmPin = new LogicOutPin(this.d_src, logicPinName);
    }

    public void setAlarmInfo(AlarmInfo ai) {
        if (AlarmInfo.checkAlarmChange(this.d_src, this.d_alarmInfo, ai, this.d_alarmPin)) {
            this.d_alarmInfo = ai;
            this.d_src.changedEvt(new Object[0]);
        }
    }

    public boolean latches() {
        return this.d_alarmInfo != null ? TripFlags.latch(this.d_alarmInfo.tripFlags) : false;
    }

    public AlarmInfo getAlarmInfo() {
        return this.d_alarmInfo;
    }

    public IDoubleOutPin getPin() {
        return this.d_pin;
    }

    public LogicOutPin getAlarmPin() {
        return this.d_alarmPin;
    }

    public void legacySetPin(IDoubleOutPin pin) {
        this.d_pin = pin;
        this.d_pin.setSource(this.d_src);
    }

    public void legacySetSource(ILatchable src) {
        this.d_src = src;
        this.d_pin.setSource(src);
        this.d_alarmPin.setSource(src);
    }

    public Object clone(ISignalSource srcClone) {
        try {
            MeasureOutInfo pi = (MeasureOutInfo)super.clone();
            pi.d_pin = (IDoubleOutPin)this.d_pin.clone(srcClone);
            pi.d_alarmPin = (LogicOutPin)this.d_alarmPin.clone(srcClone);
            assert (srcClone instanceof ILatchable);
            pi.d_src = (ILatchable)srcClone;
            return pi;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof MeasureOutInfo && ((MeasureOutInfo)obj).d_enabled == this.d_enabled && theUtil.equal(((MeasureOutInfo)obj).d_alarmInfo, this.d_alarmInfo);
    }

    public List<IOutPin> getPins() {
        ArrayList<IOutPin> pins = new ArrayList<IOutPin>(2);
        this.getPins(pins);
        return pins;
    }

    public void getPins(List<IOutPin> pins) {
        if (this.d_enabled) {
            pins.add(this.d_pin);
            if (this.d_alarmInfo != null) {
                pins.add(this.d_alarmPin);
            }
        }
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.d_enabled) {
            return;
        }
        this.d_enabled = enabled;
        PyroMod domain = (PyroMod)this.d_src.getDomain();
        if (domain != null) {
            domain.pauseUpdates();
        }
        if (!this.d_enabled && domain != null) {
            DepSnapshot dss = domain.getDependencies(this.d_src);
            Set<Dependency> deps = dss.getDependents(this.d_src);
            for (Dependency dep : deps) {
                if (dep.source instanceof IInPin) {
                    IInPin inPin = (IInPin)dep.source;
                    inPin.disconnect(this.d_pin);
                    inPin.disconnect(this.d_alarmPin);
                    continue;
                }
                if (!(dep.source instanceof Ramp)) continue;
                Ramp r = (Ramp)dep.source;
                if (((SignalInput)r.getInput()).input != this.d_pin) continue;
                r.taskSetInput(r.getDefaultInput()).run();
                for (IPyroObject pobj : dss.getAncestors(IPyroObject.class, this.d_src)) {
                    pobj.changedEvt(new Object[0]);
                }
            }
        }
        this.d_src.changedEvt(new Object[0]);
        if (domain != null) {
            domain.resumeUpdates();
        }
    }
}

