/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.geom.IGeomSource;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IProxyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.PropsBuilder;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class GeomUtil {
    public static AABox getBounds(IGeom geomObj) {
        AABox bounds = new AABox();
        geomObj.getBoundingBox(bounds);
        return bounds;
    }

    public static AABox getBounds(IGeomSource geomObj) {
        return geomObj.getBounds();
    }

    public static AABox getBounds(Collection<? extends IGeomSource> geomObjs) {
        AABox bounds = new AABox();
        for (IGeomSource iGeomSource : geomObjs) {
            bounds.add(iGeomSource.getBounds());
        }
        return bounds;
    }

    public static UnitAABox getUnitBounds(IGeomSource geomObj) {
        return new UnitAABox(GeomUtil.getBounds(geomObj), Geometry.LU);
    }

    public static UnitAABox getUnitBounds(IGeom geomObj) {
        return new UnitAABox(GeomUtil.getBounds(geomObj), Geometry.LU);
    }

    public static boolean isUniform(Surface[] surfs) {
        if (surfs.length == 0) {
            return false;
        }
        Surface base = surfs[0];
        for (int m = 1; m < surfs.length; ++m) {
            if (surfs[m] == base) continue;
            return false;
        }
        return true;
    }

    public static boolean isUniform(Color[] colors) {
        if (colors.length == 0) {
            return false;
        }
        Color base = colors[0];
        for (int m = 1; m < colors.length; ++m) {
            if (theUtil.equal(base, colors[m])) continue;
            return false;
        }
        return true;
    }

    public static DisplayGeom convertToOutline(DisplayGeom dispGeom) {
        List<Pair<ICurve, Integer>> outlines = pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil.getFaceOutlines(dispGeom.geom);
        ArrayList<IGeom> resultGeom = new ArrayList<IGeom>(outlines.size());
        PropsBuilder resultProps = new PropsBuilder();
        for (int m = 0; m < outlines.size(); ++m) {
            Pair<ICurve, Integer> pair = outlines.get(m);
            IPrimProps props = dispGeom.props.get((Integer)pair.v2);
            resultGeom.add((IGeom)pair.v1);
            resultProps.add(props, false);
        }
        IPropsSrc props = resultProps.finalizeProps();
        GeomGroup group = new GeomGroup(resultGeom);
        return new DisplayGeom((IGeom)group, dispGeom.texuv, props);
    }

    public static boolean isCullGeom(IGeom geom) {
        if (geom instanceof AABoxGeom) {
            return true;
        }
        if (geom instanceof IProxyGeom) {
            return GeomUtil.isCullGeom(((IProxyGeom)geom).getBase());
        }
        if (geom instanceof GeomGroup) {
            for (IGeom child : ((GeomGroup)geom).children) {
                if (GeomUtil.isCullGeom(child)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<IPolygon> toPolys(IFace face, double errorTol, boolean triangulateIfHoles) {
        ArrayList<IPolygon> polys = new ArrayList<IPolygon>();
        GeomUtil.toPolys(face, errorTol, triangulateIfHoles, polys);
        return polys;
    }

    public static void toPolys(IFace face, double errorTol, boolean triangulateIfHoles, List<IPolygon> polys) {
        if (face instanceof IPolygon) {
            IPolygon poly = (IPolygon)face;
            if (!triangulateIfHoles || poly.getNumLoops() <= 1) {
                polys.add(poly);
                return;
            }
        }
        polys.addAll(pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil.getTriangles(errorTol, face));
    }
}

