/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class ExSpecList
extends Composite<ExSpec> {
    static final long serialVersionUID = 1L;
    public static final ExSpec[] MIXFRAC_EXSPECS;
    public static final Map<String, ExSpec> PREDEFINED;

    public ExSpecList() {
        this(Intl.intl("Extra Species"));
    }

    public ExSpecList(String name) {
        super(name, ExSpec.class);
    }

    public List<String> getPredefinedSpeciesNamesFree() {
        ArrayList<String> names = new ArrayList<String>(PREDEFINED.keySet());
        for (ExSpec es : this.flatten()) {
            String name = es.getName();
            if (!names.contains(name)) continue;
            names.remove(name);
        }
        Collections.sort(names);
        return names;
    }

    public static boolean isPredefinedSpecies(String id) {
        return PREDEFINED.containsKey(id);
    }

    public static ExSpec getPredefinedSpecies(String id) {
        assert (ExSpecList.isPredefinedSpecies(id));
        return PREDEFINED.get(id);
    }

    @Override
    public boolean add(IPyroObject obj) {
        if (obj instanceof ExSpec && ((ExSpec)obj).isMixFracOnly()) {
            return false;
        }
        return super.add(obj);
    }

    @Override
    public boolean remove(IPyroObject obj) {
        if (obj instanceof ExSpec && ((ExSpec)obj).isMixFracOnly()) {
            return false;
        }
        return super.remove(obj);
    }

    static {
        PREDEFINED = new LinkedHashMap<String, ExSpec>();
        for (Predefined predef : Predefined.values()) {
            PREDEFINED.put(predef.spec.getName(), predef.spec);
        }
        MixFrac[] mfs = MixFrac.values();
        MIXFRAC_EXSPECS = new ExSpec[mfs.length];
        for (int m = 0; m < mfs.length; ++m) {
            ExSpecList.MIXFRAC_EXSPECS[m] = mfs[m].spec;
        }
    }

    public static enum Predefined {
        AIR("AIR", 29.0, 3.711, 78.6),
        ARGON("ARGON", 40.0, 3.42, 124.0),
        CARBON_DIOXIDE("CARBON DIOXIDE", 44.0, 3.941, 195.2),
        CARBON_MONOXIDE("CARBON MONOXIDE", 28.0, 3.69, 91.7),
        ETHANOL("ETHANOL", 46.0, 4.53, 362.6),
        ETHYLENE("ETHYLENE", 28.0, 4.163, 224.7),
        HELIUM("HELIUM", 4.0, 2.551, 10.22),
        HYDROGEN("HYDROGEN", 2.0, 2.827, 59.7),
        HYDROGEN_BROMIDE("HYDROGEN BROMIDE", 81.0, 3.353, 449.0),
        HYDROGEN_CHLORIDE("HYDROGEN CHLORIDE", 36.0, 3.339, 344.7),
        HYDROGEN_CYANIDE("HYDROGEN CYANIDE", 26.0, 3.63, 569.1),
        HYDROGEN_FLOURIDE("HYDROGEN FLOURIDE", 20.0, 3.148, 330.0),
        METHANE("METHANE", 16.0, 3.758, 148.6),
        METHANOL("METHANOL", 32.0, 3.626, 481.8),
        N_HEXANE("N-HEXANE", 86.0, 4.524, 199.41),
        N_HEPTANE("N-HEPTANE", 100.0, 4.701, 205.75),
        N_OCTANE("N-OCTANE", 114.0, 4.892, 231.16),
        N_DECANE("N-DECANE", 142.0, 5.233, 226.46),
        NITROGEN("NITROGEN", 28.0, 3.798, 71.4),
        OXYGEN("OXYGEN", 32.0, 3.467, 106.7),
        PROPANE("PROPANE", 44.0, 5.118, 237.1),
        TOLUENE("TOLUENE", 92.0, 5.698, 480.0),
        WATER_VAPOR("WATER VAPOR", 18.0, 2.641, 809.1);

        public final ExSpec spec;

        private Predefined(String id, double molWt, double sigma, double ek) {
            this.spec = new ExSpec(id, true);
            this.spec.setMolWt(new UnitDouble(molWt, SI.GRAM.divide(SI.MOLE)));
            this.spec.setDNSLJ(new UnitDouble(sigma, NonSI.ANGSTROM), new UnitDouble(ek, SI.KELVIN));
        }

        public String getName() {
            return this.spec.getName();
        }
    }

    public static enum MixFrac {
        FUEL(1, "fuel"),
        OXYGEN(2, "oxygen"),
        NITROGEN(3, "nitrogen"),
        WATER_VAPOR(4, "water vapor"),
        CARBON_DIOXIDE(5, "carbon dioxide"),
        CARBON_MONOXIDE(6, "carbon monoxide"),
        HYDROGEN(7, "hydrogen"),
        SOOT(8, "soot"),
        OTHER(9, "other");

        public final ExSpec spec;
        public final String name;

        private MixFrac(int id, String name) {
            this.spec = new ExSpec(id);
            this.name = name;
        }
    }
}

