/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import pyrosim.legacy_2006_2.thunderheadeng.util.IWarning;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public class WarningReport<T extends IWarning> {
    public static final int SORT_NONE = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;
    private Collection<T> d_allWarnings = new ArrayList<T>();
    private final Class<T> d_warningType;
    private Collection<T> d_sortedWarnings;
    private final int[] d_warningInfoTypes;
    private final String[] d_warningInfoDescs;
    private int d_sortType;
    private int d_sortOrder = 0;

    public WarningReport(Class<T> warningType, int[] warningInfoTypes, String[] warningInfoDescs, int defaultInfoSort) {
        assert (warningInfoTypes.length == warningInfoDescs.length);
        this.d_warningType = warningType;
        this.d_warningInfoTypes = warningInfoTypes;
        this.d_warningInfoDescs = warningInfoDescs;
        this.d_sortType = defaultInfoSort;
    }

    public Class<T> getType() {
        return this.d_warningType;
    }

    public void addWarning(T warning) {
        this.d_allWarnings.add(warning);
        this.d_sortedWarnings = null;
    }

    public void removeWarning(T warning) {
        this.d_allWarnings.add(warning);
        this.d_sortedWarnings = null;
    }

    public int[] getInfoTypes() {
        return this.d_warningInfoTypes;
    }

    public String[] getInfoDescriptions() {
        return this.d_warningInfoDescs;
    }

    public Collection<T> getWarnings() {
        if (this.d_sortOrder == 0) {
            return this.d_allWarnings;
        }
        this.sortWarnings(this.d_sortOrder);
        return this.d_sortedWarnings;
    }

    public boolean isEmpty() {
        return this.d_allWarnings.isEmpty();
    }

    public void setSortInfoType(int sortType, boolean resort) {
        this.d_sortType = sortType;
        this.d_sortedWarnings = null;
        if (resort) {
            this.sortWarnings(this.d_sortOrder);
        }
    }

    public void sortWarnings(int sortType) {
        this.sortWarnings(this.d_sortType, sortType);
    }

    public void sortWarnings(int sortType, int sortOrder) {
        if (sortType != this.d_sortType || sortOrder != this.d_sortOrder) {
            this.d_sortedWarnings = null;
            this.d_sortType = sortType;
            this.d_sortOrder = sortOrder;
        }
        if (this.d_sortedWarnings != null || this.d_sortOrder == 0) {
            return;
        }
        IWarning[] arr = (IWarning[])Array.newInstance(this.d_warningType, this.d_allWarnings.size());
        this.d_allWarnings.toArray(arr);
        final int mult = this.d_sortOrder == 1 ? 1 : -1;
        Comparator comp = new Comparator<T>(){

            @Override
            public int compare(T arg0, T arg1) {
                Comparable c0 = arg0.getWarningInfo(WarningReport.this.d_sortType);
                Comparable c1 = arg1.getWarningInfo(WarningReport.this.d_sortType);
                if (c0 instanceof String) {
                    return ((String)((Object)c0)).compareToIgnoreCase((String)((Object)c1)) * mult;
                }
                return c0.compareTo(c1) * mult;
            }
        };
        Arrays.sort(arr, comp);
        this.d_sortedWarnings = new VectorFromArray<IWarning>(arr);
    }

    public String prepareReport() {
        Collection<T> warnings = this.getWarnings();
        int[] maxWarningInfoLengths = new int[this.d_warningInfoTypes.length];
        for (int m = 0; m < this.d_warningInfoTypes.length; ++m) {
            if (this.d_warningInfoDescs[m].length() <= maxWarningInfoLengths[m]) continue;
            maxWarningInfoLengths[m] = this.d_warningInfoDescs[m].length();
        }
        for (IWarning warning : warnings) {
            for (int m = 0; m < this.d_warningInfoTypes.length; ++m) {
                int warningInfoLength = warning.getWarningInfo(this.d_warningInfoTypes[m]).toString().length();
                if (warningInfoLength <= maxWarningInfoLengths[m]) continue;
                maxWarningInfoLengths[m] = warningInfoLength;
            }
        }
        int numCharsPerLine = 0;
        for (int m = 0; m < maxWarningInfoLengths.length; ++m) {
            int n = m;
            maxWarningInfoLengths[n] = maxWarningInfoLengths[n] + 3;
            numCharsPerLine += maxWarningInfoLengths[m];
        }
        ++numCharsPerLine;
        int numLines = warnings.size() + 2;
        Object report = new String(new StringBuffer((numCharsPerLine += maxWarningInfoLengths.length + 1) * numLines));
        String nl = System.getProperty("line.separator");
        for (int m = 0; m < this.d_warningInfoTypes.length; ++m) {
            report = (String)report + "|";
            report = (String)report + this.d_warningInfoDescs[m];
            report = (String)report + WarningReport.padding(maxWarningInfoLengths[m] - this.d_warningInfoDescs[m].length(), ' ');
        }
        report = (String)report + "|" + nl;
        report = (String)report + WarningReport.padding(numCharsPerLine - 1, '=');
        report = (String)report + nl;
        for (IWarning warning : warnings) {
            for (int m = 0; m < this.d_warningInfoTypes.length; ++m) {
                report = (String)report + "|";
                String warningInfo = warning.getWarningInfo(this.d_warningInfoTypes[m]).toString();
                report = (String)report + warningInfo;
                report = (String)report + WarningReport.padding(maxWarningInfoLengths[m] - warningInfo.length(), ' ');
            }
            report = (String)report + "|" + nl;
        }
        return report;
    }

    private static String padding(int numPads, char pad) {
        char[] padding = new char[numPads];
        Arrays.fill(padding, pad);
        return new String(padding);
    }

    public void writeReport(String filename) throws IOException {
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        writer.print(this.prepareReport());
        writer.close();
    }
}

