/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v17;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import pyrosim.legacy_2006_2.legacy.v17.Quad;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class Prism
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private Point3D[] d_points;
    private Color[] d_colors;

    private Prism() {
        this.d_points = new Point3D[8];
    }

    public Prism(double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        this.d_points = new Point3D[8];
        this.d_points[0] = new Point3D(minX, minY, minZ);
        this.d_points[1] = new Point3D(maxX, minY, minZ);
        this.d_points[2] = new Point3D(maxX, maxY, minZ);
        this.d_points[3] = new Point3D(minX, maxY, minZ);
        this.d_points[4] = new Point3D(minX, minY, maxZ);
        this.d_points[5] = new Point3D(maxX, minY, maxZ);
        this.d_points[6] = new Point3D(maxX, maxY, maxZ);
        this.d_points[7] = new Point3D(minX, maxY, maxZ);
    }

    public Prism(Point3D min, Point3D max) {
        this(min.x, max.x, min.y, max.y, min.z, max.z);
    }

    public Prism(Point3D[] points) {
        if (points.length != 8) {
            throw new IllegalArgumentException("Array must have 8 points.");
        }
        this.d_points = points;
    }

    public Object clone() {
        Prism clone = new Prism();
        for (int i = 0; i < 8; ++i) {
            clone.d_points[i] = new Point3D(this.d_points[i].x, this.d_points[i].y, this.d_points[i].z);
        }
        if (this.d_colors != null) {
            clone.d_colors = new Color[this.d_colors.length];
            System.arraycopy(this.d_colors, 0, clone.d_colors, 0, this.d_colors.length);
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Prism)) {
            return false;
        }
        return Arrays.equals(this.d_points, ((Prism)obj).d_points) && Arrays.equals(this.d_colors, ((Prism)obj).d_colors);
    }

    public void translate(double dx, double dy, double dz) {
        for (int i = 0; i < this.d_points.length; ++i) {
            this.d_points[i].x += dx;
            this.d_points[i].y += dy;
            this.d_points[i].z += dz;
        }
    }

    public void mirror(int plane, UnitDouble value) {
    }

    public Point3D getPoint(int index) {
        return this.d_points[index];
    }

    public Color getColor(int faceIndex) {
        return this.d_colors[faceIndex];
    }

    public void setColor(Color color) {
        this.setColors(new Color[]{color, color, color, color, color, color});
    }

    public void setColors(Color[] colors) {
        if (colors.length != 6) {
            throw new IllegalArgumentException();
        }
        this.d_colors = colors;
    }

    public Quad getFace(int faceIndex) {
        Quad q = null;
        switch (faceIndex) {
            case 0: {
                q = new Quad(this.getPoint(3), this.getPoint(0), this.getPoint(4), this.getPoint(7));
                break;
            }
            case 1: {
                q = new Quad(this.getPoint(1), this.getPoint(2), this.getPoint(6), this.getPoint(5));
                break;
            }
            case 2: {
                q = new Quad(this.getPoint(0), this.getPoint(1), this.getPoint(5), this.getPoint(4));
                break;
            }
            case 3: {
                q = new Quad(this.getPoint(2), this.getPoint(3), this.getPoint(7), this.getPoint(6));
                break;
            }
            case 4: {
                q = new Quad(this.getPoint(3), this.getPoint(2), this.getPoint(1), this.getPoint(0));
                break;
            }
            case 5: {
                q = new Quad(this.getPoint(4), this.getPoint(5), this.getPoint(6), this.getPoint(7));
                break;
            }
            default: {
                return null;
            }
        }
        if (this.d_colors != null) {
            q.setColor(this.d_colors[faceIndex]);
        }
        return q;
    }

    public static Quad getFaceForBox(Point3D min, Point3D max, int faceIndex) {
        Quad q = null;
        switch (faceIndex) {
            case 0: {
                q = new Quad(new Point3D(min.x, max.y, min.z), new Point3D(min.x, min.y, min.z), new Point3D(min.x, min.y, max.z), new Point3D(min.x, max.y, max.z));
                break;
            }
            case 1: {
                q = new Quad(new Point3D(max.x, min.y, min.z), new Point3D(max.x, max.y, min.z), new Point3D(max.x, max.y, max.z), new Point3D(max.x, min.y, max.z));
                break;
            }
            case 2: {
                q = new Quad(new Point3D(min.x, min.y, min.z), new Point3D(max.x, min.y, min.z), new Point3D(max.x, min.y, max.z), new Point3D(min.x, min.y, max.z));
                break;
            }
            case 3: {
                q = new Quad(new Point3D(max.x, max.y, min.z), new Point3D(min.x, max.y, min.z), new Point3D(min.x, max.y, max.z), new Point3D(max.x, max.y, max.z));
                break;
            }
            case 4: {
                q = new Quad(new Point3D(min.x, max.y, min.z), new Point3D(max.x, max.y, min.z), new Point3D(max.x, min.y, min.z), new Point3D(min.x, min.y, min.z));
                break;
            }
            case 5: {
                q = new Quad(new Point3D(min.x, min.y, max.z), new Point3D(max.x, min.y, max.z), new Point3D(max.x, max.y, max.z), new Point3D(min.x, max.y, max.z));
                break;
            }
            default: {
                return null;
            }
        }
        return q;
    }
}

