/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v17;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.IFileImage;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class MVBackgroundImage
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private double d_anchorImageX;
    private double d_anchorImageY;
    private UnitPoint2D d_anchorModel;
    private double d_aX;
    private double d_aY;
    private double d_bX;
    private double d_bY;
    private UnitDouble d_distAB;
    private float d_opacity = 1.0f;
    private String d_filename = null;
    @Deprecated
    private IFileImage d_image;

    public MVBackgroundImage(String filename, Point2D anchorImage, UnitPoint2D anchorModel, Point2D aImage, Point2D bImage, UnitDouble distABModel, float opacity) {
        this.d_anchorImageX = anchorImage.getX();
        this.d_anchorImageY = anchorImage.getY();
        this.d_anchorModel = anchorModel;
        this.d_aX = aImage.getX();
        this.d_aY = aImage.getY();
        this.d_bX = bImage.getX();
        this.d_bY = bImage.getY();
        this.d_distAB = distABModel;
        this.d_opacity = opacity;
        this.d_filename = filename;
    }

    public String toString() {
        Point2D.Double anchor = this.d_anchorModel.getValue(Geometry.GEOM_LENGTH_UNIT);
        double distAB = this.d_distAB.getValue(Geometry.GEOM_LENGTH_UNIT);
        return this.d_filename + ";" + this.d_anchorImageX + "," + this.d_anchorImageY + ";" + anchor.getX() + "," + anchor.getY() + ";" + this.d_aX + "," + this.d_bY + ";" + this.d_bX + "," + this.d_bY + ";" + distAB + ";" + this.d_opacity;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.d_image != null) {
            this.d_filename = this.d_image.getFilename();
            this.d_image = null;
        }
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof MVBackgroundImage)) {
            return 1;
        }
        return ((MVBackgroundImage)obj).getID().compareTo(this.getID());
    }

    public Object clone() {
        try {
            MVBackgroundImage clone = (MVBackgroundImage)super.clone();
            clone.d_filename = this.d_filename;
            clone.d_anchorImageX = this.d_anchorImageX;
            clone.d_anchorImageY = this.d_anchorImageY;
            clone.d_anchorModel = (UnitPoint2D)this.d_anchorModel.clone();
            clone.d_aX = this.d_aX;
            clone.d_aY = this.d_aY;
            clone.d_bX = this.d_bX;
            clone.d_bY = this.d_bY;
            clone.d_distAB = (UnitDouble)this.d_distAB.clone();
            clone.d_opacity = this.d_opacity;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof MVBackgroundImage)) {
            return false;
        }
        MVBackgroundImage i = (MVBackgroundImage)o;
        boolean equal = i.d_filename.equals(this.d_filename) && (i.d_anchorModel != null ? i.d_anchorModel.equals(this.d_anchorModel) : this.d_anchorModel == null) && (i.d_distAB != null ? i.d_distAB.equals(this.d_distAB) : this.d_distAB == null) && i.d_anchorImageX == this.d_anchorImageX && i.d_anchorImageY == this.d_anchorImageY && i.d_aX == this.d_aX && i.d_aY == this.d_aY && i.d_bX == this.d_bX && i.d_bY == this.d_bY && i.d_opacity == this.d_opacity;
        return equal;
    }

    public AffineTransform getTransform() {
        Unit u = Geometry.GEOM_LENGTH_UNIT;
        AffineTransform imgTransform = new AffineTransform();
        imgTransform.translate(this.d_anchorModel.x.getValue(u), this.d_anchorModel.y.getValue(u));
        double scale = 1.0 / this.getBackgroundImageScale().getValue(u);
        imgTransform.scale(scale, scale);
        imgTransform.translate(-this.d_anchorImageX, -this.d_anchorImageY);
        return imgTransform;
    }

    public UnitDouble getBackgroundImageScale() {
        double xdiff = this.d_bX - this.d_aX;
        double ydiff = this.d_bY - this.d_aY;
        double pixelDist = Math.sqrt(xdiff * xdiff + ydiff * ydiff);
        Unit u = Geometry.GEOM_LENGTH_UNIT;
        return new UnitDouble(pixelDist / this.d_distAB.getValue(u), u);
    }

    public String getID() {
        return this.d_filename;
    }

    public UnitPoint2D getAnchorModel() {
        return this.d_anchorModel;
    }

    public void setAnchorModel(UnitPoint2D bgImageModelPt) {
        this.d_anchorModel = bgImageModelPt;
    }

    public Point2D getAnchorImage() {
        return new Point2D.Double(this.d_anchorImageX, this.d_anchorImageY);
    }

    public void setAnchorImage(Point2D anchorImage) {
        this.d_anchorImageX = anchorImage.getX();
        this.d_anchorImageY = anchorImage.getY();
    }

    public UnitDouble getDistAB() {
        return this.d_distAB;
    }

    public void setDistAB(UnitDouble distAB) {
        this.d_distAB = distAB;
    }

    public Point2D getA() {
        return new Point2D.Double(this.d_aX, this.d_aY);
    }

    public void setA(Point2D ptA) {
        this.d_aX = ptA.getX();
        this.d_aY = ptA.getY();
    }

    public Point2D getB() {
        return new Point2D.Double(this.d_bX, this.d_bY);
    }

    public void setB(Point2D ptB) {
        this.d_bX = ptB.getX();
        this.d_bY = ptB.getY();
    }

    public float getOpacity() {
        return this.d_opacity;
    }

    public void setOpacity(float opacity) {
        this.d_opacity = opacity;
    }
}

