/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.HashSet;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.domain.RadiRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class RadiProcessor
extends AFDSRecordProcessor {
    private static final Set FIELDS = new HashSet(15);

    public RadiProcessor(FDSParsingInfo nfo) {
        super(nfo);
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        if (!rec.getType().equalsIgnoreCase("RADI")) {
            return false;
        }
        boolean err = false;
        try {
            RadiRecord radi = this.getContainer().getRadiManager().get((RadiRecord)null);
            this.readInt(radi, rec, "ANGLE_INCREMENT");
            this.readInt(radi, rec, "NMIEANG");
            this.readInt(radi, rec, "NUMBER_RADIATION_ANGLES");
            this.readInt(radi, rec, "TIME_STEP_INCREMENT");
            this.readBool(radi, rec, "CH4_BANDS");
            this.readBool(radi, rec, "WIDE_BAND_MODEL");
            FdsSISystem uSys = FdsSISystem.getInstance();
            this.readNumber(radi, rec, "KAPPA0", uSys.getKappa0Unit());
            this.readNumber(radi, rec, "PATH", uSys.getLengthUnit());
            this.readNumber(radi, rec, "RADTMP", uSys.getTempUnit());
            this.flagPyroTypeAffected(RadiRecord.class);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            err = true;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            err = true;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            err = true;
        }
        return !err;
    }

    private RadiRecord readInt(RadiRecord radi, FDSInputRecord rec, String key) {
        Object oAngInc = rec.getValue(key);
        if (oAngInc != null) {
            radi.set(key, (int)Double.parseDouble(oAngInc.toString()));
        }
        return radi;
    }

    private RadiRecord readBool(RadiRecord radi, FDSInputRecord rec, String key) {
        Object oAngInc = rec.getValue(key);
        if (oAngInc != null) {
            radi.set(key, Boolean.parseBoolean(oAngInc.toString()));
        }
        return radi;
    }

    private RadiRecord readNumber(RadiRecord radi, FDSInputRecord rec, String key, Unit u) {
        Object oAngInc = rec.getValue(key);
        if (oAngInc != null) {
            double val = Double.parseDouble(oAngInc.toString());
            radi.set(key, new UnitDouble(val, u));
        }
        return radi;
    }

    @Override
    public void done() throws FDSRecordFormatException {
    }

    @Override
    public String getFDSTypeParsed() {
        return "RADI";
    }

    static {
        FIELDS.add("ANGLE_INCREMENT");
        FIELDS.add("CH4_BANDS");
        FIELDS.add("KAPPA0");
        FIELDS.add("NMIEANG");
        FIELDS.add("NUMBER_RADIATION_ANGLES");
        FIELDS.add("PATH");
        FIELDS.add("RADTMP");
        FIELDS.add("TIME_STEP_INCREMENT");
        FIELDS.add("WIDE_BAND_MODEL");
    }
}

