/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AbstractFDSObject;
import pyrosim.legacy_2006_2.domain.ActivationEventList;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.Line;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Prism;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.ATask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class Vent
extends AbstractFDSObject
implements IFace {
    static final long serialVersionUID = 1L;
    public static final int NORMAL_AUTO = 0;
    public static final int NORMAL_XPOS = 1;
    public static final int NORMAL_XNEG = -1;
    public static final int NORMAL_YPOS = 2;
    public static final int NORMAL_YNEG = -2;
    public static final int NORMAL_ZPOS = 3;
    public static final int NORMAL_ZNEG = -3;
    private Quad d_quad;
    private Material d_material;
    private transient boolean d_selected;
    private UnitPoint3D d_normal = null;
    public static final int NUM_FACES = 1;

    public Vent(Material mat) {
        this(new UnitPoint3D(0.0, 0.0, 0.0, Geometry.GEOM_LENGTH_UNIT), new UnitPoint3D(0.0, 0.0, 0.0, Geometry.GEOM_LENGTH_UNIT), null, mat);
    }

    public Vent(String name, Material mat) {
        this(new UnitPoint3D(0.0, 0.0, 0.0, Geometry.GEOM_LENGTH_UNIT), new UnitPoint3D(0.0, 0.0, 0.0, Geometry.GEOM_LENGTH_UNIT), name, mat);
    }

    public Vent(UnitPoint3D minPoint, UnitPoint3D maxPoint, String name, Material mat) {
        super(name);
        assert (minPoint.xu().compareTo(maxPoint.xu()) <= 0 && minPoint.yu().compareTo(maxPoint.yu()) <= 0 && minPoint.zu().compareTo(maxPoint.zu()) <= 0);
        Unit u = Geometry.GEOM_LENGTH_UNIT;
        if (minPoint.xu().equals(maxPoint.xu())) {
            this.d_quad = Prism.getFaceForBox(minPoint.getValue(u), maxPoint.getValue(u), 0, null);
        } else if (minPoint.yu().equals(maxPoint.yu())) {
            this.d_quad = Prism.getFaceForBox(minPoint.getValue(u), maxPoint.getValue(u), 2, null);
        } else if (minPoint.zu().equals(maxPoint.zu())) {
            this.d_quad = Prism.getFaceForBox(minPoint.getValue(u), maxPoint.getValue(u), 4, null);
        } else {
            throw new IllegalArgumentException("Vent must be flat (i.e minX=maxX or minY=maxY or minZ=maxZ");
        }
        this.d_material = mat;
        this.d_faces = new Vector(1);
        this.d_faces.add(this);
    }

    public Vent(Quad quad, String name, Material mat) {
        super(name);
        this.d_quad = quad;
        this.d_material = mat;
        this.d_faces = new Vector(1);
        this.d_faces.add(this);
    }

    public void setActualGeometry(UnitPoint3D minPoint, UnitPoint3D maxPoint) {
        int faceIndex;
        Unit u = Geometry.GEOM_LENGTH_UNIT;
        double xMin = minPoint.x(u);
        double xMax = maxPoint.x(u);
        double yMin = minPoint.y(u);
        double yMax = maxPoint.y(u);
        double zMin = minPoint.z(u);
        double zMax = maxPoint.z(u);
        assert (xMin <= xMax && yMin <= yMax && zMin <= zMax) : "Vent mins and maxes must be correctly specified";
        double xDiff = xMax - xMin;
        double yDiff = yMax - yMin;
        double zDiff = zMax - zMin;
        assert (xDiff >= 0.0 && yDiff >= 0.0 && zDiff >= 0.0);
        double smallestDiff = xDiff;
        if (yDiff < smallestDiff) {
            smallestDiff = yDiff;
        }
        if (zDiff < smallestDiff) {
            smallestDiff = zDiff;
        }
        if (smallestDiff == xDiff) {
            xMin = xMax = (xMax + xMin) * 0.5;
            faceIndex = 0;
        } else if (smallestDiff == yDiff) {
            yMin = yMax = (yMax + yMin) * 0.5;
            faceIndex = 2;
        } else {
            zMin = zMax = (zMax + zMin) * 0.5;
            faceIndex = 4;
        }
        this.d_quad = Prism.getFaceForBox(new Point3D(xMin, yMin, zMin), new Point3D(xMax, yMax, zMax), faceIndex, null);
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public void setNormal(UnitPoint3D normal) {
        this.d_normal = normal;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public UnitPoint3D getNormal() {
        return this.d_normal;
    }

    protected int[] getPossibleNormalValues() {
        UnitPoint3D min = this.getMinPoint();
        UnitPoint3D max = this.getMaxPoint();
        int[] possibleValues = new int[3];
        possibleValues[0] = 0;
        if (min.xu().equals(max.xu())) {
            possibleValues[1] = -1;
            possibleValues[2] = 1;
        } else if (min.yu().equals(max.yu())) {
            possibleValues[1] = -2;
            possibleValues[2] = 2;
        } else {
            possibleValues[1] = -3;
            possibleValues[2] = 3;
        }
        return possibleValues;
    }

    public boolean isFDSNormalValid(int normal) {
        int[] possible = this.getPossibleNormalValues();
        for (int m = 0; m < possible.length; ++m) {
            if (possible[m] != normal) continue;
            return true;
        }
        return false;
    }

    public void setFDSNormal(int normal) {
        assert (this.isFDSNormalValid(normal));
        Unit u = Geometry.GEOM_LENGTH_UNIT;
        switch (normal) {
            case 0: {
                this.d_normal = null;
                break;
            }
            case -1: {
                this.d_normal = new UnitPoint3D(Geometry.VEC3D_XNEG, u);
                break;
            }
            case 1: {
                this.d_normal = new UnitPoint3D(Geometry.VEC3D_XPOS, u);
                break;
            }
            case -2: {
                this.d_normal = new UnitPoint3D(Geometry.VEC3D_YNEG, u);
                break;
            }
            case 2: {
                this.d_normal = new UnitPoint3D(Geometry.VEC3D_YPOS, u);
                break;
            }
            case -3: {
                this.d_normal = new UnitPoint3D(Geometry.VEC3D_ZNEG, u);
                break;
            }
            case 3: {
                this.d_normal = new UnitPoint3D(Geometry.VEC3D_ZPOS, u);
            }
        }
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public int getFDSNormal() {
        if (this.d_normal == null) {
            return 0;
        }
        Vector3d normal = this.d_normal.getVector3dValue(Geometry.GEOM_LENGTH_UNIT);
        if ((normal = this.getClosestAxis(normal)).equals(Geometry.VEC3D_XNEG)) {
            return -1;
        }
        if (normal.equals(Geometry.VEC3D_XPOS)) {
            return 1;
        }
        if (normal.equals(Geometry.VEC3D_YNEG)) {
            return -2;
        }
        if (normal.equals(Geometry.VEC3D_YPOS)) {
            return 2;
        }
        if (normal.equals(Geometry.VEC3D_ZNEG)) {
            return -3;
        }
        if (normal.equals(Geometry.VEC3D_ZPOS)) {
            return 3;
        }
        return 0;
    }

    public double getNormalDistFromCenter() {
        Unit u = Geometry.GEOM_LENGTH_UNIT;
        Point3d min = this.getMinPoint().getPoint3dValue(u);
        Point3d max = this.getMaxPoint().getPoint3dValue(u);
        double xdiff = Math.abs(max.x - min.x);
        double ydiff = Math.abs(max.y - min.y);
        double zdiff = Math.abs(max.z - min.z);
        double largest = Double.MIN_VALUE;
        if (xdiff > largest) {
            largest = xdiff;
        }
        if (ydiff > largest) {
            largest = ydiff;
        }
        if (zdiff > largest && zdiff > 0.0) {
            largest = zdiff;
        }
        return largest * 0.25;
    }

    @Override
    public Object clone() {
        Vent clone = null;
        clone = new Vent((Quad)this.d_quad.clone(), super.getName(), super.getMaterial());
        clone.imprint(this);
        return clone;
    }

    @Override
    protected void imprint(Object baseObject) {
        if (!(baseObject instanceof Vent)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        Vent obj = (Vent)baseObject;
        this.d_quad = (Quad)obj.d_quad.clone();
        this.setMaterial(obj.getMaterial());
        this.setColor(obj.getColor());
        Vector existingEvents = obj.getEventsSeparatedByType();
        Vector cloneEvents = this.getEventsSeparatedByType();
        cloneEvents.clear();
        for (ActivationEventList o : existingEvents) {
            cloneEvents.add((ActivationEventList)o.clone());
        }
        this.setCanBeTriggeredByAnyHeatDetector(obj.getCanBeTriggeredByAnyHeatDetector(0), 0);
        this.setCanBeTriggeredByAnyHeatDetector(obj.getCanBeTriggeredByAnyHeatDetector(1), 1);
        this.d_normal = obj.d_normal != null ? (UnitPoint3D)obj.d_normal.clone() : null;
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected Task taskSaveGeometry() {
        return new SaveGeomTask(0);
    }

    @Override
    protected void translate(UnitPoint3D delta) {
        Unit u = Geometry.GEOM_LENGTH_UNIT;
        this.d_quad.translate(delta.x(u), delta.y(u), delta.z(u));
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected void scale(UnitPoint3D base, Tuple3d scale) {
        assert (scale.x >= 0.0 && scale.y >= 0.0 && scale.z >= 0.0);
        Unit lu = Geometry.GEOM_LENGTH_UNIT;
        Point3d base3d = base.getPoint3dValue(lu);
        Point3d ptMin = this.getMinPoint().getPoint3dValue(lu);
        Point3d ptMax = this.getMaxPoint().getPoint3dValue(lu);
        Vent.scalePoint(ptMin, base3d, scale);
        Vent.scalePoint(ptMax, base3d, scale);
        this.setActualGeometry(new UnitPoint3D(ptMin, lu), new UnitPoint3D(ptMax, lu));
    }

    @Override
    protected void rotate(UnitPoint3D base, Vector3d rotAxis, UnitDouble amount) {
        Unit lu = Geometry.GEOM_LENGTH_UNIT;
        Point3d base3d = base.getPoint3dValue(lu);
        Matrix3d rot = Vent.getRotateMat(rotAxis, amount);
        Point3d min = this.getMinPoint().getPoint3dValue(lu);
        Point3d max = this.getMaxPoint().getPoint3dValue(lu);
        Vent.rotatePoint(min, base3d, rot);
        Vent.rotatePoint(max, base3d, rot);
        this.rectifyPoints(min, max);
        Vector3d normal = null;
        if (this.getNormal() != null) {
            normal = this.getNormal().getVector3dValue(lu);
            rot.transform(normal);
        }
        ADomainObject.pauseUpdates(this);
        this.setActualGeometry(new UnitPoint3D(min, lu), new UnitPoint3D(max, lu));
        if (normal != null) {
            this.setNormal(new UnitPoint3D(normal, lu));
        }
        ADomainObject.resumeUpdates(this);
    }

    @Override
    protected void rectifyPoints(Point3d min, Point3d max) {
        super.rectifyPoints(min, max);
        double xdiff = max.x - min.x;
        double ydiff = max.y - min.y;
        double zdiff = max.z - min.z;
        double smallestDim = xdiff;
        if (ydiff < smallestDim) {
            smallestDim = ydiff;
        }
        if (zdiff < smallestDim) {
            smallestDim = zdiff;
        }
        if (smallestDim == xdiff) {
            min.x = max.x;
        } else if (smallestDim == ydiff) {
            min.y = max.y;
        } else if (smallestDim == zdiff) {
            min.z = max.z;
        }
    }

    @Override
    protected void mirror(int plane, UnitDouble value) {
        Point3d p3;
        Point3d p2;
        Point3d p1;
        Point3d p0;
        Unit u = Geometry.GEOM_LENGTH_UNIT;
        Vector3d quadNormal = this.d_quad.getNormal();
        if (plane == 0) {
            p0 = value.getValue(u) > this.d_quad.getPoint((int)0).x ? new Point3d(value.getValue(u) + (value.getValue(u) - this.d_quad.getPoint((int)0).x), this.d_quad.getPoint((int)0).y, this.d_quad.getPoint((int)0).z) : new Point3d(value.getValue(u) - (this.d_quad.getPoint((int)0).x - value.getValue(u)), this.d_quad.getPoint((int)0).y, this.d_quad.getPoint((int)0).z);
            p1 = value.getValue(u) > this.d_quad.getPoint((int)1).x ? new Point3d(value.getValue(u) + (value.getValue(u) - this.d_quad.getPoint((int)1).x), this.d_quad.getPoint((int)1).y, this.d_quad.getPoint((int)1).z) : new Point3d(value.getValue(u) - (this.d_quad.getPoint((int)1).x - value.getValue(u)), this.d_quad.getPoint((int)1).y, this.d_quad.getPoint((int)1).z);
            p2 = value.getValue(u) > this.d_quad.getPoint((int)2).x ? new Point3d(value.getValue(u) + (value.getValue(u) - this.d_quad.getPoint((int)2).x), this.d_quad.getPoint((int)2).y, this.d_quad.getPoint((int)2).z) : new Point3d(value.getValue(u) - (this.d_quad.getPoint((int)2).x - value.getValue(u)), this.d_quad.getPoint((int)2).y, this.d_quad.getPoint((int)2).z);
            p3 = value.getValue(u) > this.d_quad.getPoint((int)3).x ? new Point3d(value.getValue(u) + (value.getValue(u) - this.d_quad.getPoint((int)3).x), this.d_quad.getPoint((int)3).y, this.d_quad.getPoint((int)3).z) : new Point3d(value.getValue(u) - (this.d_quad.getPoint((int)3).x - value.getValue(u)), this.d_quad.getPoint((int)3).y, this.d_quad.getPoint((int)3).z);
            if (p0.x == p2.x) {
                quadNormal.negate();
                if (this.d_normal != null) {
                    Vector3d normal = this.d_normal.getValue(u).getV3d();
                    normal.negate();
                    this.d_normal = new UnitPoint3D(normal, u);
                }
            }
        } else if (plane == 1) {
            p0 = value.getValue(u) > this.d_quad.getPoint((int)0).y ? new Point3d(this.d_quad.getPoint((int)0).x, value.getValue(u) + (value.getValue(u) - this.d_quad.getPoint((int)0).y), this.d_quad.getPoint((int)0).z) : new Point3d(this.d_quad.getPoint((int)0).x, value.getValue(u) - (this.d_quad.getPoint((int)0).y - value.getValue(u)), this.d_quad.getPoint((int)0).z);
            p1 = value.getValue(u) > this.d_quad.getPoint((int)1).y ? new Point3d(this.d_quad.getPoint((int)1).x, value.getValue(u) + (value.getValue(u) - this.d_quad.getPoint((int)1).y), this.d_quad.getPoint((int)1).z) : new Point3d(this.d_quad.getPoint((int)1).x, value.getValue(u) - (this.d_quad.getPoint((int)1).y - value.getValue(u)), this.d_quad.getPoint((int)1).z);
            p2 = value.getValue(u) > this.d_quad.getPoint((int)2).y ? new Point3d(this.d_quad.getPoint((int)2).x, value.getValue(u) + (value.getValue(u) - this.d_quad.getPoint((int)2).y), this.d_quad.getPoint((int)2).z) : new Point3d(this.d_quad.getPoint((int)2).x, value.getValue(u) - (this.d_quad.getPoint((int)2).y - value.getValue(u)), this.d_quad.getPoint((int)2).z);
            p3 = value.getValue(u) > this.d_quad.getPoint((int)3).y ? new Point3d(this.d_quad.getPoint((int)3).x, value.getValue(u) + (value.getValue(u) - this.d_quad.getPoint((int)3).y), this.d_quad.getPoint((int)3).z) : new Point3d(this.d_quad.getPoint((int)3).x, value.getValue(u) - (this.d_quad.getPoint((int)3).y - value.getValue(u)), this.d_quad.getPoint((int)3).z);
            if (p0.y == p2.y) {
                quadNormal.negate();
                if (this.d_normal != null) {
                    Vector3d normal = this.d_normal.getValue(u).getV3d();
                    normal.negate();
                    this.d_normal = new UnitPoint3D(normal, u);
                }
            }
        } else {
            p0 = value.getValue(u) > this.d_quad.getPoint((int)0).y ? new Point3d(this.d_quad.getPoint((int)0).x, this.d_quad.getPoint((int)0).y, value.getValue(u) + (value.getValue(u) - this.d_quad.getPoint((int)0).z)) : new Point3d(this.d_quad.getPoint((int)0).x, this.d_quad.getPoint((int)0).y, value.getValue(u) - (this.d_quad.getPoint((int)0).z - value.getValue(u)));
            p1 = value.getValue(u) > this.d_quad.getPoint((int)1).y ? new Point3d(this.d_quad.getPoint((int)1).x, this.d_quad.getPoint((int)1).y, value.getValue(u) + (value.getValue(u) - this.d_quad.getPoint((int)1).z)) : new Point3d(this.d_quad.getPoint((int)1).x, this.d_quad.getPoint((int)1).y, value.getValue(u) - (this.d_quad.getPoint((int)1).z - value.getValue(u)));
            p2 = value.getValue(u) > this.d_quad.getPoint((int)2).y ? new Point3d(this.d_quad.getPoint((int)2).x, this.d_quad.getPoint((int)2).y, value.getValue(u) + (value.getValue(u) - this.d_quad.getPoint((int)2).z)) : new Point3d(this.d_quad.getPoint((int)2).x, this.d_quad.getPoint((int)2).y, value.getValue(u) - (this.d_quad.getPoint((int)2).z - value.getValue(u)));
            p3 = value.getValue(u) > this.d_quad.getPoint((int)3).y ? new Point3d(this.d_quad.getPoint((int)3).x, this.d_quad.getPoint((int)3).y, value.getValue(u) + (value.getValue(u) - this.d_quad.getPoint((int)3).z)) : new Point3d(this.d_quad.getPoint((int)3).x, this.d_quad.getPoint((int)3).y, value.getValue(u) - (this.d_quad.getPoint((int)3).z - value.getValue(u)));
            if (p0.z == p2.z) {
                quadNormal.negate();
                if (this.d_normal != null) {
                    Vector3d normal = this.d_normal.getValue(u).getV3d();
                    normal.negate();
                    this.d_normal = new UnitPoint3D(normal, u);
                }
            }
        }
        this.d_quad = new Quad(p0, p1, p2, p3, null);
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Iterator getVentIterator() {
        Vector<Vent> v = new Vector<Vent>();
        v.add(this);
        return v.iterator();
    }

    @Override
    public String getFDSType() {
        return "VENT";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        FDSInputRecord rec = new FDSInputRecord();
        rec.setType("VENT");
        Vector<Double> coords = new Vector<Double>(6);
        UnitPoint3D min = this.getMinPoint();
        UnitPoint3D max = this.getMaxPoint();
        Point3D minPoint = min.getValue(Geometry.GEOM_LENGTH_UNIT);
        Point3D maxPoint = max.getValue(Geometry.GEOM_LENGTH_UNIT);
        coords.add(minPoint.x);
        coords.add(maxPoint.x);
        coords.add(minPoint.y);
        coords.add(maxPoint.y);
        coords.add(minPoint.z);
        coords.add(maxPoint.z);
        rec.setValue("XB", coords);
        int normal = this.getFDSNormal();
        if (normal != 0) {
            rec.setValue("IOR", normal);
        }
        rec.setValue("SURF_ID", this.d_material.getName());
        Color c = this.getColor();
        if (c != null) {
            float[] rgb = c.getRGBComponents(null);
            Vector<Double> color = new Vector<Double>(3);
            color.add(Double.valueOf(rgb[0]));
            color.add(Double.valueOf(rgb[1]));
            color.add(Double.valueOf(rgb[2]));
            rec.setValue("RGB", color);
        }
        if (!this.isVisible()) {
            rec.setValue("COLOR", "INVISIBLE");
        }
        rec.setComment(this.getName());
        Collection eventRecords = this.getEventInputRecords(rec);
        if (eventRecords.size() != 0) {
            recs.addAll(eventRecords);
        } else {
            recs.add(rec);
        }
    }

    @Override
    public Map getEventInputRecordMap(int eventType) {
        TreeMap<Integer, String> recordMap = new TreeMap<Integer, String>();
        if (eventType == 0) {
            if (this.d_material.equals(Material.getPredefinedMaterial("OPEN"))) {
                recordMap.put(0, "T_OPEN");
                recordMap.put(1, "T_CLOSE");
            } else {
                recordMap.put(0, "T_ACTIVATE");
                recordMap.put(1, "T_DEACTIVATE");
            }
        } else if (eventType == 1) {
            recordMap.put(0, "HEAT_ACTIVATE");
            recordMap.put(1, "HEAT_DEACTIVATE");
        }
        return recordMap;
    }

    @Override
    public UnitPoint3D getMinPoint() {
        Geometry g = new Geometry();
        g.addQuad(this.d_quad);
        Point3D minPoint = g.getMinPoint();
        return new UnitPoint3D(minPoint.x, minPoint.y, minPoint.z, Geometry.GEOM_LENGTH_UNIT);
    }

    @Override
    public UnitPoint3D getMaxPoint() {
        Geometry g = new Geometry();
        g.addQuad(this.d_quad);
        Point3D maxPoint = g.getMaxPoint();
        return new UnitPoint3D(maxPoint.x, maxPoint.y, maxPoint.z, Geometry.GEOM_LENGTH_UNIT);
    }

    public Quad getActualGeometry() {
        return this.d_quad;
    }

    @Override
    public void getGeometry(Geometry g) {
        Quad q1 = (Quad)this.d_quad.clone();
        q1.setProps(new PrimProps(this.getMaterial(), this.getColor()));
        g.addQuad(q1);
        UnitPoint3D normalU = this.getNormal();
        if (normalU != null) {
            Unit u = Geometry.GEOM_LENGTH_UNIT;
            Vector3d normal = normalU.getVector3dValue(u);
            UnitPoint3D min = this.getMinPoint();
            UnitPoint3D max = this.getMaxPoint();
            Point3d mid = new Point3d();
            mid.add(min.getPoint3dValue(u), max.getPoint3dValue(u));
            mid.scale(0.5);
            Point3d normalEndpoint = new Point3d(normal);
            normalEndpoint.scale(this.getNormalDistFromCenter());
            normalEndpoint.add(mid);
            g.addLine(new Line(mid, normalEndpoint, normal, new PrimProps(null, Color.BLACK)));
        }
    }

    @Override
    public int getNumFaces() {
        return 1;
    }

    @Override
    public void setMaterial(Material mat) {
        this.d_material = mat;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Material getMaterial() {
        return this.d_material;
    }

    @Override
    public void setMaterial(int faceIndex, Material mat) {
        this.d_material = mat;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Material getMaterial(int faceIndex) {
        return this.d_material;
    }

    @Override
    public boolean isUniformMaterial() {
        return true;
    }

    @Override
    public void setSelected(boolean selected) {
        this.d_selected = selected;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 0));
    }

    @Override
    public boolean isSelected() {
        return this.d_selected;
    }

    @Override
    public String getPropertyHashString() {
        Object s = "";
        s = (String)s + this.d_quad.getPoint((int)0).x + "," + this.d_quad.getPoint((int)0).y + "," + this.d_quad.getPoint((int)0).z + ";";
        s = (String)s + this.d_quad.getPoint((int)1).x + "," + this.d_quad.getPoint((int)1).y + "," + this.d_quad.getPoint((int)1).z + ";";
        s = (String)s + this.d_quad.getPoint((int)2).x + "," + this.d_quad.getPoint((int)2).y + "," + this.d_quad.getPoint((int)2).z + ";";
        s = (String)s + this.d_quad.getPoint((int)3).x + "," + this.d_quad.getPoint((int)3).y + "," + this.d_quad.getPoint((int)3).z + ";";
        s = (String)s + String.valueOf(this.d_normal) + ";";
        s = (String)s + this.d_material.getName();
        return s;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Vent)) {
            return false;
        }
        Vent v = (Vent)obj;
        Vector allEventsThis = this.getEventsSeparatedByType();
        Vector allEventsThat = v.getEventsSeparatedByType();
        return this.d_quad.equals(v.d_quad) && this.d_material.equals(v.d_material) && allEventsThis.equals(allEventsThat) && this.getName().equals(v.getName()) && (this.d_normal == null ? v.d_normal == null : this.d_normal.equals(v.d_normal));
    }

    @Override
    public UnitPoint3D[] getVerts() {
        return null;
    }

    @Override
    public FDSObject getAttachedObj() {
        return this;
    }

    @Override
    public IFDSFragGenerator getFDSFragGenerator() {
        return null;
    }

    @Override
    public String getTypeDescription() {
        return "Vent";
    }

    @Override
    public boolean isRasterizable() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }

    private class SaveGeomTask
    extends ATask {
        private UnitPoint3D d_min;
        private UnitPoint3D d_max;
        private UnitPoint3D d_normal;

        public SaveGeomTask(int est) {
            super(est, true);
        }

        @Override
        public void undo() {
            ADomainObject.pauseUpdates(Vent.this);
            Vent.this.setActualGeometry(this.d_min, this.d_max);
            Vent.this.setNormal(this.d_normal);
            ADomainObject.resumeUpdates(Vent.this);
        }

        @Override
        public void run() {
            this.d_min = (UnitPoint3D)Vent.this.getMinPoint().clone();
            this.d_max = (UnitPoint3D)Vent.this.getMaxPoint().clone();
            if (Vent.this.getNormal() != null) {
                this.d_normal = (UnitPoint3D)Vent.this.getNormal().clone();
            }
        }
    }
}

