/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.devices.IDeviceModel;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.ramp.Ramp;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;

public class PropParser
extends AFDS6Parser {
    private static final FDSParseRecord s_defPropRec = new FDSParseRecord(FDS6Const.getRecordSpecs().get("PROP"), true);
    private final Map<String, FDSParseRecord> d_propMap = new HashMap<String, FDSParseRecord>();
    private final Map<String, HeatLinkModel> d_heatLinkModels = new HashMap<String, HeatLinkModel>();
    private final Map<String, SmokeLinkModel> d_smokeLinkModels = new HashMap<String, SmokeLinkModel>();
    private final Map<String, SprayModel> d_sprayModels = new HashMap<String, SprayModel>();
    private final Map<String, SprinklerLinkModel> d_sprkLinkModels = new HashMap<String, SprinklerLinkModel>();
    private final Map<String, IDeviceModel> d_models = new HashMap<String, IDeviceModel>();
    private Map<FDSParseRecord, IDeviceModel> d_incompleteRecords = new LinkedHashMap<FDSParseRecord, IDeviceModel>();

    public PropParser(FDS6ParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("PROP");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("MASS_FLOW_RATE", "UNSUPPORTED");
        unsupportedFields.put("P0", "UNSUPPORTED");
        unsupportedFields.put("PX", "UNSUPPORTED");
        unsupportedFields.put("PXX", "UNSUPPORTED");
        unsupportedFields.put("PDPA_END", "UNSUPPORTED");
        unsupportedFields.put("PDPA_HISTOGRAM", "UNSUPPORTED");
        unsupportedFields.put("PDPA_HISTOGRAM_CUMULATIVE", "UNSUPPORTED");
        unsupportedFields.put("PDPA_HISTOGRAM_LIMITS", "UNSUPPORTED");
        unsupportedFields.put("PDPA_HISTOGRAM_NMINS", "UNSUPPORTED");
        unsupportedFields.put("PDPA_INTEGRATE", "UNSUPPORTED");
        unsupportedFields.put("PDPA_M", "UNSUPPORTED");
        unsupportedFields.put("PDPA_N", "UNSUPPORTED");
        unsupportedFields.put("PDPA_NORMALIZE", "UNSUPPORTED");
        unsupportedFields.put("PDPA_RADIUS", "UNSUPPORTED");
        unsupportedFields.put("PDPA_START", "UNSUPPORTED");
        unsupportedFields.put("SMOKEVIEW_PARAMETERS", "UNSUPPORTED");
        unsupportedFields.put("SPRAY_PATTERN_BETA", "UNSUPPORTED");
        unsupportedFields.put("SPRAY_PATTERN_MU", "UNSUPPORTED");
        unsupportedFields.put("SPRAY_PATTERN_SHAPE", "UNSUPPORTED");
        unsupportedFields.put("VELOCITY_COMPONENT", "UNSUPPORTED");
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        super.done();
    }

    @Override
    protected boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        HashMap<String, String> propNameUpgrades = new HashMap<String, String>();
        propNameUpgrades.put("BEAD_DIAMETER", "DIAMETER");
        propNameUpgrades.put("BEAD_EMISSIVITY", "EMISSIVITY");
        propNameUpgrades.put("BEAD_DENSITY", "DENSITY");
        propNameUpgrades.put("BEAD_SPECIFIC_HEAT", "SPECIFIC_HEAT");
        propNameUpgrades.put("BEAD_HEAT_TRANSFER_COEFFICIENT", "HEAT_TRANSFER_COEFFICIENT");
        for (Map.Entry entry : propNameUpgrades.entrySet()) {
            if (rec.contains((String)entry.getKey()) && !rec.contains((String)entry.getValue())) {
                rec.setValue((String)entry.getValue(), rec.get((String)entry.getKey()));
                rec.setValue((String)entry.getKey(), null);
                this.addWarning(rec, String.format(Intl.intl("Legacy thermocouple property %s for record %s"), entry.getKey(), "PROP"), String.format(Intl.intl("Converted to %s"), entry.getValue()));
                continue;
            }
            if (!rec.contains((String)entry.getKey()) || !rec.contains((String)entry.getValue())) continue;
            rec.setValue((String)entry.getKey(), null);
            this.addWarning(rec, String.format(Intl.intl("Legacy thermocouple property %s for record %s"), entry.getKey(), "PROP"), String.format(Intl.intl("Legacy record ignored"), entry.getValue()));
        }
        String id = (String)rec.get("ID");
        if (id == null || id.trim().equals("")) {
            this.addWarning(rec, String.format(Intl.intl("%s has no ID."), "PROP"), String.format(Intl.intl("Adding %s to additional records section."), "PROP"));
            return false;
        }
        if (this.d_propMap.containsKey(id)) {
            this.addWarning(rec, String.format(Intl.intl("Duplicate %1$s ID found: %2$s"), "PROP", id), String.format(Intl.intl("Ignoring %s."), "PROP"));
            return true;
        }
        this.d_propMap.put(id, rec);
        return this.processProp(id, rec);
    }

    protected boolean processProp(String id, FDSParseRecord rec) throws FDSRecordFormatException {
        String propType;
        boolean parsed = false;
        if (rec.contains("PART_ID")) {
            this.parseSprayModel(rec);
            parsed = true;
        }
        if ((propType = (String)rec.get("QUANTITY", false)) != null) {
            if (propType.equals(Quantity.SPRINKLER_LINK_TEMPERATURE.fdsName)) {
                this.parseSprinklerLinkModel(rec);
                parsed = true;
            } else if (propType.equals(Quantity.LINK_TEMPERATURE.fdsName)) {
                this.parseHeatLinkModel(rec);
                parsed = true;
            } else if (propType.equals("spot obscuration") || propType.equals(Quantity.CHAMBER_OBSCURATION.fdsName)) {
                this.parseSmokeLinkModel(rec);
                parsed = true;
            }
        }
        return parsed;
    }

    public FDSParseRecord getProp(String propID) {
        return this.d_propMap.get(propID);
    }

    public static FDSParseRecord getDefaultProp() {
        return s_defPropRec;
    }

    public static boolean isDefaultProp(FDSParseRecord rec) {
        return s_defPropRec.equals(rec);
    }

    public boolean isModel(String propID) {
        return this.d_models.containsKey(propID);
    }

    private <T extends IDeviceModel> void addModel(Composite<T> mgr, Map<String, T> models, T model) {
        mgr.add(model);
        this.flagObjectAdded(model);
        models.put(model.getName(), model);
        this.d_models.put(model.getName(), model);
    }

    protected HeatLinkModel parseHeatLinkModel(FDSParseRecord rec) {
        String id = (String)rec.get("ID");
        HeatLinkModel model = this.d_heatLinkModels.get(id);
        if (model != null) {
            return model;
        }
        UnitDouble initTemp = (UnitDouble)rec.get("INITIAL_TEMPERATURE", true);
        UnitDouble actTemp = (UnitDouble)rec.get("ACTIVATION_TEMPERATURE", true);
        UnitDouble rti = (UnitDouble)rec.get("RTI", true);
        model = new HeatLinkModel(id, rti, initTemp, actTemp);
        this.addUnsupportedCustomFDSProps(model, rec);
        this.addModel(this.getContainer().getHeatLinkModels(), this.d_heatLinkModels, model);
        return model;
    }

    protected SmokeLinkModel parseSmokeLinkModel(FDSParseRecord rec) {
        SmokeLinkModel.ISpec spec;
        String id = (String)rec.get("ID");
        SmokeLinkModel model = this.d_smokeLinkModels.get(id);
        if (model != null) {
            return model;
        }
        UnitDouble actObsc = (UnitDouble)rec.get("ACTIVATION_OBSCURATION", true);
        if (rec.contains("ALPHA_C") || rec.contains("ALPHA_E") || rec.contains("BETA_C") || rec.contains("BETA_E")) {
            spec = new SmokeLinkModel.Cleary(rec.getDouble("ALPHA_C", true), rec.getDouble("BETA_C", true), rec.getDouble("ALPHA_E", true), rec.getDouble("BETA_E", true));
        } else {
            UnitDouble len = (UnitDouble)rec.get("LENGTH", true);
            spec = new SmokeLinkModel.Heskestad(len);
        }
        model = new SmokeLinkModel(id, actObsc, null, spec);
        this.addUnsupportedCustomFDSProps(model, rec);
        this.addModel(this.getContainer().getSmokeLinkModels(), this.d_smokeLinkModels, model);
        this.d_incompleteRecords.put(rec, model);
        return model;
    }

    protected SprinklerLinkModel parseSprinklerLinkModel(FDSParseRecord rec) {
        String id = (String)rec.get("ID");
        SprinklerLinkModel model = this.d_sprkLinkModels.get(id);
        if (model != null) {
            return model;
        }
        UnitDouble initTemp = (UnitDouble)rec.get("INITIAL_TEMPERATURE", true);
        UnitDouble actTemp = (UnitDouble)rec.get("ACTIVATION_TEMPERATURE", true);
        UnitDouble rti = (UnitDouble)rec.get("RTI", true);
        UnitDouble cfactor = (UnitDouble)rec.get("C_FACTOR", true);
        model = new SprinklerLinkModel(id, rti, initTemp, actTemp, cfactor);
        this.addUnsupportedCustomFDSProps(model, rec);
        this.addModel(this.getContainer().getSprinklerLinkModels(), this.d_sprkLinkModels, model);
        return model;
    }

    protected SprayModel parseSprayModel(FDSParseRecord rec) throws FDSRecordFormatException {
        String id = (String)rec.get("ID");
        SprayModel model = this.d_sprayModels.get(id);
        if (model != null) {
            return model;
        }
        UnitDouble offset = (UnitDouble)rec.get("OFFSET", true);
        String partID = (String)rec.get("PART_ID", false);
        if (partID == null) {
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("%s was not specified."), "PART_ID"));
        }
        Particle part = this.findObject(Particle.class, partID);
        if (part == null) {
            throw new FDSRecordFormatException(rec, String.format(Intl.intl("Particle %s could not be found."), partID));
        }
        List<SprayModel.Jet> jets = this.parseJets(rec, id);
        int dropsPerSecond = rec.getInteger("PARTICLES_PER_SECOND", true);
        SprayModel.FlowRate flowRate = this.parseFlowRate(rec);
        model = new SprayModel(id, part, offset, flowRate, dropsPerSecond, jets);
        this.addUnsupportedCustomFDSProps(model, rec);
        this.addModel(this.getContainer().getSprayModels(), this.d_sprayModels, model);
        return model;
    }

    private static <T> int countNonNull(T ... vals) {
        int count = 0;
        for (T val : vals) {
            if (val == null) continue;
            ++count;
        }
        return count;
    }

    private SprayModel.FlowRate parseFlowRate(FDSParseRecord rec) throws FDSRecordFormatException {
        SprayModel.FlowRate rate;
        TimeFunction timeFunc = this.parseTimeFunction(rec, "FLOW_TAU", "FLOW_RAMP");
        if (rec.contains("PRESSURE_RAMP")) {
            String rName = rec.getString("PRESSURE_RAMP");
            Ramp pressureRamp = this.getParsingInfo().getRamp(rName, SprayModel.VaryingFlowRate.DEF_RAMP_INPUT, 12, true);
            if (pressureRamp == null) {
                throw new FDSRecordFormatException(rec, String.format(Intl.intl("The RAMP, \"%s\", does not exist."), rName));
            }
            UnitDouble kFactor = (UnitDouble)rec.get("K_FACTOR", false);
            UnitDouble opPress = (UnitDouble)rec.get("OPERATING_PRESSURE", false);
            UnitDouble flowRate = (UnitDouble)rec.get("FLOW_RATE", false);
            int count = PropParser.countNonNull(kFactor, opPress, flowRate);
            if (count < 2) {
                throw new FDSRecordFormatException(rec, String.format(Intl.intl("Sprinklers and nozzles with varying pipe pressure must specify at least two of\nthese properties: %1$s, %2$s, and %3$s."), "K_FACTOR", "OPERATING_PRESSURE", "FLOW_RATE"));
            }
            rate = new SprayModel.VaryingFlowRate(pressureRamp, opPress, kFactor, flowRate, timeFunc);
        } else if (rec.contains("FLOW_RATE")) {
            UnitDouble flowRate = (UnitDouble)rec.get("FLOW_RATE", false);
            rate = new SprayModel.ExplicitFlowRate(flowRate, timeFunc);
        } else {
            UnitDouble kFactor = (UnitDouble)rec.get("K_FACTOR", true);
            UnitDouble opPress = (UnitDouble)rec.get("OPERATING_PRESSURE", true);
            rate = new SprayModel.PressurizedFlowRate(opPress, kFactor, timeFunc);
        }
        return rate;
    }

    private List<SprayModel.Jet> parseJets(FDSParseRecord rec, String id) throws FDSRecordFormatException {
        if (rec.contains("SPRAY_PATTERN_TABLE")) {
            String tableID = (String)rec.get("SPRAY_PATTERN_TABLE");
            List<List<Double>> table = this.getParsingInfo().getTable(tableID);
            if (table == null) {
                throw new FDSRecordFormatException(rec, String.format(Intl.intl("Table %s could not be found."), tableID));
            }
            ArrayList<SprayModel.Jet> jets = new ArrayList<SprayModel.Jet>(table.size());
            double totalFlowFrac = 0.0;
            for (List<Double> row : table) {
                if (row.size() < 6) {
                    throw new FDSRecordFormatException(rec, String.format(Intl.intl("%s must have 6 columns."), "SPRAY_PATTERN_TABLE"));
                }
                double flowFrac = row.get(5);
                if (flowFrac < 0.0 || flowFrac > 1.0) {
                    throw new FDSRecordFormatException(rec, Intl.intl("Flow fraction must be between 0 and 1 inclusive."));
                }
                SprayModel.Jet jet = new SprayModel.Jet(SIUS.newud(row.get(4), 8), null, flowFrac, SIUS.newud(row.get(2), 29), SIUS.newud(row.get(3), 29), SIUS.newud(row.get(0), 29), SIUS.newud(row.get(1), 29));
                jets.add(jet);
                totalFlowFrac += flowFrac;
            }
            if (totalFlowFrac > 1.00001) {
                throw new FDSRecordFormatException(rec, Intl.intl("Total flow fraction must be less than or equal to 1."));
            }
            return jets;
        }
        UnitDouble vel = (UnitDouble)rec.get("PARTICLE_VELOCITY", true);
        UnitDouble orificeDiam = rec.getUnitDouble("ORIFICE_DIAMETER", false);
        if (orificeDiam != null && rec.contains("PARTICLE_VELOCITY")) {
            this.addWarning(rec, String.format(Intl.intl("PROP %1$s specifies both %2$s and %3$s."), id, "ORIFICE_DIAMETER", "PARTICLE_VELOCITY"), String.format(Intl.intl("Ignoring %s."), "ORIFICE_DIAMETER"));
            orificeDiam = null;
        } else if (orificeDiam != null) {
            vel = null;
        }
        FDSArray angles = rec.getArray("SPRAY_ANGLE", true);
        SprayModel.Jet jet = null;
        if (angles.getTotalLength() == 2) {
            jet = new SprayModel.Jet(vel, orificeDiam, 1.0, (UnitDouble)angles.get(0, 0), (UnitDouble)angles.get(0, 1));
        } else if (angles.getTotalLength() == 4) {
            jet = new SprayModel.Jet(vel, orificeDiam, 1.0, (UnitDouble)angles.get(0, 1), (UnitDouble)angles.get(1, 1), (UnitDouble)angles.get(0, 0), (UnitDouble)angles.get(1, 0));
        }
        return Arrays.asList(jet);
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
        for (Map.Entry<FDSParseRecord, IDeviceModel> entr : this.d_incompleteRecords.entrySet()) {
            if (!(entr.getValue() instanceof SmokeLinkModel)) continue;
            SmokeLinkModel model = (SmokeLinkModel)entr.getValue();
            String specName = entr.getKey().getString("SPEC_ID", false);
            ExSpecList specs = this.getContainer().getExSpecList();
            ExSpec theSpec = specs.get(specName);
            if (theSpec == null && specName != null) {
                this.addWarning(entr.getKey(), String.format(Intl.intl("Could not find custom smoke species, \"%s.\""), specName), String.format(Intl.intl("Tracking default smoke."), new Object[0]));
                continue;
            }
            model.setSmokeSpecies(theSpec);
        }
        super.postProcess();
    }
}

