/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.parsers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.particle.ConstColoring;
import pyrosim.domain.particle.DropletColoring;
import pyrosim.domain.particle.IColoring;
import pyrosim.domain.particle.Output;
import pyrosim.domain.particle.Particle;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParsingInfo;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.v6.common.ParticleQuantityMap;
import pyrosim.io.fds.v6.parsers.AFDS6Parser;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class ParticleParser
extends AFDS6Parser {
    private final PinConnParser d_pinConns;
    private Map<FDSParseRecord, Particle> d_partsWithSurfs = new LinkedHashMap<FDSParseRecord, Particle>();
    private Map<FDSParseRecord, Particle> d_partsWithSpecs = new LinkedHashMap<FDSParseRecord, Particle>();

    public ParticleParser(FDS6ParsingInfo parsingInfo, PinConnParser pinConns) {
        super(parsingInfo);
        this.d_pinConns = pinConns;
    }

    @Override
    public void getRecordTypes(Set<String> types) {
        types.add("PART");
    }

    @Override
    public void getUnsupportedFields(String type, Map<String, String> unsupportedFields) {
        unsupportedFields.put("BREAKUP", "UNSUPPORTED");
        unsupportedFields.put("BREAKUP_CNF_RAMP_ID", "UNSUPPORTED");
        unsupportedFields.put("BREAKUP_DISTRIBUTION", "UNSUPPORTED");
        unsupportedFields.put("BREAKUP_GAMMA_D", "UNSUPPORTED");
        unsupportedFields.put("BREAKUP_RATIO", "UNSUPPORTED");
        unsupportedFields.put("BREAKUP_SIGMA_D", "UNSUPPORTED");
        unsupportedFields.put("CHECK_DISTRIBUTION", "UNSUPPORTED");
        unsupportedFields.put("CNF_RAMP_ID", "UNSUPPORTED");
        unsupportedFields.put("COMPLEX_REFRACTIVE_INDEX", "UNSUPPORTED");
        unsupportedFields.put("N_STRATA", "UNSUPPORTED");
        unsupportedFields.put("PROP_ID", "UNSUPPORTED");
        unsupportedFields.put("QUANTITIES_SPEC_ID", "UNSUPPORTED");
        unsupportedFields.put("RADIATIVE_PROPERTY_TABLE", "UNSUPPORTED");
        unsupportedFields.put("REAL_REFRACTIVE_INDEX", "UNSUPPORTED");
        unsupportedFields.put("SURFACE_TENSION", "UNSUPPORTED");
        unsupportedFields.put("HORIZONTAL_VELOCITY", "UNSUPPORTED");
        unsupportedFields.put("VERTICAL_VELOCITY", "UNSUPPORTED");
    }

    @Override
    public boolean process(FDSParseRecord rec) throws FDSRecordFormatException {
        String id = this.parseName(rec, "ID", Particle.class);
        if (!this.checkName(rec, id)) {
            return false;
        }
        Particle.Type type = null;
        if (type == null) {
            if (rec.getBoolean("MASSLESS", true).booleanValue()) {
                type = Particle.Type.TRACER;
            } else {
                String specID = rec.getString("SPEC_ID", true);
                if (specID != null) {
                    type = Particle.Type.LIQUID;
                } else {
                    String surfID = rec.getString("SURF_ID", true);
                    if (surfID != null) {
                        type = Particle.Type.SOLID;
                    } else {
                        throw new FDSRecordFormatException(rec, Intl.intl("Particle invalid. Must specify SPEC_ID, SURF_ID, or MASSLESS=.TRUE."));
                    }
                }
            }
        }
        Output out = ParticleParser.parseOutput(rec, 10);
        IColoring colors = ParticleParser.parseColoring(this.getParsingInfo(), rec);
        Particle part = new Particle(id, type, out, colors);
        part.setFYI(rec.getString("FYI", false));
        part.setStatic(rec.getBoolean("STATIC", true));
        if (part.getType() == Particle.Type.SOLID) {
            this.d_partsWithSurfs.put(rec, part);
        }
        if (part.getType() == Particle.Type.LIQUID) {
            this.d_partsWithSpecs.put(rec, part);
        }
        ParticleParser.parseDrag(rec, part);
        ParticleParser.parseSizeDistribution(this.getParsingInfo(), rec, part);
        this.addUnsupportedCustomFDSProps(part, rec);
        int exists = this.existsStatus(rec, part, Particle.class);
        if (exists != 0) {
            return this.convertToReturn(exists);
        }
        this.getContainer().getPartList().add(part);
        this.flagObjectAdded(part);
        ParticleParser.markSingleInputForRetrieval(rec, part, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        return true;
    }

    private static IColoring parseColoring(FDSParsingInfo pi, FDSParseRecord rec) {
        if (rec.contains("QUANTITIES")) {
            List quantities = rec.getList("QUANTITIES", false);
            ArrayList<Integer> propVals = new ArrayList<Integer>(quantities.size());
            for (String quantity : quantities) {
                Integer val = ParticleQuantityMap.getPyroVal(quantity);
                if (val == null) {
                    pi.addWarning(rec, String.format(Intl.intl("Unknown particle coloring quantity, %s."), quantity), Intl.intl("Ignoring coloring quantity."));
                    continue;
                }
                propVals.add(val);
            }
            return new DropletColoring(propVals);
        }
        Color c = ParticleParser.parseColor(pi, rec, "RGB", "COLOR", null, false);
        if (c != null) {
            return new ConstColoring(c);
        }
        return null;
    }

    private static void parseSizeDistribution(FDSParsingInfo pi, FDSParseRecord rec, Particle part) {
        UnitDouble diameter = rec.getUnitDouble("DIAMETER", true);
        boolean monodisperse = rec.getBoolean("MONODISPERSE", true);
        if (monodisperse) {
            part.setConstDistribution(diameter);
            return;
        }
        UnitDouble minDiam = rec.getUnitDouble("MINIMUM_DIAMETER", true);
        UnitDouble maxDiam = rec.getUnitDouble("MAXIMUM_DIAMETER", true);
        String distribution = rec.getString("DISTRIBUTION", true);
        if (distribution.equals("ROSIN-RAMMLER")) {
            double gammaD = rec.getDouble("GAMMA_D", true);
            part.setRosinRammler(diameter, minDiam, maxDiam, gammaD);
        } else if (distribution.equals("LOGNORMAL")) {
            double sigmaD = rec.getDouble("SIGMA_D", false);
            part.setLognormal(diameter, minDiam, maxDiam, sigmaD);
        } else if (distribution.equals("ROSIN-RAMMLER-LOGNORMAL")) {
            double gammaD = rec.getDouble("GAMMA_D", true);
            part.setRosinRammlerLognormal(diameter, minDiam, maxDiam, gammaD);
            if (rec.contains("SIGMA_D")) {
                List<String> sigmaD = Arrays.asList(Double.toString(rec.getDouble("SIGMA_D")));
                rec.addUnknownProp("SIGMA_D", sigmaD);
            }
        }
    }

    private static void parseDragCoef(FDSParseRecord rec, Particle part) throws FDSRecordFormatException {
        List coeff = rec.getList("DRAG_COEFFICIENT", true);
        UnitPoint3D converted = new UnitPoint3D(0.0, 0.0, 0.0, Unit.ONE);
        if (coeff != null && coeff.get(0) != null && coeff.get(1) != null && coeff.get(2) != null) {
            converted = new UnitPoint3D((Double)coeff.get(0), (Double)coeff.get(0), (Double)coeff.get(0), Unit.ONE);
        } else if (coeff != null && coeff.get(0) != null) {
            converted = new UnitPoint3D((Double)coeff.get(0), 0.0, 0.0, Unit.ONE);
        }
        part.setDragCoef3D(converted);
    }

    private static void parseDrag(FDSParseRecord rec, Particle part) throws FDSRecordFormatException {
        String dragLaw = rec.getString("DRAG_LAW", true);
        if (dragLaw.equals("SPHERE")) {
            part.setDrag(Particle.Drag.SPHERE);
        } else if (dragLaw.equals("CYLINDER")) {
            part.setDrag(Particle.Drag.CYLINDER);
        } else if (dragLaw.equals("DISK")) {
            part.setDrag(Particle.Drag.DISK);
        } else if (dragLaw.equals("POROUS MEDIA")) {
            part.setDrag(Particle.Drag.POROUS_MEDIA);
            part.setPorousVolumeFraction(rec.getDouble("POROUS_VOLUME_FRACTION", true));
            part.setPermeability(ParticleParser.parseLoc(rec, "PART", "PERMEABILITY", true));
            ParticleParser.parseDragCoef(rec, part);
        } else if (dragLaw.equals("SCREEN")) {
            part.setDrag(Particle.Drag.SCREEN);
            part.setFreeAreaFraction(rec.getDouble("FREE_AREA_FRACTION", true));
            part.setOrientation(ParticleParser.parseLoc(rec, "PART", "ORIENTATION", true));
        } else {
            part.setDrag(Particle.Drag.CUSTOM);
            ParticleParser.parseDragCoef(rec, part);
        }
        part.setDenseVolumeFraction(rec.getDouble("DENSE_VOLUME_FRACTION", true));
    }

    @Override
    public void postProcess() throws FDSRecordFormatException {
        SurfaceManager surfs = this.getContainer().getSurfaceMgr();
        for (Map.Entry<FDSParseRecord, Particle> entr : this.d_partsWithSurfs.entrySet()) {
            if (!entr.getKey().contains("SURF_ID")) continue;
            entr.getValue().setSurface((Surface)surfs.get(entr.getKey().getString("SURF_ID", true)));
        }
        ExSpecList specs = this.getContainer().getExSpecList();
        for (Map.Entry<FDSParseRecord, Particle> entr : this.d_partsWithSpecs.entrySet()) {
            if (!entr.getKey().contains("SPEC_ID")) continue;
            ExSpec spec = specs.get(entr.getKey().getString("SPEC_ID", true));
            if (spec != null) {
                entr.getValue().setSpecies(spec);
                continue;
            }
            spec = ExSpecList.getPredefinedSpecies(entr.getKey().getString("SPEC_ID", true));
            if (spec != null) {
                entr.getValue().setSpecies(ExSpecList.getPredefinedSpecies(entr.getKey().getString("SPEC_ID", true)));
                continue;
            }
            entr.getValue().setSpecies(null);
        }
        super.postProcess();
    }

    private static Output parseOutput(FDSParseRecord rec, int defSampleFreq) {
        int sampleFreq = rec.getInteger("SAMPLING_FACTOR", true);
        if (sampleFreq == -1) {
            sampleFreq = defSampleFreq;
        }
        return new Output(rec.getUnitDouble("AGE", true), sampleFreq);
    }
}

