/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import pyrosim.Intl;
import pyrosim.domain.ExSpec;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParsingInfo;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.Util;
import thunderheadeng.io.TeciLogging;

public class FDS6QuantityMap {
    private static final Logger LOGGER = Logger.getLogger(FDS6QuantityMap.class.getSimpleName());
    public static final String CONTROL = "CONTROL";
    public static final String SPOT_OBSCURATION = "spot obscuration";
    private final Map<Quantity, String> d_pyroToFDSMap = new HashMap<Quantity, String>();
    private final Map<String, IQuantity> d_fdsToPyroPredefMap = new HashMap<String, IQuantity>();
    private final Map<String, List<Quantity>> d_fdsToPyroObjMap = new HashMap<String, List<Quantity>>();
    private final Map<String, IQuantity> d_fdsToPyroPredefFlowMap = new HashMap<String, IQuantity>();
    private final Map<String, List<Quantity>> d_fdsToPyroObjFlowMap = new HashMap<String, List<Quantity>>();
    private final Map<Quantity, Map<Byte, Quantity>> d_legacyFlowMap = new HashMap<Quantity, Map<Byte, Quantity>>();

    private static Stream<String> getLegacyNames(Quantity q) {
        return switch (q) {
            case Quantity.ABSORPTION_COEFFICIENT -> Stream.of("ABSORPTION_COEFFICIENT");
            case Quantity.EXTINCTION_COEFFICIENT -> Stream.of("extinction coefficient");
            case Quantity.MIXTURE_FRACTION -> Stream.of("MIXTURE_FRACTION");
            case Quantity.VISIBILITY -> Stream.of("visibility");
            case Quantity.ADIABATIC_SURFACE_TEMPERATURE -> Stream.of("ADIABATIC_SURFACE_TEMPERATURE");
            case Quantity.BACK_WALL_TEMPERATURE -> Stream.of("BACK_WALL_TEMPERATURE");
            case Quantity.BURNING_RATE -> Stream.of("BURNING_RATE");
            case Quantity.CONVECTIVE_FLUX -> Stream.of("CONVECTIVE_FLUX");
            case Quantity.GAUGE_HEAT_FLUX -> Stream.of("GAUGE_HEAT_FLUX");
            case Quantity.HEAT_FLUX -> Stream.of("HEAT_FLUX");
            case Quantity.HEAT_TRANSFER_COEFFICIENT -> Stream.of("HEAT_TRANSFER_COEFFICIENT");
            case Quantity.INCIDENT_HEAT_FLUX -> Stream.of("INCIDENT_HEAT_FLUX");
            case Quantity.INSIDE_WALL_TEMPERATURE -> Stream.of("INSIDE_WALL_TEMPERATURE");
            case Quantity.NORMAL_VELOCITY -> Stream.of("NORMAL_VELOCITY");
            case Quantity.PRESSURE_COEFFICIENT -> Stream.of("PRESSURE_COEFFICIENT");
            case Quantity.RADIATIVE_FLUX -> Stream.of("RADIATIVE_FLUX");
            case Quantity.WALL_TEMPERATURE -> Stream.of("WALL_TEMPERATURE");
            case Quantity.WALL_THICKNESS -> Stream.of("WALL_THICKNESS");
            case Quantity.PATH_OBSCURATION -> Stream.of("path obscuration");
            case Quantity.CHEMISTRY_ITER -> Stream.of("CHEMISTRY SUBITERATIONS");
            default -> Stream.empty();
        };
    }

    public FDS6QuantityMap() {
        for (Quantity quantity : Quantity.values()) {
            if (quantity.fdsName.isBlank()) continue;
            Stream<String> names = Stream.concat(Stream.of(quantity.fdsName), FDS6QuantityMap.getLegacyNames(quantity));
            List<String> namesList = names.toList();
            if (quantity.getNumArgs() > 0) {
                this.mapObj(quantity, namesList);
                continue;
            }
            this.mapPredef(quantity, namesList);
        }
        this.mapFlowPredef(Quantity.VOLUME_FLOW_X, Quantity.U_VELOCITY);
        this.mapFlowPredef(Quantity.VOLUME_FLOW_Y, Quantity.V_VELOCITY);
        this.mapFlowPredef(Quantity.VOLUME_FLOW_Z, Quantity.W_VELOCITY);
        this.mapFlowPredef(Quantity.VOLUME_FLOW_BOUNDARY, Quantity.NORMAL_VELOCITY);
        this.mapFlowPredef(Quantity.ENTHALPY_FLOW_X, Quantity.ENTHALPY_FLUX_X);
        this.mapFlowPredef(Quantity.ENTHALPY_FLOW_Y, Quantity.ENTHALPY_FLUX_Y);
        this.mapFlowPredef(Quantity.ENTHALPY_FLOW_Z, Quantity.ENTHALPY_FLUX_Z);
        this.mapFlowPredef(Quantity.ENTHALPY_FLOW_WALL, Quantity.ENTHALPY_FLUX_WALL);
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW, Quantity.NOSPEC_MASS_FLUX);
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_WALL, Quantity.NOSPEC_MASS_FLUX_WALL);
        this.mapFlowPredef(Quantity.NOSPEC_TOTAL_MASS_FLOW_WALL, Quantity.NOSPEC_TOTAL_MASS_FLUX_WALL);
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_X, Quantity.NOSPEC_MASS_FLUX_X);
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_Y, Quantity.NOSPEC_MASS_FLUX_Y);
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_Z, Quantity.NOSPEC_MASS_FLUX_Z);
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_X_TOTAL, Quantity.NOSPEC_MASS_FLUX_X_TOTAL);
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_Y_TOTAL, Quantity.NOSPEC_MASS_FLUX_Y_TOTAL);
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_Z_TOTAL, Quantity.NOSPEC_MASS_FLUX_Z_TOTAL);
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_X_ADVECTIVE, Quantity.NOSPEC_MASS_FLUX_X_ADVECTIVE);
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_Y_ADVECTIVE, Quantity.NOSPEC_MASS_FLUX_Y_ADVECTIVE);
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_Z_ADVECTIVE, Quantity.NOSPEC_MASS_FLUX_Z_ADVECTIVE);
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_X_DIFFUSIVE, Quantity.NOSPEC_MASS_FLUX_X_DIFFUSIVE);
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_Y_DIFFUSIVE, Quantity.NOSPEC_MASS_FLUX_Y_DIFFUSIVE);
        this.mapFlowPredef(Quantity.NOSPEC_MASS_FLOW_Z_DIFFUSIVE, Quantity.NOSPEC_MASS_FLUX_Z_DIFFUSIVE);
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW, Quantity.SPEC_MASS_FLUX);
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_WALL, Quantity.SPEC_MASS_FLUX_WALL);
        this.mapFlowObj(Quantity.SPEC_TOTAL_MASS_FLOW_WALL, Quantity.SPEC_TOTAL_MASS_FLUX_WALL);
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_X, Quantity.SPEC_MASS_FLUX_X);
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_Y, Quantity.SPEC_MASS_FLUX_Y);
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_Z, Quantity.SPEC_MASS_FLUX_Z);
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_X_TOTAL, Quantity.SPEC_MASS_FLUX_X_TOTAL);
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_Y_TOTAL, Quantity.SPEC_MASS_FLUX_Y_TOTAL);
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_Z_TOTAL, Quantity.SPEC_MASS_FLUX_Z_TOTAL);
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_X_ADVECTIVE, Quantity.SPEC_MASS_FLUX_X_ADVECTIVE);
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_Y_ADVECTIVE, Quantity.SPEC_MASS_FLUX_Y_ADVECTIVE);
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_Z_ADVECTIVE, Quantity.SPEC_MASS_FLUX_Z_ADVECTIVE);
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_X_DIFFUSIVE, Quantity.SPEC_MASS_FLUX_X_DIFFUSIVE);
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_Y_DIFFUSIVE, Quantity.SPEC_MASS_FLUX_Y_DIFFUSIVE);
        this.mapFlowObj(Quantity.SPEC_MASS_FLOW_Z_DIFFUSIVE, Quantity.SPEC_MASS_FLUX_Z_DIFFUSIVE);
        this.constructLegacyFlowMap();
        Consumer<Map> sortLookupMapQuants = map -> map.values().forEach(list -> {
            if (list.size() == 1) {
                return;
            }
            list.sort((q1, q2) -> -Integer.compare(q1.requiredTypes.length, q2.requiredTypes.length));
        });
        sortLookupMapQuants.accept(this.d_fdsToPyroObjFlowMap);
        sortLookupMapQuants.accept(this.d_fdsToPyroObjMap);
    }

    private void constructLegacyFlowMap() {
        HashMap<Byte, Quantity> volGas = new HashMap<Byte, Quantity>();
        volGas.put((byte)0, Quantity.VOLUME_FLOW_X);
        volGas.put((byte)1, Quantity.VOLUME_FLOW_Y);
        volGas.put((byte)2, Quantity.VOLUME_FLOW_Z);
        HashMap<Byte, Quantity> volSolid = new HashMap<Byte, Quantity>();
        volSolid.put((byte)0, Quantity.VOLUME_FLOW_BOUNDARY);
        volSolid.put((byte)1, Quantity.VOLUME_FLOW_BOUNDARY);
        volSolid.put((byte)2, Quantity.VOLUME_FLOW_BOUNDARY);
        HashMap<Byte, Quantity> massGas = new HashMap<Byte, Quantity>();
        massGas.put((byte)0, Quantity.NOSPEC_MASS_FLOW_X);
        massGas.put((byte)1, Quantity.NOSPEC_MASS_FLOW_Y);
        massGas.put((byte)2, Quantity.NOSPEC_MASS_FLOW_Z);
        HashMap<Byte, Quantity> massSolid = new HashMap<Byte, Quantity>();
        massSolid.put((byte)0, Quantity.NOSPEC_MASS_FLOW);
        massSolid.put((byte)1, Quantity.NOSPEC_MASS_FLOW);
        massSolid.put((byte)2, Quantity.NOSPEC_MASS_FLOW);
        HashMap<Byte, Quantity> heatGas = new HashMap<Byte, Quantity>();
        heatGas.put((byte)0, Quantity.ENTHALPY_FLOW_X);
        heatGas.put((byte)1, Quantity.ENTHALPY_FLOW_Y);
        heatGas.put((byte)2, Quantity.ENTHALPY_FLOW_Z);
        HashMap<Byte, Quantity> heatSolid = new HashMap<Byte, Quantity>();
        heatSolid.put((byte)0, Quantity.ENTHALPY_FLOW_WALL);
        heatSolid.put((byte)1, Quantity.ENTHALPY_FLOW_WALL);
        heatSolid.put((byte)2, Quantity.ENTHALPY_FLOW_WALL);
        this.d_legacyFlowMap.put(Quantity.VOLUME_FLOW, volGas);
        this.d_legacyFlowMap.put(Quantity.VOLUME_FLOW_WALL, volSolid);
        this.d_legacyFlowMap.put(Quantity.MASS_FLOW, massGas);
        this.d_legacyFlowMap.put(Quantity.MASS_FLOW_WALL, massSolid);
        this.d_legacyFlowMap.put(Quantity.HEAT_FLOW, heatGas);
        this.d_legacyFlowMap.put(Quantity.HEAT_FLOW_WALL, heatSolid);
    }

    private void mapObj(Quantity quantity, List<String> fdsNames) {
        for (String fdsName : fdsNames) {
            this.putObjName(this.d_fdsToPyroObjMap, fdsName, quantity);
        }
        this.d_pyroToFDSMap.put(quantity, fdsNames.getFirst());
    }

    private void mapFlowObj(Quantity quantity, Quantity nonIntegrated) {
        assert (quantity != nonIntegrated);
        String fdsName = nonIntegrated.fdsName;
        this.putObjName(this.d_fdsToPyroObjFlowMap, fdsName, quantity);
        this.d_pyroToFDSMap.put(quantity, fdsName);
    }

    private void mapPredef(Quantity quantity, List<String> fdsNames) {
        assert (quantity.getNumArgs() == 0);
        this.mapPredef(quantity.create(), fdsNames);
    }

    private void mapPredef(IQuantity quantity, List<String> fdsNames) {
        for (String fdsName : fdsNames) {
            this.putName(this.d_fdsToPyroPredefMap, fdsName, quantity);
        }
        if (quantity.get().getNumArgs() == 0) {
            this.d_pyroToFDSMap.put(quantity.get(), fdsNames.getFirst());
        }
    }

    private void mapFlowPredef(Quantity quantity, Quantity nonIntegrated) {
        assert (quantity.getNumArgs() == 0);
        this.mapFlowPredef(quantity.create(), nonIntegrated);
    }

    private void mapFlowPredef(IQuantity quantity, Quantity nonIntegrated) {
        assert (quantity.get() != nonIntegrated);
        String fdsName = nonIntegrated.fdsName;
        this.putName(this.d_fdsToPyroPredefFlowMap, fdsName, quantity);
        if (quantity.get().getNumArgs() == 0) {
            this.d_pyroToFDSMap.put(quantity.get(), fdsName);
        }
    }

    private void putName(Map<String, IQuantity> map, String fdsName, IQuantity q) {
        if (map.containsKey(fdsName)) {
            TeciLogging.log(LOGGER, Level.INFO, "[Quantity: %s] Duplicate FDS name. '%s' is already mapped to Quantity:'%s'. Quantity:'%s' will be added as another possible quantity.", q.get().name, fdsName, map.get((Object)fdsName).get().name, q.get().name);
        }
        map.put(fdsName, q);
    }

    private void putObjName(Map<String, List<Quantity>> map, String fdsName, Quantity q) {
        map.computeIfAbsent(fdsName, n -> new ArrayList(3)).add(q);
    }

    public IQuantity parseFlowQuantity(FDSParsingInfo parseInfo, FDSParseRecord rec, String quantKey, String partIdKey, String specIdKey, String matIdKey, String ductIdKey, String nodeIdKey, boolean quantityRequired) throws FDSRecordFormatException {
        String quantName = rec.getString(quantKey);
        if (quantName == null) {
            if (quantityRequired) {
                throw new FDSRecordFormatException(rec, Intl.intl("Quantity missing."));
            }
            return null;
        }
        Object partId = partIdKey == null ? null : rec.get(partIdKey);
        Object specId = specIdKey == null ? null : rec.get(specIdKey);
        Object matId = matIdKey == null ? null : rec.get(matIdKey);
        Object ductId = ductIdKey == null ? null : rec.get(ductIdKey);
        Object nodeId = nodeIdKey == null ? null : rec.get(nodeIdKey);
        return this.parseFlowQuantity(parseInfo, rec, quantName, partId, specId, matId, ductId, nodeId);
    }

    public IQuantity parseQuantity(FDSParsingInfo parseInfo, FDSParseRecord rec, String quantKey, String partIdKey, String specIdKey, String matIdKey, String ductIdKey, String nodeIdKey, boolean quantityRequired) throws FDSRecordFormatException {
        String quantName = rec.getString(quantKey);
        if (quantName == null) {
            if (quantityRequired) {
                throw new FDSRecordFormatException(rec, Intl.intl("Quantity missing."));
            }
            return null;
        }
        Object partId = partIdKey == null ? null : rec.get(partIdKey);
        Object specId = specIdKey == null ? null : rec.get(specIdKey);
        Object matId = matIdKey == null ? null : rec.get(matIdKey);
        Object ductId = ductIdKey == null ? null : rec.get(ductIdKey);
        Object nodeId = nodeIdKey == null ? null : rec.get(nodeIdKey);
        return this.parseQuantity(parseInfo, rec, quantName, partId, specId, matId, ductId, nodeId);
    }

    public IQuantity parseFlowQuantity(FDSParsingInfo parseInfo, FDSParseRecord rec, String quantName, Object partId, Object specId, Object matId, Object ductId, Object nodeId) throws FDSRecordFormatException {
        return this.parseMappedQuantity(parseInfo, rec, quantName, partId, specId, matId, ductId, nodeId, key -> this.d_fdsToPyroObjFlowMap.getOrDefault(key, List.of()).stream(), key -> this.d_fdsToPyroPredefFlowMap.get(key));
    }

    public IQuantity parseMappedQuantity(FDSParsingInfo parseInfo, FDSParseRecord rec, String quantName, Object partId, Object specId, Object matId, Object ductId, Object nodeId, Function<String, ? extends Stream<Quantity>> objGetter, Function<String, IQuantity> staticGetter) throws FDSRecordFormatException {
        IQuantity quantity = FDS6QuantityMap.tryParseObjQuantity(parseInfo, rec, quantName, partId, specId, matId, ductId, nodeId, objGetter, staticGetter);
        if (quantity != null) {
            return quantity;
        }
        return staticGetter.apply(quantName);
    }

    public IQuantity parseQuantity(FDSParsingInfo parseInfo, FDSParseRecord rec, String quantName, Object partId, Object specId, Object matId, Object ductId, Object nodeId) throws FDSRecordFormatException {
        IQuantity quantity = this.parseMappedQuantity(parseInfo, rec, quantName, partId, specId, matId, ductId, nodeId, key -> this.d_fdsToPyroObjMap.getOrDefault(key, List.of()).stream(), key -> this.d_fdsToPyroPredefMap.get(key));
        if (quantity != null) {
            return quantity;
        }
        ExSpec spec = parseInfo.findObject(ExSpec.class, quantName);
        if (spec != null) {
            return Quantity.SPEC_MASS_FRACTION.create(spec);
        }
        Material mat = parseInfo.findObject(Material.class, quantName);
        if (mat != null) {
            return Quantity.MATL_DENSITY.create(mat);
        }
        throw new FDSRecordFormatException(rec, String.format(Intl.intl("Unknown quantity: %s"), quantName));
    }

    private static IQuantity tryParseObjQuantity(FDSParsingInfo parseInfo, FDSParseRecord rec, String quantName, Object partId, Object specId, Object matId, Object ductId, Object nodeId, Function<String, ? extends Stream<Quantity>> objGetter, Function<String, IQuantity> staticGetter) throws FDSRecordFormatException {
        FDSRecordFormatException[] exc = new FDSRecordFormatException[]{null};
        boolean[] allArgsMissing = new boolean[]{true};
        Optional<ObjectQuantity> foundObjQuant = objGetter.apply(quantName).map(objQuantity -> {
            int count;
            ArrayList<String> missingTypes = new ArrayList<String>();
            ArrayList<IPyroObject> objects = new ArrayList<IPyroObject>(objQuantity.getNumArgs());
            for (int m = 0; m < objQuantity.getNumArgs(); m += count) {
                Class<? extends IPyroObject> type = objQuantity.requiredTypes[m];
                count = 1;
                for (int n = m + 1; n < objQuantity.getNumArgs() && objQuantity.requiredTypes[n].equals(type); ++n) {
                    ++count;
                }
                Object ids = FDS6QuantityMap.getObjVal(type, partId, specId, matId, ductId, nodeId);
                for (int n = 0; n < count; ++n) {
                    if (ids == null) {
                        String typeDesc = TVEntryPoints.ep(type).getCategoryName(null);
                        missingTypes.add(typeDesc);
                        objects.add(null);
                        continue;
                    }
                    String id = ids instanceof String ? (String)ids : (String)((List)ids).get(n);
                    try {
                        IPyroObject obj = FDS6QuantityMap.findObject(parseInfo, rec, type, objQuantity.typeFilters[m + n], id, quantName);
                        objects.add(obj);
                        continue;
                    }
                    catch (FDSRecordFormatException e) {
                        if (exc[0] == null) {
                            exc[0] = e;
                        }
                        String typeDesc = TVEntryPoints.ep(type).getCategoryName(null);
                        missingTypes.add(typeDesc);
                    }
                }
            }
            if (!missingTypes.isEmpty()) {
                allArgsMissing[0] = allArgsMissing[0] & missingTypes.size() == objQuantity.requiredTypes.length;
                String typeDesc = (String)missingTypes.get(0);
                String msg = String.format(Intl.intl("Use of quantity, %1$s, requires a %2$s to be specified."), quantName, typeDesc);
                if (exc[0] == null) {
                    exc[0] = new FDSRecordFormatException(rec, msg);
                }
                return null;
            }
            assert (objects.size() == objQuantity.requiredTypes.length);
            return objQuantity.create(objects.toArray(new IPyroObject[objects.size()]));
        }).filter(quant -> quant != null).findFirst();
        if (foundObjQuant.isPresent()) {
            return foundObjQuant.get();
        }
        IQuantity staticQuantity = staticGetter.apply(quantName);
        if (staticQuantity != null && allArgsMissing[0]) {
            return staticQuantity;
        }
        if (exc[0] != null) {
            throw exc[0];
        }
        return null;
    }

    private static IPyroObject findObject(FDSParsingInfo parseInfo, FDSParseRecord rec, Class type, Predicate filter, String id, String quantName) throws FDSRecordFormatException {
        String typeDesc = TVEntryPoints.ep(type).getCategoryName(null);
        Object obj = parseInfo.findObject(type, id);
        if (obj == null) {
            String msg = String.format(Intl.intl("Could not find %1$s, %2$s, needed for quantity, %3$s."), typeDesc, id, quantName);
            throw new FDSRecordFormatException(rec, msg);
        }
        if (!filter.test(obj)) {
            String msg = String.format(Intl.intl("Invalid %1$s for quantity, %2$s: %3$s"), typeDesc, quantName, filter.toString());
            throw new FDSRecordFormatException(rec, msg);
        }
        return obj;
    }

    public void renderQuantity(FDSRenderRecord rec, String quantKey, String partIdKey, String specIdKey, String matIdKey, String ductIdKey, String nodeIdKey, IQuantity msr) {
        if (msr.get() == Quantity.MATL_DENSITY) {
            rec.setValue(quantKey, Util.getName(((ObjectQuantity)msr).objects[0]));
            return;
        }
        String quantity = this.d_pyroToFDSMap.get((Object)msr.get());
        assert (quantity != null);
        rec.setValue(quantKey, quantity);
        if (msr instanceof ObjectQuantity) {
            int count;
            ObjectQuantity om = (ObjectQuantity)msr;
            Quantity q = msr.get();
            for (int m = 0; m < q.getNumArgs(); m += count) {
                Class<? extends IPyroObject> type = q.requiredTypes[m];
                count = 1;
                for (int n = m + 1; n < q.getNumArgs() && q.requiredTypes[n].equals(type); ++n) {
                    ++count;
                }
                ArrayList<String> ids = new ArrayList<String>(count);
                for (int n = 0; n < count; ++n) {
                    Object obj = om.objects[m + n];
                    ids.add(((INamed)obj).getName());
                }
                String objIdKey = FDS6QuantityMap.getObjVal(type, partIdKey, specIdKey, matIdKey, ductIdKey, nodeIdKey);
                if (objIdKey == null || ids.size() <= 0) continue;
                FDSRecordSpec.Field fld = rec.getSpec().fields.get(objIdKey);
                ArrayList<String> objVal = fld instanceof FDSRecordSpec.ListFld ? ids : ids.get(0);
                rec.setValue(objIdKey, objVal);
            }
        }
    }

    public Stream<Quantity> getQuantity(String quantityName) {
        IQuantity predef = this.d_fdsToPyroPredefMap.get(quantityName);
        if (predef != null) {
            return Stream.of(predef.get());
        }
        return this.d_fdsToPyroObjMap.getOrDefault(quantityName, List.of()).stream();
    }

    public String getFDSName(Quantity msr) {
        return this.d_pyroToFDSMap.get((Object)msr);
    }

    private static <T> T getObjVal(Class type, T part, T spec, T mat, T duct, T node) {
        if (ExSpec.class.isAssignableFrom(type)) {
            return spec;
        }
        if (Particle.class.isAssignableFrom(type)) {
            return part;
        }
        if (Material.class.isAssignableFrom(type)) {
            return mat;
        }
        if (HvacNode.class.isAssignableFrom(type)) {
            return node;
        }
        if (HvacDuct.class.isAssignableFrom(type)) {
            return duct;
        }
        return null;
    }

    public static boolean isLegacyFlowQuantity(String quant) {
        return quant.startsWith(Quantity.MASS_FLOW.fdsName) || quant.startsWith(Quantity.HEAT_FLOW.fdsName) || quant.startsWith(Quantity.VOLUME_FLOW.fdsName);
    }

    public boolean isFlowMeasureQuantity(String quant) {
        return this.d_fdsToPyroObjFlowMap.containsKey(quant) || this.d_fdsToPyroPredefFlowMap.containsKey(quant);
    }

    public Quantity convertLegacyFlowQuantity(Quantity legQ, byte plane) {
        return this.d_legacyFlowMap.get((Object)legQ).get(plane);
    }
}

