/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.util.LinkedHashMap;
import java.util.Map;

public class SyntaxMap {
    public static final String SYMBOL_KEYWORD = "SYMBOL_KEYWORD";
    public static final String SYMBOL_SPECIAL = "SYMBOL_SPECIAL";
    public static final String SYMBOL_REFERENCE = "SYMBOL_REFERENCE";
    public static final String SYMBOL_VALUE = "SYMBOL_VALUE";
    public static final String SYMBOL_COMMENT = "SYMBOL_COMMENT";
    public static final String SYMBOL_EMPTY = "SYMBOL_EMPTY";
    private Map<Integer, String> d_map = new LinkedHashMap<Integer, String>();
    private int d_currIx = 0;

    public void put(int key, String value) {
        this.d_map.put(key, value);
        this.d_currIx = key == 0 ? key : key + 1;
    }

    public void putSmart(int offset, String value) {
        this.d_currIx += offset;
        this.d_map.put(this.d_currIx, value);
    }

    public int getCurrIx() {
        return this.d_currIx;
    }

    public Map<Integer, String> getMap() {
        return new LinkedHashMap<Integer, String>(this.d_map);
    }

    public void mergeSyntaxToRoot(SyntaxMap branch) {
        Map<Integer, String> branchSource = branch.getMap();
        int lastEntr = Integer.MAX_VALUE;
        for (Map.Entry<Integer, String> branchEntr : branchSource.entrySet()) {
            lastEntr = branchEntr.getKey() + this.d_currIx;
            this.d_map.put(lastEntr, branchEntr.getValue());
        }
        if (lastEntr != Integer.MAX_VALUE) {
            this.d_currIx = lastEntr;
        }
    }

    public void clearSyntax() {
        this.d_map.clear();
        this.d_currIx = 0;
    }
}

