/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import pyrosim.io.fds.LineScanner;
import thunderheadeng.geometry.AABox;

public class SMVReader {
    public SMVInfo read(InputStream in) throws IOException {
        LineScanner scanner = new LineScanner(in);
        try {
            ArrayList<MeshInfo> meshes = new ArrayList<MeshInfo>();
            int numMeshes = Integer.MAX_VALUE;
            MeshInfo currMesh = new MeshInfo();
            Runnable checkMeshComplete = () -> {
                if (currMesh.isComplete()) {
                    if (currMesh.isValid()) {
                        meshes.add(currMesh.clone());
                    }
                    currMesh.reset();
                }
            };
            Type type = Type.UNKNOWN;
            while (meshes.size() < numMeshes) {
                String typeStr;
                try {
                    typeStr = scanner.next();
                }
                catch (NoSuchElementException e) {
                    break;
                }
                try {
                    type = Type.valueOf(typeStr.trim().toUpperCase());
                }
                catch (Throwable t) {
                    type = Type.UNKNOWN;
                }
                switch (type.ordinal()) {
                    case 1: {
                        scanner.nextLine();
                        numMeshes = this.readNMeshes(scanner);
                        break;
                    }
                    case 2: {
                        currMesh.name = scanner.nextLine().trim();
                        this.readGrid(scanner);
                        checkMeshComplete.run();
                        break;
                    }
                    case 3: {
                        currMesh.bounds = this.readPDIM(scanner);
                        checkMeshComplete.run();
                    }
                }
            }
            return new SMVInfo(meshes);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    private int readNMeshes(LineScanner scanner) {
        int nmeshes = scanner.nextInt();
        scanner.nextLine();
        return nmeshes;
    }

    private void readGrid(LineScanner scanner) {
        scanner.nextLine();
    }

    private AABox readPDIM(LineScanner scanner) {
        double[] vals = scanner.nextDoubles(6);
        return new AABox(vals[0], vals[2], vals[4], vals[1], vals[3], vals[5]);
    }

    public static class MeshInfo
    implements Cloneable {
        public String name;
        public AABox bounds;

        protected MeshInfo clone() {
            try {
                return (MeshInfo)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public boolean isComplete() {
            return this.name != null && this.bounds != null;
        }

        public boolean isValid() {
            return this.isComplete() && this.bounds.isValid();
        }

        public void reset() {
            this.name = null;
            this.bounds = null;
        }
    }

    private static enum Type {
        UNKNOWN,
        NMESHES,
        GRID,
        PDIM;

    }

    public static class SMVInfo {
        public final List<MeshInfo> meshes;

        public SMVInfo(List<MeshInfo> meshes) {
            this.meshes = meshes;
        }
    }
}

