/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.Grid;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.Serialized;
import pyrosim.domain.SimParams;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.surf.AirFlow;
import pyrosim.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.domain.boundcond.surf.DefaultSurface;
import pyrosim.domain.boundcond.surf.GeneralSurfDesc;
import pyrosim.domain.boundcond.surf.HeatTransfer3D;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ISlip;
import pyrosim.domain.boundcond.surf.ISurfDesc;
import pyrosim.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.boundcond.surf.SpeciesInjection;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.SurfDescStatic;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.TempRegulation;
import pyrosim.domain.bridge.IBridgeObj;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.LatchCtrl;
import pyrosim.domain.controls.LogicOps.ADblCompareOp;
import pyrosim.domain.controls.LogicOps.AIntCompareOp;
import pyrosim.domain.controls.LogicOps.ALogicOp;
import pyrosim.domain.controls.LogicOps.AndOp;
import pyrosim.domain.controls.LogicOps.DblGreaterThanOp;
import pyrosim.domain.controls.LogicOps.DblLessThanOp;
import pyrosim.domain.controls.LogicOps.IntEqualOp;
import pyrosim.domain.controls.LogicOps.IntGreaterThanOp;
import pyrosim.domain.controls.LogicOps.IntLessThanOp;
import pyrosim.domain.controls.LogicOps.IntNotEqualOp;
import pyrosim.domain.controls.LogicOps.NotOp;
import pyrosim.domain.controls.LogicOps.OrOp;
import pyrosim.domain.controls.MathOps.AMathOp;
import pyrosim.domain.controls.MathOps.MultiplyOp;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.ControlValueDevice;
import pyrosim.domain.devices.FreePointGeom;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.detectors.CableFailDetector;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.devices.measurers.FEDMeasurer;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.GaugeHeatFluxMeasurer;
import pyrosim.domain.devices.measurers.IMeasurer;
import pyrosim.domain.devices.measurers.MeasureOutInfo;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.Sprinkler;
import pyrosim.domain.devices.statistics.IStatGeom;
import pyrosim.domain.devices.statistics.StatisticsDevc;
import pyrosim.domain.evac.Pers;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.geom.EvacProps;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.hvac.AHvacGeomComponent;
import pyrosim.domain.hvac.HvacAircoil;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacFan;
import pyrosim.domain.hvac.HvacLeak;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.hvac.IHvacGeomComp;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.output.Isosurface;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.Slice;
import pyrosim.domain.output.SliceList;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityStat;
import pyrosim.domain.quantity.StaticQuantity;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.scenario.Scenario;
import pyrosim.domain.signals.DoubleOutPin;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.Util;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.zones.Leak;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.FDSStringRenderer;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.CorrRenderer;
import pyrosim.io.fds.v6.renderers.DoorRenderer;
import pyrosim.io.fds.v6.renderers.EntrRenderer;
import pyrosim.io.fds.v6.renderers.EvacRenderer;
import pyrosim.io.fds.v6.renderers.EvhoRenderer;
import pyrosim.io.fds.v6.renderers.EvssRenderer;
import pyrosim.io.fds.v6.renderers.ExitRenderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PersRenderer;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import pyrosim.io.fds.v6.renderers.SingletonRecords;
import pyrosim.io.fds.v6.renderers.SurfaceRenderer;
import pyrosim.legacy.v109.domain.devices.hvac.HvacDevice;
import pyrosim.legacy.v126.domain.output.GasMsrStat;
import pyrosim.legacy.v126.domain.output.SolidMsrStat;
import pyrosim.legacy.v131.domain.boundcond.surf.TempRegulation;
import pyrosim.legacy.v141.domain.controls.SumOp;
import pyrosim.legacy.v154.mv.ModelView;
import pyrosim.legacy.v160.domain.boundcond.surf.HeatTransfer3DSurfDesc;
import pyrosim.legacy.v172.domain.output.AMsrStat;
import pyrosim.legacy.v172.domain.output.IMeasurementStat;
import pyrosim.legacy.v172.domain.output.StatGeom;
import pyrosim.legacy.v172.domain.output.StatisticMgr;
import pyrosim.legacy.v49.domain.Variant;
import pyrosim.legacy.v76.domain.geom.Vent;
import pyrosim.legacy.v78.domain.geom.FireSpread;
import pyrosim.legacy.v78.domain.geom.Vent;
import pyrosim.legacy.v86.geom.TexCoordGenerator;
import pyrosim.legacy.v96.domain.NamesDB;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.unitsystem.EnglishUS;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.TeciIO;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.MutableInt;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.ResultsIdGen;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class PyroSimObjectInputStream
extends ObjectInputStream {
    public static final int CURR_VERSION = 173;
    public static final int TECI_VERSION = 19;
    public static final byte[] FORMAT_CODE;
    private final int d_version;
    private final int d_teciVersion;
    private String d_revision;
    private final TeciIO d_teciio;
    private final WarningReport<Warning> d_warnings = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0);
    private final NavigableMap<Integer, Map<String, Class>> d_classLookup;
    private final NavigableMap<Integer, List<Pair<Unit, Unit>>> d_unitReplacements;
    private final boolean d_resetResultsIds;
    private final Optional<File> d_file;
    private Set<Unit> d_obscurationUnits;

    public PyroSimObjectInputStream(InputStream arg0, boolean resetResultsIds) throws IOException {
        this(arg0, resetResultsIds, Optional.empty());
    }

    public PyroSimObjectInputStream(InputStream arg0, boolean resetResultsIds, Optional<File> srcFile) throws IOException {
        super(arg0);
        this.d_resetResultsIds = resetResultsIds;
        this.d_file = srcFile;
        String versionString = this.readVersionStringCompat();
        this.d_version = Integer.parseInt(versionString.substring(3));
        if (this.d_version < 30) {
            this.d_teciVersion = 1;
            this.d_revision = "";
        } else {
            this.d_teciVersion = this.readInt();
            try {
                this.d_revision = (String)this.readObject();
            }
            catch (ClassNotFoundException e) {
                assert (false);
                this.d_revision = "";
            }
        }
        this.enableResolveObject(true);
        this.d_unitReplacements = new TreeMap<Integer, List<Pair<Unit, Unit>>>();
        this.initUnitReplacements();
        this.d_classLookup = new TreeMap<Integer, Map<String, Class>>();
        this.initLegClasses();
        this.d_teciio = new TeciIO(this.d_teciVersion, this.d_unitReplacements.tailMap(this.d_version, false).values());
    }

    public static int getVersion(ObjectInputStream is) {
        return is instanceof PyroSimObjectInputStream ? ((PyroSimObjectInputStream)is).getVersion() : Integer.MAX_VALUE;
    }

    public String readVersionStringCompat() throws IOException {
        String formatStr = new String(FORMAT_CODE);
        byte[] readbytes = new byte[FORMAT_CODE.length];
        this.read(readbytes);
        String testStrA = new String(readbytes);
        if (testStrA.length() == formatStr.length()) {
            return testStrA;
        }
        ByteArrayOutputStream allBytes = new ByteArrayOutputStream();
        allBytes.write(readbytes);
        for (int i : IntStream.range(0, 16).toArray()) {
            byte[] addByte = new byte[1];
            this.read(addByte);
            allBytes.write(addByte);
            String testStrN = allBytes.toString(StandardCharsets.UTF_8);
            if (testStrN.length() < formatStr.length()) continue;
            if (testStrN.length() == formatStr.length()) {
                try {
                    int ver = Integer.parseInt(testStrN.substring(3));
                    if (ver >= 0 && ver <= 9999) {
                        System.out.printf("[%s] Consumed %s additional bytes.%n", "readVersionStringCompat()", i + 1);
                        return testStrN;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (testStrN.length() <= formatStr.length()) continue;
            throw new RuntimeException(Intl.intl("PSM file version string decoding error."));
        }
        throw new RuntimeException(Intl.intl("Unable to decode PSM file version string."));
    }

    public boolean getResetResultsIds() {
        return this.d_resetResultsIds;
    }

    public static boolean getResetResultsId(ObjectInputStream is) {
        return PyroSimObjectInputStream.getVersion(is) < 147 || !(is instanceof PyroSimObjectInputStream) || ((PyroSimObjectInputStream)is).getResetResultsIds();
    }

    public boolean canOpenVersion() {
        return this.d_version >= 49;
    }

    public boolean isNewer() {
        return this.d_version > 173;
    }

    public boolean isSupported() {
        if (this.d_version <= 50) {
            return false;
        }
        if (this.d_version == 51) {
            return true;
        }
        return true;
    }

    public String getRevision() {
        return this.d_revision;
    }

    public int getVersion() {
        return this.d_version;
    }

    public Serialized readModel() throws IOException, ClassNotFoundException {
        System.out.printf("loading model (PyroSim Version: %d; Teci Version: %d)%n", this.d_version, this.d_teciVersion);
        Serialized ser = (Serialized)this.readObject();
        this.initSerFields(ser);
        this.updateData(ser);
        this.fixSurfRefs(ser);
        return ser;
    }

    private void removeObjsFromInvalidGroups(Serialized ser) {
        LinkedHashMap<IPyroObject, List<Composite>> objGroups = new LinkedHashMap<IPyroObject, List<Composite>>();
        PyroSimObjectInputStream.mapParents(ser.obstructions, objGroups);
        HashSet<Composite> affectedParents = new HashSet<Composite>();
        for (Map.Entry entry : objGroups.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            for (int m = 1; m < ((List)entry.getValue()).size(); ++m) {
                Composite parent = (Composite)((List)entry.getValue()).get(m);
                parent.remove((IPyroObject)entry.getKey());
                affectedParents.add(parent);
            }
        }
        System.out.printf("Removed duplicate objects from %d groups.%n", affectedParents.size());
    }

    private static void mapParents(Composite parent, Map<IPyroObject, List<Composite>> parents) {
        for (IPyroObject obj : parent.getMembers(IPyroObject.class)) {
            List<Composite> objParents = parents.get(obj);
            if (objParents == null) {
                objParents = new ArrayList<Composite>(2);
                parents.put(obj, objParents);
            }
            if (!objParents.contains(parent)) {
                objParents.add(parent);
            }
            if (!(obj instanceof Composite)) continue;
            PyroSimObjectInputStream.mapParents((Composite)obj, parents);
        }
    }

    private void initSerFields(Serialized ser) {
        if (this.d_version < 78) {
            ser.initNewFields(true, "views", "viewNames");
        }
        if (this.d_version < 100) {
            ser.initNewFields(true, "slices3d");
        }
        if (this.d_version < 104) {
            ser.initNewFields(true, "slice3dNames");
        }
        if (this.d_version < 109) {
            ser.initNewFields(true, "hvacLeakNames");
        }
        if (this.d_version < 135) {
            ser.initNewFields(true, "scenarios", "scenarioNames");
        }
        if (this.d_version < 152) {
            ser.initNewFields(true, "sliceNames");
        }
        if (this.d_version < 163) {
            ser.initNewFields(true, "hvacNodeOut", "hvacDuctOut");
        }
        if (this.d_version < 165) {
            ser.initNewFields(true, "modelCheckNames");
            ser.initNewFields(true, "modelCheckManager");
        }
        if (this.d_version < 168) {
            ser.initNewFields(true, "tagMgr");
            ser.initNewFields(true, "tagNames");
        }
    }

    private void updateData(Serialized ser) {
        if (this.d_version < 173) {
            PyroSimObjectInputStream.convertPre173Statistics(ser, this.d_warnings);
        }
        if (this.d_version < 143) {
            PyroSimObjectInputStream.reinterpretPre143MultiplyOps(ser);
        }
        if (this.d_version < 67) {
            this.addPeriodicSurface(ser);
        }
        if (this.d_version < 52) {
            this.removePre52deprecatedQuants(ser);
            this.fixPre52ThermocoupleQuants(ser);
        }
        if (this.d_version < 54) {
            this.removePre54HRRPUA(ser);
            this.fixPre54OperatingPressure(ser);
            this.fixPre54DefaultSurfs(ser);
        }
        if (this.d_version < 56) {
            this.migratePre56TempRegToAdvanced(ser);
        }
        if (this.d_version < 57) {
            this.fixPre57Species(ser);
        }
        if (this.d_version < 58) {
            // empty if block
        }
        if (this.d_version < 59) {
            this.fixPre59Species(ser);
        }
        if (this.d_version < 60) {
            this.removePre60InitVaporFlux(ser);
        }
        if (this.d_version < 62) {
            this.reorganizePre62HVAC(ser);
        }
        if (this.d_version < 63) {
            this.updatePre63Surfs(ser);
        }
        if (this.d_version < 65) {
            this.updatePre65Surfs(ser);
        }
        if (this.d_version < 66) {
            this.removeSolidPartSizeDist(ser);
        }
        if (this.d_version < 68) {
            this.fixPre68SprayModels(ser);
        }
        if (this.d_version < 69) {
            this.updatePre69Adiabatic(ser);
        }
        if (this.d_version < 72) {
            this.fixPre72ClonedPins(ser);
        }
        if (this.d_version < 73) {
            this.fixPre73SprayModels(ser);
        }
        if (this.d_version < 75) {
            this.fixPre75FireSpreadVents(ser);
        }
        if (this.d_version < 76) {
            this.fixPre76SliceDuplicates(ser);
        }
        if (this.d_version == 76) {
            this.fix76BurnerVents(ser);
        }
        if (this.d_version < 80) {
            PyroSimObjectInputStream.fixMissingJets(ser, this.d_warnings);
        }
        if (this.d_version < 82) {
            this.fixPre82FanCurves(ser);
        }
        if (this.d_version < 83) {
            this.fixPre83CableFailDetector(ser, this.d_warnings);
        }
        if (this.d_version < 84) {
            PyroSimObjectInputStream.fixPre84Evac(ser, this.d_warnings);
        }
        if (this.d_version < 85) {
            PyroSimObjectInputStream.fds_6_3_update(ser, this.d_warnings);
        }
        if (this.d_version < 86) {
            PyroSimObjectInputStream.manuallyConvertPre86AtmGradUnits(ser, this.d_warnings);
        }
        if (this.d_version < 87) {
            PyroSimObjectInputStream.generatePre87Elements(ser, this.d_warnings);
        }
        if (this.d_version < 88) {
            this.reorganizePre88UV(ser);
        }
        if (this.d_version < 89) {
            this.fixPre89ImportedSurfs(ser);
            this.fixPre89BadObstSurfs(ser);
        }
        if (this.d_version < 91) {
            PyroSimObjectInputStream.warnPre91SingleSprkDryPipe(ser, this.d_warnings);
        }
        if (this.d_version < 96) {
            PyroSimObjectInputStream.warnPre92HvacCtrls(ser, this.d_warnings);
        }
        if (this.d_version < 94) {
            PyroSimObjectInputStream.warnPre94OutflowSurfs(ser, this.d_warnings);
        }
        if (this.d_version < 95) {
            PyroSimObjectInputStream.fixPre95MultipleReacs(ser, this.d_warnings);
        }
        if (this.d_version < 99) {
            PyroSimObjectInputStream.bakePre99Transforms(ser, this.d_warnings);
        }
        if (this.d_version < 102) {
            PyroSimObjectInputStream.udpateDefaultDTs3d(ser, this.d_warnings);
        }
        if (this.d_version < 103) {
            PyroSimObjectInputStream.fixDanglingGridRefs(ser, this.d_warnings);
        }
        if (this.d_version < 105) {
            PyroSimObjectInputStream.purgeMutantDevices(ser, this.d_warnings);
        }
        if (this.d_version < 106) {
            PyroSimObjectInputStream.fixPre106CyclicControls(ser, this.d_warnings);
        }
        if (this.d_version < 107) {
            PyroSimObjectInputStream.fixPre107SurfDepDevcs(ser, this.d_warnings);
        }
        if (this.d_version < 111) {
            PyroSimObjectInputStream.fixPre111HvacRefs(ser, this.d_warnings);
        }
        if (this.d_version < 112) {
            PyroSimObjectInputStream.fixPre112HvacDevices(ser, this.d_warnings);
        }
        if (this.d_version < 114) {
            PyroSimObjectInputStream.fixPre114SprayAndSprinklerLinkModels(ser, this.d_warnings);
        }
        if (this.d_version >= 113 && this.d_version < 116) {
            PyroSimObjectInputStream.warnPre116WindRecords(ser, this.d_warnings);
        }
        if (this.d_version < 117) {
            PyroSimObjectInputStream.fixPre117PredefLumped(ser, this.d_warnings);
        }
        if (this.d_version < 119) {
            PyroSimObjectInputStream.updatePre119BackgroundSpecies(ser, this.d_warnings);
        }
        if (this.d_version < 120) {
            PyroSimObjectInputStream.updatePre120PredefSoot(ser, this.d_warnings);
        }
        if (this.d_version < 121) {
            PyroSimObjectInputStream.updatePre121ProductsSpec(ser, this.d_warnings);
        }
        if (this.d_version < 122) {
            PyroSimObjectInputStream.removePre122deprecatedQuants(ser, this.d_warnings);
        }
        if (this.d_version < 125) {
            PyroSimObjectInputStream.warnPre125deprecatedField(ser, this.d_warnings);
        }
        if (this.d_version < 126) {
            PyroSimObjectInputStream.updatePre126Surfs(ser, this.d_warnings);
        }
        if (this.d_version < 128) {
            PyroSimObjectInputStream.fixPre128Leaks(ser, this.d_warnings);
        }
        if (this.d_version < 131) {
            PyroSimObjectInputStream.fixPre131AspiratorUnits(ser, this.d_warnings);
        }
        if (this.d_version < 133) {
            PyroSimObjectInputStream.fixPre133ThermalBCs(ser, this.d_warnings);
        }
        if (this.d_version < 134) {
            PyroSimObjectInputStream.fixPre134SurfaceProps(ser, this.d_warnings);
        }
        if (this.d_version < 135) {
            PyroSimObjectInputStream.fixPre135ScenarioData(ser, this.d_warnings);
        }
        if (this.d_version < 138) {
            PyroSimObjectInputStream.fixPre138ViscousWallUnitsQuantity(ser, this.d_warnings);
        }
        if (this.d_version < 139) {
            PyroSimObjectInputStream.fixPre139CpuPerTimeStepQuantity(ser, this.d_warnings);
        }
        if (this.d_version < 140) {
            PyroSimObjectInputStream.warnPre140PeriodicWindVent(ser, this.d_warnings);
        }
        if (this.d_version < 142) {
            PyroSimObjectInputStream.prunePre142ControlValueDevices(ser, this.d_warnings);
        }
        if (this.d_version < 144) {
            PyroSimObjectInputStream.removePre144HRRPUAQuantFromDevice(ser, this.d_warnings);
        }
        if (this.d_version < 149) {
            PyroSimObjectInputStream.fixPre149DefaultSurfs(ser, this.d_warnings);
        }
        if (this.d_version < 150) {
            PyroSimObjectInputStream.fixPre150FlowMeasurers(ser, this.d_warnings);
        }
        if (this.d_version < 151) {
            PyroSimObjectInputStream.fixPre151SurfaceReferences(ser, this.d_warnings);
        }
        if (this.d_version < 152) {
            PyroSimObjectInputStream.fixPre152SliceNames(ser, this.d_warnings);
        }
        if (this.d_version < 153) {
            PyroSimObjectInputStream.prunePre153LatchControls(ser, this.d_warnings);
        }
        if (this.d_version < 154) {
            PyroSimObjectInputStream.updatePre154HvacLeakDefaultLossValue(ser, this.d_warnings);
        }
        if (this.d_version < 156 && this.d_version != 154 && this.d_version != 155) {
            PyroSimObjectInputStream.updateVolumeSliceNamesPre156(ser, this.d_warnings);
        }
        if (this.d_version < 159) {
            PyroSimObjectInputStream.updatePre159SimpleChemistry(ser, this.d_warnings);
        }
        if (this.d_version < 160) {
            PyroSimObjectInputStream.warnPre160SootHFraction(ser, this.d_warnings);
        }
        if (this.d_version < 162) {
            PyroSimObjectInputStream.fixPre162SolidParticles(ser, this.d_warnings);
        }
        if (this.d_version < 163) {
            PyroSimObjectInputStream.removePre163HvacQuant(ser, this.d_warnings);
        }
        if (this.d_version < 164) {
            PyroSimObjectInputStream.updatePre164FEDDevices(ser, this.d_warnings);
        }
        if (this.d_version < 166) {
            PyroSimObjectInputStream.notifyPre166Wind(ser, this.d_warnings);
        }
        if (this.d_version < 169) {
            PyroSimObjectInputStream.fixPre169DanglingSpecRef(ser, this.d_warnings);
        }
        if (this.d_version < 170) {
            PyroSimObjectInputStream.fixPre170FEDPlot3DQuants(ser, this.d_warnings);
        }
        if (this.d_version < 171) {
            PyroSimObjectInputStream.fixPre171FlowMeasurerQuants(ser, this.d_warnings);
        }
        if (this.d_version < 172) {
            PyroSimObjectInputStream.fixPre172SurfLayeredHt3d(ser, this.d_warnings);
        }
        this.fixBadSpecInj(ser);
        PyroSimObjectInputStream.fixBadDeviceRefs(ser);
        PyroSimObjectInputStream.removeBadQuantityRefs(ser, this.d_warnings);
        if (this.d_version < 147) {
            PyroSimObjectInputStream.regeneratePre147ResultsIds(this.d_file, ser, this.d_warnings);
        }
    }

    private void removePre52deprecatedQuants(Serialized ser) {
        PyroSimObjectInputStream.removePre52deprecatedQuants(ser, this.d_warnings);
    }

    public static void removePre52deprecatedQuants(Serialized ser, WarningReport<Warning> warns) {
        PyroMod tempMod = new PyroMod(ser, false, false);
        LinkedHashSet<StaticQuantity> massLoss = new LinkedHashSet<StaticQuantity>();
        massLoss.add(Quantity.MASS_LOSS.create());
        ArrayList<IMeasurer> toRemove = new ArrayList<IMeasurer>();
        block0: for (IMeasurer devc : ((APyroObject)ser.devices).flatten(IMeasurer.class)) {
            for (int m = 0; m < devc.getNumMeasurements(); ++m) {
                if (!massLoss.contains(devc.getQuantity(m))) continue;
                toRemove.add(devc);
                continue block0;
            }
        }
        boolean quantityReferenced = !toRemove.isEmpty();
        LinkedHashSet<IQuantity> bndfQuants = new LinkedHashSet<IQuantity>(ser.boundaryOutput.getQuantities());
        if (bndfQuants.removeAll(massLoss)) {
            quantityReferenced = true;
            ser.boundaryOutput.setQuantities(bndfQuants);
        }
        if (quantityReferenced) {
            warns.addWarning(new Warning(Intl.intl("Quantity MASS_LOSS is no longer supported."), Intl.intl("All references to MASS_LOSS have been removed.")));
        }
        PyroSimObjectInputStream.removeObjs(tempMod, tempMod.getDependencies(new IPyroObject[0]), toRemove, warns);
        ser.setDomain(null);
    }

    private void fixPre52ThermocoupleQuants(Serialized ser) {
        PyroSimObjectInputStream.fixPre52ThermocoupleQuants(ser, this.d_warnings);
    }

    public static void fixPre52ThermocoupleQuants(Serialized ser, WarningReport<Warning> warns) {
        PyroMod tempMod = new PyroMod(ser, false, false);
        LinkedHashSet<StaticQuantity> thermocouple = new LinkedHashSet<StaticQuantity>();
        thermocouple.add(Quantity.THERMOCOUPLE.create());
        ArrayList<APyroObject> toRemove = new ArrayList<APyroObject>();
        for (Slice slice : ser.slices.flatten()) {
            if (!thermocouple.contains(slice.getQuantity())) continue;
            toRemove.add(slice);
        }
        for (Isosurface isof : ser.isosurfaces.flatten()) {
            if (!thermocouple.contains(isof.getQuantity())) continue;
            toRemove.add(isof);
        }
        boolean quantityReferenced = !toRemove.isEmpty();
        LinkedHashSet<IQuantity> pl3dQuants = new LinkedHashSet<IQuantity>(ser.plot3d.getQuantities());
        if (pl3dQuants.removeAll(thermocouple)) {
            quantityReferenced = true;
            ser.plot3d.setQuantities(pl3dQuants);
        }
        if (quantityReferenced) {
            warns.addWarning(new Warning(Intl.intl("Quantity THERMOCOUPLE is only supported as a device."), Intl.intl("All invalid references to THERMOCOUPLE have been removed.")));
        }
        PyroSimObjectInputStream.removeObjs(tempMod, tempMod.getDependencies(new IPyroObject[0]), toRemove, warns);
        ser.setDomain(null);
    }

    private void removePre54HRRPUA(Serialized ser) {
        PyroSimObjectInputStream.removePre54HRRPUA(ser, this.d_warnings);
    }

    public static void removePre54HRRPUA(Serialized ser, WarningReport<Warning> warns) {
        LinkedHashSet<IQuantity> pl3dQuants;
        PyroMod tempMod = new PyroMod(ser, false, false);
        LinkedHashSet<StaticQuantity> hrrpua = new LinkedHashSet<StaticQuantity>();
        hrrpua.add(Quantity.HRRPUA.create());
        ArrayList<APyroObject> toRemove = new ArrayList<APyroObject>();
        for (Slice slice : ser.slices.flatten()) {
            if (!hrrpua.contains(slice.getQuantity())) continue;
            toRemove.add(slice);
        }
        for (Isosurface isof : ser.isosurfaces.flatten()) {
            if (!hrrpua.contains(isof.getQuantity())) continue;
            toRemove.add(isof);
        }
        boolean quantityReferenced = !toRemove.isEmpty();
        LinkedHashSet<IQuantity> bndfQuants = new LinkedHashSet<IQuantity>(ser.boundaryOutput.getQuantities());
        if (bndfQuants.removeAll(hrrpua)) {
            quantityReferenced = true;
            ser.boundaryOutput.setQuantities(bndfQuants);
        }
        if ((pl3dQuants = new LinkedHashSet<IQuantity>(ser.plot3d.getQuantities())).removeAll(hrrpua)) {
            quantityReferenced = true;
            ser.plot3d.setQuantities(pl3dQuants);
        }
        if (quantityReferenced) {
            warns.addWarning(new Warning(Intl.intl("Quantity HRRPUA is only supported as a device."), Intl.intl("All invalid references to HRRPUA have been removed.")));
        }
        PyroSimObjectInputStream.removeObjs(tempMod, tempMod.getDependencies(new IPyroObject[0]), toRemove, warns);
        ser.setDomain(null);
    }

    private void fixPre54OperatingPressure(Serialized ser) {
        for (SprayModel spMdl : ser.sprayModels.flatten()) {
            SprayModel.FlowRate flowRate = spMdl.getFlowRate();
            if (flowRate instanceof SprayModel.PressurizedFlowRate) {
                SprayModel.PressurizedFlowRate pflowRateOld = (SprayModel.PressurizedFlowRate)flowRate;
                spMdl.setFlowRate(new SprayModel.PressurizedFlowRate(SIUS.newud(pflowRateOld.d_opPressure.getValueNoUnit(), 12), pflowRateOld.d_kFactor, pflowRateOld.d_ramp));
                this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Spray Model %s used an Operating Pressure of the wrong unit."), spMdl.getName()), String.format(Intl.intl("Please verify values for %s are correct."), spMdl.getName())));
                continue;
            }
            if (!(flowRate instanceof SprayModel.VaryingFlowRate)) continue;
            SprayModel.VaryingFlowRate vflowRateOld = (SprayModel.VaryingFlowRate)flowRate;
            Ramp oldRamp = vflowRateOld.d_pressureRamp;
            List<Ramp.Entry> oldRecs = oldRamp.getRecords();
            ArrayList<Ramp.Entry> newRecs = new ArrayList<Ramp.Entry>();
            boolean convertedUnit = false;
            for (Ramp.Entry entry : oldRecs) {
                UnitDouble f = entry.f;
                if (entry.f.getUnit().equals(SI.PASCAL)) {
                    f = new UnitDouble(entry.f.getValueNoUnit(), NonSI.ATMOSPHERE);
                    convertedUnit = true;
                } else if (entry.f.getUnit().equals(NonSI.BAR)) {
                    double fval = entry.f.getValue(SI.PASCAL);
                    f = new UnitDouble(fval, NonSI.ATMOSPHERE);
                    convertedUnit = true;
                }
                newRecs.add(new Ramp.Entry(entry.t, f));
            }
            if (convertedUnit) {
                this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Spray Model, %s, contained incorrectly stored units for Pipe Pressure Ramp."), spMdl.getName()), String.format(Intl.intl("Attempted to auto-correct. Verify values for %s are correct."), spMdl.getName())));
            }
            Ramp newRamp = new Ramp(newRecs, oldRamp.getDefaultInput(), oldRamp.getInput(), 12);
            spMdl.setFlowRate(new SprayModel.VaryingFlowRate(newRamp, vflowRateOld.d_opPressure, vflowRateOld.d_kFactor, vflowRateOld.d_rate, vflowRateOld.d_ramp));
        }
    }

    private void fixPre54DefaultSurfs(Serialized ser) {
        PyroSimObjectInputStream.fixPre54DefaultSurfs(ser, this.d_warnings);
    }

    public static void fixPre54DefaultSurfs(Serialized ser, WarningReport<Warning> warns) {
        SimParams.Misc miscData = ser.simParams.getMisc();
        Surface defSurf = miscData.getSurfDefault();
        if (defSurf.isPredefined() && !defSurf.equals(ser.surfmgr.get("INERT"))) {
            miscData.setSurfDefault((Surface)ser.surfmgr.get("INERT"));
            warns.addWarning(new Warning(Intl.intl("The following surfaces cannot be set as default: OPEN, MIRROR, HVAC."), Intl.intl("Default Surface set as INERT")));
        }
    }

    private void migratePre56TempRegToAdvanced(Serialized ser) {
        String addRecs = PyroSimObjectInputStream.migrateBurnerTempRegToAdvanced(ser.surfmgr.flatten(), this.d_warnings);
        ser.unprocessedRecords = ser.unprocessedRecords + addRecs;
    }

    private void fixPre57Species(Serialized ser) {
        HashMap<String, Ramp> ramps = new HashMap<String, Ramp>();
        FDSNameMap nameMap = new FDSNameMap();
        for (ExSpec spec : ser.exSpecs.flatten()) {
            if (ExSpecList.isPredefinedSpecies(spec.getName())) {
                if (!ExSpecList.equalsPredefinedSpecies(spec)) {
                    String rampName;
                    this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports modifying predefined species."), String.format(Intl.intl("Non-default fields for Species %s moved to Advanced Parameters."), spec.getName())));
                    HashMap<String, String> newCustomProps = new HashMap<String, String>();
                    ExSpec oneTrue = ExSpecList.getPredefinedSpecies(spec.getName());
                    if (!spec.getMolecularWeight().equals(oneTrue.getMolecularWeight())) {
                        newCustomProps.put("MW", Double.toString(spec.getMolecularWeight().getValue(SI.GRAM.divide(SI.MOLE))));
                        spec.setMolecularWeight(oneTrue.getMolecularWeight());
                    }
                    if (!spec.getChemFormula().equals(oneTrue.getChemFormula())) {
                        newCustomProps.put("FORMULA", "'" + spec.getChemFormula() + "'");
                        spec.setChemFormula(oneTrue.getChemFormula());
                    }
                    ExSpec.PrimitiveParams specParams = spec.getPrimParams();
                    ExSpec.PrimitiveParams trueParams = oneTrue.getPrimParams();
                    if (!specParams.getDiffusivity().isDefault()) {
                        if (specParams.getDiffusivity().isRamp()) {
                            rampName = RampRenderer.createID(nameMap, spec.getName(), "RAMP_D");
                            ramps.put(rampName, (Ramp)specParams.getDiffusivity().val);
                            newCustomProps.put("RAMP_D", "'" + rampName + "'");
                        } else {
                            newCustomProps.put("DIFFUSIVITY", Double.toString(((UnitDouble)specParams.getDiffusivity().val).getValue(SI.METER.pow(2).divide(SI.SECOND))));
                        }
                        specParams.setDiffusivity(Variant.def());
                    }
                    if (!specParams.getViscosity().isDefault()) {
                        if (specParams.getViscosity().isRamp()) {
                            rampName = RampRenderer.createID(nameMap, spec.getName(), "RAMP_MU");
                            ramps.put(rampName, (Ramp)specParams.getViscosity().val);
                            newCustomProps.put("RAMP_MU", "'" + rampName + "'");
                        } else {
                            newCustomProps.put("VISCOSITY", Double.toString(((UnitDouble)specParams.getViscosity().val).getValue(SI.KILOGRAM.divide(SI.METER.multiply(SI.SECOND)))));
                        }
                        specParams.setViscosity(Variant.def());
                    }
                    if (specParams.isSigmaLJSet()) {
                        newCustomProps.put("SIGMALJ", Double.toString(specParams.getSigmaLJ()));
                        specParams.setSigmaLJ(0.0, false);
                    }
                    if (specParams.isEpsilonKLJSet()) {
                        newCustomProps.put("EPSILONKLJ", Double.toString(specParams.getEpsilonKLJ()));
                        specParams.setEpsilonKLJ(0.0, false);
                    }
                    if (!specParams.getRadCalSurrogate().equals(trueParams.getRadCalSurrogate())) {
                        newCustomProps.put("RADCAL_ID", "'" + specParams.getRadCalSurrogate() + "'");
                        specParams.setRadCalSurrogate(trueParams.getRadCalSurrogate());
                    }
                    if (specParams.isAerosol()) {
                        newCustomProps.put("AEROSOL", ".TRUE.");
                        if (!specParams.getDensitySolid().equals(trueParams.getDensitySolid())) {
                            newCustomProps.put("DENSITY_SOLID", Double.toString(specParams.getDensitySolid().getValue(SI.KILOGRAM.divide(SI.METER.pow(3)))));
                            specParams.setDensitySolid(trueParams.getDensitySolid());
                        }
                        if (!specParams.getConductivitySolid().equals(trueParams.getConductivitySolid())) {
                            newCustomProps.put("CONDUCTIVITY_SOLID", Double.toString(specParams.getConductivitySolid().getValue(SI.WATT.divide(SI.KELVIN.multiply(SI.METER)))));
                            specParams.setConductivitySolid(trueParams.getConductivitySolid());
                        }
                        if (!specParams.getMeanDiameter().equals(trueParams.getMeanDiameter())) {
                            newCustomProps.put("MEAN_DIAMETER", Double.toString(specParams.getMeanDiameter().getValue(SI.METER)));
                            specParams.setMeanDiameter(trueParams.getMeanDiameter());
                        }
                    }
                    if (!specParams.getSpecHeat().isDefault()) {
                        if (specParams.getSpecHeat().isRamp()) {
                            rampName = RampRenderer.createID(nameMap, spec.getName(), "RAMP_CP");
                            ramps.put(rampName, (Ramp)specParams.getSpecHeat().val);
                            newCustomProps.put("RAMP_CP", "'" + rampName + "'");
                        } else {
                            newCustomProps.put("SPECIFIC_HEAT", Double.toString(((UnitDouble)specParams.getSpecHeat().val).getValue(SI.KILO(SI.JOULE).divide(SI.KILOGRAM.multiply(SI.KELVIN)))));
                        }
                        specParams.setSpecHeat(Variant.def());
                    }
                    if (specParams.isRefTempSet()) {
                        newCustomProps.put("REFERENCE_TEMPERATURE", Double.toString(specParams.getRefTemp().getValue(SI.CELSIUS)));
                        specParams.setRefTemp(trueParams.getRefTemp(), false);
                    }
                    if (specParams.isRefEnthalpySet() && specParams.getRefEnthalpy().isConstant()) {
                        newCustomProps.put("REFERENCE_ENTHALPY", Double.toString(((UnitDouble)specParams.getRefEnthalpy().val).getValue(SI.KILO(SI.JOULE).divide(SI.KILOGRAM))));
                        specParams.setRefEnthalpy(null);
                    }
                    if (!specParams.getSpecHeatLiquid().isDefault()) {
                        if (specParams.getSpecHeatLiquid().isRamp()) {
                            rampName = RampRenderer.createID(nameMap, spec.getName(), "RAMP_CP_L");
                            ramps.put(rampName, (Ramp)specParams.getSpecHeatLiquid().val);
                            newCustomProps.put("RAMP_CP_L", "'" + rampName + "'");
                        } else {
                            newCustomProps.put("SPECIFIC_HEAT_LIQUID", Double.toString(((UnitDouble)specParams.getSpecHeat().val).getValue(SI.KILO(SI.JOULE).divide(SI.KILOGRAM.multiply(SI.KELVIN)))));
                        }
                        specParams.setViscosity(Variant.def());
                    }
                    if (specParams.isDensityLiquidSet()) {
                        newCustomProps.put("DENSITY_LIQUID", Double.toString(((UnitDouble)specParams.getDensityLiquid().val).getValue(SI.KILOGRAM.divide(SI.METER.pow(3)))));
                        specParams.setDensityLiquid(null);
                    }
                    if (specParams.isVapTempSet()) {
                        newCustomProps.put("VAPORIZATION_TEMPERATURE", Double.toString(((UnitDouble)specParams.getVapTemp().val).getValue(SI.CELSIUS)));
                        specParams.setVapTemp(null);
                    }
                    if (specParams.isMeltingTempSet()) {
                        newCustomProps.put("MELTING_TEMPERATURE", Double.toString(((UnitDouble)specParams.getMeltTemp().val).getValue(SI.CELSIUS)));
                        specParams.setMeltingTemp(null);
                    }
                    if (specParams.isHoVaporizationSet()) {
                        newCustomProps.put("HEAT_OF_VAPORIZATION", Double.toString(((UnitDouble)specParams.getHoVaporization().val).getValue(SI.KILO(SI.JOULE).divide(SI.KILOGRAM))));
                        specParams.setHoVaporization(null);
                    }
                    if (specParams.isEoFormationSet()) {
                        newCustomProps.put("ENTHALPY_OF_FORMATION", Double.toString(((UnitDouble)specParams.getEoFormation().val).getValue(SI.KILO(SI.JOULE).divide(SI.KILOGRAM))));
                        specParams.setEoFormation(null);
                    }
                    if (specParams.isHVRefTempSet()) {
                        newCustomProps.put("H_V_REFERENCE_TEMPERATURE", Double.toString(((UnitDouble)specParams.getHVRefTemp().val).getValue(SI.CELSIUS)));
                        specParams.setHVRefTemp(null);
                    }
                    if (spec.getComposition().size() > 0) {
                        this.fixAirReferences(ser.exSpecs.get("AIR"), spec, this.d_warnings);
                        int i = 1;
                        for (Map.Entry<ExSpec, Double> entr : spec.getComposition().entrySet()) {
                            newCustomProps.put(String.format("%s(%d)", "SPEC_ID", i), "'" + entr.getKey().getName() + "'");
                            if (spec.getType() == 2) {
                                newCustomProps.put(String.format("%s(%d)", "MASS_FRACTION", i), entr.getValue().toString());
                            } else if (spec.getType() == 3) {
                                newCustomProps.put(String.format("%s(%d)", "VOLUME_FRACTION", i), entr.getValue().toString());
                            }
                            ++i;
                        }
                        spec.setComposition(0, new LinkedHashMap<ExSpec, Double>());
                    }
                    CustomFDSProps newProps = CustomFDSProps.get(newCustomProps);
                    spec.setCustomFDSProps(CustomFDSProps.union(newProps, spec.getCustomFDSProps()));
                }
                spec.setType(0);
            }
            this.fixAirReferences(ser.exSpecs.get("AIR"), spec, this.d_warnings);
            this.fixEnthalpyOfFormation(spec);
        }
        if (!ramps.isEmpty()) {
            this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports modifying predefined species."), Intl.intl("Unsupported ramps moved to Additional Records.")));
            FDSRenderProps renderProps = PyroSim.getFdsRenderPropsNullSafe();
            PinConnectionRenderer pinConnRenderer = new PinConnectionRenderer(nameMap);
            FDSStringRenderer stringRenderer = new FDSStringRenderer(renderProps);
            RampRenderer.render(stringRenderer, ramps, pinConnRenderer);
            ser.unprocessedRecords = ser.unprocessedRecords + stringRenderer.toString();
        }
        ser.exSpecs.addDefaults();
    }

    private void fixAirReferences(ExSpec airSpec, ExSpec lumpedSpec, WarningReport<Warning> warns) {
        if (lumpedSpec.getType() != 2 && lumpedSpec.getType() != 3) {
            return;
        }
        if (airSpec == null) {
            return;
        }
        Map<ExSpec, Double> compositionMap = lumpedSpec.getComposition();
        if (compositionMap.containsKey(airSpec)) {
            warns.addWarning(new Warning(Intl.intl("The lumped species AIR can not be used as a component of another lumped species."), String.format(Intl.intl("AIR removed from the composition of species %s."), lumpedSpec.getName())));
            compositionMap.remove(airSpec);
        }
    }

    private void fixEnthalpyOfFormation(ExSpec spec) {
        Variant v;
        if (spec.getType() == 1 && (v = spec.getPrimParams().getEoFormation()).isConstant()) {
            double val = ((UnitDouble)v.val).getValue(SI.KILO(SI.JOULE).divide(SI.KILOGRAM));
            spec.getPrimParams().setEoFormation(new UnitDouble(val, SI.KILO(SI.JOULE).divide(SI.MOLE)));
        }
    }

    private void fixPre59Species(Serialized ser) {
        PyroSimObjectInputStream.fixPre59Species(ser, this.d_warnings);
    }

    private static void fixPre59Species(Serialized ser, WarningReport<Warning> warns) {
        ArrayList<ExSpec> toBeRemoved = new ArrayList<ExSpec>();
        for (ExSpec spec : ser.exSpecs.flatten()) {
            if (!ExSpecList.equalsPredefinedSpecies(spec)) continue;
            toBeRemoved.add(spec);
        }
    }

    private void removePre60InitVaporFlux(Serialized ser) {
        for (Material mat : ser.matmgr.flatten()) {
            if (!(mat.getPyrolysis() instanceof LiquidPyrolysis)) continue;
            HashMap<String, String> newAdvanced = new HashMap<String, String>();
            newAdvanced.put("INITIAL_VAPOR_FLUX", Double.toString(((LiquidPyrolysis)mat.getPyrolysis()).d_iniVaporFlux.getValue(SIUS.unit(73))));
            CustomFDSProps newProps = CustomFDSProps.get(newAdvanced);
            mat.setCustomFDSProps(CustomFDSProps.union(newProps, mat.getCustomFDSProps()));
            this.d_warnings.addWarning(new Warning("The variable Initial Vapor Flux is no longer supported.", String.format(Intl.intl("INITIAL_VAPOR_FLUX for material %s moved to Advanced Parameters."), mat.getName())));
        }
    }

    private void reorganizePre62HVAC(Serialized ser) {
        Collection<IHvacGeomComp> hvacGeom = ((APyroObject)ser.hvacSystem).flatten(IHvacGeomComp.class);
        if (hvacGeom.isEmpty()) {
            return;
        }
        hvacGeom = new ArrayList<IHvacGeomComp>(hvacGeom);
        Composite root = ser.obstructions.newGroup(Intl.intl("HVAC"));
        ser.obstructions.add(root);
        IdentityHashMap<Composite, Composite> parentMap = new IdentityHashMap<Composite, Composite>();
        parentMap.put(ser.hvacSystem, root);
        new PyroMod(ser, false, false);
        for (IHvacGeomComp comp : hvacGeom) {
            IPyroObject oldParent = comp.getParent();
            if (!(oldParent instanceof Composite)) continue;
            Composite newParent = PyroSimObjectInputStream.getCopyParent(ser, parentMap, comp);
            ((Composite)oldParent).remove(comp);
            newParent.add(comp);
        }
        ser.hvacSystem.prune(Filters.accept(parentMap.keySet()));
        ser.setDomain(null);
        this.d_warnings.addWarning(new Warning(String.format(Intl.intl("HVAC ducts and nodes are now stored in the \"%s\" group."), ser.obstructions.getName()), String.format(Intl.intl("Ducts and nodes have been moved to \"%s\"."), ser.obstructions.getName() + "->" + root.getName())));
    }

    private static Composite getCopyParent(Serialized ser, Map<Composite, Composite> oldToNewMap, IPyroObject obj) {
        IPyroObject oldParentObj = obj.getParent();
        if (!(oldParentObj instanceof Composite)) {
            return ser.obstructions;
        }
        Composite oldParent = (Composite)oldParentObj;
        Composite newParent = oldToNewMap.get(oldParent);
        if (newParent != null) {
            return newParent;
        }
        Composite parentParent = PyroSimObjectInputStream.getCopyParent(ser, oldToNewMap, oldParent);
        newParent = parentParent.newGroup(pyrosim.util.Util.getName(oldParent));
        parentParent.add(newParent);
        oldToNewMap.put(oldParent, newParent);
        return newParent;
    }

    private void updatePre63Surfs(Serialized ser) {
        PyroSimObjectInputStream.updatePre63Surfs(ser, this.d_warnings);
    }

    public static void updatePre63Surfs(Serialized ser, WarningReport<Warning> warns) {
        for (Surface surf : ser.surfmgr.flatten()) {
            if (!(surf.getSurfDesc() instanceof SurfDescStatic.Adiabatic)) continue;
            LinkedHashMap<String, String> newCustomProps = new LinkedHashMap<String, String>(surf.getCustomFDSProps().getProps());
            SurfDescStatic.Adiabatic desc = (SurfDescStatic.Adiabatic)surf.getSurfDesc();
            if (desc.slip instanceof ISlip.FreeSlip) {
                newCustomProps.put("FREE_SLIP", ".TRUE.");
            } else if (desc.slip instanceof ISlip.NoSlip) {
                newCustomProps.put("NO_SLIP", ".TRUE.");
            } else if (((ISlip.RoughSlip)desc.slip).roughness.getValueNoUnit() > 0.0) {
                newCustomProps.put("ROUGHNESS", Double.toString(((ISlip.RoughSlip)desc.slip).roughness.getValue(SI.METER)));
            }
            if (surf.isPredefined()) {
                surf.setSurfDesc(new SurfDescStatic.Adiabatic());
                surf.setCustomFDSProps(CustomFDSProps.EMPTY);
            }
            if (newCustomProps.size() <= 0) continue;
            if (surf.isPredefined()) {
                warns.addWarning(new Warning(Intl.intl("The default surface ADIABATIC can no longer be modified."), Intl.intl("Slip conditions and custom properties removed from surface, ADIABATIC.")));
                continue;
            }
            surf.setCustomFDSProps(CustomFDSProps.get(newCustomProps));
            surf.setSurfDesc(new ConstantTempSurfDesc(pyrosim.domain.boundcond.surf.TempRegulation.newAdiabaticTR(Variant.def(), false), new ParticleInjection(), IGeometry.DEFAULT));
            warns.addWarning(new Warning(Intl.intl("Adiabatic surfaces are now specified using the Heater/Cooler type."), String.format(Intl.intl("Surface %s is being converted to a Heater/Cooler surface type."), surf.getName())));
        }
    }

    private void updatePre69Adiabatic(Serialized ser) {
        PyroSimObjectInputStream.updatePre69Adiabatic(ser, this.d_warnings);
    }

    public static void updatePre69Adiabatic(Serialized ser, WarningReport<Warning> warnings) {
        for (Surface surf : ser.surfmgr.flatten()) {
            if (!(surf.getSurfDesc() instanceof SurfDescStatic.Adiabatic) || surf.isPredefined()) continue;
            surf.setSurfDesc(new ConstantTempSurfDesc(pyrosim.domain.boundcond.surf.TempRegulation.newAdiabaticTR(Variant.def(), false), new ParticleInjection(), IGeometry.DEFAULT));
        }
    }

    private void updatePre65Surfs(Serialized ser) {
        PyroSimObjectInputStream.updatePre65Surfs(ser, this.d_warnings);
    }

    public static void updatePre65Surfs(Serialized ser, WarningReport<Warning> warnings) {
        for (Surface surf : ser.surfmgr.flatten()) {
            if (!(surf.getSurfDesc() instanceof LayeredSurfDesc)) continue;
            LayeredSurfDesc desc = (LayeredSurfDesc)surf.getSurfDesc();
            HashMap<String, String> newCustomProps = new HashMap<String, String>();
            if (desc.d_slip instanceof ISlip.FreeSlip) {
                newCustomProps.put("FREE_SLIP", ".TRUE.");
            } else if (desc.d_slip instanceof ISlip.NoSlip) {
                newCustomProps.put("NO_SLIP", ".TRUE.");
            } else if (((ISlip.RoughSlip)desc.d_slip).roughness.getValueNoUnit() > 0.0) {
                newCustomProps.put("ROUGHNESS", Double.toString(((ISlip.RoughSlip)desc.d_slip).roughness.getValue(SI.METER)));
            }
            if (newCustomProps.size() > 0) {
                surf.setCustomFDSProps(CustomFDSProps.union(surf.getCustomFDSProps(), CustomFDSProps.get(newCustomProps)));
                warnings.addWarning(new Warning(Intl.intl("Tangential boundary conditions can no longer be specified on layered surface."), String.format(Intl.intl("Tangential boundary conditions for %s moved to Advanced."), surf.getName())));
            }
            UnitDouble length = new UnitDouble(0.0, SI.METER);
            UnitDouble width = new UnitDouble(0.0, SI.METER);
            UnitDouble innerRad = new UnitDouble(0.0, SI.METER);
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(surf.getCustomFDSProps().getProps());
            if (props.containsKey("LENGTH")) {
                length = new UnitDouble(Double.parseDouble((String)props.get("LENGTH")), SI.METER);
            }
            if (props.containsKey("WIDTH")) {
                width = new UnitDouble(Double.parseDouble((String)props.get("WIDTH")), SI.METER);
            }
            if (props.containsKey("INNER_RADIUS")) {
                innerRad = new UnitDouble(Double.parseDouble((String)props.get("INNER_RADIUS")), SI.METER);
            }
            IGeometry newGeom = IGeometry.DEFAULT;
            if (desc.d_geom.equals((Object)LayeredSurfDesc.Geometry.CYLINDRICAL)) {
                newGeom = new IGeometry.Cylindrical(innerRad, null, Variant.constant(length));
                if (props.containsKey("INNER_RADIUS")) {
                    props.remove("INNER_RADIUS");
                }
                if (props.containsKey("LENGTH")) {
                    props.remove("LENGTH");
                }
            } else if (desc.d_geom.equals((Object)LayeredSurfDesc.Geometry.SPHERICAL)) {
                newGeom = new IGeometry.Spherical(innerRad, null);
                if (props.containsKey("INNER_RADIUS")) {
                    props.remove("INNER_RADIUS");
                }
            } else if (desc.d_geom.equals((Object)LayeredSurfDesc.Geometry.FLAT)) {
                newGeom = new IGeometry.Cartesian(length, width);
                if (props.containsKey("LENGTH")) {
                    props.remove("LENGTH");
                }
                if (props.containsKey("WIDTH")) {
                    props.remove("WIDTH");
                }
            }
            surf.setSurfDesc(new LayeredSurfDesc(newGeom, desc.d_iReac, desc.d_surfComp, desc.d_specInj, desc.d_partInj, desc.d_burnAway, desc.d_leakPath, pyrosim.domain.boundcond.surf.TempRegulation.newDefault()));
            surf.setCustomFDSProps(CustomFDSProps.get(props));
        }
    }

    private void removeSolidPartSizeDist(Serialized ser) {
        for (Particle part : ser.particles.flatten()) {
            if (part.getType() != Particle.Type.SOLID || part.getDistribution().equals((Object)Particle.Distribution.CONST)) continue;
            this.d_warnings.addWarning(new Warning(Intl.intl("Solid particles do not support size distribution."), Intl.intl("Size distribution data removed from solid particles.")));
            break;
        }
    }

    private void addPeriodicSurface(Serialized ser) {
        PyroSimObjectInputStream.addPeriodicSurface(ser, this.d_warnings);
    }

    public static void addPeriodicSurface(Serialized ser, WarningReport<Warning> warnings) {
        if (ser.surfmgr.get(PredefSurf.PERIODIC.toString()) == null) {
            ser.surfmgr.addPredefined();
        } else {
            NameGenerator ng = new NameGenerator("Surfaces");
            for (Surface surf : ser.surfmgr.flatten()) {
                ng.registerName(surf.getName());
            }
            String validName = ng.generateValidName(PredefSurf.PERIODIC.toString());
            Surface conflictSurf = (Surface)ser.surfmgr.get(PredefSurf.PERIODIC.toString());
            conflictSurf.setName(validName);
            ser.surfmgr.addPredefined();
            warnings.addWarning(new Warning(String.format(Intl.intl("The surface name %s conflicts with a reserved FDS surface name."), PredefSurf.PERIODIC.toString()), String.format(Intl.intl("User defined surface %s renamed as %s."), PredefSurf.PERIODIC.toString(), validName)));
        }
    }

    private void fixPre68SprayModels(Serialized ser) {
        PyroSimObjectInputStream.fixPre68SprayModels(ser, this.d_warnings);
    }

    public static void fixPre68SprayModels(Serialized ser, WarningReport<Warning> warnings) {
        for (SprayModel spray : ser.sprayModels.flatten()) {
            double long2;
            double long1;
            if (spray.getJets().size() > 1) continue;
            SprayModel.Jet jet = spray.getJets().get(0);
            if (jet.d_long1 == null || jet.d_long2 == null || !(Math.abs(Math.abs((long1 = jet.d_long1.getValue(NonSI.DEGREE_ANGLE)) - (long2 = jet.d_long2.getValue(NonSI.DEGREE_ANGLE))) - 360.0) < 1.0E-5)) continue;
            SprayModel.Jet newJet = new SprayModel.Jet(jet.d_velocity, jet.d_orificeDiam, 1.0, jet.d_lat1, jet.d_lat2);
            spray.setJets(Arrays.asList(newJet));
        }
    }

    private void fixPre72ClonedPins(Serialized ser) {
        PyroSimObjectInputStream.fixPre72ClonedPins(ser, this.d_warnings);
    }

    public static void fixPre72ClonedPins(Serialized ser, WarningReport<Warning> warnings) {
        for (ControlBridge ctrl : ser.controls.flatten()) {
            for (IOutPin iOutPin : ctrl.getOutputPins()) {
                if (iOutPin.getAttachedSource() == ctrl) continue;
                iOutPin.setSource(ctrl);
            }
        }
        for (IDevice devc : ser.devices.flatten()) {
            if (!(devc instanceof ISignalSource)) continue;
            for (IOutPin iOutPin : ((ISignalSource)((Object)devc)).getOutputPins()) {
                if (iOutPin.getAttachedSource() == devc) continue;
                iOutPin.setSource((ISignalSource)((Object)devc));
            }
        }
    }

    private void fixPre73SprayModels(Serialized ser) {
        PyroSimObjectInputStream.fixPre73SprayModels(ser, this.d_warnings);
    }

    public static void fixPre73SprayModels(Serialized ser, WarningReport<Warning> warns) {
        for (SprayModel model : ser.sprayModels.flatten()) {
            if (model.getJets().size() != 1) continue;
            ArrayList<SprayModel.Jet> newJets = new ArrayList<SprayModel.Jet>();
            for (SprayModel.Jet jet : model.getJets()) {
                if (jet.d_orificeDiam != null || jet.d_velocity != null) continue;
                newJets.add(new SprayModel.Jet(new UnitDouble(5.0, SI.METER.divide(SI.SECOND)), null, jet.d_flowFrac, jet.d_long1, jet.d_long2, jet.d_lat1, jet.d_lat2));
            }
            if (newJets.isEmpty()) continue;
            model.setJets(newJets);
        }
    }

    private void fixPre75FireSpreadVents(Serialized ser) {
        PyroSimObjectInputStream.fixPre75FireSpreadVents(ser, this.d_warnings);
    }

    public static void fixPre75FireSpreadVents(Serialized ser, WarningReport<Warning> warns) {
    }

    private void fixPre76SliceDuplicates(Serialized ser) {
        PyroSimObjectInputStream.fixPre76SliceDuplicates(ser, this.d_warnings);
    }

    public static void fixPre76SliceDuplicates(Serialized ser, WarningReport<Warning> warns) {
        new PyroMod(ser, false, false);
        HashMap items = new HashMap();
        for (Slice slc : ser.slices.flatten()) {
            PlanarSlice pslc = (PlanarSlice)slc;
            PlanarSlice.PlanarSliceHash hash = new PlanarSlice.PlanarSliceHash(pslc.getPlane(), pslc.getLocation(), pslc.getQuantity(), pslc.getName());
            if (items.get(hash) == null) {
                items.put(hash, new ArrayList());
            }
            ((List)items.get(hash)).add(slc);
        }
        for (List slcfList : items.values()) {
            slcfList.sort(new Comparator<Slice>(){

                @Override
                public int compare(Slice o1, Slice o2) {
                    if (o1.includeFlowVector() && !o2.includeFlowVector()) {
                        return 1;
                    }
                    if (!o1.includeFlowVector() && o2.includeFlowVector()) {
                        return -1;
                    }
                    return Integer.compare(o1.hashCode(), o2.hashCode());
                }
            });
            slcfList.remove(0);
            for (Slice slc : slcfList) {
                ((SliceList)slc.getParent()).remove(slc);
            }
        }
        ser.setDomain(null);
    }

    private void fix76BurnerVents(Serialized ser) {
        PyroSimObjectInputStream.fix76BurnerVents(ser, this.d_warnings);
    }

    private static void fix76BurnerVents(Serialized ser, WarningReport<Warning> warns) {
        for (IModelObj obj : ser.obstructions.flatten()) {
            if (!(obj instanceof pyrosim.domain.geom.Vent)) continue;
            pyrosim.domain.geom.Vent v = (pyrosim.domain.geom.Vent)obj;
            boolean fireSurf = false;
            for (Surface surf : v.getSurfaces()) {
                if (!pyrosim.domain.geom.Vent.isValidFireSpreadSurf(surf)) continue;
                fireSurf = true;
                break;
            }
            if (fireSurf && v.getFireSpreadRate() != null && v.getFireSpreadRate().getValueNoUnit() == 0.0) {
                v.setFireSpreadRate(null);
                warns.addWarning(new Warning(Intl.intl("The previous PyroSim version incorrectly assigned spread rate properties to burning vents."), String.format(Intl.intl("Spread rate set inactive for Vent %s."), v.getName())));
            }
            if (v.getRadius() == null || v.getRadius().getValueNoUnit() != 0.0) continue;
            v.setRadius(null);
        }
    }

    private void fixBadSpecInj(Serialized ser) {
        PyroSimObjectInputStream.fixBadSpecInj(ser, this.d_warnings);
    }

    private static void fixBadSpecInj(Serialized ser, WarningReport<Warning> warns) {
        for (Surface surf : ((APyroObject)ser.surfmgr).flatten(Surface.class)) {
            ISurfDesc newSurfDesc = null;
            if (surf.getSurfDesc() instanceof InFlowSurfDesc) {
                oldDesc = (InFlowSurfDesc)surf.getSurfDesc();
                if (oldDesc.d_airFlow.d_rate.specInj == null) continue;
                newSurfDesc = new InFlowSurfDesc(PyroSimObjectInputStream.fixBadSpecInj(oldDesc.d_airFlow), oldDesc.d_temperature);
            } else if (surf.getSurfDesc() instanceof BlowerSurfDesc) {
                oldDesc = (BlowerSurfDesc)surf.getSurfDesc();
                if (((BlowerSurfDesc)oldDesc).d_airFlow.d_rate.specInj == null) continue;
                newSurfDesc = new BlowerSurfDesc(((BlowerSurfDesc)oldDesc).d_tempReg, PyroSimObjectInputStream.fixBadSpecInj(((BlowerSurfDesc)oldDesc).d_airFlow), ((BlowerSurfDesc)oldDesc).d_partInj, ((BlowerSurfDesc)oldDesc).d_geometry);
            } else if (surf.getSurfDesc() instanceof GeneralSurfDesc) {
                oldDesc = (GeneralSurfDesc)surf.getSurfDesc();
                if (((GeneralSurfDesc)oldDesc).d_airflow.d_rate.specInj == null || ((GeneralSurfDesc)oldDesc).d_specInj == null) continue;
                newSurfDesc = new GeneralSurfDesc(((GeneralSurfDesc)oldDesc).d_tempReg, ((GeneralSurfDesc)oldDesc).d_partInj, PyroSimObjectInputStream.fixBadSpecInj(((GeneralSurfDesc)oldDesc).d_specInj), ((GeneralSurfDesc)oldDesc).d_heatRelease, PyroSimObjectInputStream.fixBadSpecInj(((GeneralSurfDesc)oldDesc).d_airflow), ((GeneralSurfDesc)oldDesc).d_geometry);
            } else if (surf.getSurfDesc() instanceof LayeredSurfDesc) {
                oldDesc = (LayeredSurfDesc)surf.getSurfDesc();
                if (((LayeredSurfDesc)oldDesc).d_specInj == null) continue;
                newSurfDesc = new LayeredSurfDesc(((LayeredSurfDesc)oldDesc).d_geometry, ((LayeredSurfDesc)oldDesc).d_iReac, ((LayeredSurfDesc)oldDesc).d_surfComp, PyroSimObjectInputStream.fixBadSpecInj(((LayeredSurfDesc)oldDesc).d_specInj), ((LayeredSurfDesc)oldDesc).d_partInj, ((LayeredSurfDesc)oldDesc).d_burnAway, ((LayeredSurfDesc)oldDesc).d_leakPath, ((LayeredSurfDesc)oldDesc).d_temperature, ((LayeredSurfDesc)oldDesc).d_ht3d);
            }
            if (newSurfDesc == null) continue;
            surf.setSurfDesc(newSurfDesc);
        }
    }

    private static SpecInjList fixBadSpecInj(SpecInjList oldInj) {
        return new SpecInjList(oldInj.injType, new ArrayList<SpeciesInjection>(oldInj.getInjections()));
    }

    private static AirFlow fixBadSpecInj(AirFlow oldFlow) {
        AirFlow newFlow = null;
        if (oldFlow.d_rate instanceof AirFlow.NormalVel) {
            AirFlow.NormalVel oldRate = (AirFlow.NormalVel)oldFlow.d_rate;
            newFlow = new AirFlow(new AirFlow.NormalVel(oldRate.val, oldRate.tanVelU, oldRate.tanVelV, oldRate.func, new SpecInjList(oldRate.specInj.injType, new ArrayList<SpeciesInjection>(oldRate.specInj.getInjections()))), oldFlow.d_profile);
        } else if (oldFlow.d_rate instanceof AirFlow.VolumeFlux) {
            AirFlow.VolumeFlux oldRate = (AirFlow.VolumeFlux)oldFlow.d_rate;
            newFlow = new AirFlow(new AirFlow.VolumeFlux(oldRate.val, oldRate.tanVelU, oldRate.tanVelV, oldRate.func, new SpecInjList(oldRate.specInj.injType, new ArrayList<SpeciesInjection>(oldRate.specInj.getInjections()))), oldFlow.d_profile);
        } else if (oldFlow.d_rate instanceof AirFlow.TotalMassFlux) {
            AirFlow.TotalMassFlux oldRate = (AirFlow.TotalMassFlux)oldFlow.d_rate;
            newFlow = new AirFlow(new AirFlow.TotalMassFlux(oldRate.val, oldRate.tanVelU, oldRate.tanVelV, oldRate.func, new SpecInjList(oldRate.specInj.injType, new ArrayList<SpeciesInjection>(oldRate.specInj.getInjections()))), oldFlow.d_profile);
        } else if (oldFlow.d_rate instanceof AirFlow.ExSpecMassFlux) {
            AirFlow.ExSpecMassFlux oldRate = (AirFlow.ExSpecMassFlux)oldFlow.d_rate;
            newFlow = new AirFlow(new AirFlow.ExSpecMassFlux(oldRate.tanVelU, oldRate.tanVelV, oldRate.func, new SpecInjList(oldRate.specInj.injType, new ArrayList<SpeciesInjection>(oldRate.specInj.getInjections()))), oldFlow.d_profile);
        } else {
            assert (false);
            newFlow = oldFlow;
        }
        return newFlow;
    }

    public static void fixBadDeviceRefs(Serialized ser) {
        LinkedHashMap controlMap = new LinkedHashMap();
        for (ControlBridge controlBridge : ser.controls.flatten()) {
            PyroSimObjectInputStream.getOriginalControl(controlBridge, controlMap);
        }
        for (Map.Entry entry : controlMap.entrySet()) {
            if (ser.devices.containsDeep((IPyroObject)((Pair)entry.getKey()).v2) || !(((Pair)entry.getKey()).v2 instanceof IDevice) || ((Pair)entry.getKey()).v2 instanceof Timer || ((Pair)entry.getKey()).v2 instanceof Clock) continue;
            ser.devices.remove((IPyroObject)((Pair)entry.getKey()).v2);
            for (IOutPin iOutPin : ((ISignalSource)((Pair)entry.getKey()).v2).getOutputPins()) {
                ((ISignalSink)((Pair)entry.getKey()).v1).getInputPin().disconnect(iOutPin);
            }
        }
    }

    private static void getOriginalControl(ControlBridge bridge, Map baseMap) {
        for (ISignalSource src : bridge.getInputPin().getConnectedSources()) {
            PyroSimObjectInputStream.getOriginalControl(new Pair<ControlBridge, ISignalSource>(bridge, src), bridge, src, baseMap);
        }
    }

    private static void getOriginalControl(Pair root, ISignalSink parent, ISignalSource src, Map baseMap) {
        if (src instanceof ISignalSink) {
            if (((ISignalSink)((Object)src)).getInputPin().getConnectedSources().isEmpty()) {
                baseMap.put(new Pair<ISignalSink, ISignalSource>(parent, src), root);
                return;
            }
            for (ISignalSource nextSrc : ((ISignalSink)((Object)src)).getInputPin().getConnectedSources()) {
                PyroSimObjectInputStream.getOriginalControl(root, (ISignalSink)((Object)src), nextSrc, baseMap);
            }
        } else {
            baseMap.put(new Pair<ISignalSink, ISignalSource>(parent, src), root);
        }
    }

    public static String migrateBurnerTempRegToAdvanced(Collection<Surface> surfs, WarningReport<Warning> warnings) {
        FDSNameMap nameMap = new FDSNameMap();
        PinConnectionRenderer pinConnRenderer = new PinConnectionRenderer(nameMap);
        HashMap<String, Ramp> ramps = new HashMap<String, Ramp>();
        FDSRenderProps renderProps = PyroSim.getFdsRenderPropsNullSafe();
        for (Surface surf : surfs) {
            pyrosim.domain.boundcond.surf.TempRegulation tempReg;
            if (surf.isPredefined() || !(surf.getSurfDesc() instanceof BurnerSurfDesc)) continue;
            BurnerSurfDesc burnerData = (BurnerSurfDesc)surf.getSurfDesc();
            pyrosim.domain.boundcond.surf.TempRegulation defaultTempReg = pyrosim.domain.boundcond.surf.TempRegulation.newDefault();
            if (defaultTempReg.equals(tempReg = burnerData.getVestigialTempRegData())) continue;
            FDSRenderRecord rec = FDS6Const.newRenderRecord("SURF");
            SurfaceRenderer.renderTempRegulation(rec, nameMap, ramps, surf, tempReg, false);
            if (!rec.contains("CONVECTIVE_HEAT_FLUX") || !rec.contains("TAU_Q") && !rec.contains("RAMP_Q")) continue;
            rec.setValue("TAU_Q", null);
            if (rec.contains("RAMP_Q")) {
                String rampName = (String)rec.get("RAMP_Q");
                ramps.remove(rampName);
                rec.setValue("RAMP_Q", null);
            }
            if (warnings == null) continue;
            warnings.addWarning(new Warning(String.format(Intl.intl("[%s] Ambiguous ramp-up."), surf.getName()), Intl.intl("Using heat release ramp-up; temperature ramp-up removed.")));
        }
        if (!ramps.isEmpty()) {
            FDSStringRenderer stringRenderer = new FDSStringRenderer(renderProps);
            RampRenderer.render(stringRenderer, ramps, pinConnRenderer);
            if (warnings != null) {
                for (String rampName : ramps.keySet()) {
                    warnings.addWarning(new Warning(Intl.intl("Surface boundary conditions are no longer supported on burner surfaces."), String.format(Intl.intl("Ramp %s moved to the Additional Records."), rampName)));
                }
            }
            return stringRenderer.toString();
        }
        return "";
    }

    public WarningReport<Warning> getWarnings() {
        return this.d_warnings;
    }

    private void sortManagers(Serialized ser) {
        ArrayList<Composite> allGroups = new ArrayList<Composite>(Hierarchy.flatten(PyroMod.getMembers(ser, true), Composite.class));
        for (Composite group : allGroups) {
            Class type = group.getType();
            if (type.isAssignableFrom(FDSObject.class) || type.isAssignableFrom(Grid.class) || !INamed.class.isAssignableFrom(type)) continue;
            List<IPyroObject> members = pyrosim.util.Util.sort(group.getMembers());
            group.reorder(members);
        }
    }

    private static void disconnectControls(Collection<? extends ISignalSink> objs, Map<IOutPin, List<IInPin>> map) {
        for (ISignalSink iSignalSink : objs) {
            for (IOutPin iOutPin : iSignalSink.getInputPin().getConnections()) {
                List<IInPin> inPins = map.get(iOutPin);
                if (inPins == null) {
                    inPins = new ArrayList<IInPin>(1);
                    map.put(iOutPin, inPins);
                }
                inPins.add(iSignalSink.getInputPin());
            }
            iSignalSink.getInputPin().disconnectAll();
        }
    }

    private void fixSurfRefs(Serialized ser) {
        ArrayList<Surface> addedSurfs = new ArrayList<Surface>();
        int numBad = 0;
        for (FDSObject obj : ((APyroObject)ser.obstructions).flatten(FDSObject.class)) {
            pyrosim.domain.geom.Vent vent;
            Surface surf;
            if (obj instanceof IObstruction) {
                int bad = 0;
                IObstruction obst = (IObstruction)obj;
                Surface[] surfs = obst.getSurfaces();
                for (int m = 0; m < surfs.length; ++m) {
                    Surface surf2 = surfs[m];
                    if (surf2 instanceof DefaultSurface) continue;
                    Surface inModel = (Surface)ser.surfmgr.get(surf2.getName());
                    if (surf2.equals(ser.surfmgr.getDefaultSurfaceObj())) continue;
                    if (inModel == null) {
                        ser.surfmgr.add(surf2);
                        addedSurfs.add(surf2);
                        continue;
                    }
                    if (surf2 == inModel) continue;
                    surfs[m] = inModel;
                    ++bad;
                }
                if (bad > 0) {
                    obst.setSurfaces(surfs);
                }
                numBad += bad;
                continue;
            }
            if (!(obj instanceof pyrosim.domain.geom.Vent) || (surf = (vent = (pyrosim.domain.geom.Vent)obj).getSurface()) instanceof DefaultSurface) continue;
            Surface inModel = (Surface)ser.surfmgr.get(surf.getName());
            if (inModel == null) {
                ser.surfmgr.add(surf);
                addedSurfs.add(surf);
                continue;
            }
            if (surf == inModel) continue;
            vent.setSurface(inModel);
            ++numBad;
        }
        if (numBad > 0) {
            System.err.println("Fixed " + numBad + " invalid surface references.");
        }
        if (!addedSurfs.isEmpty()) {
            Object surfsStr = "";
            for (int m = 0; m < addedSurfs.size(); ++m) {
                if (m > 0) {
                    surfsStr = (String)surfsStr + ", ";
                }
                surfsStr = (String)surfsStr + ((Surface)addedSurfs.get(m)).getName();
            }
            String msg = String.format(Intl.intl("Found %d surface(s) missing from the model: %s"), addedSurfs.size(), surfsStr);
            String action = Intl.intl("Added extra surfaces to the model.");
            this.d_warnings.addWarning(new Warning(msg, action));
        }
    }

    public static void fixMissingJets(Serialized ser, WarningReport<Warning> warnings) {
        for (SprayModel spray : ser.sprayModels.flatten()) {
            if (!spray.getJets().isEmpty()) continue;
            String msg = String.format(Intl.intl("Invalid spray model \"%s\". Jet stream data missing."), spray.getName());
            String action = Intl.intl("Default jet stream data added.");
            warnings.addWarning(new Warning(msg, action));
            spray.setJets(Arrays.asList(new SprayModel.Jet()));
        }
    }

    private void fixPre82FanCurves(Serialized ser) {
        PyroSimObjectInputStream.fixPre82FanCurves(ser, this.d_warnings);
    }

    public static void fixPre82FanCurves(Serialized ser, WarningReport<Warning> warnings) {
        for (IHvacObject hvac : ser.hvacSystem.flatten()) {
            HvacFan fan;
            if (!(hvac instanceof HvacFan) || !(fan = (HvacFan)hvac).getProp("opt_fan_model").equals(HvacFan.FAN_MODEL_PRESDROP)) continue;
            Variant fanCurve = fan.getPressureFlow();
            Ramp ramp = (Ramp)fanCurve.val;
            if (ramp.getTUnitType() == 39) {
                ArrayList<Ramp.Entry> entries = new ArrayList<Ramp.Entry>(ramp.getRecords().size());
                for (Ramp.Entry oldEntr : ramp.getRecords()) {
                    entries.add(new Ramp.Entry(oldEntr.f, oldEntr.t));
                }
                fan.setPressureFlow(Variant.ramp(new Ramp(entries, RampInputs.FLOW, RampInputs.FLOW, 39)));
                warnings.addWarning(new Warning(Intl.intl("HVAC fans previously reversed values for fan curve tables."), String.format(Intl.intl("Fan curve entries for fan %s have been reversed."), fan.getName())));
                continue;
            }
            Variant newPresFlow = Variant.constant(new UnitDouble(0.0, SI.METER.pow(3).divide(SI.SECOND)));
            fan.setPressureFlow(newPresFlow);
            warnings.addWarning(new Warning(Intl.intl("HVAC fans cannot be controlled by signal inputs."), String.format(Intl.intl("Volume Flow Rate set to 0.0 for fan %s"), fan.getName())));
        }
    }

    private void fixPre83CableFailDetector(Serialized ser, WarningReport<Warning> warnings) {
        for (IDevice devc : ser.devices.flatten()) {
            if (!(devc instanceof CableFailDetector)) continue;
            warnings.addWarning(new Warning(Intl.intl("Cable failure detectors are no longer supported by FDS. "), String.format(Intl.intl("Device %s is removed. Please check section 15.3.8 of FDS version 6 user's guide."), ((CableFailDetector)devc).getName())));
        }
        for (IDevice devc : ser.devices.flatten()) {
            if (!(devc instanceof CableFailDetector)) continue;
            ser.devices.remove(devc);
        }
    }

    public static void fixPre84Evac(Serialized ser, WarningReport<Warning> warns) {
        FDSStringRenderer stringRenderer;
        Iterator renderProps;
        boolean evacEnabled = ser.enableFdsEvac;
        if (!evacEnabled) {
            if (!(ser.perss.isEmpty() && ser.exits.isEmpty() && ser.evacs.isEmpty() && ser.entrs.isEmpty() && ser.evhos.isEmpty() && ser.corrs.isEmpty() && ser.evsss.isEmpty() && ser.doors.isEmpty())) {
                warns.addWarning(new Warning(Intl.intl("PyroSim no longer supports evacuation."), Intl.intl("Unreferenced evacuation data will be removed from the model.")));
            }
            return;
        }
        boolean evacNamelistMoved = false;
        if (!ser.perss.isEmpty()) {
            renderProps = PyroSim.getFdsRenderPropsNullSafe();
            stringRenderer = new FDSStringRenderer((FDSRenderProps)((Object)renderProps));
            PersRenderer persRend = new PersRenderer(ser.perss);
            persRend.render((IFDSRecordRenderer)stringRenderer, ser.perss.flatten());
            ser.unprocessedRecords = ser.unprocessedRecords + stringRenderer.toString();
            evacNamelistMoved = true;
        }
        if (!ser.exits.isEmpty()) {
            renderProps = PyroSim.getFdsRenderPropsNullSafe();
            stringRenderer = new FDSStringRenderer((FDSRenderProps)((Object)renderProps));
            ExitRenderer exitRend = new ExitRenderer();
            exitRend.render((IFDSRecordRenderer)stringRenderer, ser.exits.flatten());
            ser.unprocessedRecords = ser.unprocessedRecords + stringRenderer.toString();
            evacNamelistMoved = true;
        }
        if (!ser.evacs.isEmpty()) {
            renderProps = PyroSim.getFdsRenderPropsNullSafe();
            stringRenderer = new FDSStringRenderer((FDSRenderProps)((Object)renderProps));
            EvacRenderer evacRenderer = new EvacRenderer();
            evacRenderer.render((IFDSRecordRenderer)stringRenderer, ser.evacs.flatten());
            ser.unprocessedRecords = ser.unprocessedRecords + stringRenderer.toString();
            evacNamelistMoved = true;
        }
        if (!ser.entrs.isEmpty()) {
            renderProps = PyroSim.getFdsRenderPropsNullSafe();
            stringRenderer = new FDSStringRenderer((FDSRenderProps)((Object)renderProps));
            EntrRenderer entrRenderer = new EntrRenderer();
            entrRenderer.render((IFDSRecordRenderer)stringRenderer, ser.entrs.flatten());
            ser.unprocessedRecords = ser.unprocessedRecords + stringRenderer.toString();
            evacNamelistMoved = true;
        }
        if (!ser.evhos.isEmpty()) {
            renderProps = PyroSim.getFdsRenderPropsNullSafe();
            stringRenderer = new FDSStringRenderer((FDSRenderProps)((Object)renderProps));
            EvhoRenderer evhoRenderer = new EvhoRenderer();
            evhoRenderer.render((IFDSRecordRenderer)stringRenderer, ser.evhos.flatten());
            ser.unprocessedRecords = ser.unprocessedRecords + stringRenderer.toString();
            evacNamelistMoved = true;
        }
        if (!ser.corrs.isEmpty()) {
            renderProps = PyroSim.getFdsRenderPropsNullSafe();
            stringRenderer = new FDSStringRenderer((FDSRenderProps)((Object)renderProps));
            CorrRenderer corrRenderer = new CorrRenderer();
            corrRenderer.render((IFDSRecordRenderer)stringRenderer, ser.corrs.flatten());
            ser.unprocessedRecords = ser.unprocessedRecords + stringRenderer.toString();
            evacNamelistMoved = true;
        }
        if (!ser.evsss.isEmpty()) {
            renderProps = PyroSim.getFdsRenderPropsNullSafe();
            stringRenderer = new FDSStringRenderer((FDSRenderProps)((Object)renderProps));
            EvssRenderer evssRenderer = new EvssRenderer();
            evssRenderer.render((IFDSRecordRenderer)stringRenderer, ser.evsss.flatten());
            ser.unprocessedRecords = ser.unprocessedRecords + stringRenderer.toString();
            evacNamelistMoved = true;
        }
        if (!ser.doors.isEmpty()) {
            renderProps = PyroSim.getFdsRenderPropsNullSafe();
            stringRenderer = new FDSStringRenderer((FDSRenderProps)((Object)renderProps));
            DoorRenderer doorRenderer = new DoorRenderer();
            doorRenderer.render((IFDSRecordRenderer)stringRenderer, ser.doors.flatten());
            ser.unprocessedRecords = ser.unprocessedRecords + stringRenderer.toString();
            evacNamelistMoved = true;
        }
        ser.perss.clear();
        ser.exits.clear();
        ser.evacs.clear();
        ser.entrs.clear();
        ser.evhos.clear();
        ser.corrs.clear();
        ser.evsss.clear();
        ser.doors.clear();
        if (evacNamelistMoved) {
            warns.addWarning(new Warning(Intl.intl("PyroSim no longer supports evacuation."), Intl.intl("Evacuation namelists moved to the additional records section.")));
        }
        for (Grid grid : ser.grids.flatten()) {
            boolean showWarn = false;
            HashMap<String, String> newGridCustoms = new HashMap<String, String>();
            if (grid.getEvacuation()) {
                newGridCustoms.put("EVACUATION", ".TRUE.");
                grid.setEvacuation(false);
                showWarn = true;
            }
            if (grid.getEvacHumans()) {
                newGridCustoms.put("EVAC_HUMANS", ".TRUE.");
                grid.setEvacHumans(false);
                showWarn = true;
            }
            if (grid.getEvacHumans() || grid.getEvacuation()) {
                FDSRenderProps renderProps2 = PyroSim.getFdsRenderPropsNullSafe();
                FDSRecordSpec meshSpec = FDS6Const.getRecordSpecs().get("MESH");
                Pair<String, String> evacSpec = meshSpec.renderField(renderProps2, "EVAC_Z_OFFSET", grid.getEvacZOffset());
                newGridCustoms.put((String)evacSpec.v1, (String)evacSpec.v2);
                grid.setEvacZOffset(new UnitDouble(1.0, SI.METER));
            }
            if (!showWarn) continue;
            grid.setCustomFDSProps(CustomFDSProps.union(grid.getCustomFDSProps(), CustomFDSProps.get(newGridCustoms)));
            warns.addWarning(new Warning(Intl.intl("PyroSim no longer supports evacuation."), String.format(Intl.intl("Evacuation parameters for mesh %s moved to Advanced Parameters."), grid.getName())));
        }
        for (IModelObj obst : ser.obstructions.flatten()) {
            if (!(obst instanceof FDSObject)) continue;
            FDSObject fdsObj = (FDSObject)obst;
            EvacProps evac = fdsObj.getEvac();
            boolean showWarn = false;
            HashMap<String, String> newObstCustoms = new HashMap<String, String>();
            if (evac.evacuation == 2) {
                newObstCustoms.put("EVACUATION", ".TRUE.");
                showWarn = true;
            }
            if (evac.mesh != null) {
                showWarn = true;
                FDSRenderProps renderProps3 = PyroSim.getFdsRenderPropsNullSafe();
                FDSRecordSpec obstSpec = FDS6Const.getRecordSpecs().get("OBST");
                Pair<String, String> obstMesh = obstSpec.renderField(renderProps3, "MESH_ID", evac.mesh.getName());
                newObstCustoms.put((String)obstMesh.v1, (String)obstMesh.v2);
            }
            if (showWarn) {
                fdsObj.setCustomFDSProps(CustomFDSProps.union(fdsObj.getCustomFDSProps(), CustomFDSProps.get(newObstCustoms)));
                warns.addWarning(new Warning(Intl.intl("PyroSim no longer supports evacuation."), String.format(Intl.intl("Evacuation parameters for mesh %s moved to Advanced Parameters."), obst.getName())));
            }
            fdsObj.setEvac(EvacProps.DEFAULT);
        }
        HashMap<String, String> customMISC = new HashMap<String, String>();
        HashMap<String, String> customTIME = new HashMap<String, String>();
        FDSRecordSpec miscSpec = FDS6Const.getRecordSpecs().get("MISC");
        FDSRecordSpec timeSpec = FDS6Const.getRecordSpecs().get("TIME");
        FDSRenderProps renderProps4 = PyroSim.getFdsRenderPropsNullSafe();
        Pair<String, String> mcMode = miscSpec.renderField(renderProps4, "EVACUATION_MC_MODE", ser.simParams.getMisc().getEvacProp("EVACUATION_MC_MODE"));
        customMISC.put((String)mcMode.v1, (String)mcMode.v2);
        Pair<String, String> pressIt = miscSpec.renderField(renderProps4, "EVAC_PRESSURE_ITERATIONS", ser.simParams.getMisc().getEvacProp("PRESSURE_ITERATIONS"));
        customMISC.put((String)pressIt.v1, (String)pressIt.v2);
        Pair<String, String> timeIt = miscSpec.renderField(renderProps4, "EVAC_TIME_ITERATIONS", ser.simParams.getMisc().getEvacProp("TIME_ITERATIONS"));
        customMISC.put((String)timeIt.v1, (String)timeIt.v2);
        Pair<String, String> dtSS = timeSpec.renderField(renderProps4, "EVAC_DT_STEADY_STATE", ser.simParams.getTime().getEvacProp("EVAC_DT_STEADY_STATE"));
        customTIME.put((String)dtSS.v1, (String)dtSS.v2);
        Pair<String, String> dtFlow = timeSpec.renderField(renderProps4, "EVAC_DT_FLOWFIELD", ser.simParams.getTime().getEvacProp("EVAC_DT_FLOWFIELD"));
        customTIME.put((String)dtFlow.v1, (String)dtFlow.v2);
        ser.simParams.setCustomFDSProps("MISC", CustomFDSProps.union(ser.simParams.getCustomFDSProps("MISC"), CustomFDSProps.get(customMISC)));
        ser.simParams.setCustomFDSProps("TIME", CustomFDSProps.union(ser.simParams.getCustomFDSProps("TIME"), CustomFDSProps.get(customTIME)));
        Object surfOb = ser.simParams.getMisc().getEvacProp("EVAC_SURF_DEFAULT");
        if (surfOb != null) {
            Surface defEvacSurf = (Surface)surfOb;
            HashMap<String, String> newProps = new HashMap<String, String>();
            newProps.put("EVAC_SURF_DEFAULT", ".TRUE.");
            defEvacSurf.setCustomFDSProps(CustomFDSProps.union(defEvacSurf.getCustomFDSProps(), CustomFDSProps.get(newProps)));
        }
        ser.simParams.getMisc().initEvacProps(ser.surfmgr);
        ser.simParams.getTime().setEvacProps(SimParams.Time.initEvacProps());
        Pers p = ser.simParams.getPersGlobals();
        Pers defaults = new Pers(p.getName());
        if (!(!evacEnabled || Pers.diff(PersRenderer.GLOBAL_PROPS, p, defaults).isEmpty() && Pers.diff(PersRenderer.GLOBAL_PROPS_SPECIAL, p, defaults).isEmpty())) {
            SingletonRecords sr = new SingletonRecords();
            sr.persRec.setValue("ID", p.getName());
            for (String prop : PersRenderer.GLOBAL_PROPS) {
                sr.persRec.setValue(prop, p.getProp(prop), false);
            }
            FDSRenderRecord persRec = sr.persRec;
            FDSStringRenderer stringRenderer2 = new FDSStringRenderer(renderProps4);
            stringRenderer2.render(persRec, null);
            ser.unprocessedRecords = ser.unprocessedRecords + stringRenderer2.toString();
        }
        ser.simParams.clearPers();
        warns.addWarning(new Warning(Intl.intl("PyroSim no longer supports evacuation."), Intl.intl("Evacuation parameters for TIME and MISC namelists moved Simulation Parameters - Advanced.")));
    }

    public static void fds_6_3_update(Serialized ser, WarningReport<Warning> warns) {
        boolean warnSynch = false;
        for (Grid grid : ser.grids.flatten()) {
            if (grid.syncTimeStep()) continue;
            warnSynch = true;
            break;
        }
        if (warnSynch) {
            warns.addWarning(new Warning(Intl.intl("As of FDS 6.3, SYNCHRONIZATION is no longer defined."), Intl.intl("Removing variable Synchronize Meshes from affected Meshes.")));
        }
        UnitDouble frac = null;
        double radiativeFrac = ser.simParams.getRadiTransport().getRadiativeLossFraction();
        if (radiativeFrac != 0.35) {
            frac = SIUS.newud(radiativeFrac, 28);
            String actionMsg = !ser.reactions.isEmpty() ? Intl.intl("Radiative Loss Fraction applied to all Reactions.") : Intl.intl("Radiative Loss Fraction removed from Simulation Parameters.");
            warns.addWarning(new Warning(Intl.intl("FDS variable RADIATIVE_FRACTION moved from &RADI to &REAC namelist."), actionMsg));
        }
        boolean warnHRRPUA = false;
        boolean warnHRRPUV = false;
        for (Object reac : ser.reactions.flatten()) {
            ((Reaction)reac).setRadiativeFraction(frac);
            if (!((Reaction)reac).getHrrpuaSheet().equals(new UnitDouble(200.0, SI.KILO(SI.WATT).divide(SI.METER.pow(2))))) {
                warnHRRPUA = true;
            }
            if (((Reaction)reac).getHrrpuvAvg().equals(new UnitDouble(2500.0, SI.KILO(SI.WATT).divide(SI.METER.pow(3))))) continue;
            warnHRRPUV = true;
        }
        if (warnHRRPUA) {
            warns.addWarning(new Warning(Intl.intl("FDS variable HRRPUA_SHEET dropped from &REAC namelist."), Intl.intl("Maximum heat release rate per unit area removed from Reactions.")));
        }
        if (warnHRRPUV) {
            warns.addWarning(new Warning(Intl.intl("FDS variable HRRPUV_AVERAGE dropped from &REAC namelist."), Intl.intl("Maximum heat release rate per unit volume removed from Reactions.")));
        }
        ArrayList<IDevice> devicesToRemove = new ArrayList<IDevice>(ser.devices.flatten().size());
        for (IDevice devc : ser.devices.flatten()) {
            GasPointMeasurer gpm;
            if (devc instanceof GaugeHeatFluxMeasurer) {
                ((GaugeHeatFluxMeasurer)devc).setGaugeEmissivity(0.9);
                continue;
            }
            if (!(devc instanceof GasPointMeasurer) || !(gpm = (GasPointMeasurer)devc).getQuantity().get().equals((Object)Quantity.TURBULENCE_RESOLUTION)) continue;
            warns.addWarning(new Warning(Intl.intl("Quantity TURBULENCE RESOLUTION is no longer supported by FDS."), String.format(Intl.intl("Solid-phase device %s removed from model."), devc.getName())));
            devicesToRemove.add(devc);
        }
        ser.devices.removeAll(devicesToRemove);
        ArrayList<Slice> slicesToRemove = new ArrayList<Slice>(ser.devices.flatten().size());
        for (Slice slc : ser.slices.flatten()) {
            if (!slc.getQuantity().get().equals((Object)Quantity.TURBULENCE_RESOLUTION)) continue;
            slicesToRemove.add(slc);
        }
        if (!slicesToRemove.isEmpty()) {
            warns.addWarning(new Warning(Intl.intl("Quantity TURBULENCE RESOLUTION is no longer supported by FDS."), Intl.intl("TURBULENCE RESOLUTION slices removed from model.")));
            ser.slices.removeAll(slicesToRemove);
        }
    }

    public static void manuallyConvertPre86AtmGradUnits(Serialized ser, WarningReport<Warning> warns) {
        UnitDouble lapseRate = ser.simParams.getWind().get(SimParams.Wind.LAPSE_RATE);
        UnitDouble converted = lapseRate.convert(SIUS.unit(5));
        ser.simParams.getWind().setNoCheck(SimParams.Wind.LAPSE_RATE, converted);
    }

    public static boolean generatePre87Elements(Serialized ser, WarningReport<Warning> warns) {
        ArrayList<IModelObj> importedGeom = new ArrayList<IModelObj>();
        importedGeom.addAll(((APyroObject)ser.obstructions).flatten(IObstruction.class));
        importedGeom.addAll(((APyroObject)ser.obstructions).flatten(IHole.class));
        importedGeom.addAll(((APyroObject)ser.obstructions).flatten(GenericGeomSrc.class));
        if (importedGeom.isEmpty()) {
            return false;
        }
        System.out.println("Generating creases for legacy objects...");
        theTimer timer = new theTimer();
        boolean modified = false;
        LinkedHashMap<IGeom, IElemSource> creases = new LinkedHashMap<IGeom, IElemSource>();
        for (IPyroGeomSrc iPyroGeomSrc : importedGeom) {
            IElemSource<Boolean> creaseSrc;
            IGeomNode node = iPyroGeomSrc.getGeom();
            if (node.getLocalGeom() != EmptyGeom.INSTANCE && node.isLeaf()) {
                creaseSrc = creases.computeIfAbsent(node.getLocalGeom(), g -> Elements.generateCreasesFromFacets(g, (IElemSource)((Object)node.getLocalElements().get(Elements.ORIENT))));
            } else {
                IGeomNode fnode = node.flatten(2);
                creaseSrc = Elements.generateCreasesFromFacets(fnode.getLocalGeom(), (IElemSource)((Object)fnode.getLocalElements().get(Elements.ORIENT)));
            }
            if (creaseSrc == Elements.ALL_CREASE) continue;
            IGeomNode newNode = node.applyElements(Elements.CREASE, (pix, oldCrease) -> creaseSrc.getPrimSource((int)pix));
            modified |= newNode != node;
            iPyroGeomSrc.setGeom(newNode);
        }
        System.out.printf("Creases complete (%g s)%n", timer.curr());
        return modified;
    }

    private boolean reorganizePre88UV(Serialized ser) {
        boolean modified = true;
        Collection<ISurfObj> sobjs = ((APyroObject)ser.obstructions).flatten(ISurfObj.class);
        if (sobjs.isEmpty()) {
            return false;
        }
        IdentityHashMap<IPropertySet, IPropertySet> elMap = new IdentityHashMap<IPropertySet, IPropertySet>();
        for (ISurfObj ig : sobjs) {
            IGeomNode node = ig.getGeom();
            IGeomNode newNode = PyroSimObjectInputStream.reorganizePre88NodeUV(node, elMap);
            modified |= newNode != node;
            ig.setGeom(newNode);
        }
        return modified;
    }

    private static IGeomNode reorganizePre88NodeUV(IGeomNode node, Map<IPropertySet, IPropertySet> elMap) {
        IPropertySet newElements;
        IPropertySet elements = node.getLocalElements();
        if (elements == (newElements = elMap.computeIfAbsent(elements, e -> Elements.fixLegacy(e))) && node.getChildren().isEmpty()) {
            return node;
        }
        elements = newElements;
        Collection<? extends IGeomNode> children = node.getChildren();
        ArrayList<? extends IGeomNode> newChildren = null;
        int ix = 0;
        for (IGeomNode iGeomNode : children) {
            IGeomNode newChild = PyroSimObjectInputStream.reorganizePre88NodeUV(iGeomNode, elMap);
            if (newChild != iGeomNode) {
                if (newChildren == null) {
                    newChildren = new ArrayList<IGeomNode>(node.getChildren());
                }
                newChildren.set(ix, newChild);
            }
            ++ix;
        }
        if (newChildren != null) {
            children = newChildren;
        }
        return GeomNodeUtil.newNode(node.getLocalTransform(), node.getLocalGeom(), elements, children);
    }

    private void fixPre89ImportedSurfs(Serialized ser) {
        for (Surface surf : ser.surfmgr.flatten()) {
            if (!PyroSimObjectInputStream.isBadSurfCombo(surf, SurfDescStatic.Adiabatic.class) && !PyroSimObjectInputStream.isBadSurfCombo(surf, SurfDescStatic.Hvac.class) && !PyroSimObjectInputStream.isBadSurfCombo(surf, SurfDescStatic.Mirror.class) && !PyroSimObjectInputStream.isBadSurfCombo(surf, SurfDescStatic.Open.class) && !PyroSimObjectInputStream.isBadSurfCombo(surf, SurfDescStatic.Periodic.class)) continue;
            String warning = String.format(Intl.intl("Surface was created with an invalid surface type"), new Object[0]);
            String fix = String.format(Intl.intl("Changed surface type on \"%1$s\" from \"%2$s\" to \"Basic\""), surf.getName(), ((SurfDescStatic)surf.getSurfDesc()).getPredefType().name());
            this.d_warnings.addWarning(new Warning(warning, fix));
            surf.setSurfDesc(Surface.newBasicDesc());
        }
    }

    private static boolean isBadSurfCombo(Surface surf, Class<? extends SurfDescStatic> ptype) {
        ISurfDesc desc = surf.getSurfDesc();
        return ptype.isInstance(desc) && !surf.isPredefined(ptype.cast(desc).getPredefType());
    }

    private void fixPre89BadObstSurfs(Serialized ser) {
        Surface inert = ser.surfmgr.get(PredefSurf.INERT);
        assert (inert != null);
        for (IObstruction obst : ((APyroObject)ser.obstructions).flatten(IObstruction.class)) {
            Surface[] surfs;
            Predicate<Surface> filter = obst.getSurfFilter();
            Surface[] newSurfs = surfs = obst.getSurfaces();
            for (int m = 0; m < surfs.length; ++m) {
                Surface surf = surfs[m];
                if (filter.test(surf)) continue;
                if (newSurfs == surfs) {
                    newSurfs = Arrays.copyOf(surfs, surfs.length);
                }
                newSurfs[m] = inert;
            }
            if (newSurfs == surfs) continue;
            obst.setSurfaces(newSurfs);
            String warning = Intl.intl("Invalid surface assigned to obstruction.");
            String action = String.format(Intl.intl("Obstruction \"%s\": Faces assigned to MIRROR, OPEN, PERIODIC, or HVAC switched to INERT"), obst.getName());
            this.d_warnings.addWarning(new Warning(warning, action));
        }
    }

    public static void warnPre91SingleSprkDryPipe(Serialized ser, WarningReport<Warning> warnings) {
        LinkedIdentityHashMap<DryPipe, List> dryPipes = new LinkedIdentityHashMap<DryPipe, List>();
        for (Sprinkler sprk : ((APyroObject)ser.devices).flatten(Sprinkler.class)) {
            DryPipe dpipe = sprk.getDryPipe();
            if (dpipe == null) continue;
            dryPipes.computeIfAbsent(dpipe, d -> new ArrayList()).add(sprk);
        }
        dryPipes.entrySet().stream().filter(e -> ((List)e.getValue()).size() == 1).forEach(e -> {
            String msg = Intl.intl("Behavior has changed for a single sprinkler attached to a dry pipe.");
            String action = String.format(Intl.intl("%s: Nozzle will now activate after the dry pipe delay rather than immediately."), ((Sprinkler)((List)e.getValue()).get(0)).getName());
            warnings.addWarning(new Warning(msg, action));
        });
    }

    public static void warnPre92HvacCtrls(Serialized ser, WarningReport<Warning> warnings) {
        Collection<IModelObj> ducts = ser.obstructions.flatten(obj -> obj instanceof HvacDuct);
        for (IHvacObject comp : ser.hvacSystem.flatten()) {
            HvacFan fan;
            HvacDuct duct;
            boolean warningShown;
            Set<ISignalSource> sources;
            IInPin inpin;
            if (comp instanceof HvacAircoil) {
                HvacAircoil aircoil = (HvacAircoil)comp;
                inpin = aircoil.getInputPin();
                sources = inpin.getConnectedSources();
                if (sources.isEmpty()) continue;
                warningShown = false;
                for (IModelObj ductObj : ducts) {
                    duct = (HvacDuct)ductObj;
                    if (!theUtil.equal(duct.getProp("AIRCOIL_ID"), aircoil) || !duct.getInputPin().getConnectedSources().isEmpty()) continue;
                    for (IOutPin iOutPin : inpin.getConnections()) {
                        duct.getInputPin().connect(iOutPin);
                    }
                    warnings.addWarning(new Warning(Intl.intl("Aircoils can no longer be automated by a Control."), String.format(Intl.intl("Controls for Aircoil %s have been moved to HVAC Duct %s"), aircoil.getName(), duct.getName())));
                    inpin.disconnectAll();
                    warningShown = true;
                }
                if (warningShown) continue;
                warnings.addWarning(new Warning("Aircoils can no longer be automated by a Control.", String.format("Aircoil %s is no longer managed by a control.", aircoil.getName())));
                inpin.disconnectAll();
                continue;
            }
            if (!(comp instanceof HvacFan) || (sources = (inpin = (fan = (HvacFan)comp).getInputPin()).getConnectedSources()).isEmpty()) continue;
            warningShown = false;
            for (IModelObj ductObj : ducts) {
                duct = (HvacDuct)ductObj;
                if (!theUtil.equal(duct.getProp("FAN_ID"), fan) || !duct.getInputPin().getConnections().isEmpty()) continue;
                for (IOutPin iOutPin : inpin.getConnections()) {
                    duct.getInputPin().connect(iOutPin);
                }
                warnings.addWarning(new Warning(Intl.intl("Fans can no longer be automated by a Control."), String.format(Intl.intl("Controls for Fan %s have been moved to HVAC Duct %s"), fan.getName(), duct.getName())));
                inpin.disconnectAll();
                warningShown = true;
            }
            if (warningShown) continue;
            warnings.addWarning(new Warning(Intl.intl("Fans can  no longer be automated by a Control."), String.format(Intl.intl("Fan %s is no longer managed by a control."), fan.getName())));
            inpin.disconnectAll();
        }
    }

    public static void warnPre94OutflowSurfs(Serialized ser, WarningReport<Warning> warns) {
        for (Surface surf : ser.surfmgr.flatten()) {
            AirFlow fixedAF;
            AirFlow.ExSpecMassFlux fixedRate;
            AirFlow fixedAF2;
            AirFlow.TotalMassFlux newtmf;
            AirFlow.TotalMassFlux oldtmf;
            if (surf.getSurfDesc() instanceof InFlowSurfDesc) {
                InFlowSurfDesc supply = (InFlowSurfDesc)surf.getSurfDesc();
                if (supply.d_airFlow.d_rate instanceof AirFlow.TotalMassFlux) {
                    oldtmf = (AirFlow.TotalMassFlux)supply.d_airFlow.d_rate;
                    if (oldtmf.val.getValueNoUnit() < 0.0) {
                        warns.addWarning(new Warning(Intl.intl("Exhaust surfaces cannot specify a negative Total Mass Flux."), String.format(Intl.intl("Set Total Mass Flux for Surface %s to 0."), surf.getName())));
                        newtmf = PyroSimObjectInputStream.fixPre94NegativeMassFlux(oldtmf);
                        fixedAF2 = new AirFlow(newtmf, supply.d_airFlow.d_profile);
                        surf.setSurfDesc(new InFlowSurfDesc(fixedAF2, supply.d_temperature));
                    }
                }
                if (!(supply.d_airFlow.d_rate instanceof AirFlow.ExSpecMassFlux) || supply.d_airFlow.d_rate.func.equals(TimeFunction.newDefault())) continue;
                warns.addWarning(new Warning(Intl.intl("Ramp Up Time is invalid when specifying mass flux on a per species basis."), String.format(Intl.intl("Ramp Up Time dropped from surface %s."), surf.getName())));
                fixedRate = new AirFlow.ExSpecMassFlux(supply.d_airFlow.d_rate.tanVelU, supply.d_airFlow.d_rate.tanVelV, TimeFunction.newDefault(), supply.d_airFlow.d_rate.specInj);
                fixedAF = new AirFlow(fixedRate, supply.d_airFlow.d_profile);
                surf.setSurfDesc(new InFlowSurfDesc(fixedAF, supply.d_temperature));
                continue;
            }
            if (surf.getSurfDesc() instanceof BlowerSurfDesc) {
                BlowerSurfDesc oldBlower = (BlowerSurfDesc)surf.getSurfDesc();
                if (oldBlower.d_airFlow.d_rate instanceof AirFlow.TotalMassFlux) {
                    warns.addWarning(new Warning(Intl.intl("Supply surfaces cannot specify Total Mass Flux."), String.format(Intl.intl("Converted airflow profile for Surface %s to Volume Flux."), surf.getName())));
                    oldtmf = (AirFlow.TotalMassFlux)oldBlower.d_airFlow.d_rate;
                    AirFlow.VolumeFlux fixedRate2 = new AirFlow.VolumeFlux(SIUS.newud(0.0, 24), oldtmf.tanVelU, oldtmf.tanVelV, oldtmf.func, oldtmf.specInj);
                    fixedAF2 = new AirFlow(fixedRate2, oldBlower.d_airFlow.d_profile);
                    surf.setSurfDesc(new BlowerSurfDesc(oldBlower.d_tempReg, fixedAF2, oldBlower.d_partInj, oldBlower.d_geometry));
                }
                if (!(oldBlower.d_airFlow.d_rate instanceof AirFlow.ExSpecMassFlux) || oldBlower.d_airFlow.d_rate.func.equals(TimeFunction.newDefault())) continue;
                warns.addWarning(new Warning(Intl.intl("Ramp Up Time is invalid when specifying mass flux on a per species basis."), String.format(Intl.intl("Ramp Up Time dropped from surface %s."), surf.getName())));
                fixedRate = new AirFlow.ExSpecMassFlux(oldBlower.d_airFlow.d_rate.tanVelU, oldBlower.d_airFlow.d_rate.tanVelV, TimeFunction.newDefault(), oldBlower.d_airFlow.d_rate.specInj);
                fixedAF = new AirFlow(fixedRate, oldBlower.d_airFlow.d_profile);
                surf.setSurfDesc(new BlowerSurfDesc(oldBlower.d_tempReg, fixedAF, oldBlower.d_partInj, oldBlower.d_geometry));
                continue;
            }
            if (!(surf.getSurfDesc() instanceof GeneralSurfDesc)) continue;
            GeneralSurfDesc oldGeneral = (GeneralSurfDesc)surf.getSurfDesc();
            if (oldGeneral.d_airflow.d_rate instanceof AirFlow.TotalMassFlux) {
                oldtmf = (AirFlow.TotalMassFlux)oldGeneral.d_airflow.d_rate;
                if (oldtmf.val.getValueNoUnit() < 0.0) {
                    warns.addWarning(new Warning(Intl.intl("General surfaces cannot specify a negative Total Mass Flux."), String.format(Intl.intl("Set Total Mass Flux for Surface %s to 0."), surf.getName())));
                    newtmf = PyroSimObjectInputStream.fixPre94NegativeMassFlux(oldtmf);
                    fixedAF2 = new AirFlow(newtmf, oldGeneral.d_airflow.d_profile);
                    GeneralSurfDesc fixedGeneral = new GeneralSurfDesc(oldGeneral.d_tempReg, oldGeneral.d_partInj, oldGeneral.d_specInj, oldGeneral.d_heatRelease, fixedAF2, oldGeneral.d_geometry);
                    surf.setSurfDesc(fixedGeneral);
                }
            }
            if (!(oldGeneral.d_airflow.d_rate instanceof AirFlow.ExSpecMassFlux) || oldGeneral.d_airflow.d_rate.func.equals(TimeFunction.newDefault())) continue;
            warns.addWarning(new Warning(Intl.intl("Ramp Up Time is invalid when specifying mass flux on a per species basis."), String.format(Intl.intl("Ramp Up Time dropped from surface %s."), surf.getName())));
            fixedRate = new AirFlow.ExSpecMassFlux(oldGeneral.d_airflow.d_rate.tanVelU, oldGeneral.d_airflow.d_rate.tanVelV, TimeFunction.newDefault(), oldGeneral.d_airflow.d_rate.specInj);
            fixedAF = new AirFlow(fixedRate, oldGeneral.d_airflow.d_profile);
            surf.setSurfDesc(new GeneralSurfDesc(oldGeneral.d_tempReg, oldGeneral.d_partInj, oldGeneral.d_specInj, oldGeneral.d_heatRelease, fixedAF, oldGeneral.d_geometry));
        }
    }

    private static AirFlow.TotalMassFlux fixPre94NegativeMassFlux(AirFlow.TotalMassFlux oldtmf) {
        return new AirFlow.TotalMassFlux(SIUS.newud(0.0, 45), oldtmf.tanVelU, oldtmf.tanVelV, oldtmf.func, oldtmf.specInj);
    }

    public static void fixPre95MultipleReacs(Serialized ser, WarningReport<Warning> warns) {
        ArrayList<Reaction> activeReacs = new ArrayList<Reaction>();
        for (Reaction r : ser.reactions.flatten()) {
            if (!r.isActive()) continue;
            activeReacs.add(r);
        }
        if (activeReacs.size() > 1) {
            Reaction theWinner = (Reaction)activeReacs.iterator().next();
            warns.addWarning(new Warning(Intl.intl("Multiple active reactions detected."), String.format(Intl.intl("Reaction %s set as the only active reaction."), theWinner.getName())));
            for (Reaction r : activeReacs) {
                r.setActive(false);
            }
            theWinner.setActive(true);
        }
    }

    public static void bakePre99Transforms(Serialized ser, WarningReport<Warning> warns) {
        for (IPyroGeomSrc src : ser.obstructions.flatten()) {
            IGeomNode geom = src.getGeom().bakeIfRecommended();
            src.setGeom(geom);
        }
    }

    public static void udpateDefaultDTs3d(Serialized ser, WarningReport<Warning> warns) {
        SimParams.FileOutput fo = ser.simParams.getFileOutput();
        if (fo.getDtSlice3dFiles() == null) {
            CustomFDSProps advProps = ser.simParams.getCustomFDSProps("DUMP");
            Map<String, String> propMap = advProps.getProps();
            Double userDefTime = null;
            if (propMap.containsKey("DT_SL3D")) {
                try {
                    userDefTime = Double.valueOf(propMap.get("DT_SL3D"));
                    warns.addWarning(new Warning(Intl.intl("3D Slice output interval detected in Additional Fields."), Intl.intl("3D Slice output interval set moved to Simulation Parameters-Output.")));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    warns.addWarning(new Warning(Intl.intl("Unparseable value for 3D Slice output interval detected in Additional Fields."), Intl.intl("Default 3D Slice output interval of .25s set in Simulation Parameters-Output")));
                }
                HashMap<String, String> newProps = new HashMap<String, String>(propMap);
                newProps.remove("DT_SL3D");
                ser.simParams.setCustomFDSProps("DUMP", CustomFDSProps.get(newProps));
            }
            if (userDefTime == null) {
                userDefTime = 0.25;
            }
            fo.setDtSlice3dFiles(new UnitDouble(userDefTime, SI.SECOND));
        }
    }

    public static void fixDanglingGridRefs(Serialized ser, WarningReport<Warning> warns) {
        for (StatisticsDevc stat : ((APyroObject)ser.devices).flatten(StatisticsDevc.class)) {
            IStatGeom iStatGeom = stat.getStatGeom();
            if (!(iStatGeom instanceof IStatGeom.GridGeom)) continue;
            IStatGeom.GridGeom gridGeom = (IStatGeom.GridGeom)iStatGeom;
            Grid g = gridGeom.grid;
            if (ser.grids.containsDeep(g)) continue;
            warns.addWarning(new Warning(String.format(Intl.intl("Invalid grid %1$s referenced by Statistics %2$s."), g.getName(), stat.getName()), String.format(Intl.intl("Statistics %s converted to record a volume."), stat.getName())));
            AABox bounds = g.getBounds();
            stat.setGeom(new IStatGeom.Box(bounds.getMin(), bounds.getMax()));
        }
    }

    public static void purgeMutantDevices(Serialized ser, WarningReport<Warning> warns) {
        HashSet<IDevice> toDelete = new HashSet<IDevice>();
        for (IDevice devc : ser.devices.flatten()) {
            IGeom geom = devc.getGeom().getLocalGeom();
            if (!(geom instanceof FreePointGeom)) continue;
            FreePointLoc fpl = ((FreePointGeom)geom).loc;
            if (!(fpl.d_geom instanceof LineSeg)) continue;
            toDelete.add(devc);
        }
        ser.devices.removeAll(toDelete);
    }

    public static void fixPre106CyclicControls(Serialized ser, WarningReport<Warning> warns) {
        for (IDevice devc : ser.devices.flatten()) {
            if (!(devc instanceof ISignalSink) || !Util.isCycle((ISignalSink)((Object)devc))) continue;
            warns.addWarning(new Warning(String.format(Intl.intl("Device %s has a cyclic definition."), devc.getName()), String.format(Intl.intl("Device %s has been disconnected from input controls."), devc.getName())));
            ((ISignalSink)((Object)devc)).getInputPin().disconnectAll();
        }
    }

    public static void fixPre107SurfDepDevcs(Serialized ser, WarningReport<Warning> warns) {
        HashMap<GasPointMeasurer, SolidPointMeasurer> changeList = new HashMap<GasPointMeasurer, SolidPointMeasurer>();
        for (IDevice devc : ser.devices.flatten()) {
            AMeasuringDevc measurer;
            if (!(devc instanceof AMeasuringDevc) || !(measurer = (AMeasuringDevc)devc).getQuantity().get().equals((Object)Quantity.SPEC_SURFACE_DEPOSITION) || !(measurer instanceof GasPointMeasurer)) continue;
            GasPointMeasurer gMsr = (GasPointMeasurer)measurer;
            FreePointLoc fpl = gMsr.getLocation();
            UnitPoint3D newLoc = new UnitPoint3D(0.0, 0.0, 0.0, Geometry.LU);
            if (fpl.d_geom instanceof Point) {
                Point pt = (Point)fpl.d_geom;
                newLoc = new UnitPoint3D(pt.loc, Geometry.LU);
            }
            SolidPointMeasurer sMsr = new SolidPointMeasurer(gMsr.getName(), gMsr.getQuantity(), new AttachedPointLoc(newLoc, fpl.d_orientation, fpl.d_rotation));
            changeList.put(gMsr, sMsr);
        }
        if (!changeList.isEmpty()) {
            PyroMod tempMod = new PyroMod(ser, false, false);
            DepSnapshot deps = tempMod.getDependencies(new IPyroObject[0]);
            ser.devices.addAll(changeList.values());
            for (Map.Entry kvPair : changeList.entrySet()) {
                PyroSimObjectInputStream.replaceRefs(deps, (IPyroObject)kvPair.getKey(), (IPyroObject)kvPair.getValue());
            }
            ser.devices.removeAll(changeList.keySet());
        }
    }

    private static int checkHvac(AHvacGeomComponent geomComp, String key, Serialized ser, List<IHvacObject> addedHvacs, List<IHvacObject> renamedHvacs, Set<String> generatedNames, int numBads) {
        Object object = geomComp.getProp(key);
        if (object != null && object instanceof IHvacObject) {
            IHvacObject hvac = (IHvacObject)object;
            IHvacObject inModel = (IHvacObject)ser.hvacSystem.get(hvac.getName());
            if (inModel == null) {
                ser.hvacSystem.add(hvac);
                addedHvacs.add(hvac);
            } else if (hvac != inModel && inModel.equals(hvac)) {
                geomComp.setProp(key, inModel);
                ++numBads;
            } else if (hvac != inModel) {
                NameGenerator ng = null;
                switch (key) {
                    case "AIRCOIL_ID": {
                        ng = ser.hvacAircoilNames;
                        break;
                    }
                    case "FAN_ID": {
                        ng = ser.hvacFanNames;
                        break;
                    }
                    case "FILTER_ID": {
                        ng = ser.hvacFilterNames;
                    }
                }
                assert (ng != null);
                List<String> names = ng.generateValidNames(1, hvac.getName(), Predicates.alwaysFalse(), Filters.reject(generatedNames));
                String name = names.get(0);
                hvac.setName(name);
                generatedNames.add(name);
                ser.hvacSystem.add(hvac);
                renamedHvacs.add(hvac);
            }
        }
        return numBads;
    }

    private static void fixPre111HvacRefs(Serialized ser, WarningReport<Warning> warns) {
        String action;
        new PyroMod(ser, false, false);
        HashSet<String> generatedNames = new HashSet<String>();
        ArrayList<IHvacObject> addedHvacs = new ArrayList<IHvacObject>();
        ArrayList<IHvacObject> renamedHvacs = new ArrayList<IHvacObject>();
        Integer numBads = 0;
        for (HvacNode node : ((APyroObject)ser.obstructions).flatten(HvacNode.class)) {
            numBads = PyroSimObjectInputStream.checkHvac(node, "FILTER_ID", ser, addedHvacs, renamedHvacs, generatedNames, numBads);
        }
        for (HvacDuct duct : ((APyroObject)ser.obstructions).flatten(HvacDuct.class)) {
            numBads = PyroSimObjectInputStream.checkHvac(duct, "AIRCOIL_ID", ser, addedHvacs, renamedHvacs, generatedNames, numBads);
            numBads = PyroSimObjectInputStream.checkHvac(duct, "FAN_ID", ser, addedHvacs, renamedHvacs, generatedNames, numBads);
        }
        if (numBads > 0) {
            System.err.println("Fixed " + numBads + " invalid HVAC component(s) references.");
        }
        if (!addedHvacs.isEmpty()) {
            Object hvacs = "";
            for (int m = 0; m < addedHvacs.size(); ++m) {
                if (m > 0) {
                    hvacs = (String)hvacs + ", ";
                }
                hvacs = (String)hvacs + ((IHvacObject)addedHvacs.get(m)).getName();
            }
            String msg = String.format(Intl.intl("Found %d HVAC component(s) missing from the model: %s"), addedHvacs.size(), hvacs);
            action = Intl.intl("Added extra HVAC component(s) to the model.");
            warns.addWarning(new Warning(msg, action));
        }
        if (!renamedHvacs.isEmpty()) {
            Object str = "";
            for (int i = 0; i < renamedHvacs.size(); ++i) {
                if (i > 0) {
                    str = (String)str + ", ";
                }
                str = (String)str + ((IHvacObject)renamedHvacs.get(i)).getName();
            }
            String msg = String.format(Intl.intl("Renamed %d HVAC component(s) that contains duplicated names in the model: %s"), renamedHvacs.size(), str);
            action = Intl.intl("Renamed HVAC component(s) in the model");
            warns.addWarning(new Warning(msg, action));
        }
        ser.setDomain(null);
    }

    private static void fixPre112HvacDevices(Serialized ser, WarningReport<Warning> warns) {
        ArrayList<pyrosim.domain.devices.hvac.HvacDevice> toDelete = new ArrayList<pyrosim.domain.devices.hvac.HvacDevice>();
        for (pyrosim.domain.devices.hvac.HvacDevice devc : ((APyroObject)ser.devices).flatten(pyrosim.domain.devices.hvac.HvacDevice.class)) {
            ObjectQuantity quant = (ObjectQuantity)devc.getQuantity();
            ArrayList<IHvacGeomComp> validRefs = new ArrayList<IHvacGeomComp>();
            ArrayList<IHvacGeomComp> invalidRefs = new ArrayList<IHvacGeomComp>();
            for (Object obj : quant.objects) {
                if (!(obj instanceof IHvacGeomComp)) continue;
                if (ser.obstructions.containsDeep((IPyroObject)obj)) {
                    validRefs.add((IHvacGeomComp)obj);
                    continue;
                }
                invalidRefs.add((IHvacGeomComp)obj);
            }
            if (validRefs.isEmpty() && !invalidRefs.isEmpty()) {
                warns.addWarning(new Warning(String.format(Intl.intl("The device %s contains references to HVAC components no longer defined in the model."), devc.getName()), Intl.intl("Deleting device.")));
                toDelete.add(devc);
                continue;
            }
            if (validRefs.isEmpty() || invalidRefs.isEmpty()) continue;
            warns.addWarning(new Warning(String.format(Intl.intl("The device %s contains references to HVAC components no longer defined in the model."), devc.getName()), Intl.intl("Removing references to missing components.")));
            ObjectQuantity referenceQuant = (ObjectQuantity)devc.getQuantity();
            ObjectQuantity newQuant = referenceQuant.quantity.create((IPyroObject[])validRefs.stream().toArray(IPyroObject[]::new));
            devc.setQuantity(newQuant);
        }
        for (pyrosim.domain.devices.hvac.HvacDevice devc : toDelete) {
            ser.devices.remove(devc);
        }
    }

    private static void fixPre114SprayAndSprinklerLinkModels(Serialized ser, WarningReport<Warning> warns) {
        ser.sprayModels.addDefaults(ser.particles);
        ser.sprkLinkModels.addDefaults();
    }

    private static void warnPre116WindRecords(Serialized ser, WarningReport<Warning> warns) {
        warns.addWarning(new Warning("Intermediate WIND record invalid.", "WIND record replaced with new default."));
    }

    private static void fixPre117PredefLumped(Serialized ser, WarningReport<Warning> warns) {
        for (ExSpec spec : ser.exSpecs.flatten()) {
            if (spec.getType() != 0 || !spec.getName().equals("AIR") && !spec.getName().equals("PRODUCTS")) continue;
            spec.setType(5);
        }
    }

    private static void updatePre119BackgroundSpecies(Serialized ser, WarningReport<Warning> warns) {
        for (ExSpec spec : ser.exSpecs.flatten()) {
            spec.setIsBackgroundSpec(false);
        }
    }

    private static void updatePre120PredefSoot(Serialized ser, WarningReport<Warning> warns) {
        for (ExSpec spec : ser.exSpecs.flatten()) {
            if (!spec.getName().equals(ExSpecList.Predefined.SOOT.getName()) || !spec.isPredefined()) continue;
            ExSpec predefSoot = ExSpecList.Predefined.SOOT.spec;
            spec.setChemFormula(predefSoot.getChemFormula());
            spec.setMolecularWeight(predefSoot.getMolecularWeight());
        }
    }

    private static void updatePre121ProductsSpec(Serialized ser, WarningReport<Warning> warns) {
        for (ExSpec spec : ser.exSpecs.flatten()) {
            if (!spec.getName().equals(ExSpecList.Predefined.PRODUCTS.getName()) || !spec.isPredefined()) continue;
            ExSpec predefProds = ExSpecList.Predefined.PRODUCTS.spec;
            spec.setChemFormula(predefProds.getChemFormula());
            spec.setMolecularWeight(predefProds.getMolecularWeight());
        }
    }

    public static void removePre122deprecatedQuants(Serialized ser, WarningReport<Warning> warns) {
        boolean quantityReferenced;
        PyroMod tempMod = new PyroMod(ser, false, false);
        LinkedHashSet<StaticQuantity> averageSpecificHeat = new LinkedHashSet<StaticQuantity>();
        averageSpecificHeat.add(Quantity.AVERAGE_SPECIFIC_HEAT.create());
        ArrayList<IDirectDependent> toRemove = new ArrayList<IDirectDependent>();
        block0: for (IMeasurer devc : ((APyroObject)ser.devices).flatten(IMeasurer.class)) {
            for (int m = 0; m < devc.getNumMeasurements(); ++m) {
                if (!averageSpecificHeat.contains(devc.getQuantity(m))) continue;
                toRemove.add(devc);
                continue block0;
            }
        }
        for (Slice slice : ser.slices.flatten()) {
            if (!averageSpecificHeat.contains(slice.getQuantity())) continue;
            toRemove.add(slice);
        }
        for (Isosurface isof : ser.isosurfaces.flatten()) {
            if (!averageSpecificHeat.contains(isof.getQuantity())) continue;
            toRemove.add(isof);
        }
        LinkedHashSet<IQuantity> pl3dQuants = new LinkedHashSet<IQuantity>(ser.plot3d.getQuantities());
        if (pl3dQuants.removeAll(averageSpecificHeat)) {
            ser.plot3d.setQuantities(pl3dQuants);
        }
        boolean bl = quantityReferenced = !toRemove.isEmpty();
        if (quantityReferenced) {
            warns.addWarning(new Warning(Intl.intl("Quantity AVERAGE_SPECIFIC_HEAT is no longer supported."), Intl.intl("All references to AVERAGE_SPECIFIC_HEAT have been removed.")));
        }
        PyroSimObjectInputStream.removeObjs(tempMod, tempMod.getDependencies(new IPyroObject[0]), toRemove, warns);
        ser.setDomain(null);
    }

    public static void warnPre125deprecatedField(Serialized ser, WarningReport<Warning> warns) {
        SimParams.Time timeData = ser.simParams.getTime();
        UnitDouble hvacTimeStep = timeData.getHvacTimeStep();
        if (hvacTimeStep != null) {
            timeData.setHvacTimeStep(null);
            warns.addWarning(new Warning(Intl.intl("FDS field HVAC_DT has been deprecated by FDS."), Intl.intl("Field for HVAC Initial Time Step has been dropped.")));
        }
    }

    public static void updatePre126Surfs(Serialized ser, WarningReport<Warning> warns) {
        for (Surface surf : ser.surfmgr.flatten()) {
            if (!(surf.getSurfDesc() instanceof LayeredSurfDesc)) continue;
            LayeredSurfDesc oldLayerProps = (LayeredSurfDesc)surf.getSurfDesc();
            if (oldLayerProps.d_temperature.isCalcTempTR()) continue;
            double emissivity = pyrosim.domain.boundcond.surf.TempRegulation.getDefaultEmissivity();
            UnitDouble htCoef = pyrosim.domain.boundcond.surf.TempRegulation.getDefaultHtCoef_legacy();
            boolean log = pyrosim.domain.boundcond.surf.TempRegulation.getDefaultLog();
            TempRegulation.ThermalBCs bcs = oldLayerProps.d_temperature.d_thermalBCs;
            if (bcs.d_emissivity != emissivity) {
                emissivity = bcs.d_emissivity;
            }
            if (oldLayerProps.d_temperature.d_htCoef != null && oldLayerProps.d_temperature.d_htCoef != htCoef) {
                htCoef = oldLayerProps.d_temperature.d_htCoef;
            }
            if (oldLayerProps.d_temperature.d_logarithmic != log) {
                log = oldLayerProps.d_temperature.d_logarithmic;
            }
            pyrosim.domain.boundcond.surf.TempRegulation newReg = pyrosim.domain.boundcond.surf.TempRegulation.newCalcTempTR(emissivity, Variant.constOrDefault(htCoef), log);
            LayeredSurfDesc newDesc = new LayeredSurfDesc(oldLayerProps.d_geometry, oldLayerProps.d_slip, oldLayerProps.d_iReac, oldLayerProps.d_surfComp, oldLayerProps.d_specInj, oldLayerProps.d_partInj, oldLayerProps.d_burnAway, oldLayerProps.d_leakPath, newReg);
            surf.setSurfDesc(newDesc);
            warns.addWarning(new Warning(Intl.intl("Layered surfaces must use the Temperature Calculated boundary condition."), String.format(Intl.intl("Surface %s now uses a Temperature Calculated boundary condition."), surf.getName())));
        }
    }

    public static void fixPre128Leaks(Serialized ser, WarningReport<Warning> warns) {
        ArrayList<Leak> toPurge = new ArrayList<Leak>();
        for (IBridgeObj b : ser.bridges.flatten()) {
            Leak l;
            if (!(b instanceof Leak) || !(l = (Leak)b).containsZone(null)) continue;
            toPurge.add(l);
        }
        ser.bridges.removeAll(toPurge);
    }

    public static void fixPre131AspiratorUnits(Serialized ser, WarningReport<Warning> warns) {
        for (Aspirator asp : ((APyroObject)ser.devices).flatten(Aspirator.class)) {
            AlarmInfo alarm = asp.getMsrInfo().getAlarmInfo();
            if (alarm == null) continue;
            UnitDouble oldSetpoint = alarm.setpoint;
            int tripFlags = alarm.tripFlags;
            UnitDouble newSetpoint = SIUS.newud(oldSetpoint.getRawValue(), 57);
            asp.getMsrInfo().setAlarmInfo(new AlarmInfo(newSetpoint, tripFlags));
        }
    }

    public static void fixPre133ThermalBCs(Serialized ser, WarningReport<Warning> warns) {
        for (Surface surf : ser.surfmgr.flatten()) {
            if (!(surf.getSurfDesc() instanceof LayeredSurfDesc)) continue;
            LayeredSurfDesc lsd = (LayeredSurfDesc)surf.getSurfDesc();
            pyrosim.domain.boundcond.surf.TempRegulation legacyTR = lsd.d_temperature;
            pyrosim.domain.boundcond.surf.TempRegulation newTR = pyrosim.domain.boundcond.surf.TempRegulation.newCalcTempTR(legacyTR.d_thermalBCs.d_emissivity, Variant.constOrDefault(legacyTR.d_htCoef), legacyTR.d_logarithmic);
            surf.setSurfDesc(new LayeredSurfDesc(lsd.d_geometry, lsd.d_slip, lsd.d_iReac, lsd.d_surfComp, lsd.d_specInj, lsd.d_partInj, lsd.d_burnAway, lsd.d_leakPath, newTR));
        }
    }

    public static void fixPre134SurfaceProps(Serialized ser, WarningReport<Warning> warns) {
        for (Surface surf : ser.surfmgr.flatten()) {
            if (!(surf.getSurfDesc() instanceof LayeredSurfDesc)) continue;
            LayeredSurfDesc lsdOld = (LayeredSurfDesc)surf.getSurfDesc();
            SurfComposition temp = lsdOld.d_surfComp;
            TimeFunction defFunc = TimeFunction.newDefault();
            if (!defFunc.equals(temp.d_tempRamp)) {
                warns.addWarning(new Warning(String.format(Intl.intl("Invalid Temperature Ramp applied in Surface Props to Surface %s."), surf.getName()), Intl.intl("Invalid Temperature Ramp will be removed.")));
            }
            Variant newInnerTemp = temp.d_initInnerTemp != null ? Variant.constant(temp.d_initInnerTemp) : Variant.constant(new UnitDouble(20.0, SI.CELSIUS));
            SurfComposition newComp = new SurfComposition(newInnerTemp, temp.d_backing, temp.d_layerDivide, temp.d_layers);
            surf.setSurfDesc(new LayeredSurfDesc(lsdOld.d_geometry, lsdOld.d_iReac, newComp, lsdOld.d_specInj, lsdOld.d_partInj, lsdOld.d_burnAway, lsdOld.d_leakPath, lsdOld.d_temperature));
        }
    }

    public static void fixPre135ScenarioData(Serialized ser, WarningReport<Warning> warns) {
        for (IPyroObject iPyroObject : PyroMod.getMembers(ser, false)) {
            ser.scenarios.getActive().recordStatus(iPyroObject);
        }
    }

    public static void fixPre138ViscousWallUnitsQuantity(Serialized ser, WarningReport<Warning> warns) {
        HashSet<IDevice> toDelete = new HashSet<IDevice>();
        for (IDevice dev : ser.devices.flatten()) {
            if (!(dev instanceof GasPointMeasurer) || ((GasPointMeasurer)dev).getQuantity().get() != Quantity.YPLUS) continue;
            toDelete.add(dev);
        }
        if (!toDelete.isEmpty()) {
            PyroMod tempMod = new PyroMod(ser, false, false);
            PyroSimObjectInputStream.removeObjs(tempMod, tempMod.getDependencies(new IPyroObject[0]), toDelete, warns);
        }
    }

    public static void fixPre139CpuPerTimeStepQuantity(Serialized ser, WarningReport<Warning> warns) {
        HashSet<IDevice> toDelete = new HashSet<IDevice>();
        for (IDevice dev : ser.devices.flatten()) {
            if (!(dev instanceof GasPointMeasurer) || ((GasPointMeasurer)dev).getQuantity().get() != Quantity.CPU_TIME_PER_STEP) continue;
            toDelete.add(dev);
        }
        if (!toDelete.isEmpty()) {
            PyroMod tempMod = new PyroMod(ser, false, false);
            PyroSimObjectInputStream.removeObjs(tempMod, tempMod.getDependencies(new IPyroObject[0]), toDelete, warns);
        }
    }

    public static void warnPre140PeriodicWindVent(Serialized ser, WarningReport<Warning> warns) {
        for (IModelObj obj : ser.obstructions.flatten()) {
            pyrosim.domain.geom.Vent v;
            LinkedHashMap<String, String> propMap;
            if (!(obj instanceof pyrosim.domain.geom.Vent) || !(propMap = new LinkedHashMap<String, String>((v = (pyrosim.domain.geom.Vent)obj).getCustomFDSProps().getProps())).containsKey("WIND")) continue;
            propMap.remove("WIND");
            v.setSurface(ser.surfmgr.get(PredefSurf.PERIODIC_FLOW_ONLY));
            v.setCustomFDSProps(CustomFDSProps.get(propMap));
            warns.addWarning(new Warning(String.format(Intl.intl("%s is using a deprecated property WIND."), v.getName()), String.format(Intl.intl("The WIND property was removed and the SURF_ID was changed to PERIODIC_FLOW_ONLY."), v.getName())));
        }
    }

    public static void prunePre142ControlValueDevices(Serialized ser, WarningReport<Warning> warns) {
        ArrayList<IDevice> toRemove = new ArrayList<IDevice>();
        for (IDevice devc : ser.devices.flatten()) {
            if (!(devc instanceof ControlValueDevice)) continue;
            toRemove.add(devc);
        }
        ser.devices.removeAll(toRemove);
    }

    public static void reinterpretPre143MultiplyOps(Serialized ser) {
        ArrayList<pyrosim.legacy.v142.domain.controls.MathOps.MultiplyOp> toReinterpret = new ArrayList<pyrosim.legacy.v142.domain.controls.MathOps.MultiplyOp>();
        for (ControlBridge cb : ser.controls.flatten()) {
            AMathOp mathOp;
            if (!cb.isMathControl() || !((mathOp = (AMathOp)cb.getInputPin().getConnectedSources().iterator().next()) instanceof pyrosim.legacy.v142.domain.controls.MathOps.MultiplyOp)) continue;
            toReinterpret.add((pyrosim.legacy.v142.domain.controls.MathOps.MultiplyOp)mathOp);
        }
        PyroMod tempMod = new PyroMod(ser, false, false);
        DepSnapshot dss = tempMod.getDependencies(toReinterpret);
        for (pyrosim.legacy.v142.domain.controls.MathOps.MultiplyOp legMult : toReinterpret) {
            MultiplyOp manyInputMult = new MultiplyOp();
            MeasureOutInfo newInfo = manyInputMult.getMeasureInfo();
            MeasureOutInfo legInfo = legMult.getMeasureInfo();
            newInfo.setAlarmInfo(legInfo.getAlarmInfo());
            newInfo.setEnabled(legInfo.isEnabled());
            Set<? extends IOutPin> sourcePins = legMult.getInputPin().getConnections();
            for (IOutPin iOutPin : new ArrayList<IOutPin>(sourcePins)) {
                legMult.getInputPin().disconnect(iOutPin);
                manyInputMult.getInputPin().connect(iOutPin);
            }
            Set<Dependency> deps = dss.getDependents(legMult);
            for (Dependency dep : deps) {
                assert (dep.source instanceof ControlBridge.ControlBridgeAdapterInPin);
                if (!(dep.source instanceof ControlBridge.ControlBridgeAdapterInPin)) continue;
                ControlBridge.ControlBridgeAdapterInPin bridgeInPin = (ControlBridge.ControlBridgeAdapterInPin)dep.source;
                bridgeInPin.disconnect(legMult.getLogicOut());
                bridgeInPin.disconnect(legMult.getDoubleOut());
                for (IOutPin iOutPin : manyInputMult.getOutputPins()) {
                    bridgeInPin.connect(iOutPin);
                }
            }
        }
    }

    public static void removePre144HRRPUAQuantFromDevice(Serialized ser, WarningReport<Warning> warns) {
        boolean quantityReferenced;
        PyroMod tempMod = new PyroMod(ser, false, false);
        LinkedHashSet<StaticQuantity> hrrpua = new LinkedHashSet<StaticQuantity>();
        hrrpua.add(Quantity.HRRPUA.create());
        ArrayList<IMeasurer> toRemove = new ArrayList<IMeasurer>();
        block0: for (IMeasurer devc : ser.devices.flatten(IMeasurer.class, msr -> !(msr instanceof StatisticsDevc))) {
            for (int m = 0; m < devc.getNumMeasurements(); ++m) {
                if (!hrrpua.contains(devc.getQuantity(m))) continue;
                toRemove.add(devc);
                continue block0;
            }
        }
        boolean bl = quantityReferenced = !toRemove.isEmpty();
        if (quantityReferenced) {
            warns.addWarning(new Warning(Intl.intl("Quantity HRRPUA is only supported as a solid-phase device."), Intl.intl("All invalid references to HRRPUA have been removed.")));
        }
        PyroSimObjectInputStream.removeObjs(tempMod, tempMod.getDependencies(new IPyroObject[0]), toRemove, warns);
        ser.setDomain(null);
    }

    public static void removeBadQuantityRefs(Serialized ser, WarningReport<Warning> warns) {
        PyroMod tempMod = new PyroMod(ser, false, false);
        ArrayList<AMeasuringDevc> toRemove = new ArrayList<AMeasuringDevc>();
        block0: for (AMeasuringDevc devc : ((APyroObject)ser.devices).flatten(AMeasuringDevc.class)) {
            for (int m = 0; m < devc.getNumMeasurements(); ++m) {
                if (devc.getQuantity(m) != null) continue;
                toRemove.add(devc);
                continue block0;
            }
        }
        if (!toRemove.isEmpty()) {
            warns.addWarning(new Warning(Intl.intl("Some devices are referencing non-existent quantities."), Intl.intl("Invalid devices will be removed.")));
        }
        PyroSimObjectInputStream.removeObjs(tempMod, tempMod.getDependencies(new IPyroObject[0]), toRemove, warns);
        ser.setDomain(null);
    }

    private static void fixPre149DefaultSurfs(Serialized ser, WarningReport<Warning> warns) {
        PyroMod tempMod = new PyroMod(ser, false, false);
        tempMod.refreshDefaultSurface();
        ser.setDomain(null);
    }

    private static void fixPre150FlowMeasurers(Serialized ser, WarningReport<Warning> warns) {
        for (FlowMeasurer devc : ((APyroObject)ser.devices).flatten(FlowMeasurer.class)) {
            byte plane = devc.getRect().d_plane;
            Quantity newQuant = null;
            if (devc.getQuantity().get().equals((Object)Quantity.HEAT_FLOW)) {
                switch (plane) {
                    case 0: {
                        newQuant = Quantity.ENTHALPY_FLOW_X;
                        break;
                    }
                    case 1: {
                        newQuant = Quantity.ENTHALPY_FLOW_Y;
                        break;
                    }
                    case 2: {
                        newQuant = Quantity.ENTHALPY_FLOW_Z;
                    }
                }
            } else if (devc.getQuantity().get().equals((Object)Quantity.HEAT_FLOW_WALL)) {
                newQuant = Quantity.ENTHALPY_FLOW_WALL;
            } else if (devc.getQuantity().get().equals((Object)Quantity.MASS_FLOW)) {
                switch (plane) {
                    case 0: {
                        newQuant = Quantity.NOSPEC_MASS_FLOW_X;
                        break;
                    }
                    case 1: {
                        newQuant = Quantity.NOSPEC_MASS_FLOW_Y;
                        break;
                    }
                    case 2: {
                        newQuant = Quantity.NOSPEC_MASS_FLOW_Z;
                    }
                }
            } else if (devc.getQuantity().get().equals((Object)Quantity.MASS_FLOW_WALL)) {
                newQuant = Quantity.NOSPEC_MASS_FLOW;
            } else if (devc.getQuantity().get().equals((Object)Quantity.VOLUME_FLOW)) {
                switch (plane) {
                    case 0: {
                        newQuant = Quantity.VOLUME_FLOW_X;
                        break;
                    }
                    case 1: {
                        newQuant = Quantity.VOLUME_FLOW_Y;
                        break;
                    }
                    case 2: {
                        newQuant = Quantity.VOLUME_FLOW_Z;
                    }
                }
            } else if (devc.getQuantity().get().equals((Object)Quantity.VOLUME_FLOW_WALL)) {
                newQuant = Quantity.VOLUME_FLOW_BOUNDARY;
            }
            StaticQuantity newMsr = newQuant.create();
            Unit newUnit = PyroSim.getApp().getUnitSystem().getUnit(newMsr.get().unitType);
            devc.setQuantity(newMsr, newUnit);
        }
    }

    private static void fixPre151SurfaceReferences(Serialized ser, WarningReport<Warning> warns) {
        for (Obstruction obst : ((APyroObject)ser.obstructions).flatten(Obstruction.class)) {
            String obstName = obst.getName();
            Surface[] surfs = obst.getSurfaces();
            boolean surfChanged = false;
            for (int i = 0; i < surfs.length; ++i) {
                Surface surf = surfs[i];
                if (!surf.isPredefined(PredefSurf.PERIODIC_FLOW_ONLY)) continue;
                surfs[i] = ser.surfmgr.getDefaultSurfaceObj();
                surfChanged = true;
            }
            if (!surfChanged) continue;
            obst.setSurfaces(surfs);
            String msg = Intl.intl("PERIODIC_FLOW_ONLY Surface is invalid for Obstructions.");
            String action = String.format(Intl.intl("Replaced PERIODIC_FLOW_ONLY Surface(s) with Default Surface on Obstruction \"%s\""), obstName);
            warns.addWarning(new Warning(msg, action));
        }
    }

    private static void fixPre152SliceNames(Serialized ser, WarningReport<Warning> warns) {
        NameGenerator ng;
        for (Slice slice : ser.slices.flatten()) {
            ng = ser.sliceNames;
            slice.setName(ng.generateValidName(Intl.intl("Slice")));
            ng.registerName(slice.getName());
        }
        for (Slice slice : ser.slices3d.flatten()) {
            ng = ser.slice3dNames;
            slice.setName(ng.generateValidName(slice.getName()));
            ng.registerName(slice.getName());
        }
    }

    private static void prunePre153LatchControls(Serialized ser, WarningReport warns) {
        for (ControlBridge cb : ser.controls.flatten()) {
            pyrosim.domain.controls.Util.removeLinks(cb, LatchCtrl.class);
        }
    }

    private static void updatePre154HvacLeakDefaultLossValue(Serialized ser, WarningReport warns) {
        for (IHvacObject hvac : ser.hvacSystem.flatten()) {
            HvacLeak leak;
            UnitDouble loss;
            if (!(hvac instanceof HvacLeak) || (loss = (leak = (HvacLeak)hvac).getLoss()).getValueNoUnit() != 0.0) continue;
            leak.setLoss(new UnitDouble(1.0, Unit.ONE));
            String msg = String.format(Intl.intl("Incorrect default LOSS value on HVAC Leak %s"), leak.getName());
            String act = String.format(Intl.intl("HVAC Leak %s updated to corrected default of 1.0"), leak.getName());
            warns.addWarning(new Warning(msg, act));
        }
    }

    private static void updateVolumeSliceNamesPre156(Serialized ser, WarningReport<Warning> warns) {
        for (VolumeSlice slice : ser.slices3d.flatten()) {
            NameGenerator ng = ser.slice3dNames;
            slice.setName(ng.generateValidName(slice.getPre152Name()));
            ng.registerName(slice.getName());
        }
    }

    private static void updatePre158SimpleChemistry(Serialized ser, WarningReport warnings) {
        boolean isMultiReac;
        boolean hasLegacyReacFuel;
        ExSpec sharedLegacyFuel = ser.exSpecs.flatten(spec -> spec.isReacFuel()).stream().findFirst().orElse(null);
        boolean bl = hasLegacyReacFuel = sharedLegacyFuel != null;
        if (!hasLegacyReacFuel) {
            return;
        }
        int numReacs = 0;
        boolean hasActiveReac = false;
        for (Reaction r2 : ser.reactions.flatten(r -> r.getFuel().isReacFuel())) {
            ++numReacs;
            if (r2.isActive()) {
                r2.getFuel().setReactionForFuel(r2);
                hasActiveReac = true;
                continue;
            }
            ser.exSpecs.generateFuelForReaction(r2, true);
        }
        boolean bl2 = isMultiReac = numReacs > 1;
        if (hasLegacyReacFuel && !hasActiveReac) {
            PyroMod tempMod = new PyroMod(ser, false, false);
            PyroSimObjectInputStream.removeObjs(tempMod, tempMod.getDependencies(new IPyroObject[0]), Arrays.asList(sharedLegacyFuel), warnings);
            ser.setDomain(null);
        } else if (isMultiReac && hasLegacyReacFuel) {
            warnings.addWarning(new Warning(Intl.intl("Simple chemistry Reactions no longer use a shared fuel Species."), Intl.intl("Inactive simple chemistry Reactions now reference a uniquely named fuel Species.")));
        }
    }

    public static void updatePre159SimpleChemistry(Serialized ser, WarningReport warns) {
        boolean hasLegacyReacFuel;
        ExSpec sharedLegacyFuel = ser.exSpecs.flatten(spec -> spec.isReacFuel()).stream().findFirst().orElse(null);
        boolean bl = hasLegacyReacFuel = sharedLegacyFuel != null;
        if (!hasLegacyReacFuel) {
            return;
        }
        Reaction activeSimpleChem = ser.reactions.flatten(r -> r.getFuel().isReacFuel() && r.isActive()).stream().findFirst().orElse(null);
        if (activeSimpleChem != null) {
            ExSpec newSpec = PyroSimObjectInputStream.generateExSpecForReaction(activeSimpleChem);
            ser.exSpecs.add(newSpec);
            PyroSimObjectInputStream.replaceRefs(ser, (IPyroObject)sharedLegacyFuel, (IPyroObject)newSpec);
            ser.exSpecs.remove(sharedLegacyFuel);
            warns.addWarning(new Warning(Intl.intl("Reactions may no longer reference a Fuel that is not explicitly defined as a Species."), String.format(Intl.intl("Fuel Species %s converted to a traditional Species."), newSpec.getName())));
        } else {
            List simpleChemReacts = ser.reactions.flatten(r -> r.getFuel().isReacFuel()).stream().collect(Collectors.toList());
            if (simpleChemReacts.size() == 1) {
                ExSpec newSpec = PyroSimObjectInputStream.generateExSpecForReaction((Reaction)simpleChemReacts.get(0));
                ser.exSpecs.add(newSpec);
                PyroSimObjectInputStream.replaceRefs(ser, (IPyroObject)sharedLegacyFuel, (IPyroObject)newSpec);
                ser.exSpecs.remove(sharedLegacyFuel);
                warns.addWarning(new Warning(Intl.intl("Reactions may no longer reference a Fuel that is not explicitly defined as a Species."), String.format(Intl.intl("Fuel Species %s converted to a traditional Species."), newSpec.getName())));
            } else {
                PyroMod tempMod = new PyroMod(ser, false, false);
                for (Reaction r2 : simpleChemReacts) {
                    ExSpec newSpec = PyroSimObjectInputStream.generateExSpecForReaction(r2);
                    ser.exSpecs.add(newSpec);
                    r2.setFuel(newSpec);
                }
                PyroSimObjectInputStream.removeObjs(tempMod, tempMod.getDependencies(sharedLegacyFuel), Arrays.asList(sharedLegacyFuel), warns);
            }
        }
    }

    private static ExSpec generateExSpecForReaction(Reaction r) {
        ExSpec newSpec = new ExSpec(r.getName(), 1);
        String comp = "C" + r.getC() + "H" + r.getH() + "O" + r.getO() + "N" + r.getN();
        newSpec.setChemFormula(comp);
        return newSpec;
    }

    public static void warnPre160SootHFraction(Serialized ser, WarningReport warns) {
        ArrayList<Reaction> reacsToWarn = new ArrayList<Reaction>();
        double defaultSootFracValue = 0.1;
        for (Reaction reac : ser.reactions.flatten(r -> r.isSimpleChemReaction())) {
            if (theUtil.eq(reac.getSootHFraction(), defaultSootFracValue, 1.0E-6)) continue;
            reacsToWarn.add(reac);
        }
        if (!reacsToWarn.isEmpty()) {
            warns.addWarning(new Warning(String.format(Intl.intl("The parameter %s is no longer supported as of FDS 6.8.0."), "SOOT_H_FRACTION"), String.format(Intl.intl("%s removed from all simple chemistry reactions."), "SOOT_H_FRACTION")));
        }
    }

    public static void fixPre162SolidParticles(Serialized ser, WarningReport warns) {
        DefaultSurface defSurf = ser.surfmgr.getDefaultSurfaceObj();
        for (Particle part : ser.particles.flatten(p -> p.isSolidPart())) {
            if (part.getSurface() != null) continue;
            part.setSurface(defSurf);
        }
    }

    public static void removePre163HvacQuant(Serialized ser, WarningReport warns) {
        boolean quantityReferenced;
        PyroMod tempMod = new PyroMod(ser, false, false);
        ArrayList<pyrosim.domain.devices.hvac.HvacDevice> toRemove = new ArrayList<pyrosim.domain.devices.hvac.HvacDevice>();
        for (pyrosim.domain.devices.hvac.HvacDevice devc : ((APyroObject)ser.devices).flatten(pyrosim.domain.devices.hvac.HvacDevice.class)) {
            if (!Quantity.HVAC_DUCT_ENERGY_FLOW.equals((Object)devc.getQuantity().get())) continue;
            toRemove.add(devc);
            break;
        }
        boolean bl = quantityReferenced = !toRemove.isEmpty();
        if (quantityReferenced) {
            warns.addWarning(new Warning(Intl.intl("Quantity HVAC_DUCT_ENERGY_FLOW is no longer supported."), Intl.intl("All references to HVAC_DUCT_ENERGY_FLOW have been removed.")));
        }
        PyroSimObjectInputStream.removeObjs(tempMod, tempMod.getDependencies(new IPyroObject[0]), toRemove, warns);
        ser.setDomain(null);
    }

    public static void updatePre164FEDDevices(Serialized ser, WarningReport warns) {
        HashMap<GasPointMeasurer, FEDMeasurer> changeList = new HashMap<GasPointMeasurer, FEDMeasurer>();
        for (GasPointMeasurer dev : ((APyroObject)ser.devices).flatten(GasPointMeasurer.class)) {
            if (dev.getQuantity().get() != Quantity.FED) continue;
            FEDMeasurer fm = new FEDMeasurer(dev.getName(), 2, dev.getLocation());
            ArrayList<String> recType = new ArrayList<String>(1);
            dev.getCustomFDSTypes(recType);
            CustomFDSProps props = dev.getCustomFDSProps((String)recType.get(0));
            fm.setCustomFDSProps((String)recType.get(0), props);
            fm.getMsrInfo().setAlarmInfo(dev.getMsrInfo().getAlarmInfo());
            changeList.put(dev, fm);
        }
        if (!changeList.isEmpty()) {
            PyroMod tempMod = new PyroMod(ser, false, false);
            DepSnapshot deps = tempMod.getDependencies(new IPyroObject[0]);
            ser.devices.addAll(changeList.values());
            for (Map.Entry kvPair : changeList.entrySet()) {
                PyroSimObjectInputStream.replaceRefs(deps, (IPyroObject)kvPair.getKey(), (IPyroObject)kvPair.getValue());
                warns.addWarning(new Warning(String.format(Intl.intl("'%s' uses old FED Device."), ((IDevice)kvPair.getKey()).getName()), Intl.intl("Unspecified 'Activity Level' set to 'Light Activity' (default).")));
            }
            ser.devices.removeAll(changeList.keySet());
        }
    }

    public static void notifyPre166Wind(Serialized ser, WarningReport warns) {
        SimParams.Wind wind = ser.simParams.getWind();
        String baseWarnString = Intl.intl("Wind ramp %s is deprecated as of FDS 6.7.8.");
        String actionString = Intl.intl("Out of date Wind inputs removed.");
        if (!wind.get(SimParams.Wind.U0Z).isDefault()) {
            warns.addWarning(new Warning(String.format(baseWarnString, "RAMP_U0_Z"), actionString));
        }
        if (!wind.get(SimParams.Wind.V0Z).isDefault()) {
            warns.addWarning(new Warning(String.format(baseWarnString, "RAMP_V0_Z"), actionString));
        }
        if (!wind.get(SimParams.Wind.W0Z).isDefault()) {
            warns.addWarning(new Warning(String.format(baseWarnString, "RAMP_W0_Z"), actionString));
        }
        if (!wind.get(SimParams.Wind.U0T).isDefault()) {
            warns.addWarning(new Warning(String.format(baseWarnString, "RAMP_U0_T"), actionString));
        }
        if (!wind.get(SimParams.Wind.V0T).isDefault()) {
            warns.addWarning(new Warning(String.format(baseWarnString, "RAMP_V0_T"), actionString));
        }
        if (!wind.get(SimParams.Wind.W0Z).isDefault()) {
            warns.addWarning(new Warning(String.format(baseWarnString, "RAMP_W0_T"), actionString));
        }
    }

    public static void fixPre169DanglingSpecRef(Serialized ser, WarningReport warns) {
        HashSet<ExSpec> purgedSpecs = new HashSet<ExSpec>();
        for (Reaction r2 : ser.reactions.flatten(r -> r.getFuel().isReacFuel())) {
            ExSpec newSpec = PyroSimObjectInputStream.generateExSpecForReaction(r2);
            ser.exSpecs.add(newSpec);
            purgedSpecs.add(r2.getFuel());
            r2.setFuel(newSpec);
        }
        PyroMod tempMod = new PyroMod(ser, false, false);
        PyroSimObjectInputStream.removeObjs(tempMod, tempMod.getDependencies(purgedSpecs), purgedSpecs, warns);
    }

    public static void fixPre170FEDPlot3DQuants(Serialized ser, WarningReport<Warning> warns) {
        PyroMod tempMod = new PyroMod(ser, false, false);
        LinkedHashSet<StaticQuantity> FEDQuant = new LinkedHashSet<StaticQuantity>();
        FEDQuant.add(Quantity.FED.create());
        ArrayList<Slice> toRemove = new ArrayList<Slice>();
        for (Slice slice : ser.slices.flatten()) {
            if (!FEDQuant.contains(slice.getQuantity())) continue;
            toRemove.add(slice);
        }
        boolean quantityReferenced = !toRemove.isEmpty();
        LinkedHashSet<IQuantity> pl3dQuants = new LinkedHashSet<IQuantity>(ser.plot3d.getQuantities());
        if (pl3dQuants.removeAll(FEDQuant)) {
            quantityReferenced = true;
            ser.plot3d.setQuantities(pl3dQuants);
        }
        if (quantityReferenced) {
            warns.addWarning(new Warning(Intl.intl("Quantity Fractional Effective Dose (FED) is not supported in Plot3D or Slice output."), Intl.intl("All invalid references to Fractional Effective Dose (FED) have been removed.")));
        }
        PyroSimObjectInputStream.removeObjs(tempMod, tempMod.getDependencies(new IPyroObject[0]), toRemove, warns);
        ser.setDomain(null);
    }

    public static void fixPre171FlowMeasurerQuants(Serialized ser, WarningReport<Warning> warns) {
        for (FlowMeasurer devc : ((APyroObject)ser.devices).flatten(FlowMeasurer.class)) {
            devc.updateQuantity();
        }
    }

    public static void fixPre172SurfLayeredHt3d(Serialized ser, WarningReport<Warning> warns) {
        for (Surface surf : ((APyroObject)ser.surfmgr).flatten(Surface.class)) {
            ISurfDesc iSurfDesc = surf.getSurfDesc();
            if (!(iSurfDesc instanceof LayeredSurfDesc)) continue;
            LayeredSurfDesc oldSurfDesc = (LayeredSurfDesc)iSurfDesc;
            if (oldSurfDesc.d_ht3d == null || !oldSurfDesc.d_ht3d.d_normalDirectionOnly) continue;
            LayeredSurfDesc updatedSurfDesc = new LayeredSurfDesc(oldSurfDesc.d_geometry, oldSurfDesc.d_iReac, oldSurfDesc.d_surfComp, oldSurfDesc.d_specInj, oldSurfDesc.d_partInj, oldSurfDesc.d_burnAway, oldSurfDesc.d_leakPath, oldSurfDesc.d_temperature, new HeatTransfer3D(oldSurfDesc.d_ht3d.d_cellSize));
            surf.setSurfDesc(updatedSurfDesc);
            String problem = String.format(Intl.intl("Surface %s uses obsolete model 1D-to-3D."), surf.getName());
            String action = String.format(Intl.intl("Heat transfer model updated, please review."), new Object[0]);
            warns.addWarning(new Warning(problem, action));
        }
    }

    public static void regeneratePre147ResultsIds(Optional<File> file, Serialized ser, WarningReport<Warning> warns) {
        ResultsIdGen gen = file.map(f -> new ResultsIdGen(Objects.hash(f.getName(), f.length()))).orElse(new ResultsIdGen(0L));
        for (APyroObject obj : Hierarchy.flatten(PyroMod.getMembers(ser, true), APyroObject.class)) {
            obj.generateResultsIds(gen);
        }
        ser.resultsArchive.generateResultsIds(gen);
    }

    public static void convertPre173Statistics(Serialized ser, WarningReport<Warning> warnings) {
        StatisticMgr legacyStats = (StatisticMgr)ser.msrStats;
        ser.msrStats = null;
        if (legacyStats.isEmpty()) {
            return;
        }
        Composite statGroup = ser.devices.newGroup(Intl.intl("Statistics"));
        NameGenerator tempNameGen = ser.devcNames.clone();
        ser.devices.flatten().forEach(o -> tempNameGen.registerName(o.getName()));
        ArrayList addedDevices = new ArrayList();
        MutableInt numConverted = new MutableInt(0);
        for (IPyroObject child : legacyStats.getChildren()) {
            PyroSimObjectInputStream.convertPre173Statistics((legStat, newDevcs) -> {
                ++numConverted.val;
                addedDevices.addAll(newDevcs);
            }, tempNameGen, warnings, statGroup, child);
        }
        ser.devices.add(statGroup);
        ArrayList<IPyroObject> removedStats = new ArrayList<IPyroObject>(((APyroObject)legacyStats).flatten(IMeasurementStat.class));
        for (Scenario scenario : ((APyroObject)ser.scenarios).flatten(Scenario.class)) {
            scenario.removeDeletedObjs(removedStats);
            scenario.recordStatus(addedDevices);
        }
        if (numConverted.val > 0) {
            warnings.addWarning(new Warning(Intl.intl("Statistics are now supported as devices instead of output objects."), String.format(Intl.intl("%1$d Statistics Objects converted into devices and placed under '%2$s->%3$s'."), numConverted.val, ser.devices.getName(), statGroup.getName())));
        }
    }

    private static void convertPre173Statistics(BiConsumer<? super AMsrStat, List<StatisticsDevc>> result, NameGenerator tempNameGen, WarningReport<Warning> warnings, Composite<? super IDevice> parent, IPyroObject obj) {
        if (obj instanceof Composite) {
            Composite c = (Composite)obj;
            Composite<? super IDevice> group = parent.newGroup(c.getName());
            parent.add(group);
            for (IPyroObject child : c.getChildren()) {
                PyroSimObjectInputStream.convertPre173Statistics(result, tempNameGen, warnings, group, child);
            }
        } else if (obj instanceof AMsrStat) {
            AMsrStat legacyStatObj = (AMsrStat)obj;
            Composite<? super IDevice> deviceGroup = parent;
            if (legacyStatObj.d_stats.size() > 1) {
                deviceGroup = parent.newGroup(legacyStatObj.getName());
                parent.add(deviceGroup);
            }
            Function<IStatGeom.ArrayProfile, IStatGeom> getGeom = profile -> {
                Object object = legacyStatObj.d_geom;
                Objects.requireNonNull(object);
                Object selector0$temp = object;
                int index$1 = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Point.class, AABoxGeom.class, AARectangle.class, StatGeom.GridGeom.class, StatGeom.LinearPointArrayGeom.class, StatGeom.LinearVolumeArrayGeom.class}, (Object)selector0$temp, index$1)) {
                    case 0 -> {
                        Point p = (Point)selector0$temp;
                        yield new IStatGeom.Point(p.loc);
                    }
                    case 1 -> {
                        AABoxGeom box = (AABoxGeom)selector0$temp;
                        yield new IStatGeom.Box(box.min, box.max, box.swizzle, box.cw);
                    }
                    case 2 -> {
                        AARectangle rect = (AARectangle)selector0$temp;
                        yield new IStatGeom.Rectangle(rect);
                    }
                    case 3 -> {
                        StatGeom.GridGeom grid = (StatGeom.GridGeom)selector0$temp;
                        yield new IStatGeom.GridGeom(grid.grid);
                    }
                    case 4 -> {
                        StatGeom.LinearPointArrayGeom arr = (StatGeom.LinearPointArrayGeom)selector0$temp;
                        yield new IStatGeom.LinearArray((IStatGeom.ArrayProfile)((Object)profile), arr.p1, arr.p2, IStatGeom.POINT_ARRAY, arr.d_numPoints);
                    }
                    case 5 -> {
                        StatGeom.LinearVolumeArrayGeom arr = (StatGeom.LinearVolumeArrayGeom)selector0$temp;
                        yield new IStatGeom.LinearArray((IStatGeom.ArrayProfile)((Object)profile), arr.p1, arr.p2, arr.d_delta, arr.d_numPoints);
                    }
                    default -> {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        yield new IStatGeom.Point(GeomConstants.PNT3D_ORIGIN);
                    }
                };
            };
            IStatGeom timeVaryingGeom = getGeom.apply(IStatGeom.ArrayProfile.TIME_VARYING);
            IStatGeom steadyStateGeom = getGeom.apply(IStatGeom.ArrayProfile.STEADY_STATE);
            long steadyStateId = 0x2000000L;
            if (timeVaryingGeom.isArray() && !legacyStatObj.d_stats.isEmpty() && legacyStatObj.d_stats.stream().noneMatch(s -> s == 0x2000000L)) {
                warnings.addWarning(new Warning(String.format(Intl.intl("Statistics Object, '%1$s', was previously specified as an array-type whose profile was inherently 'Steady-State'."), legacyStatObj.getName()), String.format(Intl.intl("Converted the profile to 'Time-Varying' so the device can be used as input to controls."), new Object[0])));
            }
            boolean first = true;
            ArrayList<StatisticsDevc> devices = new ArrayList<StatisticsDevc>(legacyStatObj.d_stats.size());
            for (Long legStat : legacyStatObj.d_stats) {
                boolean steadyState = legStat == 0x2000000L;
                QuantityStat stat = steadyState ? null : QuantityStat.fromLegacy(legStat);
                String baseName = legacyStatObj.d_stats.size() > 1 && stat != null && !legacyStatObj.getName().contains(stat.displayName) ? String.format(Intl.intl("%s [%s]"), legacyStatObj.getName(), stat.displayName) : legacyStatObj.getName();
                String name = tempNameGen.generateValidName(baseName);
                tempNameGen.registerName(name);
                StatisticsDevc statDevc = new StatisticsDevc(name, legacyStatObj.d_msr, stat != null && stat.type == QuantityStat.Type.SPATIAL ? stat : null, stat != null && stat.type == QuantityStat.Type.TEMPORAL ? stat : null, steadyState ? steadyStateGeom : timeVaryingGeom);
                statDevc.setCustomFDSProps(legacyStatObj.d_customProps);
                statDevc.setTags(legacyStatObj.d_tags);
                statDevc.setEnabled(legacyStatObj.isEnabled());
                statDevc.setForceWrite(legacyStatObj.isForceWrite());
                statDevc.setVisible(legacyStatObj.d_visible);
                if (first) {
                    statDevc.setResultsId(legacyStatObj.getResultsId());
                }
                deviceGroup.add(statDevc);
                first = false;
                devices.add(statDevc);
            }
            if (!devices.isEmpty()) {
                if (!legacyStatObj.d_customProps.isEmpty()) {
                    warnings.addWarning(new Warning(String.format(Intl.intl("Statistics Object, '%s', included <b>Additional Fields</b> under the <b>Advanced</b> tab."), legacyStatObj.getName()), Intl.intl("Ensure the <b>Additional Fields</b> are compatible with the properties of the converted statistic device.")));
                }
                result.accept(legacyStatObj, devices);
            } else {
                warnings.addWarning(new Warning(String.format(Intl.intl("Statistics Object, '%s', did not specify any output statistics."), legacyStatObj.getName()), String.format(Intl.intl("'%s' removed from the model."), legacyStatObj.getName())));
            }
        } else assert (false);
    }

    private static void replaceRefs(Serialized ser, IPyroObject toReplace, IPyroObject replacement) {
        PyroMod tempMod = new PyroMod(ser, false, false);
        DepSnapshot depSnap = tempMod.getDependencies(toReplace);
        PyroSimObjectInputStream.replaceRefs(depSnap, toReplace, replacement);
    }

    private static void replaceRefs(DepSnapshot depSnap, IPyroObject toReplace, IPyroObject replacement) {
        Set<Dependency> deps = depSnap.getDependents(toReplace);
        for (Dependency dep : deps) {
            dep.source.taskReplaceDep(toReplace, replacement).run();
        }
    }

    private static void removeObjs(PyroMod domain, DepSnapshot ss, Collection<? extends IPyroObject> objs, WarningReport<Warning> warns) {
        LinkedIdentityHashSet allToRemove = new LinkedIdentityHashSet();
        LinkedIdentityHashSet<IPyroObject> toRemove = new LinkedIdentityHashSet<IPyroObject>(objs);
        while (!toRemove.isEmpty()) {
            allToRemove.addAll(toRemove);
            LinkedIdentityHashSet incidentalDeletes = new LinkedIdentityHashSet();
            for (IPyroObject iPyroObject : toRemove) {
                Set<Dependency> deps = ss.getDependents(iPyroObject);
                for (Dependency dep : deps) {
                    assert (dep.link != DLink.REQUIRED);
                    if (dep.link == DLink.STRONG && dep.source instanceof IPyroObject && !allToRemove.contains((IPyroObject)((Object)dep.source)) && pyrosim.util.Util.canDelete(domain, dep.source)) {
                        incidentalDeletes.add((IPyroObject)((Object)dep.source));
                        continue;
                    }
                    dep.source.taskReplaceDep(iPyroObject, null).run();
                }
            }
            toRemove = incidentalDeletes;
        }
        for (IPyroObject obj : allToRemove) {
            IPyroObject iPyroObject = obj.getParent();
            if (!(iPyroObject instanceof Composite)) continue;
            String catName = pyrosim.util.Util.getCatName(obj);
            String msg = String.format(Intl.intl("The %s, %s, is no longer valid."), catName, pyrosim.util.Util.getName(obj));
            String action = String.format(Intl.intl("Removed %s from the model."), catName);
            warns.addWarning(new Warning(msg, action));
            ((Composite)iPyroObject).remove(obj);
        }
    }

    private void initUnitReplacements() {
        this.addUnitReplacement(141, SI.METER.pow(2).multiply(SI.SECOND).divide(SI.KILOGRAM), SIUS.unit(21));
        this.addUnitReplacement(141, NonSI.FOOT.pow(2).multiply(SI.SECOND).divide(NonSI.POUND), EnglishUS.unit(21));
    }

    private void initLegClasses() {
        this.addLegClass(50, "pyrosim.domain.Variant", pyrosim.legacy.v49.domain.Variant.class);
        this.addLegClass(50, "pyrosim.domain.Variant$UnitDoubleVar", Variant.UnitDoubleVar.class);
        this.addLegClass(50, "pyrosim.domain.Variant$RampVar", Variant.RampVar.class);
        this.addLegClass(77, "pyrosim.domain.geom.Vent", pyrosim.legacy.v76.domain.geom.Vent.class);
        this.addLegClass(77, "pyrosim.domain.geom.Vent$VentGeom", Vent.VentGeom.class);
        this.addLegClass(77, "pyrosim.domain.geom.FireSpread", pyrosim.legacy.v76.domain.geom.FireSpread.class);
        this.addLegClass(79, "pyrosim.domain.geom.Vent", Vent.class);
        this.addLegClass(79, "pyrosim.domain.geom.Vent$VentGeom", Vent.VentGeom.class);
        this.addLegClass(79, "pyrosim.domain.geom.FireSpread", FireSpread.class);
        this.addLegClass(87, "pyrosim.geom.TexCoordGenerator", TexCoordGenerator.class);
        this.addLegClass(87, "pyrosim.geom.TexCoordGenerator$1", TexCoordGenerator.DEFAULT_PRIM.getClass());
        this.addLegClass(87, "pyrosim.geom.TexCoordGenerator$2", TexCoordGenerator.DEFAULT_OBJ.getClass());
        this.addLegClass(97, "pyrosim.domain.NameGenerator", pyrosim.legacy.v96.domain.NameGenerator.class);
        this.addLegClass(97, "pyrosim.domain.NamesDB", NamesDB.class);
        this.addLegClass(100, "pyrosim.domain.geom.FreePointLoc", pyrosim.legacy.v100.domain.geom.FreePointLoc.class);
        this.addLegClass(110, "pyrosim.domain.devices.hvac.HvacDevice", HvacDevice.class);
        this.addLegClass(110, "pyrosim.domain.devices.hvac.HvacDevice$DuctDevice", HvacDevice.DuctDevice.class);
        this.addLegClass(110, "pyrosim.domain.devices.hvac.HvacDevice$NodeDevice", HvacDevice.NodeDevice.class);
        this.addLegClass(127, "pyrosim.domain.output.AMsrStat", pyrosim.legacy.v126.domain.output.AMsrStat.class);
        this.addLegClass(127, "pyrosim.domain.output.GasMsrStat", GasMsrStat.class);
        this.addLegClass(127, "pyrosim.domain.output.SolidMsrStat", SolidMsrStat.class);
        this.addLegClass(132, "pyrosim.domain.boundcond.surf.TempRegulation", TempRegulation.class);
        this.addLegClass(132, "pyrosim.domain.boundcond.surf.TempRegulation$ThermalBCs", TempRegulation.ThermalBCs.class);
        this.addLegClass(142, "pyrosim.domain.controls.ADblCompareOp", ADblCompareOp.class);
        this.addLegClass(142, "pyrosim.domain.controls.AIntCompareOp", AIntCompareOp.class);
        this.addLegClass(142, "pyrosim.domain.controls.ALogicOp", ALogicOp.class);
        this.addLegClass(142, "pyrosim.domain.controls.AndOp", AndOp.class);
        this.addLegClass(142, "pyrosim.domain.controls.DblGreaterThanOp", DblGreaterThanOp.class);
        this.addLegClass(142, "pyrosim.domain.controls.DblLessThanOp", DblLessThanOp.class);
        this.addLegClass(142, "pyrosim.domain.controls.IntEqualOp", IntEqualOp.class);
        this.addLegClass(142, "pyrosim.domain.controls.IntGreaterThanOp", IntGreaterThanOp.class);
        this.addLegClass(142, "pyrosim.domain.controls.IntLessThanOp", IntLessThanOp.class);
        this.addLegClass(142, "pyrosim.domain.controls.IntNotEqualOp", IntNotEqualOp.class);
        this.addLegClass(142, "pyrosim.domain.controls.NotOp", NotOp.class);
        this.addLegClass(142, "pyrosim.domain.controls.OrOp", OrOp.class);
        this.addLegClass(142, "pyrosim.domain.controls.SumOp", SumOp.class);
        this.addLegClass(143, "pyrosim.domain.controls.MathOps.MultiplyOp", pyrosim.legacy.v142.domain.controls.MathOps.MultiplyOp.class);
        this.addLegClass(155, "pyrosim.mv.ModelView$ModelViewFilterProps", ModelView.ModelViewFilterProps.class);
        this.addLegClass(161, "pyrosim.domain.boundcond.surf.HeatTransfer3DSurfDesc", HeatTransfer3DSurfDesc.class);
        this.addLegClass(173, "pyrosim.domain.output.IMeasurementStat", IMeasurementStat.class);
        this.addLegClass(173, "pyrosim.domain.output.StatisticMgr", StatisticMgr.class);
        this.addLegClass(173, "pyrosim.domain.output.AMsrStat", AMsrStat.class);
        this.addLegClass(173, "pyrosim.domain.output.AMsrStat$RestrictedRect", AMsrStat.RestrictedRect.class);
        this.addLegClass(173, "pyrosim.domain.output.GasMsrStat", pyrosim.legacy.v172.domain.output.GasMsrStat.class);
        this.addLegClass(173, "pyrosim.domain.output.SolidMsrStat", pyrosim.legacy.v172.domain.output.SolidMsrStat.class);
        this.addLegClass(173, "pyrosim.domain.output.StatGeom$GridGeom", StatGeom.GridGeom.class);
        this.addLegClass(173, "pyrosim.domain.output.StatGeom$LinearArrayGeom", StatGeom.LinearArrayGeom.class);
        this.addLegClass(173, "pyrosim.domain.output.StatGeom$LinearPointArrayGeom", StatGeom.LinearPointArrayGeom.class);
        this.addLegClass(173, "pyrosim.domain.output.StatGeom$LinearVolumeArrayGeom", StatGeom.LinearVolumeArrayGeom.class);
    }

    private void addLegClass(int version, String legName, Class newClass) {
        HashMap<String, Class> versionMap = (HashMap<String, Class>)this.d_classLookup.get(version);
        if (versionMap == null) {
            versionMap = new HashMap<String, Class>();
            this.d_classLookup.put(version, versionMap);
        }
        versionMap.put(legName, newClass);
    }

    private void addUnitReplacement(int version, Unit oldUnit, Unit newUnit) {
        this.d_unitReplacements.computeIfAbsent(version, v -> new ArrayList()).add(new Pair<Unit, Unit>(oldUnit, newUnit));
    }

    protected Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        String name = osc.getName();
        Collection lookups = this.d_classLookup.tailMap(this.d_version, false).values();
        for (Map lookup : lookups) {
            Class clazz = (Class)lookup.get(name);
            if (clazz == null) continue;
            System.out.printf("Resolving %s -> %s%n", name, clazz.getName());
            return clazz;
        }
        Class<?> clazz = this.d_teciio.resolveClass(osc);
        if (clazz == null) {
            clazz = super.resolveClass(osc);
        }
        return clazz;
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        if (this.d_version < 90 && obj instanceof DoubleOutPin && ((DoubleOutPin)obj).getAttachedSource() instanceof Sprinkler) {
            return new Sprinkler.LinkQuantOutPin((Sprinkler)((DoubleOutPin)obj).getAttachedSource());
        }
        if (this.d_version < 90 && obj instanceof IMeasurer && ((IMeasurer)obj).getQuantity(0).get() == Quantity.TIME) {
            return Clock.INSTANCE;
        }
        return this.d_teciio.resolveObject(obj);
    }

    private boolean isObscurationUnit(Unit u) {
        if (this.d_obscurationUnits == null) {
            this.d_obscurationUnits = new HashSet<Unit>();
            for (Object ounit : Unit.getInstances()) {
                Unit unit = (Unit)ounit;
                if (!unit.isCompatible(SI.METER)) continue;
                this.d_obscurationUnits.add(NonSI.PERCENT.divide(unit));
            }
        }
        return this.d_obscurationUnits.contains(u);
    }

    static {
        String code = String.format(Locale.US, "PSM%04d", 173);
        assert (code.length() <= 7);
        FORMAT_CODE = code.getBytes();
    }

    private static class PinReplacement
    extends Pair<IOutPin, IInPin> {
        private static final long serialVersionUID = -5478775037381610444L;

        public PinReplacement(IOutPin outPin, IInPin inPin) {
            super(outPin, inPin);
        }
    }
}

