/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.FDSVersion;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.Version;
import pyrosim.domain.APyroObject;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.Grid;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.geom.IPyroDisplayProps;
import pyrosim.io.fds.EnabledFilter;
import pyrosim.mv.displays.ClippingManager;
import pyrosim.mv.displays.GridDisplay;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.image.IImage;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class GE1File {
    public static boolean writeFile(String filename, PyroMod mod, Map<IImage, String> imgFilenames) throws IOException {
        return GE1File.writeFile(filename, mod, Version.FDS_DESIGN, imgFilenames);
    }

    public static boolean writeFile(String filename, PyroMod mod, FDSVersion smvVersion, Map<IImage, String> imgFilenames) throws IOException {
        System.out.println("Writing GE1 File...");
        theTimer timer = new theTimer();
        ArrayList<PolyInfo> polys = new ArrayList<PolyInfo>();
        ArrayList<Appearance> appearances = new ArrayList<Appearance>();
        GE1File.getPolys(mod, appearances, polys);
        System.out.println(String.format("   %d polys", polys.size()));
        System.out.println(String.format("   %d appearances", appearances.size()));
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        writer.println("[APPEARANCE]");
        writer.println(appearances.size());
        GE1File.writeAppearances(writer, appearances, smvVersion, imgFilenames);
        writer.println("[FACES]");
        writer.println(polys.size());
        GE1File.writePrims(writer, polys);
        writer.close();
        System.out.println("GE1 Written in " + GE1File.formatDbl(timer.curr() * 1000.0) + " ms");
        return true;
    }

    private static void getPolys(PyroMod mod, List<Appearance> appearances, List<PolyInfo> polyInfos) {
        Surface defSurf;
        Predicate<IModelObj> validObjTypes;
        LinkedHashMap appearanceMap = new LinkedHashMap();
        Predicate<Surface> surfFilter = Filters.reject(mod.getSurfaceMgr().get(PredefSurf.MIRROR), mod.getSurfaceMgr().get(PredefSurf.OPEN), mod.getSurfaceMgr().get(PredefSurf.PERIODIC));
        Predicate<IModelObj> objFilter = validObjTypes = obj -> obj instanceof ISurfObj || obj instanceof GenericGeomSrc;
        BiConsumer<DisplayGeom, IntPredicate> faceCollector = (dispGeom, faceFilter) -> {
            IPropsSrc props = dispGeom.props;
            IGeomNode flattened = dispGeom.node.flatten();
            IElemSource<Elements.Orient> orients = flattened.getElements(Elements.ORIENT);
            List prims = thunderheadeng.geometry.objs.GeomUtil.explode(flattened.getLocalGeom(), IPrimitive.class);
            int fix = 0;
            for (int m = 0; m < prims.size(); ++m) {
                IPrimitive prim = (IPrimitive)prims.get(m);
                if (!(prim instanceof IFace)) continue;
                boolean skip = !faceFilter.test(fix);
                ++fix;
                if (skip) continue;
                IFace face = (IFace)prim;
                IPrimProps fprops = props.get(m);
                int appIx = GE1File.getAppearance(fprops, appearanceMap);
                Elements.Orient orient = orients.getPrimElement(m);
                Consumer<IPolygon> addPoly = orient == Elements.Orient.CCW ? p -> polyInfos.add(new PolyInfo((IPolygon)p, appIx)) : p -> polyInfos.add(new PolyInfo(p.flipOrient(), appIx));
                List<IPolygon> polys = GeomUtil.toPolys(face, 0.1, false);
                for (IPolygon poly : polys) {
                    if (poly.getNumLoops() > 1 || poly.getNumPoints(0) > 4) {
                        Mesh mesh = poly.triangulate(0.1);
                        int n = 0;
                        while (n < mesh.indices.length) {
                            Point3d p1 = mesh.vertices[mesh.indices[n++]];
                            Point3d p2 = mesh.vertices[mesh.indices[n++]];
                            Point3d p3 = mesh.vertices[mesh.indices[n++]];
                            addPoly.accept(new Triangle(p1, p2, p3));
                        }
                        continue;
                    }
                    addPoly.accept(poly);
                }
            }
        };
        final Collection grids = mod.getGridManager().flatten(new EnabledFilter());
        if (PyroPrefs.getBoolean(PyroPrefs.RESULTS_MESHBOUNDS) && surfFilter.test(defSurf = mod.getSimParams().getMisc().getSurfDefault())) {
            Collection<Vent> vents = ((APyroObject)mod.getObstructions()).flatten(Vent.class);
            Map<Grid, GridMergeUtil.BoundaryInfo> gridFaces = GridMergeUtil.mergeGrids(grids, vents).faces;
            for (Map.Entry entry : gridFaces.entrySet()) {
                Grid g = (Grid)entry.getKey();
                if (!g.isVisible()) continue;
                Point3d gcenter = g.getBounds().getCenter();
                for (Face face : ((GridMergeUtil.BoundaryInfo)entry.getValue()).faces) {
                    if (!(face.plane.dot(gcenter) < 0.0)) continue;
                    face.flipOrient();
                }
                GridDisplay.DisplayData ddata = GridDisplay.generateDisplayData(((GridMergeUtil.BoundaryInfo)entry.getValue()).faces, Collections.emptyList(), defSurf, true);
                IGeomNode geom = ddata.getGeom(false);
                int options = 2;
                IPrimProps.Face fprops = new IPrimProps.Face(defSurf.getColor(), defSurf.getAppearance() == null ? null : defSurf, options);
                faceCollector.accept(new DisplayGeom(geom, (IPrimProps)fprops), i -> true);
            }
        }
        final GridMergeUtil.MergeResult[] mergedGrids = new GridMergeUtil.MergeResult[]{null};
        IPyroDisplayProps dprop = new IPyroDisplayProps(){

            @Override
            public double getFaceError() {
                return 0.1;
            }

            @Override
            public double getCurveError() {
                return 0.1;
            }

            @Override
            public Predicate<IHole> getHoleFilter(IObstruction obst) {
                return Predicates.alwaysTrue();
            }

            @Override
            public GridMergeUtil.MergeResult getMergedMeshes() {
                if (mergedGrids[0] == null) {
                    mergedGrids[0] = GridMergeUtil.mergeGrids(grids, Collections.emptyList());
                }
                return mergedGrids[0];
            }

            @Override
            public boolean isWireframe(Object o) {
                return false;
            }

            @Override
            public boolean getVentOrientVisible() {
                return false;
            }

            @Override
            public FDSRasterization getRasterizer() {
                return null;
            }

            @Override
            public ClippingManager getClippingManager() {
                return null;
            }
        };
        BitSet skipFaces = new BitSet();
        for (IModelObj iModelObj : mod.getObstructions().flatten(objFilter)) {
            skipFaces.clear();
            if (!iModelObj.isEnabled() || !iModelObj.isVisible()) continue;
            if (iModelObj instanceof ISurfObj) {
                ISurfObj sobj = (ISurfObj)iModelObj;
                int numFaces = sobj.getNumFaces();
                Surface[] surfs = sobj.getSurfaces();
                for (int m = 0; m < numFaces; ++m) {
                    Surface surf;
                    Surface surface = surf = surfs.length == 1 ? surfs[0] : surfs[m];
                    if (surfFilter.test(surf)) continue;
                    skipFaces.set(m);
                }
                if (skipFaces.cardinality() == numFaces) continue;
            }
            DisplayGeom dispGeom2 = iModelObj.getDisplayGeom(dprop);
            faceCollector.accept(dispGeom2, i -> !skipFaces.get(i));
        }
        appearances.addAll(appearanceMap.keySet());
    }

    private static void writeAppearances(PrintWriter writer, Collection<Appearance> appearances, FDSVersion smvVersion, Map<IImage, String> imgFilenames) {
        float[] ccomps = new float[3];
        Iterator<Appearance> appIt = appearances.iterator();
        for (int i = 0; i < appearances.size(); ++i) {
            Appearance app = appIt.next();
            Color c = app.d_color;
            IImage img = app.d_surf;
            writer.println(app.toString());
            String texname = "";
            if (img != null && (texname = imgFilenames.get(img)) == null) {
                texname = new File(img.getFilename()).getName();
            }
            writer.print(i);
            writer.print(' ');
            if (smvVersion.major < 6) {
                c.getColorComponents(ccomps);
                writer.printf(GE1File.formatFloat(ccomps[0]) + " " + GE1File.formatFloat(ccomps[1]) + " " + GE1File.formatFloat(ccomps[2]), new Object[0]);
            } else {
                writer.printf(Locale.US, "%d %d %d", c.getRed(), c.getGreen(), c.getBlue());
            }
            writer.printf(" " + GE1File.formatDbl(app.d_width) + ", " + GE1File.formatDbl(app.d_height), new Object[0]);
            writer.print(" ");
            writer.print(GE1File.formatFloat((float)c.getAlpha() / 255.0f));
            writer.print(" ");
            writer.print(GE1File.formatFloat(0.0f));
            writer.print(" 0 0 0");
            writer.print(" ");
            writer.print(app.d_oneSided ? 1 : 0);
            writer.println();
            writer.println(texname);
        }
    }

    private static void writePrims(PrintWriter writer, List<PolyInfo> polys) {
        for (int m = 0; m < polys.size(); ++m) {
            PolyInfo pi = polys.get(m);
            int numPoints = pi.poly.getNumPoints(0);
            if (numPoints == 3) {
                GE1File.writeQuad(writer, pi.appearanceIx, pi.poly.getPoint(0, 0), pi.poly.getPoint(0, 1), pi.poly.getPoint(0, 2), pi.poly.getPoint(0, 2));
                continue;
            }
            if (numPoints != 4) continue;
            GE1File.writeQuad(writer, pi.appearanceIx, pi.poly.getPoint(0, 0), pi.poly.getPoint(0, 1), pi.poly.getPoint(0, 2), pi.poly.getPoint(0, 3));
        }
    }

    private static void writeQuad(PrintWriter writer, int appearance, Point3d p1, Point3d p2, Point3d p3, Point3d p4) {
        GE1File.writePoint(writer, p1);
        GE1File.writePoint(writer, p2);
        GE1File.writePoint(writer, p3);
        GE1File.writePoint(writer, p4);
        writer.println(appearance);
    }

    private static void writePoint(PrintWriter writer, Point3d p) {
        writer.print(GE1File.formatFloat((float)p.x));
        writer.print(" ");
        writer.print(GE1File.formatFloat((float)p.y));
        writer.print(" ");
        writer.print(GE1File.formatFloat((float)p.z));
        writer.print(" ");
    }

    private static int getAppearance(IPrimProps props, Map<Appearance, Integer> appearanceMap) {
        Appearance app;
        Integer ix;
        Material appearance;
        IMatAttrs attrs;
        Texture tex;
        Surface surface = (Surface)props.getMaterial();
        IImage img = null;
        double width = 0.0;
        double height = 0.0;
        if (surface != null && surface.getAppearance() != null && (tex = (attrs = (appearance = surface.getAppearance()).getAttributes()).getTexture(MatChannel.DIFFUSE)) != null) {
            Unit lu = SIUS.getInstance().getLengthUnit();
            img = tex.image;
            width = appearance.getWidth().getValue(lu);
            height = appearance.getHeight().getValue(lu);
        }
        if ((ix = appearanceMap.get(app = new Appearance(GE1File.getColor(props), img, width, height, props.testOptions(2)))) == null) {
            ix = appearanceMap.size();
            appearanceMap.put(app, ix);
        }
        return ix;
    }

    private static Color getColor(IPrimProps props) {
        if (props.getMaterial() != null && props.getMaterial().getAttributes().getTexture(MatChannel.DIFFUSE) == null) {
            Color c = props.getMaterial().getAttributes().getDiffuseColorWithOpacity();
            assert (c != null);
            return c;
        }
        assert (props.getColor() != null);
        return props.getColor();
    }

    private static String formatFloat(float f) {
        return String.format(Locale.US, "%f", Float.valueOf(f));
    }

    private static String formatDbl(double d) {
        return String.format(Locale.US, "%f", d);
    }

    private static class Appearance {
        public final Color d_color;
        public final IImage d_surf;
        public final double d_width;
        public final double d_height;
        public final boolean d_oneSided;

        public Appearance(Color color, IImage texImg, double wid, double ht, boolean oneSided) {
            this.d_surf = texImg;
            this.d_width = wid;
            this.d_height = ht;
            this.d_color = color;
            this.d_oneSided = oneSided;
        }

        public int hashCode() {
            return 0x223FA3B ^ (this.d_surf != null ? this.d_surf.makeHashable().hashCode() : 0) + theUtil.hashCode(this.d_width) + theUtil.hashCode(this.d_height) + theUtil.hashCode(this.d_color) + theUtil.hashCode(this.d_oneSided);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Appearance)) {
                return false;
            }
            Appearance ao = (Appearance)o;
            return this.d_width == ao.d_width && this.d_height == ao.d_height && theUtil.equal(ao.d_color, this.d_color) && Appearance.pseudoEquals(ao.d_surf, this.d_surf) && this.d_oneSided == ao.d_oneSided;
        }

        private static boolean pseudoEquals(IImage img1, IImage img2) {
            if (img1 == null) {
                return img2 == null;
            }
            if (img2 != null) {
                return img1.makeHashable().equals(img2);
            }
            return false;
        }

        public String toString() {
            String surfStr = this.d_surf != null ? this.d_surf.getFilename() : "";
            String colorStr = this.d_color != null ? String.format(Locale.US, "r=%d,g=%d,b=%d,a=%d", this.d_color.getRed(), this.d_color.getGreen(), this.d_color.getBlue(), this.d_color.getAlpha()) : "";
            return String.format("Appearance[%s,%s,%b]", surfStr, colorStr, this.d_oneSided);
        }
    }

    private static class PolyInfo {
        public final IPolygon poly;
        public final int appearanceIx;

        public PolyInfo(IPolygon poly, int appearanceIx) {
            this.poly = poly;
            this.appearanceIx = appearanceIx;
        }
    }
}

