/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.view;

import java.awt.Color;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import pyrosim.Intl;
import pyrosim.domain.Composite;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.view.SectionBox;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.IGeomEditor;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.Task;

public class SectionBoxDlg
extends guiDialog {
    private static final long serialVersionUID = 7868312739617375409L;
    private final ColorButton d_colorEditor;
    private final IGeomEditor<IGeom> d_geomEditor;
    public static final Composite.IObjectProp<SectionBox, Color> colorProp = new Composite.AObjectProp<SectionBox, Color>(SectionBox.class){

        @Override
        public void set(SectionBox obj, Color prop) {
            obj.setColor(prop);
        }

        @Override
        public Object get(SectionBox obj) {
            return obj.getColor();
        }
    };

    public SectionBoxDlg(Window owner, Collection<? extends IPyroGeomSrc> objs) {
        super(owner, Intl.intl("Section Box Properties"), 9);
        Collection<SectionBox> boxes = Hierarchy.flatten(objs, SectionBox.class);
        this.d_geomEditor = GeomGuiUtil.newEditor(boxes);
        this.d_colorEditor = new ColorButton();
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        gb.addRow(Intl.intl("Color:"), this.d_colorEditor);
        if (this.d_geomEditor != null) {
            gb.addFilledRow(new TitleSeparator(Intl.intl("Geometry")));
            gb.indent();
            gb.addFilledRow(this.d_geomEditor);
        }
        gb.finalizeRows();
        this.load(objs);
    }

    private void load(Collection<? extends IPyroGeomSrc> objs) {
        Collection<SectionBox> boxes = Hierarchy.flatten(objs, SectionBox.class);
        if (this.d_geomEditor != null) {
            this.d_geomEditor.load(boxes);
        }
        this.loadColor(this.d_colorEditor, boxes);
    }

    public Task taskSave(Collection<? extends IPyroGeomSrc> objs) {
        final ArrayList<SectionBox> boxes = new ArrayList<SectionBox>(Hierarchy.flatten(objs, SectionBox.class));
        return new AOneTimeTask(){

            @Override
            public void run() {
                if (SectionBoxDlg.this.d_geomEditor != null) {
                    SectionBoxDlg.this.d_geomEditor.save(boxes);
                }
                SectionBoxDlg.this.saveColor(SectionBoxDlg.this.d_colorEditor, boxes);
            }
        };
    }

    private void loadColor(ColorButton btn, Collection<? extends SectionBox> boxes) {
        Object result = Composite.getProperty(colorProp, boxes);
        if (result instanceof Color) {
            btn.setColor((Color)result);
        } else {
            btn.setColor(null);
        }
    }

    private void saveColor(ColorButton btn, Collection<? extends SectionBox> boxes) {
        Color color = btn.getColor();
        if (color != null) {
            Composite.setProperty(colorProp, color, boxes);
        }
    }
}

