/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.reaction;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.tasks.Tasks;
import pyrosim.domain.variant.Variant;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.TagEditor;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.ExSpecComboBox;
import pyrosim.gui.comboboxes.PyroComboBox;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiSeparator;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Task;

public class ReactionConfigPanel
extends guiPanel
implements IEditor<Reaction> {
    private static final long serialVersionUID = 8520540044821832889L;
    private static final String FUEL_LABEL = Intl.intl("Fuel");
    private static final String SUPP_LABEL = Intl.intl("Fire Suppression");
    private static final String PROD_LABEL = Intl.intl("Byproducts");
    private static final String COMPLEX_LABEL = Intl.intl("Complex Chemistry");
    private static final String ADVANCED_LABEL = Intl.intl("Advanced");
    private final guiTextField d_fyiFld;
    private final TagEditor d_tagsFld;
    private final guiComboBox<Reaction.ReacType> d_typeCB;
    private final JTabbedPane d_tabs = new JTabbedPane();
    private final FuelPanel d_fuelPanel;
    private final FireSupPanel d_fireSupPanel;
    private final ByproductsPanel d_byproductsPanel;
    private final ComplexReacEditor d_complexReacPanel;
    private final CustomFDSPanel d_advancedPnl;

    public ReactionConfigPanel(ExSpecList specMgr) {
        this.d_fuelPanel = new FuelPanel(specMgr);
        this.d_fireSupPanel = new FireSupPanel();
        this.d_byproductsPanel = new ByproductsPanel();
        this.d_complexReacPanel = new ComplexReacEditor(specMgr);
        this.d_advancedPnl = new CustomFDSPanel(7);
        this.d_tabs.addTab(FUEL_LABEL, this.d_fuelPanel);
        this.d_tabs.addTab(SUPP_LABEL, this.d_fireSupPanel);
        this.d_tabs.addTab(PROD_LABEL, this.d_byproductsPanel);
        this.d_tabs.addTab(COMPLEX_LABEL, this.d_complexReacPanel);
        this.d_tabs.addTab(ADVANCED_LABEL, this.d_advancedPnl);
        this.d_tabs.setPreferredSize(PyroGuiUtil.determineMinimumTabbedPaneSize(this.d_fuelPanel, this.d_fireSupPanel, this.d_byproductsPanel, this.d_complexReacPanel, this.d_advancedPnl));
        this.setLayout(new GridBagLayout());
        this.d_fyiFld = new guiTextField();
        this.d_tagsFld = new TagEditor();
        this.d_typeCB = new guiComboBox();
        this.d_typeCB.setRenderer(ReactionConfigPanel.getReacTypeRenderer());
        this.d_typeCB.addActionListener(e -> this.updateActivePanels());
        this.d_typeCB.add(Reaction.ReacType.SIMPLE);
        this.d_typeCB.add(Reaction.ReacType.COMPLEX);
        this.d_typeCB.setSelectedItem((Object)Reaction.ReacType.SIMPLE);
        GridBagHelper gb = new GridBagHelper(this.getEditorPanel());
        gb.addRow(Intl.intl("Description:"), this.d_fyiFld, 1.0);
        gb.addRow(Intl.intl("Tags:"), this.d_tagsFld.getEditor(), 1.0);
        gb.addRow(Intl.intl("Reaction Type:"), this.d_typeCB, 1.0);
        gb.addRow(this.d_tabs, new double[]{1.0, 1.0}, GridBagHelper.REMAINING);
        gb.finalizeRows();
        this.setEnabled(false);
        this.setModified(false);
    }

    private static ListCellRenderer getReacTypeRenderer() {
        return new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof Reaction.ReacType) {
                    this.setText(((Reaction.ReacType)((Object)value)).id);
                }
                return this;
            }
        };
    }

    private void updateActivePanels() {
        this.d_tabs.removeAll();
        if (this.d_typeCB.getSelectedItem().equals((Object)Reaction.ReacType.SIMPLE)) {
            this.d_tabs.addTab(FUEL_LABEL, this.d_fuelPanel);
            this.d_tabs.addTab(SUPP_LABEL, this.d_fireSupPanel);
            this.d_tabs.addTab(PROD_LABEL, this.d_byproductsPanel);
            this.d_tabs.addTab(ADVANCED_LABEL, this.d_advancedPnl);
        } else {
            this.d_tabs.addTab(COMPLEX_LABEL, this.d_complexReacPanel);
            this.d_tabs.addTab(ADVANCED_LABEL, this.d_advancedPnl);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.d_fyiFld.setEnabled(enable);
        this.d_tagsFld.getEditor().setEnabled(enable);
        this.d_byproductsPanel.setEnabled(enable);
        this.d_fireSupPanel.setEnabled(enable);
        this.d_fuelPanel.setEnabled(enable);
        this.d_complexReacPanel.setEnabled(enable);
        this.d_advancedPnl.setEnabled(enable);
    }

    @Override
    public Reaction commit(final Reaction dataObj) {
        PyroMod pm = PyroSim.getApp().getMediator();
        CompositeTask<PyroMod> tasks = new CompositeTask<PyroMod>(pm);
        if (this.shouldReplaceFuel(dataObj)) {
            tasks.addTask(this.handleFuelReplacement(pm, dataObj));
        }
        tasks.addTask(new AOneTimeTask(){

            @Override
            public void run() {
                ReactionConfigPanel.this.saveReaction(dataObj, false);
            }
        });
        tasks.addTask(this.d_tagsFld.getUpdateTagsTask(pm, dataObj));
        pm.getTaskManager().exec(tasks, Intl.intl("Edit Reaction"));
        this.setModified(false);
        return dataObj;
    }

    private CompositeTask<PyroMod> handleFuelReplacement(PyroMod pm, Reaction dataObj) {
        CompositeTask<PyroMod> taskGroup = new CompositeTask<PyroMod>(pm);
        for (Task replaceTask : Actions.getReplaceTasks(pm, dataObj.getFuel(), (ExSpec)this.d_fuelPanel.d_specCombo.getSelectedItem())) {
            taskGroup.addTask(replaceTask);
        }
        taskGroup.addTask(Tasks.delete(dataObj.getFuel()));
        return taskGroup;
    }

    @Deprecated
    private boolean shouldReplaceFuel(Reaction r) {
        return false;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(Reaction dataObj) {
        this.setEnabled(dataObj != null);
        if (dataObj != null) {
            this.loadReactions(dataObj);
            this.updateActivePanels();
        }
        this.setModified(false);
    }

    @Override
    public Reaction preview(Reaction reaction) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.saveReaction(reaction, true);
        return reaction;
    }

    public void loadReactions(Reaction dataObj) {
        this.d_fyiFld.setText(dataObj.getFYI());
        this.d_tagsFld.initTags(dataObj);
        this.d_typeCB.setSelectedItem((Object)dataObj.getReacType());
        this.d_fuelPanel.loadData(dataObj);
        this.d_fireSupPanel.loadData(dataObj);
        this.d_byproductsPanel.loadData(dataObj);
        this.d_complexReacPanel.loadData(dataObj);
        this.d_advancedPnl.clear();
        this.d_advancedPnl.load(Collections.singleton(dataObj), new CustomFDSPanel.AdvPropWrapper<Boolean>(dataObj.isForceWrite(), 1));
    }

    public void saveReaction(Reaction reac, boolean isPreview) {
        reac.setFYI(this.d_fyiFld.getText());
        reac.setReacType(this.d_typeCB.getSelectedItem());
        if (this.checkShouldSave(this.d_fuelPanel)) {
            this.d_fuelPanel.saveData(reac, isPreview);
        }
        if (this.checkShouldSave(this.d_fireSupPanel)) {
            this.d_fireSupPanel.saveData(reac);
        }
        if (this.checkShouldSave(this.d_byproductsPanel)) {
            this.d_byproductsPanel.saveData(reac);
        }
        if (this.checkShouldSave(this.d_complexReacPanel)) {
            this.d_complexReacPanel.saveData(reac);
        }
        this.d_advancedPnl.save(Collections.singleton(reac));
    }

    private boolean checkShouldSave(guiPanel pnl) {
        return this.d_tabs.indexOfComponent(pnl) != -1;
    }

    private class FuelPanel
    extends guiPanel {
        private static final long serialVersionUID = 177924900571047191L;
        private PyroComboBox<ExSpec> d_specCombo;
        private final JButton d_editSpecs;

        public FuelPanel(ExSpecList specMgr) {
            this.setLayout(new GridBagLayout());
            guiLabel fuelSelectLbl = new guiLabel(Intl.intl("Fuel Species:"));
            this.d_specCombo = new ExSpecComboBox(specMgr);
            this.d_specCombo.setPreferredSize(new Dimension(100, this.d_specCombo.getPreferredSize().height));
            this.d_specCombo.setFilter(spec -> !spec.isReacFuel());
            this.d_editSpecs = new JButton(Intl.intl("Edit Species..."));
            this.d_editSpecs.addActionListener(e -> Actions.editSpecies((ExSpec)this.d_specCombo.getSelectedItem()));
            GridBagHelper gbh = new GridBagHelper(this, true);
            gbh.addRow(fuelSelectLbl, this.d_specCombo, 1.0, this.d_editSpecs);
            gbh.finalizeRows();
        }

        public void loadData(Reaction reac) {
            this.d_specCombo.setSelectedItem(reac.getFuel());
        }

        public void saveData(Reaction reac, boolean isPreview) {
            reac.setFuel((ExSpec)this.d_specCombo.getSelectedItem());
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            boolean validSpec = true;
            if (showWarn && !(validSpec = Actions.isValidSpecies((ExSpec)this.d_specCombo.getSelectedItem()))) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("Must select a valid Species."));
                return false;
            }
            return validSpec && super.validateData(showWarn, allowModify);
        }
    }

    private class FireSupPanel
    extends guiPanel {
        private static final long serialVersionUID = 7271780612622304827L;
        private guiCheckBox d_fireSupCB;
        private final ValueField<UnitDouble> d_critFlameTemp;
        private final ValueField<UnitDouble> d_autoIgnitionTemp;

        public FireSupPanel() {
            this.setLayout(new MigLayout("insets 12, gap 6, fillx", "[]6[grow]", ""));
            this.d_fireSupCB = new guiCheckBox(Intl.intl("Enable Fire Suppression"));
            this.d_critFlameTemp = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_autoIgnitionTemp = ValueFields.udFld(UnitSystem.getSource(1));
            guiLabel critFlameLab = new guiLabel(Intl.intl("Critical Flame Temperature:"));
            guiLabel autoIgnitLab = new guiLabel(Intl.intl("Autoignition Temperature:"));
            this.d_critFlameTemp.setNullAllowed(true);
            this.d_autoIgnitionTemp.setNullAllowed(true);
            this.add((Component)this.d_fireSupCB, "grow, span, wrap");
            this.add((Component)new guiSeparator(), "grow, span, wrap");
            this.add((Component)critFlameLab, "gapleft 18");
            this.add(this.d_critFlameTemp, "wrap");
            this.add((Component)autoIgnitLab, "gapleft 18");
            this.add(this.d_autoIgnitionTemp, "wrap");
            LinkStatus.link((AbstractButton)this.d_fireSupCB, this.d_critFlameTemp);
            LinkStatus.link((AbstractButton)this.d_fireSupCB, this.d_autoIgnitionTemp);
            LinkStatus.link((AbstractButton)this.d_fireSupCB, critFlameLab);
            LinkStatus.link((AbstractButton)this.d_fireSupCB, autoIgnitLab);
        }

        public void loadData(Reaction reac) {
            this.d_fireSupCB.setSelected(reac.allowSuppression());
            this.d_critFlameTemp.setValue(reac.getCritFlameTemp());
            if (reac.getAutoIgnitionTemp().getType() == Variant.Type.CONSTANT) {
                this.d_autoIgnitionTemp.setValue((UnitDouble)reac.getAutoIgnitionTemp().val);
            } else {
                this.d_autoIgnitionTemp.setValue(SIUS.newud(-273.0, 1));
            }
        }

        public void saveData(Reaction reac) {
            reac.setSuppression(this.d_fireSupCB.isSelected());
            reac.setCritFlameTemp((UnitDouble)this.d_critFlameTemp.getValue());
            reac.setAutoIgnitionTemp((UnitDouble)this.d_autoIgnitionTemp.getValue());
        }
    }

    private class ByproductsPanel
    extends guiPanel {
        private static final long serialVersionUID = 1217278318223851207L;
        private final guiRadioButton d_epumRB;
        private final guiRadioButton d_hocRB;
        private final guiCheckBox d_ideal;
        private final ValueField<UnitDouble> d_epum;
        private final ValueField<UnitDouble> d_hoc;
        private final guiCheckBox d_radFracCB;
        private final ValueField<Double> d_radFrac;
        private final ValueField<Double> d_coYield;
        private final ValueField<Double> d_sootYield;
        private final ValueField<Double> d_hcnYield;

        public ByproductsPanel() {
            this.setLayout(new GridBagLayout());
            this.d_epumRB = new guiRadioButton(Intl.intl("Specify release per unit mass oxygen:"));
            this.d_hocRB = new guiRadioButton(Intl.intl("Specify heat of combustion:"));
            this.d_epum = ValueFields.udFld(UnitSystem.getSource(48));
            this.d_hoc = ValueFields.udFld(UnitSystem.getSource(48));
            this.d_radFracCB = new guiCheckBox(Intl.intl("Radiative Fraction:"));
            this.d_radFrac = ValueFields.doubleFld(SimParams.RadiationTransport.RADIATIVE_FRACTION_RANGE);
            this.d_ideal = new guiCheckBox(Intl.intl("<html>Energy is Ideal (does not account for yields of CO, H<sub>2</sub>, or Soot)</html>"));
            this.d_coYield = ValueFields.doubleFld(DoubleVR.between(0.0, 1.0, true, true));
            this.d_sootYield = ValueFields.doubleFld(DoubleVR.between(0.0, 1.0, true, true));
            this.d_hcnYield = ValueFields.doubleFld(DoubleVR.between(0.0, 1.0, true, true));
            GridBagHelper gbh = new GridBagHelper(this, true);
            gbh.addRow(Intl.intl("Energy Released:"), 0);
            gbh.addIdentRow(this.d_epumRB, this.d_epum, 0);
            gbh.addIdentRow(this.d_hocRB, this.d_hoc, 0);
            gbh.addIdentRow(this.d_radFracCB, this.d_radFrac, 0);
            gbh.addIdentRow(this.d_ideal, 0);
            guiPanel subPanel = new guiPanel(new GridBagLayout());
            GridBagHelper sgbh = new GridBagHelper(subPanel);
            sgbh.addRow(Intl.intl("<html>CO Yield (Y<sub>co</sub>):</html>"), this.d_coYield, 0);
            sgbh.addRow(Intl.intl("<html>Soot Yield (Y<sub>s</sub>):</html>"), this.d_sootYield, 0);
            sgbh.addRow(Intl.intl("<html>HCN Yield (Y<sub>hcn</sub>):</html>"), this.d_hcnYield, 0);
            sgbh.finalizeRows();
            gbh.addFilledRow(subPanel);
            gbh.finalizeRows();
            ButtonGroup group = new ButtonGroup();
            group.add(this.d_epumRB);
            group.add(this.d_hocRB);
            LinkStatus.link((AbstractButton)this.d_epumRB, this.d_epum);
            LinkStatus.link((AbstractButton)this.d_hocRB, this.d_hoc);
            LinkStatus.link((AbstractButton)this.d_radFracCB, this.d_radFrac);
        }

        private void loadData(Reaction reac) {
            this.d_epum.setValue(reac.getEpumo2());
            if (reac.getHeatOfCombustion().getType() == Variant.Type.CONSTANT) {
                this.d_hoc.setValue((UnitDouble)reac.getHeatOfCombustion().val);
            }
            if (reac.getEnergyType() == Reaction.EnergyRelease.EPUMO2) {
                this.d_epumRB.setSelected(true);
            } else {
                this.d_hocRB.setSelected(true);
            }
            this.d_ideal.setSelected(reac.isIdeal());
            Variant radFrac = reac.getRadiativeFraction();
            if (radFrac.getType() == Variant.Type.DEFAULT) {
                this.d_radFracCB.setSelected(false);
                this.d_radFrac.setValue(0.35);
            } else {
                this.d_radFracCB.setSelected(true);
                this.d_radFrac.setValue(((UnitDouble)radFrac.val).getRawValue());
            }
            this.d_coYield.setValue(reac.getCOYield());
            this.d_sootYield.setValue(reac.getSootYield());
            this.d_hcnYield.setValue(reac.getHCNYield());
        }

        public void saveData(Reaction reac) {
            reac.setEpumo2((UnitDouble)this.d_epum.getValue());
            reac.setHeatOfCombustion((UnitDouble)this.d_hoc.getValue());
            if (this.d_epumRB.isSelected()) {
                reac.setEnergyType(Reaction.EnergyRelease.EPUMO2);
            } else {
                reac.setEnergyType(Reaction.EnergyRelease.HEAT_OF_COMBUSTION);
            }
            if (this.d_radFracCB.isSelected()) {
                reac.setRadiativeFraction(SIUS.newud((Double)this.d_radFrac.getValue(), 28));
            } else {
                reac.setRadiativeFraction(null);
            }
            reac.setCOYield((Double)this.d_coYield.getValue());
            reac.setSootYield((Double)this.d_sootYield.getValue());
            reac.setHCNYield((Double)this.d_hcnYield.getValue());
            reac.setIdeal(this.d_ideal.isSelected());
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if ((Double)this.d_coYield.getValue() + (Double)this.d_sootYield.getValue() + (Double)this.d_hcnYield.getValue() > 1.0) {
                if (showWarn) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Yield values must add up to one or less."));
                }
                if (allowModify) {
                    ReactionConfigPanel.this.d_tabs.setSelectedComponent(ReactionConfigPanel.this.d_byproductsPanel);
                }
                return false;
            }
            return true;
        }
    }

    private static class ComplexReacEditor
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final ExSpecList d_specList;
        private final guiComboBox<ExSpec> d_fuelCombo;
        private final guiTable d_chemTable;
        private final guiCheckBox d_heatOfCombustionCB;
        private final ValueField<UnitDouble> d_heatOfCombustionVF;
        private static final String OPT_REACTANT = Intl.intl("Reactant");
        private static final String OPT_PRODUCT = Intl.intl("Product");

        public ComplexReacEditor(ExSpecList specList) {
            this.d_specList = specList;
            this.d_fuelCombo = new ExSpecComboBox(specList);
            this.d_heatOfCombustionCB = new guiCheckBox(Intl.intl("Heat of Combustion:"));
            this.d_heatOfCombustionVF = ValueFields.udFld(UnitSystem.getSource(48));
            this.d_chemTable = guiTableUtil.fixedColumnTable(new String[]{Intl.intl("Species"), Intl.intl("Type"), Intl.intl("NU")}, new Class[]{ExSpec.class, String.class, Double.class}, 16);
            this.d_chemTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public void setValue(Object value) {
                    this.setText(value == null ? "" : ((ExSpec)value).getName());
                }
            });
            this.d_chemTable.setColumnEditable(0, false);
            this.d_chemTable.setColumnOptions(1, OPT_REACTANT, OPT_PRODUCT);
            this.d_chemTable.setPreferredScrollableViewportSize(new Dimension(150, 200));
            GridBagHelper gbh = new GridBagHelper(this, true);
            gbh.addRow(this.d_heatOfCombustionCB, this.d_heatOfCombustionVF, 1.0);
            gbh.addRow(Intl.intl("Fuel Species:"), this.d_fuelCombo, 1.0);
            gbh.addRow(Intl.intl("Stoichiometric Coefficients:"));
            gbh.addRow(new JScrollPane(this.d_chemTable), new double[]{1.0, 1.0}, new int[]{0, 0});
            gbh.finalizeRows();
            LinkStatus.link((AbstractButton)this.d_heatOfCombustionCB, this.d_heatOfCombustionVF);
        }

        public void loadData(Reaction reac) {
            Variant hoc = reac.getHeatOfCombustion();
            if (hoc.getType().equals((Object)Variant.Type.DEFAULT)) {
                Unit hocUnit = ((PyroSim)Application.getApp()).getUnitSystem().getHeatOfCombustion();
                this.d_heatOfCombustionCB.setSelected(false);
                this.d_heatOfCombustionVF.setValue(new UnitDouble(0.0, hocUnit));
            } else if (hoc.getType().equals((Object)Variant.Type.CONSTANT)) {
                this.d_heatOfCombustionCB.setSelected(true);
                this.d_heatOfCombustionVF.setValue(hoc.val);
            }
            this.d_fuelCombo.setSelectedItem(reac.getFuel());
            List sortedSpecs = this.d_specList.flatten().stream().sorted(Comparator.comparing(NamedPyroObject::getName)).collect(Collectors.toList());
            this.d_chemTable.clearRows();
            Map<ExSpec, Double> reactionChem = reac.getComplexStoichiometry();
            int row = 0;
            for (ExSpec spec : sortedSpecs) {
                this.d_chemTable.getModel().setValueAt(spec, row, 0);
                if (reactionChem.containsKey(spec)) {
                    Double specLookup = reactionChem.get(spec);
                    if (specLookup != null) {
                        String sign = specLookup < 0.0 ? OPT_REACTANT : OPT_PRODUCT;
                        double abs = Math.abs(specLookup);
                        this.d_chemTable.getModel().setValueAt(sign, row, 1);
                        this.d_chemTable.getModel().setValueAt(abs, row, 2);
                    } else {
                        this.d_chemTable.getModel().setValueAt(OPT_REACTANT, row, 1);
                        this.d_chemTable.getModel().setValueAt(0.0, row, 2);
                    }
                } else {
                    this.d_chemTable.getModel().setValueAt(OPT_REACTANT, row, 1);
                    this.d_chemTable.getModel().setValueAt(0.0, row, 2);
                }
                ++row;
            }
            if (row > 0) {
                this.d_chemTable.setRowLimit(row);
            } else {
                this.d_chemTable.setRowLimit(1);
            }
            this.setModified(false);
        }

        public void saveData(Reaction reac) {
            if (this.d_heatOfCombustionCB.isSelected()) {
                reac.setHeatOfCombustion((UnitDouble)this.d_heatOfCombustionVF.getValue());
            } else {
                reac.setHeatOfCombustion(null);
            }
            reac.setFuel(this.d_fuelCombo.getSelectedItem());
            LinkedHashMap<ExSpec, Double> newCompMap = new LinkedHashMap<ExSpec, Double>();
            int numRows = this.d_chemTable.getRowCount();
            if (numRows > 0) {
                for (int row = 0; row < numRows; ++row) {
                    Double tableVal = (Double)this.d_chemTable.getValueAt(row, 2);
                    if (tableVal == null || tableVal == 0.0) continue;
                    double val = tableVal;
                    String sign = (String)this.d_chemTable.getValueAt(row, 1);
                    if (sign == null) continue;
                    if (sign.equals(OPT_REACTANT)) {
                        val *= -1.0;
                    }
                    newCompMap.put((ExSpec)this.d_chemTable.getValueAt(row, 0), val);
                }
            }
            reac.setComplexStoichiometry(newCompMap);
        }
    }
}

