/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.output.Slice;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.ChangeOrderTask;
import pyrosim.domain.tasks.Tasks;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.output.QuantityClipboard;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.Util;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.ComboBoxTableCell;
import thunderheadeng.gui.table.ObjectTableModel;
import thunderheadeng.gui.table.TableColProp;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableClipboard;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;

public class Slcf3dDialog
extends guiDialog {
    private static final long serialVersionUID = 1L;
    private final PyroMod d_pyroMod = PyroSim.getApp().getMediator();
    private final guiTableEditor d_editor;
    private final guiTable d_table;
    private Unit d_lengthUnit;
    private final Map<VolumeSlice.VolumeSliceProxy, VolumeSlice> d_cloneToOGSliceMap;
    private static final String OPT_YES = Intl.intl("YES");
    private static final String OPT_NO = Intl.intl("NO");

    public Slcf3dDialog(JFrame parent) {
        super((Window)parent, Intl.intl("Animated 3D Slices"), 9);
        UnitSystem system = PyroSim.getApp().getUnitSystem();
        this.d_lengthUnit = system.getLengthUnit();
        this.d_cloneToOGSliceMap = new IdentityHashMap<VolumeSlice.VolumeSliceProxy, VolumeSlice>();
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new GridBagLayout());
        QuantityComboBox qCombo = new QuantityComboBox(128L, QuantityType.GAS);
        ComboBoxTableCell<IQuantity> quantComboCell = new ComboBoxTableCell<IQuantity>(qCombo);
        Pair<guiTable, ObjectTableModel<VolumeSlice.VolumeSliceProxy>> tableAndModelPair = guiTableUtil.objectTable(() -> new VolumeSlice.VolumeSliceProxy("", new UnitDouble(0.0, SI.METER), new UnitDouble(1.0, SI.METER), new UnitDouble(0.0, SI.METER), new UnitDouble(1.0, SI.METER), new UnitDouble(0.0, SI.METER), new UnitDouble(1.0, SI.METER), null, true, true), List.of(new TableColProp<VolumeSlice.VolumeSliceProxy>(Intl.intl("Name"), Intl.intl("Name"), String.class, slice -> slice.getName(), (slice, val) -> slice.setName(val instanceof String ? (String)val : ""), new DefaultCellEditor(new JTextField()), new DefaultTableCellRenderer()), new TableColProp<VolumeSlice.VolumeSliceProxy>(Intl.intl("Min X"), Intl.intl("Min X"), UnitDouble.class, slice -> slice.getMinx(), (slice, val) -> {
            if (val instanceof UnitDouble) {
                UnitDouble locUD = (UnitDouble)val;
                slice.setMinx(locUD);
            }
        }, new guiTable.UnitDoubleEditor(this.d_lengthUnit), new guiTable.UnitDoubleRenderer(this.d_lengthUnit)), new TableColProp<VolumeSlice.VolumeSliceProxy>(Intl.intl("Max X"), Intl.intl("Max X"), UnitDouble.class, slice -> slice.getMaxx(), (slice, val) -> {
            if (val instanceof UnitDouble) {
                UnitDouble locUD = (UnitDouble)val;
                slice.setMaxx(locUD);
            }
        }, new guiTable.UnitDoubleEditor(this.d_lengthUnit), new guiTable.UnitDoubleRenderer(this.d_lengthUnit)), new TableColProp<VolumeSlice.VolumeSliceProxy>(Intl.intl("Min Y"), Intl.intl("Min Y"), UnitDouble.class, slice -> slice.getMiny(), (slice, val) -> {
            if (val instanceof UnitDouble) {
                UnitDouble locUD = (UnitDouble)val;
                slice.setMiny(locUD);
            }
        }, new guiTable.UnitDoubleEditor(this.d_lengthUnit), new guiTable.UnitDoubleRenderer(this.d_lengthUnit)), new TableColProp<VolumeSlice.VolumeSliceProxy>(Intl.intl("Max Y"), Intl.intl("Max Y"), UnitDouble.class, slice -> slice.getMaxy(), (slice, val) -> {
            if (val instanceof UnitDouble) {
                UnitDouble locUD = (UnitDouble)val;
                slice.setMaxy(locUD);
            }
        }, new guiTable.UnitDoubleEditor(this.d_lengthUnit), new guiTable.UnitDoubleRenderer(this.d_lengthUnit)), new TableColProp<VolumeSlice.VolumeSliceProxy>(Intl.intl("Min Z"), Intl.intl("Min Z"), UnitDouble.class, slice -> slice.getMinz(), (slice, val) -> {
            if (val instanceof UnitDouble) {
                UnitDouble locUD = (UnitDouble)val;
                slice.setMinz(locUD);
            }
        }, new guiTable.UnitDoubleEditor(this.d_lengthUnit), new guiTable.UnitDoubleRenderer(this.d_lengthUnit)), new TableColProp<VolumeSlice.VolumeSliceProxy>(Intl.intl("Max Z"), Intl.intl("Max Z"), UnitDouble.class, slice -> slice.getMaxz(), (slice, val) -> {
            if (val instanceof UnitDouble) {
                UnitDouble locUD = (UnitDouble)val;
                slice.setMaxz(locUD);
            }
        }, new guiTable.UnitDoubleEditor(this.d_lengthUnit), new guiTable.UnitDoubleRenderer(this.d_lengthUnit)), new TableColProp<VolumeSlice.VolumeSliceProxy>(Intl.intl("Gas Phase Quantity"), Intl.intl("Gas Phase Quantity"), IQuantity.class, slice -> slice.getQuant(), (slice, val) -> {
            if (val instanceof IQuantity) {
                IQuantity quant = (IQuantity)val;
                slice.setQuant(quant);
            }
        }, quantComboCell, quantComboCell), new TableColProp<VolumeSlice.VolumeSliceProxy>(Intl.intl("Use Vector?"), Intl.intl("Use Vector?"), String.class, slice -> slice.isIncludeFlow() ? OPT_YES : OPT_NO, (slice, val) -> {
            if (val != null) {
                slice.setIncludeFlow(val.equals(OPT_YES));
            }
        }, null, new DefaultTableCellRenderer()), new TableColProp<VolumeSlice.VolumeSliceProxy>(Intl.intl("Cell Centered?"), Intl.intl("Cell Centered?"), String.class, slice -> slice.isCellCentered() ? OPT_YES : OPT_NO, (slice, val) -> {
            if (val != null) {
                slice.setCellCentered(val.equals(OPT_YES));
            }
        }, null, new DefaultTableCellRenderer())), 24);
        this.d_table = (guiTable)tableAndModelPair.v1;
        this.d_editor = new guiTableEditor(this.d_table, 30);
        this.d_table.setNullValuesAllowed(false);
        QuantityUtil.TypeFilter qFilter = new QuantityUtil.TypeFilter(128L, QuantityType.GAS);
        this.d_table.setClipboard(7, (guiTableClipboard)new QuantityClipboard(qFilter));
        this.d_table.setColumnOptions(8, OPT_YES, OPT_NO);
        this.d_table.setColumnOptions(9, OPT_YES, OPT_NO);
        this.loadData();
        this.d_table.autoSizeColumns(200);
        GridBagUtil.add(dlgPanel, this.d_editor, 0, 0, 2, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
        int height = this.d_table.getRowHeight();
        this.d_table.setRowHeight(height + 1);
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.loadPreferredSize(PyroPrefs.LastSlcfDlgSizeX.key.toString(), PyroPrefs.LastSlcfDlgSizeY.key.toString());
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        List<VolumeSlice.VolumeSliceProxy> vslices = this.getTableEntries();
        if (!Slcf3dDialog.noTwo3DSlicesSame(vslices)) {
            this.doWarn(Intl.intl("Error: Duplicate values of the same quantity are not permitted."));
            return false;
        }
        return true;
    }

    private void doWarn(String msg) {
        this.showMessageBox(msg);
        this.requestFocusHack();
    }

    private Collection<VolumeSlice> getAll3DSlices() {
        return ((APyroObject)this.d_pyroMod.getSlcf3dList()).flatten(VolumeSlice.class);
    }

    public void setInitialSel(Collection<? extends VolumeSlice> slices) {
        this.d_table.clearSelection();
        this.d_table.setColumnSelectionInterval(0, this.d_table.getColumnCount() - 1);
        for (Slice slice : slices) {
            int ix = Util.indexOf(this.getAll3DSlices(), slice);
            if (ix < 0) continue;
            this.d_table.addRowSelectionInterval(ix, ix);
        }
    }

    private List<VolumeSlice.VolumeSliceProxy> initProxyMap(Collection<VolumeSlice> ogSlices) {
        ArrayList<VolumeSlice.VolumeSliceProxy> proxies = new ArrayList<VolumeSlice.VolumeSliceProxy>(ogSlices.size());
        for (VolumeSlice og : ogSlices) {
            VolumeSlice.VolumeSliceProxy proxy = og.getProxyRep();
            proxies.add(proxy);
            this.d_cloneToOGSliceMap.put(proxy, og);
        }
        return proxies;
    }

    public void loadData() {
        Collection<VolumeSlice> slices = this.getAll3DSlices();
        int numRows = slices.size();
        if (numRows > 0) {
            ObjectTableModel model = (ObjectTableModel)this.d_table.getModel();
            List<VolumeSlice.VolumeSliceProxy> proxies = this.initProxyMap(slices);
            model.setRows(proxies);
        }
    }

    public void saveData() {
        CompositeTask<PyroMod> compTask = new CompositeTask<PyroMod>(this.d_pyroMod);
        final HashMap<VolumeSlice, VolumeSlice.VolumeSliceProxy> refToPreEditProps = new HashMap<VolumeSlice, VolumeSlice.VolumeSliceProxy>();
        final LinkedIdentityHashSet<VolumeSlice.VolumeSliceProxy> enteredSlices = new LinkedIdentityHashSet<VolumeSlice.VolumeSliceProxy>((Collection<VolumeSlice.VolumeSliceProxy>)this.getTableEntries());
        ArrayList<VolumeSlice> modelSlices = new ArrayList<VolumeSlice>();
        ArrayList<VolumeSlice> addSlices = new ArrayList<VolumeSlice>();
        ArrayList<VolumeSlice> deleteSlices = new ArrayList<VolumeSlice>();
        for (VolumeSlice.VolumeSliceProxy volumeSliceProxy : enteredSlices) {
            if (!this.d_cloneToOGSliceMap.containsKey(volumeSliceProxy)) {
                VolumeSlice newSlice = new VolumeSlice(volumeSliceProxy.getName(), volumeSliceProxy.getMinx(), volumeSliceProxy.getMaxx(), volumeSliceProxy.getMiny(), volumeSliceProxy.getMaxy(), volumeSliceProxy.getMinz(), volumeSliceProxy.getMaxz(), volumeSliceProxy.getQuant(), volumeSliceProxy.isIncludeFlow(), volumeSliceProxy.isCellCentered());
                addSlices.add(newSlice);
                modelSlices.add(newSlice);
            }
            if (!this.d_cloneToOGSliceMap.containsKey(volumeSliceProxy)) continue;
            modelSlices.add(this.d_cloneToOGSliceMap.get(volumeSliceProxy));
        }
        for (Map.Entry entry : this.d_cloneToOGSliceMap.entrySet()) {
            if (!enteredSlices.contains(entry.getKey())) {
                deleteSlices.add((VolumeSlice)entry.getValue());
                continue;
            }
            VolumeSlice og = (VolumeSlice)entry.getValue();
            refToPreEditProps.put(og, og.getProxyRep());
        }
        compTask.addTask(new AUndoableTask(){

            @Override
            public void undo() {
                for (Map.Entry kvPair : refToPreEditProps.entrySet()) {
                    ((VolumeSlice)kvPair.getKey()).restoreProps((VolumeSlice.VolumeSliceProxy)kvPair.getValue());
                }
            }

            @Override
            public void run() {
                for (VolumeSlice.VolumeSliceProxy entered : enteredSlices) {
                    if (!Slcf3dDialog.this.d_cloneToOGSliceMap.containsKey(entered)) continue;
                    Slcf3dDialog.this.d_cloneToOGSliceMap.get(entered).restoreProps(entered);
                }
            }
        });
        compTask.addTask(Tasks.delete(deleteSlices));
        compTask.addTask(new AddTask((IPyroObject)this.d_pyroMod.getSlcf3dList(), addSlices));
        compTask.addTask(new ChangeOrderTask(this.d_pyroMod.getSlcf3dList(), children -> modelSlices));
        this.d_pyroMod.getTaskManager().exec(compTask, Intl.intl("Save 3D Slices"));
    }

    private List<VolumeSlice.VolumeSliceProxy> getTableEntries() {
        ObjectTableModel model = (ObjectTableModel)this.d_table.getModel();
        return model.getRows();
    }

    private static boolean noTwo3DSlicesSame(List<VolumeSlice.VolumeSliceProxy> slices) {
        HashSet<VolumeSlice.VolumeSliceProxy> vslices = new HashSet<VolumeSlice.VolumeSliceProxy>();
        for (VolumeSlice.VolumeSliceProxy s3d : slices) {
            if (vslices.add(s3d)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int doModal() {
        int result = super.doModal();
        this.savePreferredSize(PyroPrefs.LastSlcfDlgSizeX.key.toString(), PyroPrefs.LastSlcfDlgSizeY.key.toString());
        if (result == 1) {
            this.saveData();
        }
        return result;
    }
}

