/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.output;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.SimParams;
import pyrosim.domain.output.AMeasurementSet;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.gui.output.QuantitySetUIModel;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.TypedProp;

public class DualQuantitySetDlg
extends guiDialog {
    private static final long serialVersionUID = 927491129375483009L;
    private final PyroMod d_domain;
    private final QuantitySetUIModel d_quantSetModelUpper;
    private final QuantitySetUIModel d_quantSetModelLower;
    private final JButton d_resetButton;
    private final TypedProp<Integer> d_prefSizeX;
    private final TypedProp<Integer> d_prefSizeY;
    public static final String DLG = "QuantityDlg";

    public DualQuantitySetDlg(PyroMod domain, JFrame owner, String title, String topTableDesc, String botTableDesc, AMeasurementSet msetTop, AMeasurementSet msetBot, int maxTopQuantities, int maxBotQuantities, TypedProp<Integer> prefSizeX, TypedProp<Integer> prefSizeY, Action ... actions) {
        super((Window)owner, title, 9);
        this.d_domain = domain;
        this.d_quantSetModelUpper = new QuantitySetUIModel(msetTop, topTableDesc, maxTopQuantities);
        this.d_quantSetModelLower = new QuantitySetUIModel(msetBot, botTableDesc, maxBotQuantities);
        this.d_prefSizeX = prefSizeX;
        this.d_prefSizeY = prefSizeY;
        if (actions.length > 0) {
            JPopupMenu resetMenu = new JPopupMenu();
            resetMenu.add(new ClearAction(Intl.intl("Clear Selection")));
            for (Action a : actions) {
                a.putValue(DLG, this);
                resetMenu.add(a);
            }
            this.d_resetButton = new JButton(Intl.intl("Reset..."));
            this.d_resetButton.addActionListener(evt -> {
                int x = 1;
                int y = this.d_resetButton.getSize().height;
                resetMenu.show(this.d_resetButton, x, y);
            });
        } else {
            this.d_resetButton = new JButton(Intl.intl("Clear Selection"));
            this.d_resetButton.addActionListener(evt -> this.clearSelection());
        }
        this.setResizable(true);
        this.setMinimumSizeEnabled(true);
        this.loadPreferredSize(this.d_prefSizeX.key.toString(), this.d_prefSizeY.key.toString());
    }

    protected String getTaskDesc() {
        return Intl.intl("Save Quantities");
    }

    @Override
    public int doModal() {
        int result = super.doModal();
        this.savePreferredSize(this.d_prefSizeX.key.toString(), this.d_prefSizeY.key.toString());
        return result;
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        String baseWarnString = Intl.intl("Please choose no more than %d quantities.");
        if (!this.d_quantSetModelUpper.isValidSelCount()) {
            if (showWarn) {
                JOptionPane.showMessageDialog(this, String.format(baseWarnString, this.d_quantSetModelUpper.getMaxAllowedQuants()), Intl.intl("Error"), 0);
            }
            return false;
        }
        if (!this.d_quantSetModelLower.isValidSelCount()) {
            if (showWarn) {
                JOptionPane.showMessageDialog(this, String.format(baseWarnString, this.d_quantSetModelLower.getMaxAllowedQuants()), Intl.intl("Error"), 0);
            }
            return false;
        }
        return super.validateData(showWarn, allowModify);
    }

    public void selectQuantities(Set<IQuantity> quantities) {
        this.d_quantSetModelUpper.selectQuantities(quantities);
        this.d_quantSetModelLower.selectQuantities(quantities);
    }

    public void updateUI() {
        this.d_quantSetModelUpper.updateUI();
        this.d_quantSetModelLower.updateUI();
    }

    protected Task getSaveTask() {
        CompositeTask<PyroMod> compTask = new CompositeTask<PyroMod>(this.d_domain);
        compTask.addTask(this.d_quantSetModelUpper.getSaveTask());
        compTask.addTask(this.d_quantSetModelLower.getSaveTask());
        return compTask;
    }

    protected void updateNumQuantsSelected() {
        this.d_quantSetModelUpper.updateNumQuantsSelected();
        this.d_quantSetModelLower.updateNumQuantsSelected();
    }

    public boolean containsQauntity(IQuantity quantity) {
        return this.d_quantSetModelUpper.containsQauntity(quantity) || this.d_quantSetModelLower.containsQauntity(quantity);
    }

    protected void updateMeasurementTableModel() {
        this.d_quantSetModelUpper.updateMeasurementTableModel();
        this.d_quantSetModelLower.updateMeasurementTableModel();
    }

    public PyroMod getPyroMod() {
        return this.d_domain;
    }

    public SimParams.FileOutput getFileOutput() {
        return this.d_domain.getSimParams().getFileOutput();
    }

    public JScrollPane getspEnabledQuantitiesTop() {
        return this.d_quantSetModelUpper.getspEnabledQuantities();
    }

    public JScrollPane getspEnabledQuantitiesBot() {
        return this.d_quantSetModelLower.getspEnabledQuantities();
    }

    public guiLabel getNumberTopQuantsChosen() {
        return this.d_quantSetModelUpper.getNumberQuantsChosen();
    }

    public guiLabel getNumberBotQuantsChosen() {
        return this.d_quantSetModelLower.getNumberQuantsChosen();
    }

    public guiTable getQuantitiesTableTop() {
        return this.d_quantSetModelUpper.getQuantitiesTable();
    }

    public guiTable getQuantitiesTableBot() {
        return this.d_quantSetModelLower.getQuantitiesTable();
    }

    public JButton getResetButton() {
        return this.d_resetButton;
    }

    protected void clearSelection() {
        this.d_quantSetModelUpper.clearSelection();
        this.d_quantSetModelLower.clearSelection();
    }

    protected class ClearAction
    extends guiAction {
        private static final long serialVersionUID = -384756182938888273L;

        public ClearAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DualQuantitySetDlg.this.clearSelection();
        }
    }
}

