/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.signals.Util;
import pyrosim.domain.tags.ITaggable;
import pyrosim.domain.tasks.AddAutoRenameTask;
import pyrosim.domain.tasks.ReorderObjectsTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.TagEditor;
import pyrosim.gui.comboboxes.CompositeComboBox;
import pyrosim.gui.controls.ControlSelPnl;
import pyrosim.gui.controls.TextFldNameSource;
import pyrosim.gui.geom.AABoxGeomEditor;
import pyrosim.gui.geom.DefModelObjEditor;
import pyrosim.gui.geom.DuctEditor;
import pyrosim.gui.geom.GenericEditor;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.HoleEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.InitEditor;
import pyrosim.gui.geom.ModelDialogsUtil;
import pyrosim.gui.geom.NodeEditor;
import pyrosim.gui.geom.ObstructionEditor;
import pyrosim.gui.geom.PartCloudEditor;
import pyrosim.gui.geom.VentEditor;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.GeomUtil;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.CollectionMetrics;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ModelObjectDialog
extends guiDialog {
    private static final long serialVersionUID = 1921931658608874407L;
    public static final String EDITOR_PROPS_TAB = Intl.intl("General");
    public static final String GEOMETRY_PROPS_TAB = Intl.intl("Geometry");
    public static final int ADD = 0;
    public static final int EDIT = 1;
    private final PyroMod d_mediator;
    private final Collection<? extends IPyroObject> d_objs;
    private final ModelComposite d_parent;
    private final JTabbedPane d_tabbedPane;
    private final guiTextField d_id;
    private final guiTextField d_desc;
    private final TagEditor d_tags;
    private final CompositeComboBox<IModelObj> d_group;
    private final ControlSelPnl d_controlPnl;
    private final guiMultiStateCheckBox d_cbSpecifyColor;
    private final ColorButton d_cbColor;
    private final IEditor d_objEditor;
    private final IGeomEditor d_geomEditor;
    private final AABoxGeomEditor d_boundsPanel;
    private final CustomFDSPanel d_customFDSPanel;
    private final guiPanel d_geomPanel;
    private int d_type;

    public ModelObjectDialog(JFrame owner, PyroMod mod, Collection<? extends IPyroObject> objs, ModelComposite parent, int type) {
        super((Window)owner, null, 9);
        this.d_objs = objs;
        this.d_parent = parent;
        this.d_type = type;
        this.d_mediator = mod;
        this.d_id = new guiTextField();
        this.d_id.setEditable(objs.stream().allMatch(obj -> TVEntryPoints.ep(obj).canRename(mod, (IPyroObject)obj)));
        this.d_desc = new guiTextField();
        this.d_tags = new TagEditor();
        this.d_group = new CompositeComboBox<IModelObj>(this.d_mediator.getObstructions());
        this.d_cbSpecifyColor = new guiMultiStateCheckBox(Intl.intl("Specify Color"), false);
        this.d_cbColor = new ColorButton();
        LinkStatus.link((AbstractButton)this.d_cbSpecifyColor, this.d_cbColor);
        this.d_controlPnl = new ControlSelPnl(mod.getControls());
        Collection<IModelObj> deepObjs = Hierarchy.flatten(this.d_objs, IModelObj.class);
        this.d_controlPnl.setNameSrc(this.d_id, deepObjs);
        this.d_geomEditor = GeomGuiUtil.newEditor(deepObjs);
        this.d_objEditor = this.createObjEditor(this.d_mediator, objs, this.d_geomEditor);
        this.d_boundsPanel = new AABoxGeomEditor(false, true, true);
        this.d_boundsPanel.setEnabled(false);
        this.d_customFDSPanel = new CustomFDSPanel(6);
        guiPanel descPanel = new guiPanel(new MigLayout("insets 0, gap 6, wrap 2", "[][fill, grow]"));
        descPanel.add((Component)new guiLabel(Intl.intl("ID:")), "grow");
        descPanel.add((Component)this.d_id, "span, grow");
        descPanel.add((Component)new guiLabel(Intl.intl("Description:")), "grow");
        descPanel.add((Component)this.d_desc, "span, grow");
        descPanel.add((Component)new guiLabel(Intl.intl("Tags:")), "grow");
        descPanel.add((Component)this.d_tags.getEditor(), "span, grow");
        descPanel.add((Component)new guiLabel(Intl.intl("Group:")), "grow");
        descPanel.add(this.d_group, "grow 0");
        if (this.d_objEditor != null) {
            this.d_objEditor.add(this, descPanel);
        }
        guiPanel boundsPanel = new guiPanel(new MigLayout("insets 0, gap 6"));
        TitleSeparator boundingBoxLab = new TitleSeparator(Intl.intl("Bounding Box"));
        boundsPanel.add((Component)boundingBoxLab, "span, grow, wrap");
        boundsPanel.add((Component)this.d_boundsPanel, "span, grow");
        guiPanel basePanel = new guiPanel(new MigLayout("insets 0, gap 6, wrap 1", "[fill, grow]"));
        basePanel.add((Component)descPanel, "span, grow");
        basePanel.add((Component)boundsPanel, "span, grow");
        this.d_tabbedPane = new JTabbedPane();
        this.d_tabbedPane.add(Intl.intl("General"), ModelObjectDialog.createTab(basePanel));
        if (this.d_geomEditor != null) {
            this.d_geomPanel = new guiPanel(new GridBagLayout());
            TitleSeparator title = new TitleSeparator(String.format(Intl.intl("%s Properties"), this.d_geomEditor.getGeomName()));
            GridBagUtil.add(this.d_geomPanel, title, 0, 0, 2, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this.d_geomPanel, this.d_geomEditor.getPanel(), 0, 1, 2, 1, 0, 12, 0, 0, 1, 1.0, 1.0, 17);
            this.d_tabbedPane.add(Intl.intl("Geometry"), ModelObjectDialog.createTab(this.d_geomPanel));
        } else {
            this.d_geomPanel = new guiPanel();
        }
        if (this.d_objEditor != null) {
            List<Pair<String, guiPanel>> pairs = this.d_objEditor.getExtraTabs();
            for (Pair<String, guiPanel> pair : pairs) {
                this.d_tabbedPane.add((String)pair.v1, ModelObjectDialog.createTab((guiPanel)pair.v2));
            }
        }
        guiPanel mainPanel = this.getDialogPane();
        mainPanel.add((Component)this.d_tabbedPane, "Center");
        this.setTitle(ModelObjectDialog.determineTitle(this.d_objEditor, objs));
        this.loadValues(this.d_objs);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent arg0) {
                ModelObjectDialog.this.d_id.requestFocusInWindow();
            }

            @Override
            public void windowLostFocus(WindowEvent arg0) {
            }
        });
    }

    public ControlSelPnl.INameSource getNameSource() {
        return new TextFldNameSource(this.d_id);
    }

    public int getMode() {
        return this.d_type;
    }

    protected void removeExtraTab(String name) {
        if (this.d_tabbedPane == null) {
            return;
        }
        int ix = this.d_tabbedPane.indexOfTab(name);
        if (ix < 0) {
            return;
        }
        this.d_tabbedPane.removeTabAt(ix);
    }

    protected void addExtraTab(String name, guiPanel panel) {
        int ix = this.d_tabbedPane.indexOfTab(name);
        if (ix >= 0) {
            return;
        }
        this.d_tabbedPane.addTab(name, ModelObjectDialog.createTab(panel));
    }

    public void setGeomTabVis(boolean enable) {
        if (this.d_geomEditor == null) {
            return;
        }
        if (enable) {
            this.addExtraTab(GEOMETRY_PROPS_TAB, this.d_geomPanel);
        } else {
            this.removeExtraTab(GEOMETRY_PROPS_TAB);
        }
    }

    public ControlSelPnl getControlPanel() {
        return this.d_controlPnl;
    }

    private IEditor createObjEditor(PyroMod domain, Collection<? extends IPyroObject> objs, IGeomEditor geomEditor) {
        Collection<IModelObj> coll = Hierarchy.flatten(objs, IModelObj.class);
        CollectionMetrics<IModelObj> metrics = new CollectionMetrics<IModelObj>(coll);
        int numHoles = metrics.getNum(IHole.class);
        int numObsts = metrics.getNum(IObstruction.class);
        int numClouds = metrics.getNum(PartCloud.class);
        int numVents = metrics.getNum(Vent.class);
        int numInit = metrics.getNum(InitRegion.class);
        int numGeneric = metrics.getNum(GenericGeomSrc.class);
        int numHvacNodes = metrics.getNum(HvacNode.class);
        int numHvacDucts = metrics.getNum(HvacDuct.class);
        int numFDS = metrics.getNum(FDSObject.class);
        boolean color = true;
        boolean control = numFDS > 0;
        int numGroups = (int)IntStream.of(numHoles, numObsts, numClouds, numVents, numInit, numGeneric, numHvacNodes, numHvacDucts).filter(i -> i != 0).count();
        if (numGroups == 0) {
            return new DefModelObjEditor<IModelObj>(IModelObj.class, Intl.intl("Group Properties"), false, false);
        }
        if (numGroups > 1) {
            return new DefModelObjEditor<IModelObj>(IModelObj.class, Intl.intl("Multi-select Properties"), color, control);
        }
        int collSize = coll.size();
        if (ModelObjectDialog.isExclusive(numObsts, collSize)) {
            return new ObstructionEditor(domain, geomEditor, this.d_controlPnl);
        }
        if (ModelObjectDialog.isExclusive(numVents, collSize)) {
            return new VentEditor(this, domain);
        }
        if (ModelObjectDialog.isExclusive(numHoles, collSize)) {
            return new HoleEditor(domain);
        }
        if (ModelObjectDialog.isExclusive(numClouds, collSize)) {
            return new PartCloudEditor(this, domain);
        }
        if (ModelObjectDialog.isExclusive(numInit, collSize)) {
            return new InitEditor(domain);
        }
        if (ModelObjectDialog.isExclusive(numGeneric, collSize)) {
            return new GenericEditor();
        }
        if (ModelObjectDialog.isExclusive(numHvacNodes, collSize)) {
            return new NodeEditor(this, domain, geomEditor);
        }
        if (ModelObjectDialog.isExclusive(numHvacDucts, collSize)) {
            return new DuctEditor(domain, this.d_id);
        }
        return null;
    }

    private static boolean isExclusive(int count, int totalCount) {
        return count != 0 && count == totalCount;
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        Composite newParent;
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        Collection<IModelObj> deepObjs = Hierarchy.flatten(this.d_objs, IModelObj.class);
        if (this.d_objEditor != null && !this.d_objEditor.validateData(this, deepObjs, showWarn, allowModify)) {
            return false;
        }
        if (this.d_geomEditor != null && !this.d_geomEditor.validateData(deepObjs, showWarn, allowModify)) {
            return false;
        }
        if (this.d_type == 1 && (newParent = (Composite)this.d_group.getSelectedItem()) != null) {
            IPyroObject commonParent = Hierarchy.getCommonParent(this.d_objs);
            boolean canDrop = TVEntryPoints.ep(newParent).canDrop(this.d_mediator, newParent, new IdentityHashSet<IPyroObject>(this.d_objs), commonParent);
            if (!canDrop) {
                if (allowModify) {
                    this.d_group.requestFocusInWindow();
                }
                if (showWarn) {
                    String msg = String.format(Intl.intl("Cannot move selected objects to group, \"%s.\""), newParent.getName());
                    ModelObjectDialog.showInvalidEntryMessage(this, msg);
                }
                return false;
            }
        }
        try {
            ModelDialogsUtil.validateName(this.d_mediator, this.d_type != 1, this.d_objs, this.d_id);
        }
        catch (Exception e) {
            if (showWarn) {
                ModelObjectDialog.showInvalidEntryMessage(this, e.getLocalizedMessage());
            }
            return false;
        }
        return true;
    }

    protected int addColor(guiPanel panel, int row) {
        GridBagUtil.add(panel, this.d_cbSpecifyColor, 0, row, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(panel, this.d_cbColor, 1, row++, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        return row;
    }

    protected void addColor(guiPanel basePanel) {
        basePanel.add((Component)this.d_cbSpecifyColor, "grow");
        basePanel.add((Component)this.d_cbColor, "width 70:70:70, height 25:25:25, wrap");
    }

    protected int addControlInput(guiPanel panel, int row) {
        return this.d_controlPnl.addToGridBag(panel, 0, row, 0, 0, 6, 0);
    }

    protected void addControlInput(guiPanel basePanel) {
        this.d_controlPnl.addToMig(basePanel);
    }

    private static guiPanel createTab(guiPanel panel) {
        guiPanel tab = panel;
        tab.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        return tab;
    }

    private static String determineTitle(IEditor editor, Collection<? extends IPyroObject> objs) {
        if (editor != null) {
            return editor.getDialogTitle();
        }
        return Intl.intl("Object Properties");
    }

    private void loadValues(Collection<? extends IPyroObject> objs) {
        if (this.d_type == 0 || this.sameParent(this.d_parent, objs)) {
            this.d_group.setSelectedComposite(this.d_parent);
        } else {
            this.d_group.setSelectedComposite(null);
        }
        this.d_group.setEnabled(true);
        Collection<IModelObj> deepObjs = Hierarchy.flatten(objs, IModelObj.class);
        ModelDialogsUtil.loadName(objs, this.d_id);
        ModelDialogsUtil.loadString(deepObjs, this.d_desc, IModelObj.descProp);
        ModelDialogsUtil.loadColor(deepObjs, this.d_cbSpecifyColor, this.d_cbColor);
        this.d_tags.initTags(Hierarchy.flatten(deepObjs, ITaggable.class));
        AABox bounds = GeomUtil.getBounds(deepObjs);
        this.d_boundsPanel.load(new AABoxGeom(bounds));
        if (this.d_geomEditor != null) {
            this.d_geomEditor.load(deepObjs);
        }
        if (this.d_objEditor != null) {
            this.d_objEditor.load(this.d_mediator, deepObjs);
        }
        this.d_controlPnl.load(this.getEventPins(deepObjs));
        IFilteredCollection<ICustomFDSPropsContainer> customFDSObjs = theUtil.filter(deepObjs, ICustomFDSPropsContainer.class);
        if (customFDSObjs.isEmpty()) {
            this.d_tabbedPane.remove(this.d_boundsPanel);
        } else {
            this.d_tabbedPane.addTab(Intl.intl("Advanced"), this.d_customFDSPanel);
            this.d_customFDSPanel.load(customFDSObjs);
        }
        this.setModified(false);
    }

    public void saveValues(Collection<? extends IPyroObject> objsColl) {
        final Collection<IModelObj> deepObjs = Hierarchy.flatten(objsColl, IModelObj.class);
        final Collection<? extends IPyroObject> collObjs = objsColl;
        final ArrayList additionalSaveActions = new ArrayList();
        AOneTimeTask editTask = new AOneTimeTask(){

            @Override
            public void run() {
                ModelDialogsUtil.saveName(ModelObjectDialog.this.d_mediator, ModelObjectDialog.this.d_type == 0, collObjs, ModelObjectDialog.this.d_id);
                ModelDialogsUtil.saveString(deepObjs, ModelObjectDialog.this.d_desc, IModelObj.descProp);
                ModelDialogsUtil.saveColor(ModelObjectDialog.this.d_mediator, deepObjs, ModelObjectDialog.this.d_cbSpecifyColor, ModelObjectDialog.this.d_cbColor);
                Pair<Collection<IModelObj>, Collection<IModelObj>> controllableObjs = ModelObjectDialog.this.filterControllableObjs(deepObjs);
                if (ModelObjectDialog.this.d_controlPnl.save(ModelObjectDialog.this.getEventPins((Collection)controllableObjs.v1))) {
                    for (IModelObj obj : deepObjs) {
                        obj.changedEvt(new Object[0]);
                    }
                }
                for (OneLogicInPin pin : ModelObjectDialog.this.getEventPins((Collection)controllableObjs.v2)) {
                    pin.disconnectAll();
                }
                for (IModelObj nonControlObj : (Collection)controllableObjs.v2) {
                    nonControlObj.changedEvt(new Object[0]);
                }
                if (ModelObjectDialog.this.d_geomEditor != null && ModelObjectDialog.this.d_tabbedPane.indexOfTab(GEOMETRY_PROPS_TAB) >= 0) {
                    ModelObjectDialog.this.d_geomEditor.save(deepObjs);
                    ModelDialogsUtil.bakeTransforms(ModelObjectDialog.this.d_mediator, deepObjs);
                }
                if (ModelObjectDialog.this.d_objEditor != null) {
                    ModelObjectDialog.this.d_objEditor.save(ModelObjectDialog.this.d_mediator, deepObjs);
                    Consumer<Runnable> addActions = additionalSaveActions::add;
                    ModelObjectDialog.this.d_objEditor.getAdditionalSaveActions(ModelObjectDialog.this.isVisible() ? ModelObjectDialog.this : PyroSim.getApp().getActiveFrame(), ModelObjectDialog.this.d_type, PyroSim.getApp().getMediator(), deepObjs, addActions);
                }
                ModelObjectDialog.this.d_customFDSPanel.save(theUtil.filter(deepObjs, ICustomFDSPropsContainer.class));
            }
        };
        Composite newParent = (Composite)this.d_group.getSelectedItem();
        if (this.d_type == 0) {
            editTask.run();
            IModelObj obj = deepObjs.iterator().next();
            AddAutoRenameTask t = new AddAutoRenameTask(newParent, new IPyroObject[]{obj});
            SelectTask wrapper = new SelectTask(this.d_mediator, obj);
            wrapper.addTask(t);
            if (obj instanceof ITaggable) {
                ITaggable iTaggable = (ITaggable)((Object)obj);
                wrapper.addTask(this.d_tags.getUpdateTagsTask(this.d_mediator, iTaggable));
            }
            this.d_mediator.getTaskManager().exec(wrapper, Intl.intl("Add Object"));
        } else if (this.d_type == 1) {
            CompositeTask<PyroMod> task = new CompositeTask<PyroMod>(this.d_mediator);
            task.addTask(editTask);
            task.addTask(this.d_tags.getUpdateTagsTask(this.d_mediator, Hierarchy.flatten(objsColl, ITaggable.class)));
            if (newParent != null) {
                ArrayList<IPyroObject> moveObjs = new ArrayList<IPyroObject>();
                for (IPyroObject iPyroObject : collObjs) {
                    if (iPyroObject.getParent() == newParent) continue;
                    moveObjs.add(iPyroObject);
                }
                if (!moveObjs.isEmpty()) {
                    task.addTask(new ReorderObjectsTask((IPyroObject)newParent, newParent.getMembers().size(), moveObjs));
                }
            }
            this.d_mediator.getTaskManager().exec(task, Intl.intl("Edit Obstructions"));
        }
        for (Runnable action : additionalSaveActions) {
            action.run();
        }
    }

    private boolean sameParent(Composite<? extends IPyroObject> parent, Collection<? extends IPyroObject> objs) {
        int numEqual = 0;
        for (IPyroObject iPyroObject : objs) {
            IPyroObject p = iPyroObject.getParent();
            if (Objects.equals(p, parent)) {
                ++numEqual;
                continue;
            }
            return false;
        }
        return numEqual == objs.size();
    }

    private Pair<Collection<IModelObj>, Collection<IModelObj>> filterControllableObjs(Collection<? extends IModelObj> deepObjs) {
        Predicate<IModelObj> controlFilter = new Predicate<IModelObj>(){

            @Override
            public boolean test(IModelObj o) {
                return ModelObjectDialog.this.d_objEditor.getType().isInstance(o) && ModelObjectDialog.this.d_objEditor.isControllable(o);
            }
        };
        return new Pair<Collection<IModelObj>, Collection<IModelObj>>(theUtil.filter(deepObjs, controlFilter), theUtil.filter(deepObjs, controlFilter.negate()));
    }

    private Collection<OneLogicInPin> getEventPins(Collection<? extends IModelObj> deepObjs) {
        return theUtil.filter(Util.getInputPins(theUtil.filter(deepObjs, ISignalSink.class).iterator()), OneLogicInPin.class);
    }

    public static interface IEditor<T extends IModelObj> {
        public String getDialogTitle();

        public Class<T> getType();

        public void add(ModelObjectDialog var1, guiPanel var2);

        public List<Pair<String, guiPanel>> getExtraTabs();

        public boolean isControllable(T var1);

        public void load(PyroMod var1, Collection<? extends T> var2);

        public void save(PyroMod var1, Collection<? extends T> var2);

        default public void getAdditionalSaveActions(Component parent, int mode, PyroMod mod, Collection<? extends IObstruction> obsts, Consumer<Runnable> actions) {
        }

        public boolean validateData(Component var1, Collection<? extends T> var2, boolean var3, boolean var4);
    }
}

